/*
 * Decompiled with CFR 0.152.
 */
package scala.build.postprocessing;

import java.io.Serializable;
import java.nio.file.FileSystemException;
import os.Path;
import os.Path$;
import os.PathChunk;
import os.PathChunk$;
import os.PathConvertible;
import os.ReadablePath;
import os.RelPath;
import os.SubPath;
import os.exists$;
import os.isDir$;
import os.list;
import os.package$;
import os.read$;
import os.remove$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.build.GeneratedSource;
import scala.build.Logger;
import scala.build.options.BuildOptions;
import scala.build.options.SemanticDbOptions;
import scala.build.postprocessing.LineConversion$;
import scala.build.postprocessing.PostProcessor;
import scala.build.postprocessing.SemanticdbProcessor$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Right$;
import scala.util.Try$;

public final class SemanticDbPostProcessor$
implements PostProcessor,
Product,
Serializable,
Mirror.Singleton {
    public static final SemanticDbPostProcessor$ MODULE$ = new SemanticDbPostProcessor$();

    private SemanticDbPostProcessor$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SemanticDbPostProcessor$.class);
    }

    public int hashCode() {
        return 51152174;
    }

    public String toString() {
        return "SemanticDbPostProcessor";
    }

    public boolean canEqual(Object that) {
        return that instanceof SemanticDbPostProcessor$;
    }

    public int productArity() {
        return 0;
    }

    public String productPrefix() {
        return "SemanticDbPostProcessor";
    }

    public Object productElement(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public Either<String, BoxedUnit> postProcess(Seq<GeneratedSource> generatedSources, Map<String, Tuple2<String, Object>> mappings, Path workspace, Path output, Logger logger, String scalaVersion, BuildOptions buildOptions) {
        logger.debug(this::postProcess$$anonfun$1);
        SemanticDbOptions semanticDbOptions = buildOptions.scalaOptions().semanticDbOptions();
        Path semDbSourceRoot = (Path)semanticDbOptions.semanticDbSourceRoot().getOrElse(() -> this.$anonfun$1(workspace));
        Path semDbTargetRoot = ((Path)semanticDbOptions.semanticDbTargetRoot().getOrElse(() -> this.$anonfun$2(output))).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("META-INF")).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("semanticdb"));
        generatedSources.foreach((Function1)(JProcedure1 & Serializable)source -> source.reportingPath().foreach((Function1)(JProcedure1 & Serializable)originalSource -> {
            RelPath actual = originalSource.relativeTo(semDbSourceRoot);
            Path generatedSourceParent = Path$.MODULE$.apply((Object)source.generated().toNIO().getParent(), (PathConvertible)PathConvertible.NioPathConvertible$.MODULE$);
            Path potentialSemDbFile = generatedSourceParent.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(new StringBuilder(11).append(source.generated().last()).append(".semanticdb").toString()));
            Some$.MODULE$.apply((Object)potentialSemDbFile).filter((Function1)exists$.MODULE$).orElse(() -> this.postProcess$$anonfun$2$$anonfun$1$$anonfun$1(semDbTargetRoot, potentialSemDbFile, semDbSourceRoot)).filter((Function1)exists$.MODULE$).foreach((Function1)(JProcedure1 & Serializable)semDbFile -> {
                Boolean bl;
                IndexedSeq dirSegments = (IndexedSeq)actual.segments().dropRight(1);
                Path finalSemDbFile = semDbTargetRoot.$div((PathChunk)PathChunk$.MODULE$.SeqPathChunk((Seq)dirSegments, (Function1 & Serializable)s -> PathChunk$.MODULE$.StringPathChunk(s))).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(new StringBuilder(11).append(actual.last()).append(".semanticdb").toString()));
                SemanticdbProcessor$.MODULE$.postProcess(read$.MODULE$.apply((ReadablePath)originalSource), originalSource.relativeTo(semDbSourceRoot), (Function1<Object, Option<Object>>)(Function1 & Serializable)scalaLine -> this.postProcess$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1((GeneratedSource)source, BoxesRunTime.unboxToInt((Object)scalaLine)), (Path)semDbFile, finalSemDbFile);
                try {
                    bl = BoxesRunTime.boxToBoolean((boolean)remove$.MODULE$.apply(semDbFile));
                }
                catch (FileSystemException ex) {
                    logger.debug(() -> this.postProcess$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2(ex, semDbFile));
                    bl = BoxedUnit.UNIT;
                }
                Try$.MODULE$.apply(() -> this.postProcess$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$3(semDbTargetRoot, semDbFile)).toOption().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Path path = (Path)x$1._1();
                    SubPath subPath = (SubPath)x$1._2();
                    this.deleteSubPathIfEmpty(path, (SubPath)subPath.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(package$.MODULE$.up())), logger);
                });
            });
        }));
        return Right$.MODULE$.apply((Object)BoxedUnit.UNIT);
    }

    private void deleteSubPathIfEmpty(Path base, SubPath subPath, Logger logger) {
        while (subPath.segments().nonEmpty()) {
            Path p = base.$div((PathChunk)PathChunk$.MODULE$.SubPathChunk(subPath));
            if (isDir$.MODULE$.apply(p) && list.stream$.MODULE$.apply(p).headOption().isEmpty()) {
                Boolean bl;
                try {
                    bl = BoxesRunTime.boxToBoolean((boolean)remove$.MODULE$.apply(p));
                }
                catch (FileSystemException e) {
                    logger.debug(() -> this.deleteSubPathIfEmpty$$anonfun$1(e, p));
                    bl = BoxedUnit.UNIT;
                }
                subPath = (SubPath)subPath.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(package$.MODULE$.up()));
                continue;
            }
            return;
        }
    }

    private final String postProcess$$anonfun$1() {
        return "Moving semantic DBs around";
    }

    private final Path $anonfun$1(Path workspace$1) {
        return workspace$1;
    }

    private final Path $anonfun$2(Path output$1) {
        return output$1;
    }

    private final Option postProcess$$anonfun$2$$anonfun$1$$anonfun$1(Path semDbTargetRoot$3, Path potentialSemDbFile$1, Path semDbSourceRoot$3) {
        return Some$.MODULE$.apply((Object)semDbTargetRoot$3.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(potentialSemDbFile$1.relativeTo(semDbSourceRoot$3))));
    }

    private final /* synthetic */ Option postProcess$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(GeneratedSource source$3, int scalaLine) {
        return LineConversion$.MODULE$.scalaLineToScLine(scalaLine, source$3.wrapperParamsOpt());
    }

    private final String postProcess$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2(FileSystemException ex$1, Path semDbFile$1) {
        return new StringBuilder(25).append("Ignoring ").append(ex$1).append(" while removing ").append(semDbFile$1).toString();
    }

    private final Tuple2 postProcess$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$3(Path semDbTargetRoot$5, Path semDbFile$2) {
        Path path = (Path)Predef$.MODULE$.ArrowAssoc((Object)semDbTargetRoot$5);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path, (Object)semDbFile$2.relativeTo(semDbTargetRoot$5).asSubPath());
    }

    private final String deleteSubPathIfEmpty$$anonfun$1(FileSystemException e$1, Path p$1) {
        return new StringBuilder(28).append("Ignoring ").append(e$1).append(" while cleaning up ").append(p$1).toString();
    }
}

