/*
 * Decompiled with CFR 0.152.
 */
package scala.build.bsp;

import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import com.swoval.files.PathWatcher;
import com.swoval.files.PathWatchers;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import os.Path;
import os.Path$;
import os.PathConvertible;
import os.RelPath;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.build.Build;
import scala.build.Build$;
import scala.build.bsp.BloopSession$;
import scala.build.bsp.BspClient;
import scala.build.bsp.BspServer;
import scala.build.compiler.BloopCompiler;
import scala.build.input.Element;
import scala.build.input.Inputs;
import scala.build.input.OnDisk;
import scala.build.input.SingleElement;
import scala.build.input.SingleFile;
import scala.build.input.Virtual;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.LazyRef;
import scala.runtime.function.JProcedure1;
import scala.sys.package$;

public final class BloopSession {
    private final Inputs inputs;
    private final String inputsHash;
    private final BloopCompiler remoteServer;
    private final BspServer bspServer;
    private final Build.Watcher watcher;

    public static BloopSession apply(Inputs inputs, BloopCompiler bloopCompiler, BspServer bspServer, Build.Watcher watcher) {
        return BloopSession$.MODULE$.apply(inputs, bloopCompiler, bspServer, watcher);
    }

    public BloopSession(Inputs inputs, String inputsHash, BloopCompiler remoteServer, BspServer bspServer, Build.Watcher watcher) {
        this.inputs = inputs;
        this.inputsHash = inputsHash;
        this.remoteServer = remoteServer;
        this.bspServer = bspServer;
        this.watcher = watcher;
    }

    public Inputs inputs() {
        return this.inputs;
    }

    public String inputsHash() {
        return this.inputsHash;
    }

    public BloopCompiler remoteServer() {
        return this.remoteServer;
    }

    public BspServer bspServer() {
        return this.bspServer;
    }

    public Build.Watcher watcher() {
        return this.watcher;
    }

    public void resetDiagnostics(BspClient localClient) {
        this.bspServer().targetIds().foreach((Function1)(JProcedure1 & Serializable)targetId -> this.inputs().flattened().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            SingleElement singleElement = x$1;
            if (singleElement instanceof SingleFile) {
                SingleFile f = (SingleFile)singleElement;
                localClient.resetDiagnostics(((OnDisk)((Object)f)).path(), (BuildTargetIdentifier)targetId);
                return;
            }
            if (singleElement instanceof Virtual) {
                return;
            }
            throw new MatchError((Object)singleElement);
        }));
    }

    public void dispose() {
        this.watcher().dispose();
        this.remoteServer().shutdown();
    }

    public void registerWatchInputs() {
        this.inputs().elements().foreach((Function1 & Serializable)x$1 -> {
            Element element = x$1;
            if (element instanceof OnDisk) {
                OnDisk elem = (OnDisk)element;
                Function1 & Serializable eventFilter = (Function1 & Serializable)event -> {
                    LazyRef lazyRef = new LazyRef();
                    LazyRef lazyRef2 = new LazyRef();
                    LazyBoolean lazyBoolean = new LazyBoolean();
                    PathWatchers.Event$.Kind kind = event.getKind();
                    PathWatchers.Event$.Kind kind2 = PathWatchers.Event$.Kind.Create;
                    if (kind == null ? kind2 != null : !kind.equals(kind2)) {
                        PathWatchers.Event$.Kind kind3 = event.getKind();
                        PathWatchers.Event$.Kind kind4 = PathWatchers.Event$.Kind.Delete;
                        if (kind3 == null) {
                            if (kind4 != null) {
                                return false;
                            }
                        } else if (!kind3.equals(kind4)) return false;
                    }
                    boolean bl = true;
                    boolean newOrDeletedFile = bl;
                    if (!newOrDeletedFile) return false;
                    if (BloopSession.isHidden$1(lazyBoolean, lazyRef2, elem, lazyRef, event)) return false;
                    if (BloopSession.isScalaFile$1(lazyRef2, elem, lazyRef, event)) return true;
                    if (!BloopSession.isJavaFile$1(lazyRef2, elem, lazyRef, event)) return false;
                    return true;
                };
                PathWatcher<PathWatchers.Event> watcher0 = this.watcher().newWatcher();
                watcher0.register(elem.path().toNIO(), Integer.MAX_VALUE);
                return BoxesRunTime.boxToInteger((int)watcher0.addObserver(Build$.MODULE$.onChangeBufferedObserver((Function1<PathWatchers.Event, BoxedUnit>)(JProcedure1 & Serializable)event -> {
                    if (BoxesRunTime.unboxToBoolean((Object)eventFilter.apply(event))) {
                        this.watcher().schedule();
                        return;
                    }
                })));
            }
            return BoxedUnit.UNIT;
        });
    }

    private static final Path p$lzyINIT1$1(LazyRef p$lzy1$1, PathWatchers.Event event$1) {
        Path path;
        LazyRef lazyRef = p$lzy1$1;
        synchronized (lazyRef) {
            path = (Path)(p$lzy1$1.initialized() ? p$lzy1$1.value() : p$lzy1$1.initialize((Object)Path$.MODULE$.apply((Object)event$1.getTypedPath().getPath().toAbsolutePath(), (PathConvertible)PathConvertible.NioPathConvertible$.MODULE$)));
        }
        return path;
    }

    private static final Path p$1(LazyRef p$lzy1$2, PathWatchers.Event event$2) {
        return (Path)(p$lzy1$2.initialized() ? p$lzy1$2.value() : BloopSession.p$lzyINIT1$1(p$lzy1$2, event$2));
    }

    private static final RelPath relPath$lzyINIT1$1(LazyRef relPath$lzy1$1, OnDisk elem$1, LazyRef p$lzy1$3, PathWatchers.Event event$3) {
        RelPath relPath;
        LazyRef lazyRef = relPath$lzy1$1;
        synchronized (lazyRef) {
            relPath = (RelPath)(relPath$lzy1$1.initialized() ? relPath$lzy1$1.value() : relPath$lzy1$1.initialize((Object)BloopSession.p$1(p$lzy1$3, event$3).relativeTo(elem$1.path())));
        }
        return relPath;
    }

    private static final RelPath relPath$1(LazyRef relPath$lzy1$2, OnDisk elem$3, LazyRef p$lzy1$4, PathWatchers.Event event$4) {
        return (RelPath)(relPath$lzy1$2.initialized() ? relPath$lzy1$2.value() : BloopSession.relPath$lzyINIT1$1(relPath$lzy1$2, elem$3, p$lzy1$4, event$4));
    }

    private static final boolean isHidden$lzyINIT1$1(LazyBoolean isHidden$lzy1$1, LazyRef relPath$lzy1$3, OnDisk elem$4, LazyRef p$lzy1$5, PathWatchers.Event event$5) {
        boolean bl;
        LazyBoolean lazyBoolean = isHidden$lzy1$1;
        synchronized (lazyBoolean) {
            bl = isHidden$lzy1$1.initialized() ? isHidden$lzy1$1.value() : isHidden$lzy1$1.initialize(BloopSession.relPath$1(relPath$lzy1$3, elem$4, p$lzy1$5, event$5).segments().exists((Function1 & Serializable)_$1 -> _$1.startsWith(".")));
        }
        return bl;
    }

    private static final boolean isHidden$1(LazyBoolean isHidden$lzy1$2, LazyRef relPath$lzy1$4, OnDisk elem$5, LazyRef p$lzy1$6, PathWatchers.Event event$6) {
        if (isHidden$lzy1$2.initialized()) {
            return isHidden$lzy1$2.value();
        }
        return BloopSession.isHidden$lzyINIT1$1(isHidden$lzy1$2, relPath$lzy1$4, elem$5, p$lzy1$6, event$6);
    }

    private static final boolean isScalaFile$1(LazyRef relPath$lzy1$5, OnDisk elem$6, LazyRef p$lzy1$7, PathWatchers.Event event$7) {
        return BloopSession.relPath$1(relPath$lzy1$5, elem$6, p$lzy1$7, event$7).last().endsWith(".sc") || BloopSession.relPath$1(relPath$lzy1$5, elem$6, p$lzy1$7, event$7).last().endsWith(".scala");
    }

    private static final boolean isJavaFile$1(LazyRef relPath$lzy1$6, OnDisk elem$7, LazyRef p$lzy1$8, PathWatchers.Event event$8) {
        return BloopSession.relPath$1(relPath$lzy1$6, elem$7, p$lzy1$8, event$8).last().endsWith(".java");
    }

    public static final class Reference {
        private final AtomicReference<BloopSession> ref = new AtomicReference<Object>(null);

        public BloopSession get() {
            BloopSession session = this.ref.get();
            if (session == null) {
                throw package$.MODULE$.error("BSP server not initialized yet");
            }
            return session;
        }

        public Option<BloopSession> getAndNullify() {
            return Option$.MODULE$.apply(this.ref.getAndSet(null));
        }

        public void update(BloopSession former, BloopSession newer, String ifError) {
            if (!this.ref.compareAndSet(former, newer)) {
                throw package$.MODULE$.error(ifError);
            }
        }
    }
}

