/*
 * Decompiled with CFR 0.152.
 */
package scala.build.input;

import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import os.BasePath;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.SubPath;
import os.exists$;
import os.isFile$;
import os.makeDir;
import os.walk;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.build.Directories;
import scala.build.input.CFile;
import scala.build.input.CFile$;
import scala.build.input.Directory;
import scala.build.input.Element;
import scala.build.input.JarFile;
import scala.build.input.JavaFile;
import scala.build.input.JavaFile$;
import scala.build.input.MarkdownFile;
import scala.build.input.MarkdownFile$;
import scala.build.input.OnDisk;
import scala.build.input.ProjectScalaFile;
import scala.build.input.ProjectScalaFile$;
import scala.build.input.ResourceDirectory;
import scala.build.input.Script;
import scala.build.input.Script$;
import scala.build.input.SingleFile;
import scala.build.input.SourceFile;
import scala.build.input.SourceScalaFile;
import scala.build.input.SourceScalaFile$;
import scala.build.input.Virtual;
import scala.build.internal.Constants$;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class ElementsUtils$
implements Serializable {
    public static final ElementsUtils$ MODULE$ = new ElementsUtils$();

    private ElementsUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ElementsUtils$.class);
    }

    public Seq<SingleFile> singleFilesFromDirectory(Directory d, boolean enableMarkdown) {
        return (Seq)walk.stream$.MODULE$.apply(d.path(), (Function1 & Serializable)_$1 -> _$1.last().startsWith("."), walk.stream$.MODULE$.apply$default$3(), walk.stream$.MODULE$.apply$default$4(), walk.stream$.MODULE$.apply$default$5(), walk.stream$.MODULE$.apply$default$6()).filter((Function1 & Serializable)_$2 -> isFile$.MODULE$.apply(_$2)).collect((PartialFunction)new Serializable(enableMarkdown, d, this){
            private final boolean enableMarkdown$1;
            private final Directory d$1;
            {
                this.enableMarkdown$1 = enableMarkdown$2;
                this.d$1 = d$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(Path x) {
                Path path = x;
                Path p = path;
                if (p.last().endsWith(".java")) {
                    return true;
                }
                Path p2 = path;
                String string = p2.last();
                String string2 = Constants$.MODULE$.projectFileName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return true;
                }
                Path p3 = path;
                if (p3.last().endsWith(".scala")) {
                    return true;
                }
                Path p4 = path;
                if (p4.last().endsWith(".sc")) {
                    return true;
                }
                Path p5 = path;
                if (p5.last().endsWith(".c") || p5.last().endsWith(".h")) {
                    return true;
                }
                Path p6 = path;
                return p6.last().endsWith(".md") && this.enableMarkdown$1;
            }

            public final Object applyOrElse(Path x, Function1 function1) {
                Path path = x;
                Path p = path;
                if (p.last().endsWith(".java")) {
                    return JavaFile$.MODULE$.apply(this.d$1.path(), p.subRelativeTo((BasePath)this.d$1.path()));
                }
                Path p2 = path;
                String string = p2.last();
                String string2 = Constants$.MODULE$.projectFileName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return ProjectScalaFile$.MODULE$.apply(this.d$1.path(), p2.subRelativeTo((BasePath)this.d$1.path()));
                }
                Path p3 = path;
                if (p3.last().endsWith(".scala")) {
                    return SourceScalaFile$.MODULE$.apply(this.d$1.path(), p3.subRelativeTo((BasePath)this.d$1.path()));
                }
                Path p4 = path;
                if (p4.last().endsWith(".sc")) {
                    return Script$.MODULE$.apply(this.d$1.path(), p4.subRelativeTo((BasePath)this.d$1.path()), (Option<String>)None$.MODULE$);
                }
                Path p5 = path;
                if (p5.last().endsWith(".c") || p5.last().endsWith(".h")) {
                    return CFile$.MODULE$.apply(this.d$1.path(), p5.subRelativeTo((BasePath)this.d$1.path()));
                }
                Path p6 = path;
                if (p6.last().endsWith(".md") && this.enableMarkdown$1) {
                    return MarkdownFile$.MODULE$.apply(this.d$1.path(), p6.subRelativeTo((BasePath)this.d$1.path()));
                }
                return function1.apply((Object)x);
            }
        }).toVector().sortBy((Function1 & Serializable)_$3 -> ((SourceFile)((Object)_$3)).subPath().segments(), Ordering.Implicits$.MODULE$.seqOrdering((Ordering)Ordering.String$.MODULE$));
    }

    public Seq<ProjectScalaFile> configFile(Directory d) {
        if (exists$.MODULE$.apply(d.path().$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(Constants$.MODULE$.projectFileName())))) {
            return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProjectScalaFile[]{ProjectScalaFile$.MODULE$.apply(d.path(), (SubPath)os.package$.MODULE$.sub().$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(Constants$.MODULE$.projectFileName())))}));
        }
        return package$.MODULE$.Nil();
    }

    public Seq<ProjectScalaFile> projectSettingsFiles(Seq<Element> elements) {
        return (Seq)((SeqOps)elements.flatMap((Function1 & Serializable)x$1 -> {
            Element element = x$1;
            if (element instanceof ProjectScalaFile) {
                ProjectScalaFile f = (ProjectScalaFile)element;
                return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProjectScalaFile[]{f}));
            }
            if (element instanceof Directory) {
                Directory d = (Directory)element;
                return this.configFile(d);
            }
            return package$.MODULE$.Nil();
        })).distinct();
    }

    public String inputsHash(Seq<Element> elements) {
        Iterator it = elements.iterator().flatMap((Function1 & Serializable)x$1 -> {
            Element element = x$1;
            if (element instanceof OnDisk) {
                String string;
                OnDisk elem = (OnDisk)element;
                OnDisk onDisk = elem;
                if (onDisk instanceof Directory) {
                    string = "dir:";
                } else if (onDisk instanceof ResourceDirectory) {
                    string = "resource-dir:";
                } else if (onDisk instanceof JavaFile) {
                    string = "java:";
                } else if (onDisk instanceof ProjectScalaFile) {
                    string = "config:";
                } else if (onDisk instanceof SourceScalaFile) {
                    string = "scala:";
                } else if (onDisk instanceof CFile) {
                    string = "c:";
                } else if (onDisk instanceof Script) {
                    string = "sc:";
                } else if (onDisk instanceof MarkdownFile) {
                    string = "md:";
                } else if (onDisk instanceof JarFile) {
                    string = "jar:";
                } else {
                    throw new MatchError((Object)onDisk);
                }
                String prefix = string;
                return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{prefix, elem.path().toString(), "\n"})).map((Function1 & Serializable)s -> this.bytes$1((String)s));
            }
            if (element instanceof Virtual) {
                Virtual v = (Virtual)element;
                return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{this.bytes$1("virtual:"), v.content(), this.bytes$1(v.source()), this.bytes$1("\n")}));
            }
            throw new MatchError((Object)element);
        });
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        it.foreach((Function1)(JProcedure1 & Serializable)x$0 -> md.update((byte[])x$0));
        byte[] digest = md.digest();
        BigInteger calculatedSum = new BigInteger(1, digest);
        return StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(String.format("%040x", calculatedSum)), 10);
    }

    public Path homeWorkspace(Seq<Element> elements, Directories directories) {
        String hash0 = this.inputsHash(elements);
        Path dir = directories.virtualProjectsDir().$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(hash0), 2))).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(new StringBuilder(8).append("project-").append(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(hash0), 2)).toString()));
        makeDir.all$.MODULE$.apply(dir);
        return dir;
    }

    private final byte[] bytes$1(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }
}

