/*
 * Decompiled with CFR 0.152.
 */
package scala.build.internal;

import com.oracle.svm.core.CErrorNumber;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import coursier.jvm.ErrnoException;
import coursier.jvm.GraalvmErrnoExtras;
import java.io.FileNotFoundException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import scala.build.internal.GraalvmUnistdExtras;

@TargetClass(className="scala.build.internal.Chdir")
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
final class ChdirGraalvm {
    ChdirGraalvm() {
    }

    @Substitute
    public static boolean available() {
        return true;
    }

    @Substitute
    public static void chdir(String string) throws ErrnoException {
        CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)string);
        int n = GraalvmUnistdExtras.chdir(cCharPointerHolder.get());
        if (n != 0) {
            int n2 = CErrorNumber.getCErrorNumber();
            FileNotFoundException fileNotFoundException = null;
            if (n2 == GraalvmErrnoExtras.ENOENT() || n2 == GraalvmErrnoExtras.ENOTDIR()) {
                fileNotFoundException = new FileNotFoundException(string);
            }
            throw new ErrnoException(n2, (Throwable)fileNotFoundException);
        }
    }
}

