/*
 * Decompiled with CFR 0.152.
 */
package scala.build.internal;

import geny.Writable$;
import java.math.BigInteger;
import java.security.MessageDigest;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.PermSet;
import os.ReadablePath;
import os.Source;
import os.Source$;
import os.exists$;
import os.read;
import os.read$;
import os.write;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Serializable;
import scala.Some;
import scala.build.Build;
import scala.build.internal.Constants$;
import scala.scalanative.build.NativeConfig;

public final class NativeBuilderHelper$ {
    public static NativeBuilderHelper$ MODULE$;

    static {
        new NativeBuilderHelper$();
    }

    private Path resolveProjectShaPath(Path nativeWorkDir) {
        return nativeWorkDir.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(".project_sha"));
    }

    private Path resolveOutputShaPath(Path nativeWorkDir) {
        return nativeWorkDir.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(".output_sha"));
    }

    private String fileSha(Path filePath) {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(read.bytes$.MODULE$.apply((ReadablePath)filePath));
        byte[] digest = md.digest();
        BigInteger calculatedSum = new BigInteger(1, digest);
        return String.format("%040x", calculatedSum);
    }

    private String projectSha(Build.Successful build, NativeConfig nativeConfig) {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(build.inputs().sourceHash().getBytes());
        md.update(nativeConfig.toString().getBytes());
        md.update(Constants$.MODULE$.version().getBytes());
        md.update(((String)build.options().hash().getOrElse((Function0 & java.io.Serializable & Serializable)() -> "")).getBytes());
        byte[] digest = md.digest();
        BigInteger calculatedSum = new BigInteger(1, digest);
        return String.format("%040x", calculatedSum);
    }

    public void updateOutputSha(Path dest, Path nativeWorkDir) {
        Path outputShaPath = this.resolveOutputShaPath(nativeWorkDir);
        String sha = this.fileSha(dest);
        write.over$.MODULE$.apply(outputShaPath, (Source)Source$.MODULE$.WritableSource((Object)sha, (Function1 & java.io.Serializable & Serializable)s -> Writable$.MODULE$.StringWritable(s)), write.over$.MODULE$.apply$default$3(), write.over$.MODULE$.apply$default$4(), write.over$.MODULE$.apply$default$5(), write.over$.MODULE$.apply$default$6());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldBuildIfChanged(Build.Successful build, NativeConfig nativeConfig, Path dest, Path nativeWorkDir) {
        None$ previousOutputSha;
        Path projectShaPath = this.resolveProjectShaPath(nativeWorkDir);
        Path outputShaPath = this.resolveOutputShaPath(nativeWorkDir);
        String currentProjectSha = this.projectSha(build, nativeConfig);
        None$ currentOutputSha = exists$.MODULE$.apply(dest) ? new Some((Object)this.fileSha(dest)) : None$.MODULE$;
        None$ previousProjectSha = exists$.MODULE$.apply(projectShaPath) ? new Some((Object)read$.MODULE$.apply((ReadablePath)projectShaPath)) : None$.MODULE$;
        Object object = previousOutputSha = exists$.MODULE$.apply(outputShaPath) ? new Some((Object)read$.MODULE$.apply((ReadablePath)outputShaPath)) : None$.MODULE$;
        if (previousProjectSha.contains((Object)currentProjectSha)) {
            None$ none$ = previousOutputSha;
            None$ none$2 = currentOutputSha;
            if (!(none$ != null ? !none$.equals(none$2) : none$2 != null)) {
                if (exists$.MODULE$.apply(dest)) return false;
            }
        }
        boolean bl = true;
        boolean changed = bl;
        if (!changed) return changed;
        Path x$1 = projectShaPath;
        Source.WritableSource x$2 = Source$.MODULE$.WritableSource((Object)currentProjectSha, (Function1 & java.io.Serializable & Serializable)s -> Writable$.MODULE$.StringWritable(s));
        boolean x$3 = true;
        PermSet x$4 = write.over$.MODULE$.apply$default$3();
        long x$5 = write.over$.MODULE$.apply$default$4();
        boolean x$6 = write.over$.MODULE$.apply$default$6();
        write.over$.MODULE$.apply(x$1, (Source)x$2, x$4, x$5, x$3, x$6);
        return changed;
    }

    private NativeBuilderHelper$() {
        MODULE$ = this;
    }
}

