/*
 * Decompiled with CFR 0.152.
 */
package scala.build.postprocessing;

import java.nio.file.FileSystemException;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.ReadablePath;
import os.RelPath;
import os.SegmentedPath;
import os.SubPath;
import os.exists$;
import os.isDir$;
import os.list;
import os.package$;
import os.read$;
import os.remove$;
import scala.Function0;
import scala.Function1;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.build.GeneratedSource;
import scala.build.Logger;
import scala.build.postprocessing.LineConversion$;
import scala.build.postprocessing.PostProcessor;
import scala.build.postprocessing.SemanticdbProcessor$;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;

public final class SemanticDbPostProcessor$
implements PostProcessor,
Product,
Serializable {
    public static SemanticDbPostProcessor$ MODULE$;

    static {
        new SemanticDbPostProcessor$();
    }

    @Override
    public Either<String, BoxedUnit> postProcess(Seq<GeneratedSource> generatedSources, Map<String, Tuple2<String, Object>> mappings, Path workspace, Path output, Logger logger, String scalaVersion) {
        logger.debug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Moving semantic DBs around");
        Path semDbRoot = output.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("META-INF")).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("semanticdb"));
        generatedSources.foreach((Function1 & java.io.Serializable & Serializable)source -> {
            SemanticDbPostProcessor$.$anonfun$postProcess$2(workspace, semDbRoot, logger, source);
            return BoxedUnit.UNIT;
        });
        return new Right((Object)BoxedUnit.UNIT);
    }

    private void deleteSubPathIfEmpty(Path base, SubPath subPath, Logger logger) {
        block4: {
            BoxedUnit boxedUnit;
            while (subPath.segments().nonEmpty()) {
                Path p = base.$div((PathChunk)PathChunk$.MODULE$.SubPathChunk(subPath));
                if (isDir$.MODULE$.apply(p) && list.stream$.MODULE$.apply(p).headOption().isEmpty()) {
                    try {
                        remove$.MODULE$.apply(p);
                    }
                    catch (FileSystemException e) {
                        logger.debug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(28).append("Ignoring ").append(e).append(" while cleaning up ").append(p).toString());
                    }
                    subPath = (SubPath)subPath.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(package$.MODULE$.up()));
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
                break block4;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public String productPrefix() {
        return "SemanticDbPostProcessor";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SemanticDbPostProcessor$;
    }

    public int hashCode() {
        return 51152174;
    }

    public String toString() {
        return "SemanticDbPostProcessor";
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Some $anonfun$postProcess$6(int n) {
        return new Some((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public static final /* synthetic */ void $anonfun$postProcess$3(GeneratedSource source$1, Path workspace$1, Path semDbRoot$1, Logger logger$1, Path originalSource) {
        block2: {
            RelPath fromSourceRoot = source$1.generated().relativeTo(workspace$1);
            RelPath actual = originalSource.relativeTo(workspace$1);
            IndexedSeq dirSegments = (IndexedSeq)fromSourceRoot.segments().dropRight(1);
            SubPath semDbSubPath = (SubPath)((SegmentedPath)package$.MODULE$.sub().$div((PathChunk)PathChunk$.MODULE$.SeqPathChunk((Seq)dirSegments, (Function1 & java.io.Serializable & Serializable)s -> PathChunk$.MODULE$.StringPathChunk(s)))).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(new StringBuilder(11).append(fromSourceRoot.last()).append(".semanticdb").toString()));
            Path semDbFile = semDbRoot$1.$div((PathChunk)PathChunk$.MODULE$.SubPathChunk(semDbSubPath));
            if (!exists$.MODULE$.apply(semDbFile)) break block2;
            IndexedSeq dirSegments2 = (IndexedSeq)actual.segments().dropRight(1);
            Path finalSemDbFile = semDbRoot$1.$div((PathChunk)PathChunk$.MODULE$.SeqPathChunk((Seq)dirSegments2, (Function1 & java.io.Serializable & Serializable)s -> PathChunk$.MODULE$.StringPathChunk(s))).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(new StringBuilder(11).append(actual.last()).append(".semanticdb").toString()));
            SemanticdbProcessor$.MODULE$.postProcess(read$.MODULE$.apply((ReadablePath)originalSource), originalSource.relativeTo(workspace$1), source$1.topWrapperLen() == 0 ? n -> SemanticDbPostProcessor$.$anonfun$postProcess$6(BoxesRunTime.unboxToInt((Object)n)) : LineConversion$.MODULE$.scalaLineToScLine(read$.MODULE$.apply((ReadablePath)originalSource), read$.MODULE$.apply((ReadablePath)source$1.generated()), source$1.topWrapperLen()), semDbFile, finalSemDbFile);
            try {
                remove$.MODULE$.apply(semDbFile);
            }
            catch (FileSystemException ex) {
                logger$1.debug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(25).append("Ignoring ").append(ex).append(" while removing ").append(semDbFile).toString());
            }
            MODULE$.deleteSubPathIfEmpty(semDbRoot$1, (SubPath)semDbSubPath.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(package$.MODULE$.up())), logger$1);
        }
    }

    public static final /* synthetic */ void $anonfun$postProcess$2(Path workspace$1, Path semDbRoot$1, Logger logger$1, GeneratedSource source) {
        source.reportingPath().foreach((Function1 & java.io.Serializable & Serializable)originalSource -> {
            SemanticDbPostProcessor$.$anonfun$postProcess$3(source, workspace$1, semDbRoot$1, logger$1, originalSource);
            return BoxedUnit.UNIT;
        });
    }

    private SemanticDbPostProcessor$() {
        MODULE$ = this;
        Product.$init$((Product)this);
    }
}

