/*
 * Decompiled with CFR 0.152.
 */
package scala.cli;

import caseapp.core.Error;
import coursier.jniutils.LoadWindowsLibrary;
import coursier.jniutils.WindowsAnsiTerminal;
import coursier.paths.Util;
import coursier.proxy.SetupProxy;
import geny.Writable$;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Locale;
import java.util.zip.ZipException;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.Source;
import os.Source$;
import os.makeDir;
import os.temp$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.build.blooprifle.FailedToStartServerException;
import scala.build.internal.Constants$;
import scala.cli.CurrentParams$;
import scala.cli.ScalaCliCommands;
import scala.cli.internal.Argv0;
import scala.cli.launcher.LauncherCli$;
import scala.cli.launcher.LauncherOptions;
import scala.cli.launcher.LauncherOptions$;
import scala.cli.publish.BouncycastleSignerMaker;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;
import sun.misc.Signal;
import sun.misc.SignalHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ScalaCli$
implements Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(ScalaCli$.class, "0bitmap$1");
    public long 0bitmap$1;
    private static final String progName;
    private static boolean isSipScala;
    private static int javaMajorVersion$lzy1;
    public static final ScalaCli$ MODULE$;

    private ScalaCli$() {
    }

    static {
        MODULE$ = new ScalaCli$();
        progName = new Argv0().get("scala-cli");
        String string = MODULE$.progName();
        String string2 = "scala";
        isSipScala = !(string == null ? string2 != null : !string.equals(string2)) || MODULE$.progName().endsWith("/scala") || MODULE$.progName().endsWith(new StringBuilder(5).append(File.separator).append("scala").toString());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ScalaCli$.class);
    }

    public String progName() {
        return progName;
    }

    private boolean isGraalvmNativeImage() {
        return scala.sys.package$.MODULE$.props().contains("org.graalvm.nativeimage.imagecode");
    }

    private Tuple2<String[], String[]> partitionArgs(String[] args) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])args);
        Object[] systemProps = (String[])ArrayOps$.MODULE$.takeWhile$extension(object, (Function1 & Serializable)_$1 -> _$1.startsWith("-D"));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])args);
        Object object3 = Predef$.MODULE$.refArrayOps(systemProps);
        return Tuple2$.MODULE$.apply((Object)systemProps, ArrayOps$.MODULE$.drop$extension(object2, ArrayOps$.MODULE$.size$extension(object3)));
    }

    private void setSystemProps(String[] systemProps) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])systemProps);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(_$2), "-D"), ClassTag$.MODULE$.apply(String.class)));
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)prop -> {
            String string;
            String[] stringArray = prop.split("=", 2);
            if (stringArray == null) throw new MatchError((Object)stringArray);
            Object object = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 2) == 0) {
                String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                String key = string2;
                String value = string3;
                string = System.setProperty(key, value);
                return string;
            } else {
                String string4;
                if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 1) != 0) throw new MatchError((Object)stringArray);
                String key = string4 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                string = System.setProperty(key, "");
            }
            return string;
        });
    }

    private void printThrowable(Throwable t, PrintStream out) {
        for (Throwable throwable = t; throwable != null; throwable = throwable.getCause()) {
            out.println(throwable.toString());
            Object object = Predef$.MODULE$.refArrayOps((Object[])throwable.getStackTrace());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)l -> out.println(new StringBuilder(2).append("  ").append(l).toString()));
        }
    }

    private byte[] printThrowable(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8.name());
        this.printThrowable(t, ps);
        return baos.toByteArray();
    }

    private boolean isCI() {
        return System.getenv("CI") != null;
    }

    private boolean printStackTraces() {
        return Option$.MODULE$.apply((Object)System.getenv("SCALA_CLI_PRINT_STACK_TRACES")).map((Function1 & Serializable)_$3 -> _$3.toLowerCase(Locale.ROOT)).exists((Function1 & Serializable)x$1 -> {
            String string = x$1;
            return "true".equals(string) || "1".equals(string);
        });
    }

    private void ignoreSigpipe() {
        Signal.handle(new Signal("PIPE"), SignalHandler.SIG_IGN);
    }

    private boolean isJava17ClassName(String name) {
        String string = name;
        String string2 = "java/net/UnixDomainSocketAddress";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private int javaMajorVersion() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$_m_0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$_m_0, l, 1, 0)) continue;
                try {
                    int n;
                    javaMajorVersion$lzy1 = n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString((String)scala.sys.package$.MODULE$.props().getOrElse((Object)"java.version", this::javaMajorVersion$$anonfun$1)), "1.")), (Function1 & Serializable)_$4 -> this.javaMajorVersion$$anonfun$2(BoxesRunTime.unboxToChar((Object)_$4)))));
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$_m_0, 3, 0);
                    return n;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$_m_0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$_m_0, l, 0);
        }
        return javaMajorVersion$lzy1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void main(String[] args) {
        try {
            this.main0(args);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 == null) throw throwable;
            Throwable e = throwable3;
            if (this.isCI() || this.printStackTraces()) throw throwable;
            Path workspace = (Path)CurrentParams$.MODULE$.workspaceOpt().getOrElse(this::$anonfun$2);
            Path dir = workspace.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(Constants$.MODULE$.workspaceDirName())).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("stacktraces"));
            makeDir.all$.MODULE$.apply(dir);
            Path tempFile = temp$.MODULE$.apply((Source)Source$.MODULE$.WritableSource((Object)this.printThrowable(e), (Function1 & Serializable)a -> Writable$.MODULE$.ByteArrayWritable(a)), dir, new StringBuilder(1).append(BoxesRunTime.boxToLong((long)Instant.now().getEpochSecond()).toString()).append("-").toString(), ".log", false, temp$.MODULE$.apply$default$6());
            if (CurrentParams$.MODULE$.verbosity() <= 1) {
                System.err.println(new StringBuilder(7).append("Error: ").append(e).toString());
                System.err.println(new StringBuilder(31).append("For more details, please see '").append(tempFile).append("'").toString());
            }
            if ((throwable2 = e) instanceof UnsupportedClassVersionError && this.javaMajorVersion() < 17) {
                this.warnRequiresJava17();
            } else if (throwable2 instanceof NoClassDefFoundError && this.isJava17ClassName(e.getMessage()) && CurrentParams$.MODULE$.verbosity() <= 1 && this.javaMajorVersion() < 16) {
                this.warnRequiresJava17();
            } else if (throwable2 instanceof FailedToStartServerException) {
                System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(84).append("Running\n                 |  ").append(this.progName()).append(" bloop output\n                 |might give more details.").toString())));
            } else if (throwable2 instanceof ZipException) {
                ZipException ex = (ZipException)throwable2;
                if (!Properties$.MODULE$.isWin() && ex.getMessage().contains("invalid entry CRC")) {
                    System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Running\n                |  export SCALA_CLI_VENDORED_ZIS=true\n                |before running Scala CLI might fix the issue.\n                |")));
                }
            }
            if (CurrentParams$.MODULE$.verbosity() < 2) throw scala.sys.package$.MODULE$.exit(1);
            throw e;
        }
    }

    private void warnRequiresJava17() {
        System.err.println(new StringBuilder(53).append("Java >= 17 is required to run Scala CLI (found Java ").append(this.javaMajorVersion()).append(")").toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void main0(String[] args) {
        Tuple2 tuple2;
        Either either = LauncherOptions$.MODULE$.parser().stopAtFirstUnrecognized().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args).toVector());
        if (either instanceof Left) {
            Error e = (Error)((Left)either).value();
            System.err.println(e.message());
            throw scala.sys.package$.MODULE$.exit(1);
        }
        if (!(either instanceof Right) || (tuple2 = (Tuple2)((Right)either).value()) == null) throw new MatchError((Object)either);
        LauncherOptions launcherOpts = (LauncherOptions)tuple2._1();
        Seq args0 = (Seq)tuple2._2();
        Option option = launcherOpts.cliVersion().map((Function1 & Serializable)_$5 -> _$5.trim()).filter((Function1 & Serializable)_$6 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$6)));
        if (option instanceof Some) {
            String ver = (String)((Some)option).value();
            Nil$ powerArgs = launcherOpts.power() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--power"})) : package$.MODULE$.Nil();
            Seq newArgs = (Seq)powerArgs.$plus$plus((IterableOnce)args0);
            throw LauncherCli$.MODULE$.runAndExit(ver, launcherOpts, (Seq<String>)newArgs);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        if (launcherOpts.power()) {
            isSipScala = false;
        }
        String[] remainingArgs = (String[])args0.toArray(ClassTag$.MODULE$.apply(String.class));
        Tuple2<String[], String[]> tuple22 = this.partitionArgs(remainingArgs);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        String[] systemProps = (String[])tuple22._1();
        String[] scalaCliArgs = (String[])tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)systemProps, (Object)scalaCliArgs);
        String[] systemProps2 = (String[])tuple23._1();
        String[] scalaCliArgs2 = (String[])tuple23._2();
        this.setSystemProps(systemProps2);
        new BouncycastleSignerMaker().maybeInit();
        SetupProxy.setup();
        if (!Properties$.MODULE$.isWin() && this.isGraalvmNativeImage()) {
            this.ignoreSigpipe();
        }
        if (Properties$.MODULE$.isWin() && this.isGraalvmNativeImage()) {
            LoadWindowsLibrary.assumeInitialized();
        }
        if (Properties$.MODULE$.isWin() && System.console() != null && Util.useJni()) {
            WindowsAnsiTerminal.enableAnsiOutput();
        }
        new ScalaCliCommands(this.progName(), isSipScala).main(scalaCliArgs2);
    }

    private final String javaMajorVersion$$anonfun$1() {
        return "0";
    }

    private final /* synthetic */ boolean javaMajorVersion$$anonfun$2(char _$4) {
        return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(_$4));
    }

    private final Path $anonfun$2() {
        return os.package$.MODULE$.pwd();
    }
}

