/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.commands.pgp;

import caseapp.core.RemainingArgs;
import coursier.cache.Cache;
import coursier.cache.FileCache;
import coursier.util.Task;
import java.io.Serializable;
import os.Path;
import os.Path$;
import os.PathConvertible;
import os.ReadablePath;
import os.exists$;
import os.read$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.build.Logger;
import scala.cli.commands.ScalaCommand;
import scala.cli.commands.pgp.KeyServer$;
import scala.cli.commands.pgp.PgpProxyMaker;
import scala.cli.commands.pgp.PgpPushOptions;
import scala.cli.commands.pgp.PgpPushOptions$;
import scala.cli.commands.util.CommonOps$;
import scala.cli.commands.util.CommonOps$CoursierOptionsOps$;
import scala.cli.commands.util.CommonOps$LoggingOptionsOps$;
import scala.cli.commands.util.CommonOps$SharedPgpPushPullOptionsOps$;
import scala.cli.commands.util.ScalaCliSttpBackend;
import scala.cli.commands.util.ScalaCliSttpBackend$;
import scala.cli.internal.PgpProxyMakerSubst;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.model.Uri;

public final class PgpPush$
extends ScalaCommand<PgpPushOptions> {
    public static final PgpPush$ MODULE$ = new PgpPush$();

    private PgpPush$() {
        super(PgpPushOptions$.MODULE$.parser(), PgpPushOptions$.MODULE$.help());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PgpPush$.class);
    }

    public boolean hidden() {
        return true;
    }

    @Override
    public boolean inSipScala() {
        return false;
    }

    public List<List<String>> names() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{(List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pgp", "push"}))}));
    }

    public void run(PgpPushOptions options, RemainingArgs args) {
        LazyRef lazyRef = new LazyRef();
        Logger logger = CommonOps$LoggingOptionsOps$.MODULE$.logger$extension(CommonOps$.MODULE$.LoggingOptionsOps(options.logging()));
        ScalaCliSttpBackend backend = ScalaCliSttpBackend$.MODULE$.httpURLConnection(logger);
        Uri keyServerUri = (Uri)CommonOps$SharedPgpPushPullOptionsOps$.MODULE$.keyServerUriOptOrExit$extension(CommonOps$.MODULE$.SharedPgpPushPullOptionsOps(options.shared()), logger).getOrElse(this::$anonfun$1);
        Seq all = args.all();
        if (!options.allowEmpty() && all.isEmpty()) {
            System.err.println("No key passed as argument.");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        all.foreach((Function1)(JProcedure1 & Serializable)key -> {
            Either<String, String> res;
            Either<String, String> either;
            String keyId;
            Path path = Path$.MODULE$.apply(key, os.package$.MODULE$.pwd(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$);
            if (!exists$.MODULE$.apply(path)) {
                System.err.println(new StringBuilder(17).append("Error: ").append((String)key).append(" not found").toString());
                throw scala.sys.package$.MODULE$.exit(1);
            }
            String keyContent = read$.MODULE$.apply((ReadablePath)path);
            String string = keyId = options.forceSigningBinary() ? (String)this.EitherBuildExceptionOps((Either)new PgpProxyMaker().get().keyId(keyContent, (String)key, (Cache<Task>)this.coursierCache$1(options, logger, lazyRef), logger)).orExit(logger) : (String)this.EitherBuildExceptionOps((Either)new PgpProxyMakerSubst().get().keyId(keyContent, (String)key, (Cache<Task>)this.coursierCache$1(options, logger, lazyRef), logger)).orExit(logger);
            if (keyId.isEmpty()) {
                if (options.force()) {
                    if (logger.verbosity() >= 0) {
                        System.err.println(new StringBuilder(64).append("Warning: ").append((String)key).append(" doesn't look like a PGP public key, proceeding anyway.").toString());
                    }
                } else {
                    System.err.println(new StringBuilder(85).append("Error: ").append((String)key).append(" doesn't look like a PGP public key. ").append("Use --force to force uploading it anyway.").toString());
                    throw scala.sys.package$.MODULE$.exit(1);
                }
            }
            if ((either = (res = KeyServer$.MODULE$.add(keyContent, keyServerUri, backend))) instanceof Left) {
                String error = (String)((Left)either).value();
                System.err.println(new StringBuilder(24).append("Error uploading key to ").append(keyServerUri).append(".").toString());
                if (logger.verbosity() >= 0) {
                    System.err.println(new StringBuilder(17).append("Server response: ").append(error).toString());
                }
                throw scala.sys.package$.MODULE$.exit(1);
            }
            if (!(either instanceof Right)) {
                throw new MatchError(either);
            }
            String name = keyId.isEmpty() ? key : new StringBuilder(2).append("0x").append(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(keyId), "0x")).toString();
            logger.message(() -> this.run$$anonfun$1$$anonfun$1(keyServerUri, name));
        });
    }

    private final Uri $anonfun$1() {
        return KeyServer$.MODULE$.default();
    }

    private final FileCache coursierCache$lzyINIT1$1(PgpPushOptions options$1, Logger logger$1, LazyRef coursierCache$lzy1$1) {
        FileCache fileCache;
        LazyRef lazyRef = coursierCache$lzy1$1;
        synchronized (lazyRef) {
            fileCache = (FileCache)(coursierCache$lzy1$1.initialized() ? coursierCache$lzy1$1.value() : coursierCache$lzy1$1.initialize(CommonOps$CoursierOptionsOps$.MODULE$.coursierCache$extension(CommonOps$.MODULE$.CoursierOptionsOps(options$1.coursier()), logger$1.coursierLogger(""))));
        }
        return fileCache;
    }

    private final FileCache coursierCache$1(PgpPushOptions options$2, Logger logger$2, LazyRef coursierCache$lzy1$2) {
        return (FileCache)(coursierCache$lzy1$2.initialized() ? coursierCache$lzy1$2.value() : this.coursierCache$lzyINIT1$1(options$2, logger$2, coursierCache$lzy1$2));
    }

    private final String run$$anonfun$1$$anonfun$1(Uri keyServerUri$2, String name$1) {
        return new StringBuilder(17).append("Key ").append(name$1).append(" uploaded to ").append(keyServerUri$2).toString();
    }
}

