/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.internal;

import ch.epfl.scala.bsp4j.DiagnosticSeverity;
import ch.epfl.scala.bsp4j.Range;
import coursier.cache.CacheLogger;
import coursier.cache.CacheLogger$;
import coursier.cache.loggers.FallbackRefreshDisplay;
import coursier.cache.loggers.FallbackRefreshDisplay$;
import coursier.cache.loggers.RefreshDisplay;
import coursier.cache.loggers.RefreshLogger$;
import coursier.paths.Util;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.scalajs.logging.Level;
import org.scalajs.logging.ScalaConsoleLogger;
import os.Path;
import os.ReadablePath;
import os.read$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.build.ConsoleBloopBuildClient$;
import scala.build.Logger;
import scala.build.Position;
import scala.build.blooprifle.BloopRifleLogger;
import scala.build.errors.BuildException;
import scala.build.errors.CompositeBuildException;
import scala.build.errors.Diagnostic;
import scala.build.errors.Severity;
import scala.build.internal.CustomProgressBarRefreshDisplay$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class CliLogger
implements Logger {
    private final int verbosity;
    private final boolean quiet;
    private final Option<Object> progress;
    public final PrintStream scala$cli$internal$CliLogger$$out;
    private final List scalaNativeCliInternalLoggerOptions;

    public CliLogger(int verbosity, boolean quiet, Option<Object> progress, PrintStream out) {
        this.verbosity = verbosity;
        this.quiet = quiet;
        this.progress = progress;
        this.scala$cli$internal$CliLogger$$out = out;
        this.scalaNativeCliInternalLoggerOptions = verbosity >= 1 ? (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-v", "-v", "-v"})) : (verbosity >= 0 ? (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-v", "-v"})) : (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])));
    }

    public int verbosity() {
        return this.verbosity;
    }

    public void log(Seq<Diagnostic> diagnostics) {
        HashMap hashMap = new HashMap();
        diagnostics.foreach((Function1)(JProcedure1 & Serializable)d -> this.printDiagnostic((Seq<Position>)d.positions(), d.severity(), d.message(), (Map<Path, Seq<String>>)hashMap));
    }

    public void error(String message) {
        this.scala$cli$internal$CliLogger$$out.println(message);
    }

    public void message(Function0<String> message) {
        if (this.verbosity() >= 0) {
            this.scala$cli$internal$CliLogger$$out.println((String)message.apply());
        }
    }

    public void log(Function0<String> message) {
        if (this.verbosity() >= 1) {
            this.scala$cli$internal$CliLogger$$out.println((String)message.apply());
        }
    }

    public void log(Function0<String> message, Function0<String> debugMessage) {
        if (this.verbosity() >= 2) {
            this.scala$cli$internal$CliLogger$$out.println((String)debugMessage.apply());
        } else if (this.verbosity() >= 1) {
            this.scala$cli$internal$CliLogger$$out.println((String)message.apply());
        }
    }

    public void debug(Function0<String> message) {
        if (this.verbosity() >= 2) {
            this.scala$cli$internal$CliLogger$$out.println((String)message.apply());
        }
    }

    public void printDiagnostic(Seq<Position> positions, Severity severity, String message, Map<Path, Seq<String>> contentCache) {
        if (positions.isEmpty()) {
            this.scala$cli$internal$CliLogger$$out.println(new StringBuilder(1).append(ConsoleBloopBuildClient$.MODULE$.diagnosticPrefix(Severity.Error$.MODULE$.equals(severity))).append(" ").append(message).toString());
        } else {
            Seq positions0 = (Seq)positions.distinct();
            Seq filePositions = (Seq)positions0.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Position x) {
                    boolean bl;
                    Position position = x;
                    if (position instanceof Position.File) {
                        Position.File f = (Position.File)position;
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public final Object applyOrElse(Position x, Function1 function1) {
                    Object object;
                    Position position = x;
                    if (position instanceof Position.File) {
                        Position.File f = (Position.File)position;
                        object = f;
                    } else {
                        object = function1.apply((Object)x);
                    }
                    return object;
                }
            });
            Seq otherPositions = (Seq)positions0.filter((Function1 & Serializable)x$1 -> {
                Position position = x$1;
                return !(position instanceof Position.File);
            });
            filePositions.foreach((Function1)(JProcedure1 & Serializable)f -> {
                DiagnosticSeverity diagnosticSeverity;
                ch.epfl.scala.bsp4j.Position startPos = new ch.epfl.scala.bsp4j.Position(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)f.startPos()._1())), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)f.startPos()._2())));
                ch.epfl.scala.bsp4j.Position endPos = new ch.epfl.scala.bsp4j.Position(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)f.endPos()._1())), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)f.endPos()._2())));
                Range range = new Range(startPos, endPos);
                ch.epfl.scala.bsp4j.Diagnostic diag = new ch.epfl.scala.bsp4j.Diagnostic(range, message);
                Severity severity = severity;
                if (Severity.Error$.MODULE$.equals(severity)) {
                    diagnosticSeverity = DiagnosticSeverity.ERROR;
                } else if (Severity.Warning$.MODULE$.equals(severity)) {
                    diagnosticSeverity = DiagnosticSeverity.WARNING;
                } else {
                    throw new MatchError((Object)severity);
                }
                diag.setSeverity(diagnosticSeverity);
                f.path().foreach((Function1)(JProcedure1 & Serializable)file -> {
                    Seq lines = (Seq)contentCache.getOrElseUpdate(file, () -> CliLogger.$anonfun$2(file));
                    if (BoxesRunTime.unboxToInt((Object)f.startPos()._1()) < lines.length()) {
                        diag.setCode((String)lines.apply(BoxesRunTime.unboxToInt((Object)f.startPos()._1())));
                    }
                });
                ConsoleBloopBuildClient$.MODULE$.printFileDiagnostic((Logger)this, f.path(), diag);
            });
            if (otherPositions.nonEmpty()) {
                ConsoleBloopBuildClient$.MODULE$.printOtherDiagnostic((Logger)this, message, severity, otherPositions);
            }
        }
    }

    private void printEx(BuildException ex2, Map<Path, Seq<String>> contentCache) {
        BuildException buildException = ex2;
        if (buildException instanceof CompositeBuildException) {
            CompositeBuildException c = (CompositeBuildException)buildException;
            c.exceptions().foreach((Function1)(JProcedure1 & Serializable)ex -> this.printEx((BuildException)ex, contentCache));
        } else {
            this.printDiagnostic((Seq<Position>)ex2.positions(), (Severity)Severity.Error$.MODULE$, ex2.getMessage(), contentCache);
        }
    }

    public void log(BuildException ex) {
        if (this.verbosity() >= 0) {
            this.printEx(ex, (Map<Path, Seq<String>>)new HashMap());
        }
    }

    public Nothing$ exit(BuildException ex) {
        Nothing$ nothing$;
        if (this.verbosity() < 0) {
            nothing$ = scala.sys.package$.MODULE$.exit(1);
        } else if (this.verbosity() == 0) {
            this.printEx(ex, (Map<Path, Seq<String>>)new HashMap());
            nothing$ = scala.sys.package$.MODULE$.exit(1);
        } else {
            throw new Exception((Throwable)ex);
        }
        return nothing$;
    }

    public CacheLogger coursierLogger(String printBefore) {
        return this.quiet ? CacheLogger$.MODULE$.nop() : (BoxesRunTime.unboxToBoolean((Object)this.progress.getOrElse(CliLogger::coursierLogger$$anonfun$1)) ? RefreshLogger$.MODULE$.create((RefreshDisplay)CustomProgressBarRefreshDisplay$.MODULE$.create(this.verbosity() >= 1, (Function0)((JFunction0.mcV.sp & Serializable)() -> CliLogger.coursierLogger$$anonfun$2(printBefore)), (Function0)((JFunction0.mcV.sp & Serializable)CliLogger::coursierLogger$$anonfun$3))) : RefreshLogger$.MODULE$.create((RefreshDisplay)new FallbackRefreshDisplay(FallbackRefreshDisplay$.MODULE$.$lessinit$greater$default$1())));
    }

    public BloopRifleLogger bloopRifleLogger() {
        return new BloopRifleLogger(this){
            private final /* synthetic */ CliLogger $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void info(Function0 msg) {
                this.$outer.message((Function0<String>)msg);
            }

            public void debug(Function0 msg) {
                if (this.$outer.verbosity() >= 3) {
                    this.$outer.debug((Function0<String>)msg);
                }
            }

            public void error(Function0 msg, Throwable ex) {
                this.$outer.log((Function0<String>)((Function0 & Serializable)() -> CliLogger.scala$cli$internal$CliLogger$$anon$2$$_$error$$anonfun$1(msg, ex)));
            }

            public Option bloopBspStdout() {
                return this.$outer.verbosity() >= 2 ? Some$.MODULE$.apply((Object)this.$outer.scala$cli$internal$CliLogger$$out) : None$.MODULE$;
            }

            public Option bloopBspStderr() {
                return this.$outer.verbosity() >= 2 ? Some$.MODULE$.apply((Object)this.$outer.scala$cli$internal$CliLogger$$out) : None$.MODULE$;
            }

            public boolean bloopCliInheritStdout() {
                return this.$outer.verbosity() >= 3;
            }

            public boolean bloopCliInheritStderr() {
                return this.$outer.verbosity() >= 3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{scala$cli$internal$CliLogger$$anon$2$$_$error$$anonfun$1(scala.Function0 java.lang.Throwable )}, serializedLambda);
            }
        };
    }

    public org.scalajs.logging.Logger scalaJsLogger() {
        return new ScalaConsoleLogger((Level)(this.verbosity() >= 2 ? Level.Debug$.MODULE$ : (this.verbosity() >= 1 ? Level.Info$.MODULE$ : (Level)(this.verbosity() >= 0 ? Level.Warn$.MODULE$ : Level.Error$.MODULE$))));
    }

    public scala.scalanative.build.Logger scalaNativeTestLogger() {
        return new scala.scalanative.build.Logger(this){
            private final /* synthetic */ CliLogger $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void trace(Throwable msg) {
            }

            public void debug(String msg) {
                this.$outer.debug((Function0<String>)((Function0 & Serializable)() -> CliLogger.scala$cli$internal$CliLogger$$anon$3$$_$debug$$anonfun$1(msg)));
            }

            public void info(String msg) {
                this.$outer.log((Function0<String>)((Function0 & Serializable)() -> CliLogger.scala$cli$internal$CliLogger$$anon$3$$_$info$$anonfun$1(msg)));
            }

            public void warn(String msg) {
                this.$outer.log((Function0<String>)((Function0 & Serializable)() -> CliLogger.scala$cli$internal$CliLogger$$anon$3$$_$warn$$anonfun$1(msg)));
            }

            public void error(String msg) {
                this.$outer.message((Function0<String>)((Function0 & Serializable)() -> CliLogger.scala$cli$internal$CliLogger$$anon$3$$_$error$$anonfun$2(msg)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{scala$cli$internal$CliLogger$$anon$3$$_$debug$$anonfun$1(java.lang.String ), scala$cli$internal$CliLogger$$anon$3$$_$info$$anonfun$1(java.lang.String ), scala$cli$internal$CliLogger$$anon$3$$_$warn$$anonfun$1(java.lang.String ), scala$cli$internal$CliLogger$$anon$3$$_$error$$anonfun$2(java.lang.String )}, serializedLambda);
            }
        };
    }

    public List<String> scalaNativeCliInternalLoggerOptions() {
        return this.scalaNativeCliInternalLoggerOptions;
    }

    public PrintStream compilerOutputStream() {
        return this.scala$cli$internal$CliLogger$$out;
    }

    private static final Vector $anonfun$2(Path file$1) {
        return StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(read$.MODULE$.apply((ReadablePath)file$1))).toVector();
    }

    private static final boolean coursierLogger$$anonfun$1() {
        return Util.useAnsiOutput();
    }

    private static final void coursierLogger$$anonfun$2(String printBefore$1) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(printBefore$1))) {
            System.err.println(printBefore$1);
        }
    }

    private static final void coursierLogger$$anonfun$3() {
    }

    public static final String scala$cli$internal$CliLogger$$anon$2$$_$error$$anonfun$1(Function0 msg$1, Throwable ex$1) {
        return new StringBuilder(10).append("Error: ").append(msg$1.apply()).append(" (").append(ex$1).append(")").toString();
    }

    public static final String scala$cli$internal$CliLogger$$anon$3$$_$debug$$anonfun$1(String msg$2) {
        return msg$2;
    }

    public static final String scala$cli$internal$CliLogger$$anon$3$$_$info$$anonfun$1(String msg$3) {
        return msg$3;
    }

    public static final String scala$cli$internal$CliLogger$$anon$3$$_$warn$$anonfun$1(String msg$4) {
        return msg$4;
    }

    public static final String scala$cli$internal$CliLogger$$anon$3$$_$error$$anonfun$2(String msg$5) {
        return msg$5;
    }
}

