/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.config;

import coursier.parse.RawJson;
import coursier.parse.RawJson$;
import geny.Writable$;
import java.io.Serializable;
import java.nio.file.attribute.PosixFilePermission;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.PermSet;
import os.PermSet$;
import os.Source;
import os.Source$;
import os.exists$;
import os.makeDir;
import os.perms$;
import os.write;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.build.Directories;
import scala.build.errors.BuildException;
import scala.build.errors.BuildException$;
import scala.cli.config.ConfigDb$;
import scala.cli.config.ConfigDb$ConfigDbFormatError$;
import scala.cli.config.Key;
import scala.collection.IterableOnce;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;

public final class ConfigDb {
    private Map rawEntries;

    public static Either<ConfigDbFormatError, ConfigDb> apply(byte[] byArray, Option<String> option) {
        return ConfigDb$.MODULE$.apply(byArray, option);
    }

    public static Path dbPath(Directories directories) {
        return ConfigDb$.MODULE$.dbPath(directories);
    }

    public static String defaultDbFileName() {
        return ConfigDb$.MODULE$.defaultDbFileName();
    }

    public static ConfigDb empty() {
        return ConfigDb$.MODULE$.empty();
    }

    public static Either<BuildException, ConfigDb> open(Directories directories) {
        return ConfigDb$.MODULE$.open(directories);
    }

    public static Either<BuildException, ConfigDb> open(Path path) {
        return ConfigDb$.MODULE$.open(path);
    }

    public static Option<String> apply$default$2() {
        return ConfigDb$.MODULE$.apply$default$2();
    }

    public ConfigDb(Map<String, byte[]> rawEntries) {
        this.rawEntries = rawEntries;
    }

    public Map<String, byte[]> rawEntries() {
        return this.rawEntries;
    }

    public void rawEntries_$eq(Map<String, byte[]> x$1) {
        this.rawEntries = x$1;
    }

    public <T> Either<ConfigDbFormatError, Option<T>> get(Key<T> key) {
        Right right;
        Option option = this.rawEntries().get((Object)key.fullName());
        if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Right().apply((Object)None$.MODULE$);
        } else if (option instanceof Some) {
            byte[] rawEntryContent = (byte[])((Some)option).value();
            right = key.parse(rawEntryContent).left().map((Function1 & Serializable)e -> new ConfigDbFormatError(new StringBuilder(20).append("Error parsing ").append(key.fullName()).append(" value").toString(), (Option<Throwable>)Some$.MODULE$.apply((Object)e))).map((Function1 & Serializable)_$1 -> Some$.MODULE$.apply(_$1));
        } else {
            throw new MatchError((Object)option);
        }
        return right;
    }

    public <T> ConfigDb set(Key<T> key, T value) {
        byte[] b = key.write(value);
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key.fullName());
        this.rawEntries_$eq((Map<String, byte[]>)((Map)this.rawEntries().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)b))));
        return this;
    }

    public ConfigDb remove(Key<?> key) {
        this.rawEntries_$eq((Map<String, byte[]>)((Map)this.rawEntries().$minus((Object)key.fullName())));
        return this;
    }

    public <T> Either<ConfigDbFormatError, Option<Seq<String>>> getAsString(Key<T> key) {
        return this.get(key).map((Function1 & Serializable)_$2 -> _$2.map((Function1 & Serializable)value -> key.asString(value)));
    }

    public <T> Either<Key.MalformedValue, ConfigDb> setFromString(Key<T> key, Seq<String> values) {
        return key.fromString(values).map((Function1 & Serializable)typedValue -> this.set(key, typedValue));
    }

    public byte[] dump() {
        return ConfigDb.serializeMap$1(this.rawEntries());
    }

    public Either<ConfigDbPermissionsError, BoxedUnit> saveUnsafe(Path path) {
        Left left;
        Path dir = path.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(os.package$.MODULE$.up()));
        if (Properties$.MODULE$.isWin()) {
            Source.WritableSource writableSource = Source$.MODULE$.WritableSource((Object)this.dump(), (Function1 & Serializable)a -> Writable$.MODULE$.ByteArrayWritable(a));
            PermSet permSet = write.over$.MODULE$.apply$default$3();
            long l = write.over$.MODULE$.apply$default$4();
            boolean bl = write.over$.MODULE$.apply$default$6();
            write.over$.MODULE$.apply(path, (Source)writableSource, permSet, l, true, bl);
            left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            PermSet dirPerms;
            boolean permsOk;
            if (!exists$.MODULE$.apply(dir)) {
                makeDir.all$.MODULE$.apply(dir, PermSet$.MODULE$.fromString("rwx------"), makeDir.all$.MODULE$.apply$default$3());
            }
            boolean bl = permsOk = !(dirPerms = perms$.MODULE$.apply(dir)).contains(PosixFilePermission.GROUP_READ) && !dirPerms.contains(PosixFilePermission.GROUP_WRITE) && !dirPerms.contains(PosixFilePermission.GROUP_EXECUTE) && !dirPerms.contains(PosixFilePermission.OTHERS_READ) && !dirPerms.contains(PosixFilePermission.OTHERS_WRITE) && !dirPerms.contains(PosixFilePermission.OTHERS_EXECUTE);
            if (permsOk) {
                Source.WritableSource writableSource = Source$.MODULE$.WritableSource((Object)this.dump(), (Function1 & Serializable)a -> Writable$.MODULE$.ByteArrayWritable(a));
                PermSet permSet = PermSet$.MODULE$.fromString("rw-------");
                long l = write.over$.MODULE$.apply$default$4();
                boolean bl2 = write.over$.MODULE$.apply$default$6();
                write.over$.MODULE$.apply(path, (Source)writableSource, permSet, l, false, bl2);
                left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else {
                left = package$.MODULE$.Left().apply((Object)new ConfigDbPermissionsError(path, dirPerms));
            }
        }
        return left;
    }

    public Either<BuildException, BoxedUnit> save(Directories directories) {
        Path path = ConfigDb$.MODULE$.dbPath(directories);
        return this.saveUnsafe(path);
    }

    private static final byte[] serializeMap$1(Map m) {
        Vector keyValues = (Vector)((StrictOptimizedIterableOps)m.groupBy((Function1 & Serializable)_$3 -> ((String)_$3._1()).split("\\.", 2)[0]).toVector().sortBy((Function1 & Serializable)_$4 -> (String)_$4._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Map v = (Map)tuple2._2();
            Map v0 = (Map)v.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k1 = (String)tuple2._1();
                byte[] v1 = (byte[])tuple2._2();
                return Tuple2$.MODULE$.apply((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(k1), k)), "."), (Object)v1);
            });
            return Tuple2$.MODULE$.apply((Object)k, (Object)ConfigDb.serialize$1(v0));
        });
        ListMap sortedMap = ListMap$.MODULE$.from((IterableOnce)keyValues);
        return com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.writeToArray((Object)sortedMap, com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.writeToArray$default$2(), ConfigDb$.scala$cli$config$ConfigDb$$$codec);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final RawJson serialize$1(Map m) {
        RawJson rawJson;
        Option option = m.get((Object)"");
        if (option instanceof Some) {
            byte[] value = (byte[])((Some)option).value();
            if (m.size() != 1) throw scala.sys.package$.MODULE$.error(new StringBuilder(19).append("Inconsistent keys: ").append(m.keySet().toVector().sorted((Ordering)Ordering.String$.MODULE$)).toString());
            rawJson = RawJson$.MODULE$.apply(value);
            return rawJson;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            rawJson = RawJson$.MODULE$.apply(ConfigDb.serializeMap$1(m));
        }
        return rawJson;
    }

    public static final class ConfigDbFormatError
    extends BuildException {
        public static Option<Throwable> $lessinit$greater$default$2() {
            return ConfigDb$ConfigDbFormatError$.MODULE$.$lessinit$greater$default$2();
        }

        public ConfigDbFormatError(String message, Option<Throwable> causeOpt) {
            Throwable throwable = (Throwable)causeOpt.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Seq seq = BuildException$.MODULE$.$lessinit$greater$default$2();
            super(message, seq, throwable);
        }
    }

    public static final class ConfigDbPermissionsError
    extends BuildException {
        public ConfigDbPermissionsError(Path path, PermSet perms2) {
            super(new StringBuilder(44).append(path).append(" has wrong permissions ").append(perms2).append(" (expected rwx------)").toString(), BuildException$.MODULE$.$lessinit$greater$default$2(), BuildException$.MODULE$.$lessinit$greater$default$3());
        }
    }
}

