/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.commands.installhome;

import caseapp.core.RemainingArgs;
import caseapp.core.help.HelpFormat;
import coursier.env.EnvironmentUpdate;
import coursier.env.EnvironmentUpdate$;
import coursier.env.ProfileUpdater;
import coursier.env.ProfileUpdater$;
import coursier.paths.Util;
import os.CommandResult;
import os.Path;
import os.Path$;
import os.PathChunk;
import os.PathConvertible;
import os.PermSet$;
import os.ProcessInput;
import os.ProcessOutput;
import os.Shellable;
import os.Shellable$;
import os.copy$;
import os.exists$;
import os.isFile$;
import os.perms;
import os.proc;
import os.proc$;
import os.remove$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.build.Directories$;
import scala.build.Logger;
import scala.cli.commands.CommandUtils$;
import scala.cli.commands.CustomWindowsEnvVarUpdater;
import scala.cli.commands.CustomWindowsEnvVarUpdater$;
import scala.cli.commands.ScalaCommand;
import scala.cli.commands.SpecificationLevel;
import scala.cli.commands.installhome.InstallHomeOptions;
import scala.cli.commands.installhome.InstallHomeOptions$;
import scala.cli.commands.shared.HelpGroup$;
import scala.cli.util.ArgHelpers$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.StdIn$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Properties$;

public final class InstallHome$
extends ScalaCommand<InstallHomeOptions> {
    public static final InstallHome$ MODULE$ = new InstallHome$();

    private InstallHome$() {
        super(InstallHomeOptions$.MODULE$.parser(), InstallHomeOptions$.MODULE$.help());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(InstallHome$.class);
    }

    @Override
    public boolean hidden() {
        return true;
    }

    @Override
    public SpecificationLevel scalaSpecificationLevel() {
        this.SpecificationLevel();
        return SpecificationLevel.IMPLEMENTATION$.MODULE$;
    }

    @Override
    public HelpFormat helpFormat() {
        return ArgHelpers$.MODULE$.withPrimaryGroup(super.helpFormat(), HelpGroup$.Install);
    }

    private Nothing$ logEqual(String version, Logger logger) {
        logger.message(() -> InstallHome$.logEqual$$anonfun$1(version));
        return scala.sys.package$.MODULE$.exit(0);
    }

    private void logUpdate(boolean env, String newVersion, String oldVersion, Logger logger) {
        if (!env) {
            logger.message(() -> InstallHome$.logUpdate$$anonfun$1(oldVersion, newVersion));
            return;
        }
    }

    private void logDowngrade(boolean env, String newVersion, String oldVersion, Logger logger) {
        if (!env && Util.useAnsiOutput()) {
            String response;
            logger.message(() -> InstallHome$.logDowngrade$$anonfun$1(oldVersion));
            logger.error(new StringBuilder(43).append("Do you want to downgrade ").append(this.baseRunnerName()).append(" to version ").append(newVersion).append(" [Y/n]").toString());
            String string = response = StdIn$.MODULE$.readLine();
            String string2 = "Y";
            if (string == null ? string2 != null : !string.equals(string2)) {
                logger.message(InstallHome$::logDowngrade$$anonfun$2);
                throw scala.sys.package$.MODULE$.exit(1);
            }
            return;
        }
        logger.error(new StringBuilder(79).append("Error: ").append(this.baseRunnerName()).append(" is already installed ").append(oldVersion).append(" and up-to-date. Downgrade to ").append(newVersion).append(" pass -f or --force.").toString());
        throw scala.sys.package$.MODULE$.exit(1);
    }

    @Override
    public void runCommand(InstallHomeOptions options, RemainingArgs args, Logger logger) {
        boolean bl;
        String oldVersion;
        boolean bl2;
        long l;
        boolean bl3;
        long l2;
        boolean bl4;
        ProcessOutput processOutput;
        ProcessOutput processOutput2;
        ProcessInput processInput;
        Map map;
        Path path;
        proc proc2;
        CommandResult res;
        Path binDirPath = (Path)options.binDirPath().getOrElse(InstallHome$::$anonfun$1);
        Path destBinPath = binDirPath.$div((PathChunk)new PathChunk.StringPathChunk(options.binaryName()));
        Path newScalaCliBinPath = Path$.MODULE$.apply((Object)options.scalaCliBinaryPath(), os.package$.MODULE$.pwd(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$);
        proc proc3 = proc$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Shellable[]{Shellable$.MODULE$.PathShellable(newScalaCliBinPath), Shellable$.MODULE$.StringShellable("version"), Shellable$.MODULE$.StringShellable("--cli-version")}));
        String newVersion = proc3.call(os.package$.MODULE$.pwd(), proc3.call$default$2(), proc3.call$default$3(), proc3.call$default$4(), proc3.call$default$5(), proc3.call$default$6(), proc3.call$default$7(), proc3.call$default$8(), proc3.call$default$9(), proc3.call$default$10(), proc3.call$default$11()).out().trim();
        String string = isFile$.MODULE$.apply(destBinPath) ? ((res = (proc2 = proc$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Shellable[]{Shellable$.MODULE$.PathShellable(destBinPath), Shellable$.MODULE$.StringShellable("version"), Shellable$.MODULE$.StringShellable("--cli-version")}))).call(path = os.package$.MODULE$.pwd(), map = proc2.call$default$2(), processInput = proc2.call$default$3(), processOutput2 = proc2.call$default$4(), processOutput = proc2.call$default$5(), bl4 = proc2.call$default$6(), l2 = proc2.call$default$7(), false, bl3 = proc2.call$default$9(), l = proc2.call$default$10(), bl2 = proc2.call$default$11())).exitCode() == 0 ? res.out().trim() : "0.0.0") : (oldVersion = "0.0.0");
        if (exists$.MODULE$.apply(binDirPath) && !options.force()) {
            String string2 = newVersion;
            String string3 = oldVersion;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                throw this.logEqual(newVersion, logger);
            }
            if (CommandUtils$.MODULE$.isOutOfDateVersion(newVersion, oldVersion)) {
                this.logUpdate(options.env(), newVersion, oldVersion, logger);
            } else {
                this.logDowngrade(options.env(), newVersion, oldVersion, logger);
            }
        }
        if (exists$.MODULE$.apply(destBinPath)) {
            remove$.MODULE$.apply(destBinPath);
        }
        copy$.MODULE$.apply(newScalaCliBinPath, destBinPath, copy$.MODULE$.apply$default$3(), copy$.MODULE$.apply$default$4(), copy$.MODULE$.apply$default$5(), true, copy$.MODULE$.apply$default$7());
        if (!Properties$.MODULE$.isWin()) {
            perms.set$.MODULE$.apply(destBinPath, PermSet$.MODULE$.fromString("rwxr-xr-x"));
        }
        if (options.env()) {
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("export PATH=\"").append(binDirPath).append(":$PATH\"").toString());
            return;
        }
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"PATH");
        EnvironmentUpdate update = EnvironmentUpdate$.MODULE$.apply((Seq)package$.MODULE$.Nil(), (Seq)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)binDirPath.toString()), (List)Nil$.MODULE$)));
        if (Properties$.MODULE$.isWin()) {
            CustomWindowsEnvVarUpdater updater = CustomWindowsEnvVarUpdater$.MODULE$.apply(CustomWindowsEnvVarUpdater$.MODULE$.$lessinit$greater$default$1(), CustomWindowsEnvVarUpdater$.MODULE$.$lessinit$greater$default$2()).withUseJni((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)Util.useJni())));
            bl = updater.applyUpdate(update);
        } else {
            ProfileUpdater updater = ProfileUpdater$.MODULE$.apply();
            bl = updater.applyUpdate(update);
        }
        boolean didUpdate = bl;
        Predef$.MODULE$.println((Object)new StringBuilder(24).append("Successfully installed ").append(this.baseRunnerName()).append(" ").append(newVersion).toString());
        if (didUpdate) {
            if (Properties$.MODULE$.isLinux()) {
                Predef$.MODULE$.println((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(103).append("|Profile file(s) updated.\n                |To run ").append(this.baseRunnerName()).append(", log out and log back in, or run 'source ~/.profile'").toString())));
            }
            if (Properties$.MODULE$.isMac()) {
                Predef$.MODULE$.println((Object)new StringBuilder(53).append("To run ").append(this.baseRunnerName()).append(", open new terminal or run 'source ~/.profile'").toString());
                return;
            }
            return;
        }
    }

    private static final String logEqual$$anonfun$1(String version$1) {
        return new StringBuilder(38).append(MODULE$.fullRunnerName()).append(" ").append(version$1).append(" is already installed and up-to-date.").toString();
    }

    private static final String logUpdate$$anonfun$1(String oldVersion$1, String newVersion$1) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(89).append(MODULE$.baseRunnerName()).append(" ").append(oldVersion$1).append(" is already installed and out-of-date.\n         |").append(MODULE$.baseRunnerName()).append(" will be updated to version ").append(newVersion$1).append("\n         |").toString()));
    }

    private static final String logDowngrade$$anonfun$1(String oldVersion$2) {
        return new StringBuilder(38).append(MODULE$.baseRunnerName()).append(" ").append(oldVersion$2).append(" is already installed and up-to-date.").toString();
    }

    private static final String logDowngrade$$anonfun$2() {
        return "Abort";
    }

    private static final Path $anonfun$1() {
        String s$proxy1 = MODULE$.baseRunnerName();
        return Directories$.MODULE$.default().binRepoDir().$div((PathChunk)new PathChunk.StringPathChunk(s$proxy1));
    }
}

