/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.commands.publish.checks;

import coursier.cache.ArchiveCache$;
import coursier.cache.FileCache;
import coursier.util.Task;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import os.Path;
import os.Path$;
import os.PathConvertible;
import os.RelPath;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.build.EitherCps$;
import scala.build.Logger;
import scala.build.Ops;
import scala.build.Ops$;
import scala.build.errors.BuildException;
import scala.build.errors.BuildException$;
import scala.build.errors.CompositeBuildException$;
import scala.build.errors.MalformedCliInputError;
import scala.build.internal.util.WarningMessages$;
import scala.build.options.BuildOptions;
import scala.build.options.JavaOptions;
import scala.build.options.PublishContextualOptions;
import scala.build.options.PublishOptions;
import scala.build.options.publish.ConfigPasswordOption;
import scala.cli.commands.config.ThrowawayPgpSecret$;
import scala.cli.commands.pgp.KeyServer$;
import scala.cli.commands.pgp.PgpProxyMaker;
import scala.cli.commands.publish.ConfigUtil$;
import scala.cli.commands.publish.OptionCheck;
import scala.cli.commands.publish.OptionCheck$DefaultValue$;
import scala.cli.commands.publish.OptionCheck$Kind$Signing$;
import scala.cli.commands.publish.PublishSetupOptions;
import scala.cli.commands.publish.SetSecret;
import scala.cli.commands.publish.SetSecret$;
import scala.cli.commands.publish.checks.PgpSecretKeyCheck$;
import scala.cli.commands.publish.checks.PgpSecretKeyCheck$PGPKeys$;
import scala.cli.commands.util.JvmUtils$;
import scala.cli.config.ConfigDb;
import scala.cli.config.Key;
import scala.cli.config.Keys$;
import scala.cli.config.PasswordOption;
import scala.cli.errors.MissingPublishOptionError;
import scala.cli.errors.MissingPublishOptionError$;
import scala.cli.signing.shared.PasswordOption;
import scala.cli.signing.shared.Secret;
import scala.cli.util.ConfigPasswordOptionHelpers$;
import scala.cli.util.ConfigPasswordOptionHelpers$ConfigPasswordOptionOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.matching.Regex;
import sttp.client3.SttpBackend;
import sttp.model.Uri;
import sttp.model.Uri$;

public final class PgpSecretKeyCheck
implements OptionCheck,
Product,
Serializable {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(PgpSecretKeyCheck.class.getDeclaredField("maybeKeysFromConfig$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(PgpSecretKeyCheck.class.getDeclaredField("keysFromOptions$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PgpSecretKeyCheck.class.getDeclaredField("keyServers$lzy1"));
    private final PublishSetupOptions options;
    private final FileCache coursierCache;
    private final Function0 configDb;
    private final Logger logger;
    private final SttpBackend backend;
    private volatile Object keyServers$lzy1;
    public final PgpSecretKeyCheck$PGPKeys$ PGPKeys$lzy1;
    private final MissingPublishOptionError missingSecretKeyError;
    private volatile Object keysFromOptions$lzy1;
    private volatile Object maybeKeysFromConfig$lzy1;

    public static PgpSecretKeyCheck apply(PublishSetupOptions publishSetupOptions, FileCache<Task> fileCache, Function0<ConfigDb> function0, Logger logger, SttpBackend<Object, Object> sttpBackend) {
        return PgpSecretKeyCheck$.MODULE$.apply(publishSetupOptions, fileCache, function0, logger, sttpBackend);
    }

    public static PgpSecretKeyCheck fromProduct(Product product) {
        return PgpSecretKeyCheck$.MODULE$.fromProduct(product);
    }

    public static PgpSecretKeyCheck unapply(PgpSecretKeyCheck pgpSecretKeyCheck) {
        return PgpSecretKeyCheck$.MODULE$.unapply(pgpSecretKeyCheck);
    }

    public PgpSecretKeyCheck(PublishSetupOptions options, FileCache<Task> coursierCache, Function0<ConfigDb> configDb, Logger logger, SttpBackend<Object, Object> backend) {
        this.options = options;
        this.coursierCache = coursierCache;
        this.configDb = configDb;
        this.logger = logger;
        this.backend = backend;
        this.PGPKeys$lzy1 = new PgpSecretKeyCheck$PGPKeys$(this);
        this.missingSecretKeyError = new MissingPublishOptionError("publish secret key", "--secret-key", "publish.secretKey", (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)Keys$.MODULE$.pgpSecretKey().fullName(), (List)Nil$.MODULE$))), new StringBuilder(73).append("also specify publish.secretKeyPassword / --secret-key-password if needed.").append(options.publishParams().setupCi() ? " Alternatively, pass --random-secret-key" : "").toString());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof PgpSecretKeyCheck)) return false;
        PgpSecretKeyCheck pgpSecretKeyCheck = (PgpSecretKeyCheck)object;
        PublishSetupOptions publishSetupOptions = this.options();
        PublishSetupOptions publishSetupOptions2 = pgpSecretKeyCheck.options();
        if (publishSetupOptions == null) {
            if (publishSetupOptions2 != null) {
                return false;
            }
        } else if (!((Object)publishSetupOptions).equals(publishSetupOptions2)) return false;
        FileCache<Task> fileCache = this.coursierCache();
        FileCache<Task> fileCache2 = pgpSecretKeyCheck.coursierCache();
        if (fileCache == null) {
            if (fileCache2 != null) {
                return false;
            }
        } else if (!fileCache.equals(fileCache2)) return false;
        Function0<ConfigDb> function0 = this.configDb();
        Function0<ConfigDb> function02 = pgpSecretKeyCheck.configDb();
        if (function0 == null) {
            if (function02 != null) {
                return false;
            }
        } else if (!function0.equals(function02)) return false;
        Logger logger = this.logger();
        Logger logger2 = pgpSecretKeyCheck.logger();
        if (logger == null) {
            if (logger2 != null) {
                return false;
            }
        } else if (!logger.equals(logger2)) return false;
        SttpBackend<Object, Object> sttpBackend = this.backend();
        SttpBackend<Object, Object> sttpBackend2 = pgpSecretKeyCheck.backend();
        if (sttpBackend == null) {
            if (sttpBackend2 == null) return true;
            return false;
        } else {
            if (!sttpBackend.equals(sttpBackend2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof PgpSecretKeyCheck;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "PgpSecretKeyCheck";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "options";
            }
            case 1: {
                return "coursierCache";
            }
            case 2: {
                return "configDb";
            }
            case 3: {
                return "logger";
            }
            case 4: {
                return "backend";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public PublishSetupOptions options() {
        return this.options;
    }

    public FileCache<Task> coursierCache() {
        return this.coursierCache;
    }

    public Function0<ConfigDb> configDb() {
        return this.configDb;
    }

    public Logger logger() {
        return this.logger;
    }

    public SttpBackend<Object, Object> backend() {
        return this.backend;
    }

    @Override
    public OptionCheck.Kind kind() {
        return OptionCheck$Kind$Signing$.MODULE$;
    }

    @Override
    public String fieldName() {
        return "pgp-secret-key";
    }

    @Override
    public String directivePath() {
        return new StringBuilder(17).append("publish").append(this.options().publishParams().setupCi() ? ".ci" : "").append(".secretKey").toString();
    }

    @Override
    public boolean check(PublishOptions pubOpt) {
        PublishContextualOptions opt0 = pubOpt.retained(this.options().publishParams().setupCi());
        return opt0.repository().orElse(this::check$$anonfun$1).contains((Object)"github") || opt0.secretKey().isDefined() && opt0.secretKeyPassword().isDefined() && opt0.publicKey().isDefined() && BoxesRunTime.unboxToBoolean((Object)this.isKeyUploaded((Option<scala.cli.signing.shared.PasswordOption>)ConfigPasswordOptionHelpers$ConfigPasswordOptionOps$.MODULE$.get$extension(ConfigPasswordOptionHelpers$.MODULE$.ConfigPasswordOptionOps((ConfigPasswordOption)opt0.publicKey().get()), (Function0<ConfigDb>)((Function0 & Serializable)this::check$$anonfun$2)).toOption().map((Function1 & Serializable)_$1 -> ConfigUtil$.MODULE$.toCliSigning((PasswordOption)_$1))).getOrElse(PgpSecretKeyCheck::check$$anonfun$4)) || opt0.gpgSignatureId().isDefined();
    }

    public Either<BuildException, Function0<String>> javaCommand() {
        return EitherCps$.MODULE$.either().apply((Function1 & Serializable)evidence$1 -> (Function0 & Serializable)() -> ((BuildOptions.JavaHomeInfo)((JavaOptions)EitherCps$.MODULE$.value(evidence$1, JvmUtils$.MODULE$.javaOptions(this.options().sharedJvm()))).javaHome(ArchiveCache$.MODULE$.apply(ArchiveCache$.MODULE$.apply$default$1()).withCache(this.coursierCache()), this.coursierCache(), this.logger().verbosity()).value()).javaCommand());
    }

    private Either<BuildException, Seq<Uri>> keyServers() {
        Object object = this.keyServers$lzy1;
        if (object instanceof Either) {
            return (Either)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Either)this.keyServers$lzyINIT1();
    }

    private Object keyServers$lzyINIT1() {
        Object object;
        block9: {
            while (true) {
                if ((object = this.keyServers$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Right right = null;
                    try {
                        Right right2;
                        List rawKeyServers = this.options().sharedPgp().keyServer().filter((Function1 & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$2.trim())));
                        if (rawKeyServers.isEmpty()) {
                            right2 = package$.MODULE$.Right().apply(KeyServer$.MODULE$.allDefaults());
                        } else {
                            Seq seq = Ops$.MODULE$.EitherSeqOps((Seq)rawKeyServers.map((Function1 & Serializable)keyServerUriStr -> Uri$.MODULE$.parse(keyServerUriStr).left().map((Function1 & Serializable)err -> new MalformedCliInputError(new StringBuilder(29).append("Malformed key server URI '").append((String)keyServerUriStr).append("': ").append((String)err).toString()))));
                            right2 = right = Ops.EitherSeqOps$.MODULE$.sequence$extension(seq).left().map((Function1 & Serializable)_$3 -> CompositeBuildException$.MODULE$.apply(_$3));
                        }
                        object2 = right == null ? LazyVals.NullValue$.MODULE$ : right;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.keyServers$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.keyServers$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return right;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block9;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Either<BuildException, Object> isKeyUploaded(Option<scala.cli.signing.shared.PasswordOption> pubKeyOpt) {
        return EitherCps$.MODULE$.either().apply((Function1 & Serializable)evidence$2 -> {
            Option option = pubKeyOpt;
            if (option instanceof Some) {
                scala.cli.signing.shared.PasswordOption pubKey = (scala.cli.signing.shared.PasswordOption)((Some)option).value();
                String keyId = (String)EitherCps$.MODULE$.value(evidence$2, new PgpProxyMaker().get(Predef$.MODULE$.boolean2Boolean(BoxesRunTime.unboxToBoolean((Object)this.options().scalaSigning().forceSigningExternally().getOrElse(PgpSecretKeyCheck::$anonfun$2)))).keyId((String)pubKey.get().value(), "[generated key]", this.coursierCache(), this.logger(), this.options().sharedJvm(), this.options().coursier(), this.options().scalaSigning().cliOptions()));
                return ((IterableOnceOps)EitherCps$.MODULE$.value(evidence$2, this.keyServers())).forall((Function1 & Serializable)keyServer -> {
                    Either<String, Either<String, String>> either = KeyServer$.MODULE$.check(keyId, (Uri)keyServer, this.backend());
                    if (either instanceof Right) {
                        Either either2 = (Either)((Right)either).value();
                        if (either2 instanceof Right) {
                            return true;
                        }
                        if (either2 instanceof Left) {
                            String msg = (String)((Left)either2).value();
                            this.logger().debug(() -> PgpSecretKeyCheck.isKeyUploaded$$anonfun$1$$anonfun$1$$anonfun$1(keyServer, msg));
                            return false;
                        }
                    }
                    if (either instanceof Left) {
                        String err = (String)((Left)either).value();
                        this.logger().error(new StringBuilder(21).append("Error checking ").append(keyId).append(" at ").append(keyServer).append(": ").append(err).toString());
                        return false;
                    }
                    throw new MatchError(either);
                });
            }
            if (None$.MODULE$.equals(option)) {
                return false;
            }
            throw new MatchError((Object)option);
        });
    }

    private final PgpSecretKeyCheck$PGPKeys$ PGPKeys() {
        return this.PGPKeys$lzy1;
    }

    public MissingPublishOptionError missingSecretKeyError() {
        return this.missingSecretKeyError;
    }

    private PGPKeys keysFromOptions() {
        Object object = this.keysFromOptions$lzy1;
        if (object instanceof PGPKeys) {
            return (PGPKeys)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (PGPKeys)this.keysFromOptions$lzyINIT1();
    }

    private Object keysFromOptions$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.keysFromOptions$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    PGPKeys pGPKeys = null;
                    try {
                        pGPKeys = this.PGPKeys().apply((Option<ConfigPasswordOption>)this.options().publishParams().secretKey().map((Function1 & Serializable)_$4 -> _$4.configPasswordOptions()), (Option<ConfigPasswordOption>)this.options().publishParams().secretKeyPassword().map((Function1 & Serializable)_$5 -> _$5.configPasswordOptions()), (Option<ConfigPasswordOption>)this.options().publicKey().map((Function1 & Serializable)option -> ConfigPasswordOption.ActualOption$.MODULE$.apply(option)));
                        object2 = pGPKeys == null ? LazyVals.NullValue$.MODULE$ : pGPKeys;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.keysFromOptions$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.keysFromOptions$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return pGPKeys;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Either<BuildException, PGPKeys> maybeKeysFromConfig() {
        Object object = this.maybeKeysFromConfig$lzy1;
        if (object instanceof Either) {
            return (Either)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Either)this.maybeKeysFromConfig$lzyINIT1();
    }

    private Object maybeKeysFromConfig$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.maybeKeysFromConfig$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Either either = null;
                    try {
                        either = ConfigUtil$.MODULE$.wrapConfigException(((ConfigDb)this.configDb().apply()).get((Key)Keys$.MODULE$.pgpSecretKey())).flatMap((Function1 & Serializable)secretKeyOpt -> ConfigUtil$.MODULE$.wrapConfigException(((ConfigDb)this.configDb().apply()).get((Key)Keys$.MODULE$.pgpPublicKey())).flatMap((Function1 & Serializable)pubKeyOpt -> ConfigUtil$.MODULE$.wrapConfigException(((ConfigDb)this.configDb().apply()).get((Key)Keys$.MODULE$.pgpSecretKeyPassword())).map((Function1 & Serializable)passwordOpt -> this.PGPKeys().apply((Option<ConfigPasswordOption>)secretKeyOpt.map((Function1 & Serializable)sk -> ConfigPasswordOption.ActualOption$.MODULE$.apply(ConfigUtil$.MODULE$.toCliSigning((PasswordOption)sk))), (Option<ConfigPasswordOption>)passwordOpt.map((Function1 & Serializable)p -> ConfigPasswordOption.ActualOption$.MODULE$.apply(ConfigUtil$.MODULE$.toCliSigning((PasswordOption)p))), (Option<ConfigPasswordOption>)pubKeyOpt.map((Function1 & Serializable)pk -> ConfigPasswordOption.ActualOption$.MODULE$.apply(ConfigUtil$.MODULE$.toCliSigning((PasswordOption)pk)))))));
                        object2 = either == null ? LazyVals.NullValue$.MODULE$ : either;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.maybeKeysFromConfig$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return either;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Either<BuildException, PGPKeys> getRandomPGPKeys() {
        return EitherCps$.MODULE$.either().apply((Function1 & Serializable)evidence$3 -> {
            Either maybeMail = this.options().randomSecretKeyMail().toRight(PgpSecretKeyCheck::$anonfun$3);
            Secret passwordSecret = (Secret)this.options().publishParams().secretKeyPassword().map((Function1 & Serializable)_$6 -> _$6.configPasswordOptions()).map((Function1 & Serializable)configPasswordOption -> {
                Either either = Ops$.MODULE$.EitherThrowOps(ConfigUtil$.MODULE$.wrapConfigException(ConfigPasswordOptionHelpers$ConfigPasswordOptionOps$.MODULE$.get$extension(ConfigPasswordOptionHelpers$.MODULE$.ConfigPasswordOptionOps((ConfigPasswordOption)configPasswordOption), (Function0<ConfigDb>)((Function0 & Serializable)this::$anonfun$5$$anonfun$1))).map((Function1 & Serializable)_$7 -> ConfigUtil$.MODULE$.toCliSigning(_$7.get())));
                return (Secret)Ops.EitherThrowOps$.MODULE$.orThrow$extension(either);
            }).getOrElse(PgpSecretKeyCheck::$anonfun$6);
            Tuple2 tuple2 = (Tuple2)EitherCps$.MODULE$.value(evidence$3, ThrowawayPgpSecret$.MODULE$.pgpSecret((String)EitherCps$.MODULE$.value(evidence$3, maybeMail), (Option<Secret<String>>)Some$.MODULE$.apply((Object)passwordSecret), this.logger(), this.coursierCache(), this.options().sharedJvm(), this.options().coursier(), this.options().scalaSigning().cliOptions()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Secret pgpPublic = (Secret)tuple2._1();
            Secret pgpSecret = (Secret)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)pgpPublic, (Object)pgpSecret);
            Secret pgpPublic2 = (Secret)tuple22._1();
            Secret pgpSecret2 = (Secret)tuple22._2();
            return this.PGPKeys().apply((Option<ConfigPasswordOption>)Some$.MODULE$.apply((Object)ConfigPasswordOption.ActualOption$.MODULE$.apply((scala.cli.signing.shared.PasswordOption)PasswordOption.Value$.MODULE$.apply(pgpSecret2))), (Option<ConfigPasswordOption>)Some$.MODULE$.apply((Object)ConfigPasswordOption.ActualOption$.MODULE$.apply((scala.cli.signing.shared.PasswordOption)PasswordOption.Value$.MODULE$.apply(passwordSecret))), (Option<ConfigPasswordOption>)Some$.MODULE$.apply((Object)ConfigPasswordOption.ActualOption$.MODULE$.apply((scala.cli.signing.shared.PasswordOption)PasswordOption.Value$.MODULE$.apply(pgpPublic2))));
        });
    }

    private Either<BuildException, BoxedUnit> uploadKey(Option<ConfigPasswordOption> keyIdOpt) {
        return EitherCps$.MODULE$.either().apply((Function1)(JProcedure1 & Serializable)evidence$4 -> {
            Option option = keyIdOpt;
            if (None$.MODULE$.equals(option)) {
                this.logger().message(PgpSecretKeyCheck::uploadKey$$anonfun$1$$anonfun$1);
                return;
            }
            if (option instanceof Some) {
                ConfigPasswordOption pubKeyConfigPasswordOption = (ConfigPasswordOption)((Some)option).value();
                Either either = Ops$.MODULE$.EitherThrowOps(ConfigPasswordOptionHelpers$ConfigPasswordOptionOps$.MODULE$.get$extension(ConfigPasswordOptionHelpers$.MODULE$.ConfigPasswordOptionOps(pubKeyConfigPasswordOption), (Function0<ConfigDb>)((Function0 & Serializable)this::$anonfun$7)));
                String publicKeyString = (String)((PasswordOption)Ops.EitherThrowOps$.MODULE$.orThrow$extension(either)).get().value();
                Either either2 = Ops$.MODULE$.EitherThrowOps(new PgpProxyMaker().get(Predef$.MODULE$.boolean2Boolean(BoxesRunTime.unboxToBoolean((Object)this.options().scalaSigning().forceSigningExternally().getOrElse(PgpSecretKeyCheck::$anonfun$8)))).keyId(publicKeyString, "[generated key]", this.coursierCache(), this.logger(), this.options().sharedJvm(), this.options().coursier(), this.options().scalaSigning().cliOptions()));
                String keyId = (String)Ops.EitherThrowOps$.MODULE$.orThrow$extension(either2);
                Seq seq = Ops$.MODULE$.EitherSeqOps((Seq)((IterableOps)EitherCps$.MODULE$.value(evidence$4, this.keyServers())).map((Function1 & Serializable)keyServer -> {
                    if (this.options().dummy()) {
                        this.logger().message(() -> PgpSecretKeyCheck.uploadKey$$anonfun$1$$anonfun$2$$anonfun$1(keyId, keyServer));
                        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    }
                    Either e = EitherCps$.MODULE$.either().apply((Function1)(JProcedure1 & Serializable)evidence$5 -> {
                        Either checkResp = (Either)EitherCps$.MODULE$.value(evidence$5, KeyServer$.MODULE$.check(keyId, (Uri)keyServer, this.backend()).left().map((Function1 & Serializable)msg -> new KeyServerError(new StringBuilder(26).append("Error getting key ").append(keyId).append(" from ").append(keyServer).append(": ").append((String)msg).toString())));
                        this.logger().debug(() -> PgpSecretKeyCheck.$anonfun$9$$anonfun$1(checkResp));
                        boolean check = checkResp.isRight();
                        if (!check) {
                            String resp = (String)EitherCps$.MODULE$.value(evidence$5, KeyServer$.MODULE$.add(publicKeyString, (Uri)keyServer, this.backend()).left().map((Function1 & Serializable)msg -> new KeyServerError(new StringBuilder(26).append("Error uploading key ").append(keyId).append(" to ").append(keyServer).append(": ").append((String)msg).toString())));
                            this.logger().debug(() -> PgpSecretKeyCheck.$anonfun$9$$anonfun$2(resp));
                            this.logger().message(() -> PgpSecretKeyCheck.$anonfun$9$$anonfun$3(keyId, keyServer));
                            return;
                        }
                    });
                    return e;
                }));
                Ops.EitherSeqOps$.MODULE$.sequence$extension(seq).left().map((Function1 & Serializable)_$8 -> CompositeBuildException$.MODULE$.apply(_$8)).map((Function1)(JProcedure1 & Serializable)_$9 -> {});
                return;
            }
            throw new MatchError((Object)option);
        });
    }

    @Override
    public Either<BuildException, OptionCheck.DefaultValue> defaultValue(PublishOptions pubOpt) {
        return EitherCps$.MODULE$.either().apply((Function1 & Serializable)evidence$6 -> {
            Tuple2 tuple2;
            Tuple2 tuple22;
            PublishContextualOptions retainedOptions = pubOpt.retained(this.options().publishParams().setupCi());
            if (retainedOptions.secretKey().isDefined()) {
                Option<ConfigPasswordOption> publicKeySetup = retainedOptions.publicKey().isEmpty() ? this.keysFromOptions().publicKeyOpt() : None$.MODULE$;
                Option<ConfigPasswordOption> passwordSetup = retainedOptions.secretKeyPassword().isEmpty() ? this.keysFromOptions().secretKeyPasswordOpt() : None$.MODULE$;
                tuple22 = Tuple2$.MODULE$.apply((Object)this.PGPKeys().apply((Option<ConfigPasswordOption>)None$.MODULE$, passwordSetup, publicKeySetup), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            } else {
                boolean randomSecretKey = BoxesRunTime.unboxToBoolean((Object)this.options().randomSecretKey().getOrElse(PgpSecretKeyCheck::$anonfun$12));
                if (this.keysFromOptions().secretKeyOpt().isDefined()) {
                    tuple22 = Tuple2$.MODULE$.apply((Object)this.keysFromOptions(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                } else {
                    if (this.keysFromOptions().publicKeyOpt().isDefined() || this.keysFromOptions().secretKeyPasswordOpt().isDefined()) {
                        throw this.missingSecretKeyError();
                    }
                    if (randomSecretKey && this.options().publishParams().setupCi()) {
                        Either either = Ops$.MODULE$.EitherThrowOps(this.getRandomPGPKeys());
                        tuple22 = Tuple2$.MODULE$.apply((Object)((PGPKeys)Ops.EitherThrowOps$.MODULE$.orThrow$extension(either)), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    } else {
                        Either either = Ops$.MODULE$.EitherThrowOps(this.maybeKeysFromConfig());
                        PGPKeys keysFromConfig = (PGPKeys)Ops.EitherThrowOps$.MODULE$.orThrow$extension(either);
                        if (!keysFromConfig.secretKeyOpt().isDefined()) {
                            throw this.missingSecretKeyError();
                        }
                        this.logger().message(this::$anonfun$13);
                        this.logger().message(PgpSecretKeyCheck::$anonfun$14);
                        if (keysFromConfig.publicKeyOpt().isEmpty()) {
                            this.logger().message(PgpSecretKeyCheck::$anonfun$15);
                        }
                        tuple22 = tuple2 = Tuple2$.MODULE$.apply((Object)keysFromConfig, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                }
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            PGPKeys setupKeys = (PGPKeys)tuple2._1();
            boolean areConfigDefaults = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)setupKeys, (Object)BoxesRunTime.boxToBoolean((boolean)areConfigDefaults));
            PGPKeys setupKeys2 = (PGPKeys)tuple23._1();
            boolean areConfigDefaults2 = BoxesRunTime.unboxToBoolean((Object)tuple23._2());
            Option publicKeyOpt = retainedOptions.publicKey().orElse(() -> PgpSecretKeyCheck.$anonfun$16(setupKeys2));
            if (this.options().publishParams().setupCi()) {
                Nil$ nil$;
                Tuple2 tuple24 = (Tuple2)setupKeys2.secretKeyPasswordOpt().map((Function1 & Serializable)p -> {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"publish.ci.secretKeyPassword");
                    Tuple2 dir = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"env:PUBLISH_SECRET_KEY_PASSWORD");
                    Either either = Ops$.MODULE$.EitherThrowOps(ConfigPasswordOptionHelpers$ConfigPasswordOptionOps$.MODULE$.get$extension(ConfigPasswordOptionHelpers$.MODULE$.ConfigPasswordOptionOps((ConfigPasswordOption)p), (Function0<ConfigDb>)((Function0 & Serializable)this::$anonfun$18)));
                    scala.cli.config.Secret secret = ((PasswordOption)Ops.EitherThrowOps$.MODULE$.orThrow$extension(either)).get();
                    SetSecret setSec = SetSecret$.MODULE$.apply("PUBLISH_SECRET_KEY_PASSWORD", (scala.cli.config.Secret<String>)secret, true);
                    return Tuple2$.MODULE$.apply((Object)((SeqOps)new .colon.colon((Object)setSec, (List)Nil$.MODULE$)), (Object)((SeqOps)new .colon.colon((Object)dir, (List)Nil$.MODULE$)));
                }).getOrElse(PgpSecretKeyCheck::$anonfun$19);
                if (tuple24 == null) {
                    throw new MatchError((Object)tuple24);
                }
                Seq passwordSetSecret = (Seq)tuple24._1();
                Seq passwordDirectives = (Seq)tuple24._2();
                Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)passwordSetSecret, (Object)passwordDirectives);
                Seq passwordSetSecret2 = (Seq)tuple25._1();
                Seq passwordDirectives2 = (Seq)tuple25._2();
                Option<ConfigPasswordOption> option = setupKeys2.secretKeyOpt();
                if (option instanceof Some) {
                    ConfigPasswordOption configPasswordOption = (ConfigPasswordOption)((Some)option).value();
                    Either either = Ops$.MODULE$.EitherThrowOps(ConfigPasswordOptionHelpers$ConfigPasswordOptionOps$.MODULE$.get$extension(ConfigPasswordOptionHelpers$.MODULE$.ConfigPasswordOptionOps(configPasswordOption), (Function0<ConfigDb>)((Function0 & Serializable)this::$anonfun$20)));
                    scala.cli.config.Secret secret = ((PasswordOption)Ops.EitherThrowOps$.MODULE$.orThrow$extension(either)).get();
                    nil$ = (Seq)((SeqOps)new .colon.colon((Object)SetSecret$.MODULE$.apply("PUBLISH_SECRET_KEY", (scala.cli.config.Secret<String>)secret, true), (List)Nil$.MODULE$));
                } else {
                    nil$ = package$.MODULE$.Nil();
                }
                Nil$ keySetSecrets = nil$;
                Tuple2 tuple26 = (Tuple2)setupKeys2.publicKeyOpt().map((Function1 & Serializable)p -> {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"publish.ci.publicKey");
                    Tuple2 dir = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"env:PUBLISH_PUBLIC_KEY");
                    Either either = Ops$.MODULE$.EitherThrowOps(ConfigPasswordOptionHelpers$ConfigPasswordOptionOps$.MODULE$.get$extension(ConfigPasswordOptionHelpers$.MODULE$.ConfigPasswordOptionOps((ConfigPasswordOption)p), (Function0<ConfigDb>)((Function0 & Serializable)this::$anonfun$22)));
                    scala.cli.config.Secret secret = ((PasswordOption)Ops.EitherThrowOps$.MODULE$.orThrow$extension(either)).get();
                    SetSecret setSec = SetSecret$.MODULE$.apply("PUBLISH_PUBLIC_KEY", (scala.cli.config.Secret<String>)secret, true);
                    return Tuple2$.MODULE$.apply((Object)((SeqOps)new .colon.colon((Object)setSec, (List)Nil$.MODULE$)), (Object)((SeqOps)new .colon.colon((Object)dir, (List)Nil$.MODULE$)));
                }).getOrElse(PgpSecretKeyCheck::$anonfun$23);
                if (tuple26 == null) {
                    throw new MatchError((Object)tuple26);
                }
                Seq publicKeySetSecret = (Seq)tuple26._1();
                Seq publicKeyDirective = (Seq)tuple26._2();
                Tuple2 tuple27 = Tuple2$.MODULE$.apply((Object)publicKeySetSecret, (Object)publicKeyDirective);
                Seq publicKeySetSecret2 = (Seq)tuple27._1();
                Seq publicKeyDirective2 = (Seq)tuple27._2();
                Seq secretsToSet = (Seq)((IterableOps)keySetSecrets.$plus$plus((IterableOnce)passwordSetSecret2)).$plus$plus((IterableOnce)publicKeySetSecret2);
                Seq extraDirectives = (Seq)passwordDirectives2.$plus$plus((IterableOnce)publicKeyDirective2);
                return OptionCheck$DefaultValue$.MODULE$.apply((Function0<Either<BuildException, Option<String>>>)(Function0 & Serializable)() -> this.uploadKey((Option<ConfigPasswordOption>)publicKeyOpt).map((Function1 & Serializable)_$10 -> Some$.MODULE$.apply((Object)"env:PUBLISH_SECRET_KEY")), (Seq<Tuple2<String, String>>)extraDirectives, (Seq<SetSecret>)secretsToSet);
            }
            if (areConfigDefaults2) {
                return OptionCheck$DefaultValue$.MODULE$.apply((Function0<Either<BuildException, Option<String>>>)(Function0 & Serializable)() -> this.uploadKey((Option<ConfigPasswordOption>)publicKeyOpt).map((Function1 & Serializable)_$11 -> None$.MODULE$), (Seq<Tuple2<String, String>>)package$.MODULE$.Nil(), (Seq<SetSecret>)package$.MODULE$.Nil());
            }
            Regex rawValueRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^value:(.*)"));
            Seq passwordDirectives = Option$.MODULE$.option2Iterable(PgpSecretKeyCheck.getDirectiveValue$1(setupKeys2.secretKeyPasswordOpt()).flatMap((Function1 & Serializable)x$1 -> {
                List list;
                Option option;
                String string = x$1;
                if (string != null && !(option = rawValueRegex.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                    String string2;
                    String rawValue = string2 = (String)list.apply(0);
                    this.logger().diagnostic(WarningMessages$.MODULE$.rawValueNotWrittenToPublishFile(rawValue, "PGP password", "--secret-key-password"), this.logger().diagnostic$default$2(), this.logger().diagnostic$default$3());
                    return None$.MODULE$;
                }
                String secretOption = string;
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"publish.secretKeyPassword");
                return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)secretOption));
            })).toSeq();
            Option secretKeyDirValue = PgpSecretKeyCheck.getDirectiveValue$1(setupKeys2.secretKeyOpt()).flatMap((Function1 & Serializable)x$1 -> {
                List list;
                Option option;
                String string = x$1;
                if (string != null && !(option = rawValueRegex.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                    String string2;
                    String rawValue = string2 = (String)list.apply(0);
                    this.logger().diagnostic(WarningMessages$.MODULE$.rawValueNotWrittenToPublishFile(rawValue, "PGP secret key", "--secret-key"), this.logger().diagnostic$default$2(), this.logger().diagnostic$default$3());
                    return None$.MODULE$;
                }
                String secretOption = string;
                return Some$.MODULE$.apply((Object)secretOption);
            });
            Seq publicKeyDirective = Option$.MODULE$.option2Iterable(PgpSecretKeyCheck.getDirectiveValue$1(setupKeys2.publicKeyOpt()).map((Function1 & Serializable)_$12 -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"publish.publicKey");
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$12);
            })).toSeq();
            Seq extraDirectives = (Seq)passwordDirectives.$plus$plus((IterableOnce)publicKeyDirective);
            return OptionCheck$DefaultValue$.MODULE$.apply((Function0<Either<BuildException, Option<String>>>)(Function0 & Serializable)() -> this.uploadKey((Option<ConfigPasswordOption>)publicKeyOpt).map((Function1 & Serializable)_$13 -> secretKeyDirValue), (Seq<Tuple2<String, String>>)extraDirectives, (Seq<SetSecret>)package$.MODULE$.Nil());
        });
    }

    public PgpSecretKeyCheck copy(PublishSetupOptions options, FileCache<Task> coursierCache, Function0<ConfigDb> configDb, Logger logger, SttpBackend<Object, Object> backend) {
        return new PgpSecretKeyCheck(options, coursierCache, configDb, logger, backend);
    }

    public PublishSetupOptions copy$default$1() {
        return this.options();
    }

    public FileCache<Task> copy$default$2() {
        return this.coursierCache();
    }

    public Function0<ConfigDb> copy$default$3() {
        return this.configDb();
    }

    public Logger copy$default$4() {
        return this.logger();
    }

    public SttpBackend<Object, Object> copy$default$5() {
        return this.backend();
    }

    public PublishSetupOptions _1() {
        return this.options();
    }

    public FileCache<Task> _2() {
        return this.coursierCache();
    }

    public Function0<ConfigDb> _3() {
        return this.configDb();
    }

    public Logger _4() {
        return this.logger();
    }

    public SttpBackend<Object, Object> _5() {
        return this.backend();
    }

    private final Option check$$anonfun$1() {
        return this.options().publishRepo().publishRepository();
    }

    private final ConfigDb check$$anonfun$2() {
        return (ConfigDb)this.configDb().apply();
    }

    private static final boolean check$$anonfun$4() {
        return false;
    }

    private static final boolean $anonfun$2() {
        return false;
    }

    private static final String isKeyUploaded$$anonfun$1$$anonfun$1$$anonfun$1(Uri keyServer$1, String msg$1) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(61).append("Response from ").append(keyServer$1).append(":\n                     |").append(msg$1).append("\n                     |").toString()));
    }

    private static final MissingPublishOptionError $anonfun$3() {
        return new MissingPublishOptionError("the e-mail address to associate to the random key pair", "--random-secret-key-mail", "", MissingPublishOptionError$.MODULE$.$lessinit$greater$default$4(), MissingPublishOptionError$.MODULE$.$lessinit$greater$default$5());
    }

    private final ConfigDb $anonfun$5$$anonfun$1() {
        return (ConfigDb)this.configDb().apply();
    }

    private static final Secret $anonfun$6() {
        return ThrowawayPgpSecret$.MODULE$.pgpPassPhrase();
    }

    private static final String uploadKey$$anonfun$1$$anonfun$1() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n              |Warning: no public key passed, not checking if the key needs to be uploaded to a key server."));
    }

    private final ConfigDb $anonfun$7() {
        return (ConfigDb)this.configDb().apply();
    }

    private static final boolean $anonfun$8() {
        return false;
    }

    private static final String uploadKey$$anonfun$1$$anonfun$2$$anonfun$1(String keyId$3, Uri keyServer$2) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(46).append("\n                     |Would upload key 0x").append(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(keyId$3), "0x")).append(" to ").append(keyServer$2).toString()));
    }

    private static final String $anonfun$9$$anonfun$1(Either checkResp$1) {
        return new StringBuilder(27).append("Key server check response: ").append(checkResp$1).toString();
    }

    private static final String $anonfun$9$$anonfun$2(String resp$1) {
        return new StringBuilder(28).append("Key server upload response: ").append(resp$1).toString();
    }

    private static final String $anonfun$9$$anonfun$3(String keyId$7, Uri keyServer$6) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(46).append("\n                         |Uploaded key 0x").append(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(keyId$7), "0x")).append(" to ").append(keyServer$6).toString()));
    }

    private static final boolean $anonfun$12() {
        return false;
    }

    private final String $anonfun$13() {
        return new StringBuilder(1).append(this.fieldName()).append(":").toString();
    }

    private static final String $anonfun$14() {
        return "  found keys in config";
    }

    private static final String $anonfun$15() {
        return "  warning: no PGP public key found in config";
    }

    private static final Option $anonfun$16(PGPKeys setupKeys$1) {
        return setupKeys$1.publicKeyOpt();
    }

    private final ConfigDb $anonfun$18() {
        return (ConfigDb)this.configDb().apply();
    }

    private static final Tuple2 $anonfun$19() {
        return Tuple2$.MODULE$.apply((Object)package$.MODULE$.Nil(), (Object)package$.MODULE$.Nil());
    }

    private final ConfigDb $anonfun$20() {
        return (ConfigDb)this.configDb().apply();
    }

    private final ConfigDb $anonfun$22() {
        return (ConfigDb)this.configDb().apply();
    }

    private static final Tuple2 $anonfun$23() {
        return Tuple2$.MODULE$.apply((Object)package$.MODULE$.Nil(), (Object)package$.MODULE$.Nil());
    }

    public static final RelPath scala$cli$commands$publish$checks$PgpSecretKeyCheck$$anon$1$$_$applyOrElse$$anonfun$1(Path path$1) {
        return path$1.relativeTo(os.package$.MODULE$.pwd());
    }

    public static final /* synthetic */ String scala$cli$commands$publish$checks$PgpSecretKeyCheck$$anon$1$$_$applyOrElse$$anonfun$2(RelPath p) {
        return new StringBuilder(5).append("file:").append(p.toString()).toString();
    }

    public static final String scala$cli$commands$publish$checks$PgpSecretKeyCheck$$anon$1$$_$applyOrElse$$anonfun$3(String optionValue$1) {
        return optionValue$1;
    }

    private static final Option getDirectiveValue$1(Option configPasswordOpt) {
        return configPasswordOpt.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(ConfigPasswordOption x) {
                ConfigPasswordOption configPasswordOption = x;
                if (configPasswordOption instanceof ConfigPasswordOption.ActualOption) {
                    scala.cli.signing.shared.PasswordOption passwordOption;
                    ConfigPasswordOption.ActualOption actualOption = ConfigPasswordOption.ActualOption$.MODULE$.unapply((ConfigPasswordOption.ActualOption)configPasswordOption);
                    scala.cli.signing.shared.PasswordOption passwordOption2 = passwordOption = actualOption._1();
                    return true;
                }
                if (configPasswordOption instanceof ConfigPasswordOption.ConfigOption) {
                    String string;
                    ConfigPasswordOption.ConfigOption configOption = ConfigPasswordOption.ConfigOption$.MODULE$.unapply((ConfigPasswordOption.ConfigOption)configPasswordOption);
                    String fullName = string = configOption._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(ConfigPasswordOption x, Function1 function1) {
                ConfigPasswordOption configPasswordOption = x;
                if (configPasswordOption instanceof ConfigPasswordOption.ActualOption) {
                    ConfigPasswordOption.ActualOption actualOption = ConfigPasswordOption.ActualOption$.MODULE$.unapply((ConfigPasswordOption.ActualOption)configPasswordOption);
                    scala.cli.signing.shared.PasswordOption passwordOption = actualOption._1();
                    scala.cli.signing.shared.PasswordOption passwordOption2 = passwordOption;
                    String optionValue = (String)passwordOption2.asString().value();
                    if (optionValue.startsWith("file:")) {
                        Path path = Path$.MODULE$.apply((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(optionValue), "file:"), (PathConvertible)PathConvertible.StringConvertible$.MODULE$);
                        return Try$.MODULE$.apply(() -> PgpSecretKeyCheck.scala$cli$commands$publish$checks$PgpSecretKeyCheck$$anon$1$$_$applyOrElse$$anonfun$1(path)).map(PgpSecretKeyCheck::scala$cli$commands$publish$checks$PgpSecretKeyCheck$$anon$1$$_$applyOrElse$$anonfun$2).getOrElse(() -> PgpSecretKeyCheck.scala$cli$commands$publish$checks$PgpSecretKeyCheck$$anon$1$$_$applyOrElse$$anonfun$3(optionValue));
                    }
                    return optionValue;
                }
                if (configPasswordOption instanceof ConfigPasswordOption.ConfigOption) {
                    String string;
                    ConfigPasswordOption.ConfigOption configOption = ConfigPasswordOption.ConfigOption$.MODULE$.unapply((ConfigPasswordOption.ConfigOption)configPasswordOption);
                    String fullName = string = configOption._1();
                    return new StringBuilder(7).append("config:").append(fullName).toString();
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{scala$cli$commands$publish$checks$PgpSecretKeyCheck$$anon$1$$_$applyOrElse$$anonfun$1(os.Path ), scala$cli$commands$publish$checks$PgpSecretKeyCheck$$anon$1$$_$applyOrElse$$anonfun$2(os.RelPath ), scala$cli$commands$publish$checks$PgpSecretKeyCheck$$anon$1$$_$applyOrElse$$anonfun$3(java.lang.String )}, serializedLambda);
            }
        });
    }

    public static final class KeyServerError
    extends BuildException {
        public KeyServerError(String message) {
            super(message, BuildException$.MODULE$.$lessinit$greater$default$2(), BuildException$.MODULE$.$lessinit$greater$default$3());
        }

        private String message$accessor() {
            return super.message();
        }
    }

    public class PGPKeys
    implements Product,
    Serializable {
        private final Option secretKeyOpt;
        private final Option secretKeyPasswordOpt;
        private final Option publicKeyOpt;
        private final /* synthetic */ PgpSecretKeyCheck $outer;

        public PGPKeys(PgpSecretKeyCheck $outer, Option<ConfigPasswordOption> secretKeyOpt, Option<ConfigPasswordOption> secretKeyPasswordOpt, Option<ConfigPasswordOption> publicKeyOpt) {
            this.secretKeyOpt = secretKeyOpt;
            this.secretKeyPasswordOpt = secretKeyPasswordOpt;
            this.publicKeyOpt = publicKeyOpt;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PGPKeys)) return false;
            if (((PGPKeys)object).scala$cli$commands$publish$checks$PgpSecretKeyCheck$PGPKeys$$$outer() != this.$outer) return false;
            PGPKeys pGPKeys = (PGPKeys)object;
            Option<ConfigPasswordOption> option = this.secretKeyOpt();
            Option<ConfigPasswordOption> option2 = pGPKeys.secretKeyOpt();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<ConfigPasswordOption> option3 = this.secretKeyPasswordOpt();
            Option<ConfigPasswordOption> option4 = pGPKeys.secretKeyPasswordOpt();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<ConfigPasswordOption> option5 = this.publicKeyOpt();
            Option<ConfigPasswordOption> option6 = pGPKeys.publicKeyOpt();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            if (!pGPKeys.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PGPKeys;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "PGPKeys";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "secretKeyOpt";
                }
                case 1: {
                    return "secretKeyPasswordOpt";
                }
                case 2: {
                    return "publicKeyOpt";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<ConfigPasswordOption> secretKeyOpt() {
            return this.secretKeyOpt;
        }

        public Option<ConfigPasswordOption> secretKeyPasswordOpt() {
            return this.secretKeyPasswordOpt;
        }

        public Option<ConfigPasswordOption> publicKeyOpt() {
            return this.publicKeyOpt;
        }

        public PGPKeys copy(Option<ConfigPasswordOption> secretKeyOpt, Option<ConfigPasswordOption> secretKeyPasswordOpt, Option<ConfigPasswordOption> publicKeyOpt) {
            return new PGPKeys(this.$outer, secretKeyOpt, secretKeyPasswordOpt, publicKeyOpt);
        }

        public Option<ConfigPasswordOption> copy$default$1() {
            return this.secretKeyOpt();
        }

        public Option<ConfigPasswordOption> copy$default$2() {
            return this.secretKeyPasswordOpt();
        }

        public Option<ConfigPasswordOption> copy$default$3() {
            return this.publicKeyOpt();
        }

        public Option<ConfigPasswordOption> _1() {
            return this.secretKeyOpt();
        }

        public Option<ConfigPasswordOption> _2() {
            return this.secretKeyPasswordOpt();
        }

        public Option<ConfigPasswordOption> _3() {
            return this.publicKeyOpt();
        }

        public final /* synthetic */ PgpSecretKeyCheck scala$cli$commands$publish$checks$PgpSecretKeyCheck$PGPKeys$$$outer() {
            return this.$outer;
        }
    }
}

