/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.integration;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import os.Path;
import os.Path$;
import os.PathChunk;
import os.PathChunk$;
import os.PathConvertible;
import os.RelPath;
import os.makeDir;
import os.remove;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.cli.integration.TestInputs;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;

public final class TestInputs$
implements Serializable {
    public static final TestInputs$ MODULE$ = new TestInputs$();
    private static Path baseTmpDir;
    private static final AtomicInteger tmpCount;
    private static volatile boolean bitmap$0;

    static {
        tmpCount = new AtomicInteger();
    }

    public TestInputs apply(Seq<Tuple2<RelPath, String>> files) {
        return new TestInputs((Option<Charset>)None$.MODULE$, files);
    }

    public TestInputs apply(String charsetName, Seq<Tuple2<RelPath, String>> files) {
        Charset charset = Charset.forName(charsetName);
        return new TestInputs((Option<Charset>)new Some((Object)charset), files);
    }

    public TestInputs empty() {
        return this.apply((Seq<Tuple2<RelPath, String>>)Nil$.MODULE$);
    }

    public void compress(Path zipFilepath, Seq<Tuple3<RelPath, String, Charset>> files) {
        try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(zipFilepath.toString()));){
            files.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TestInputs$.$anonfun$compress$1(check$ifrefutable$2))).foreach((Function1 & Serializable)x$2 -> {
                TestInputs$.$anonfun$compress$2(zip, x$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Path baseTmpDir$lzycompute() {
        TestInputs$ testInputs$ = this;
        synchronized (testInputs$) {
            if (!bitmap$0) {
                Option$.MODULE$.apply((Object)System.getenv("SCALA_CLI_TMP")).getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error("SCALA_CLI_TMP not set"));
                Path base = Path$.MODULE$.apply((Object)System.getenv("SCALA_CLI_TMP"), os.package$.MODULE$.pwd(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$);
                SecureRandom rng = new SecureRandom();
                Path d = base.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(new StringBuilder(4).append("run-").append(package$.MODULE$.abs((long)rng.nextInt())).toString()));
                makeDir.all$.MODULE$.apply(d);
                Runtime.getRuntime().addShutdownHook(new Thread(d){
                    private final Path d$1;

                    public void run() {
                        try {
                            remove.all$.MODULE$.apply(this.d$1);
                        }
                        catch (Throwable throwable) {
                            Option option;
                            Throwable throwable2 = throwable;
                            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                System.err.println(new StringBuilder(31).append("Could not remove ").append(this.d$1).append(", ignoring it.").toString());
                            }
                            throw throwable;
                        }
                    }
                    {
                        this.d$1 = d$1;
                        super("scala-cli-its-clean-up-tmp-dir");
                        this.setDaemon(true);
                    }
                });
                baseTmpDir = d;
                bitmap$0 = true;
            }
        }
        return baseTmpDir;
    }

    private Path baseTmpDir() {
        if (!bitmap$0) {
            return this.baseTmpDir$lzycompute();
        }
        return baseTmpDir;
    }

    private AtomicInteger tmpCount() {
        return tmpCount;
    }

    public <T> T scala$cli$integration$TestInputs$$withTmpDir(Function1<Path, T> f) {
        Object object;
        Path tmpDir = this.baseTmpDir().$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(new StringBuilder(5).append("test-").append(this.tmpCount().incrementAndGet()).toString()));
        makeDir.all$.MODULE$.apply(tmpDir);
        Path tmpDir0 = Path$.MODULE$.apply((Object)tmpDir.toIO().getCanonicalFile(), (PathConvertible)PathConvertible.JavaIoFileConvertible$.MODULE$);
        try {
            object = f.apply((Object)tmpDir0);
        }
        finally {
            TestInputs$.removeAll$1(tmpDir0);
        }
        return (T)object;
    }

    public Path scala$cli$integration$TestInputs$$tmpDir() {
        Path tmpDir = this.baseTmpDir().$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(new StringBuilder(5).append("test-").append(this.tmpCount().incrementAndGet()).toString()));
        makeDir.all$.MODULE$.apply(tmpDir);
        return Path$.MODULE$.apply((Object)tmpDir.toIO().getCanonicalFile(), (PathConvertible)PathConvertible.JavaIoFileConvertible$.MODULE$);
    }

    public TestInputs apply(Option<Charset> maybeCharset, Seq<Tuple2<RelPath, String>> files) {
        return new TestInputs(maybeCharset, files);
    }

    public Option<Tuple2<Option<Charset>, Seq<Tuple2<RelPath, String>>>> unapplySeq(TestInputs x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.maybeCharset(), x$0.files()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TestInputs$.class);
    }

    public static final /* synthetic */ boolean $anonfun$compress$1(Tuple3 check$ifrefutable$2) {
        Tuple3 tuple3 = check$ifrefutable$2;
        return tuple3 != null;
    }

    public static final /* synthetic */ void $anonfun$compress$2(ZipOutputStream zip$1, Tuple3 x$2) {
        Tuple3 tuple3 = x$2;
        if (tuple3 != null) {
            RelPath relPath = (RelPath)tuple3._1();
            String content = (String)tuple3._2();
            Charset charset = (Charset)tuple3._3();
            zip$1.putNextEntry(new ZipEntry(relPath.toString()));
            byte[] in = content.getBytes(charset);
            zip$1.write(in);
            zip$1.closeEntry();
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    private static final void removeAll$1(Path tmpDir0$1) {
        try {
            remove.all$.MODULE$.apply(tmpDir0$1);
        }
        catch (IOException ex) {
            System.err.println(new StringBuilder(25).append("Ignoring ").append(ex).append(" while removing ").append(tmpDir0$1).toString());
        }
    }

    private TestInputs$() {
    }
}

