/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.runner;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.cli.runner.StackTracePrinter$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class StackTracePrinter
implements Product,
Serializable {
    private final ClassLoader loader;
    private final Option callerClass;
    private final boolean cutInvoke;
    private final boolean colored;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(StackTracePrinter$.class, "0bitmap$1");

    public static StackTracePrinter apply(ClassLoader classLoader, Option<String> option, boolean bl, boolean bl2) {
        return StackTracePrinter$.MODULE$.apply(classLoader, option, bl, bl2);
    }

    public static boolean coloredStackTraces() {
        return StackTracePrinter$.MODULE$.coloredStackTraces();
    }

    public static StackTracePrinter fromProduct(Product product) {
        return StackTracePrinter$.MODULE$.fromProduct(product);
    }

    public static StackTracePrinter unapply(StackTracePrinter stackTracePrinter) {
        return StackTracePrinter$.MODULE$.unapply(stackTracePrinter);
    }

    public static ClassLoader $lessinit$greater$default$1() {
        return StackTracePrinter$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<String> $lessinit$greater$default$2() {
        return StackTracePrinter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$3() {
        return StackTracePrinter$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$4() {
        return StackTracePrinter$.MODULE$.$lessinit$greater$default$4();
    }

    public StackTracePrinter(ClassLoader loader, Option<String> callerClass, boolean cutInvoke, boolean colored) {
        this.loader = loader;
        this.callerClass = callerClass;
        this.cutInvoke = cutInvoke;
        this.colored = colored;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.loader()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.callerClass()));
        n = Statics.mix((int)n, (int)(this.cutInvoke() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.colored() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof StackTracePrinter)) return false;
        StackTracePrinter stackTracePrinter = (StackTracePrinter)object;
        if (this.cutInvoke() != stackTracePrinter.cutInvoke()) return false;
        if (this.colored() != stackTracePrinter.colored()) return false;
        ClassLoader classLoader = this.loader();
        ClassLoader classLoader2 = stackTracePrinter.loader();
        if (classLoader == null) {
            if (classLoader2 != null) {
                return false;
            }
        } else if (!classLoader.equals(classLoader2)) return false;
        Option<String> option = this.callerClass();
        Option<String> option2 = stackTracePrinter.callerClass();
        if (option == null) {
            if (option2 == null) return true;
            return false;
        } else {
            if (!option.equals(option2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof StackTracePrinter;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "StackTracePrinter";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this._3());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this._4());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "loader";
                break;
            }
            case 1: {
                string = "callerClass";
                break;
            }
            case 2: {
                string = "cutInvoke";
                break;
            }
            case 3: {
                string = "colored";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public ClassLoader loader() {
        return this.loader;
    }

    public Option<String> callerClass() {
        return this.callerClass;
    }

    public boolean cutInvoke() {
        return this.cutInvoke;
    }

    public boolean colored() {
        return this.colored;
    }

    private String bold() {
        return this.colored() ? "\u001b[1m" : "";
    }

    private String gray() {
        return this.colored() ? "\u001b[90m" : "";
    }

    private String reset() {
        return this.colored() ? "\u001b[0m" : "";
    }

    private void truncateStackTrace(Throwable ex) {
        int n;
        Object[] objectArray;
        Option<String> option = this.callerClass();
        if (None$.MODULE$.equals(option)) {
            objectArray = ex.getStackTrace();
        } else if (option instanceof Some) {
            String caller = (String)((Some)option).value();
            Object object = Predef$.MODULE$.refArrayOps((Object[])ex.getStackTrace());
            objectArray = (StackTraceElement[])ArrayOps$.MODULE$.takeWhile$extension(object, (Function1 & Serializable)_$1 -> {
                String string = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(_$1.getClassName()), "$");
                String string2 = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(caller), "$");
                return string == null ? string2 != null : !string.equals(string2);
            });
        } else {
            throw new MatchError(option);
        }
        Object[] noCallerStackTrace = objectArray;
        if (this.cutInvoke()) {
            Object object = Predef$.MODULE$.refArrayOps(noCallerStackTrace);
            n = ArrayOps$.MODULE$.reverseIterator$extension(object).takeWhile((Function1 & Serializable)elem -> elem.getMethodName().startsWith("invoke") && StackTracePrinter.isJdkClass$1(elem)).length();
        } else {
            n = 0;
        }
        int drop = n;
        Object object = Predef$.MODULE$.refArrayOps(noCallerStackTrace);
        StackTraceElement[] truncated = (StackTraceElement[])ArrayOps$.MODULE$.dropRight$extension(object, drop);
        if (truncated.length != ex.getStackTrace().length) {
            ex.setStackTrace(truncated);
        }
    }

    private void printCause(Throwable ex, StackTraceElement[] causedStackTrace, int verbosity) {
        StackTracePrinter stackTracePrinter = this;
        StackTraceElement[] stackTraceElementArray = causedStackTrace;
        Throwable throwable = ex;
        while (throwable != null) {
            stackTracePrinter.truncateStackTrace(throwable);
            System.err.println("Caused by: " + throwable);
            stackTracePrinter.printStackTrace(throwable.getStackTrace(), stackTraceElementArray);
            StackTracePrinter stackTracePrinter2 = stackTracePrinter;
            Throwable throwable2 = throwable.getCause();
            StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
            stackTracePrinter = stackTracePrinter2;
            throwable = throwable2;
            stackTraceElementArray = stackTraceElementArray2;
        }
    }

    private void printStackTrace(StackTraceElement[] trace) {
        this.printStackTrace(trace, (StackTraceElement[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StackTraceElement.class)));
    }

    private void printStackTrace(StackTraceElement[] trace, StackTraceElement[] causedStackTrace) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])causedStackTrace);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])trace);
        int cut = ArrayOps$.MODULE$.reverseIterator$extension(object).zip((IterableOnce)ArrayOps$.MODULE$.reverseIterator$extension(object2)).takeWhile((Function1 & Serializable)x$1 -> {
            StackTraceElement stackTraceElement;
            StackTraceElement stackTraceElement2;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                StackTraceElement a = (StackTraceElement)tuple2._1();
                StackTraceElement b = (StackTraceElement)tuple2._2();
                stackTraceElement2 = a;
                stackTraceElement = b;
            } else {
                throw new MatchError((Object)tuple2);
            }
            return !(stackTraceElement2 != null ? !((Object)stackTraceElement2).equals(stackTraceElement) : stackTraceElement != null);
        }).length();
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])trace);
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(object3, trace.length - cut));
        ArrayOps$.MODULE$.foreach$extension(object4, (Function1)((JProcedure1 & Serializable)this::printStackTrace$$anonfun$1));
        if (cut > 0) {
            System.err.println("\t" + this.gray() + "... " + cut + " more" + this.reset());
        }
    }

    public void printException(Throwable ex, int verbosity) {
        String q = "\"";
        String threadName = Thread.currentThread().getName();
        this.truncateStackTrace(ex);
        System.err.println("Exception in thread " + q + threadName + q + " " + ex);
        this.printStackTrace(ex.getStackTrace());
        this.printCause(ex.getCause(), ex.getStackTrace(), verbosity);
    }

    public StackTracePrinter copy(ClassLoader loader, Option<String> callerClass, boolean cutInvoke, boolean colored) {
        return new StackTracePrinter(loader, callerClass, cutInvoke, colored);
    }

    public ClassLoader copy$default$1() {
        return this.loader();
    }

    public Option<String> copy$default$2() {
        return this.callerClass();
    }

    public boolean copy$default$3() {
        return this.cutInvoke();
    }

    public boolean copy$default$4() {
        return this.colored();
    }

    public ClassLoader _1() {
        return this.loader();
    }

    public Option<String> _2() {
        return this.callerClass();
    }

    public boolean _3() {
        return this.cutInvoke();
    }

    public boolean _4() {
        return this.colored();
    }

    private static final boolean isJdkClass$1(StackTraceElement elem$1) {
        return elem$1.getClassName().startsWith("java.") || elem$1.getClassName().startsWith("jdk.") || elem$1.getClassName().startsWith("sun.");
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ void printStackTrace$$anonfun$1(StackTraceElement elem) {
        clsName = elem.getClassName();
        resource = clsName.replace('.', '/') + ".class";
        resourceUrl = this.loader().getResource(resource);
        if (resourceUrl == null) ** GOTO lbl-1000
        v0 = resourceUrl.getProtocol();
        var6_5 = "file";
        if (!(v0 != null ? v0.equals(var6_5) == false : var6_5 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = highlight = false;
        }
        if (highlight) {
            location = elem.isNativeMethod() != false ? "Native Method" : (elem.getFileName() == null ? "Unknown Source" : (elem.getLineNumber() >= 0 ? "" + elem.getFileName() + ":" + elem.getLineNumber() : elem.getFileName()));
            str = "" + this.bold() + elem.getClassName() + "." + elem.getMethodName() + this.reset() + ("" + this.gray() + "(" + this.reset() + location + this.gray() + ")" + this.reset());
            System.err.println("\t" + this.gray() + "at" + this.reset() + " " + str);
        } else {
            System.err.println("\t" + this.gray() + "at " + elem);
        }
    }
}

