/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.graal;

import geny.Writable$;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import os.Path;
import os.Path$;
import os.PathChunk;
import os.PathChunk$;
import os.PathConvertible;
import os.ReadablePath;
import os.RelPath;
import os.RelPath$;
import os.Source;
import os.Source$;
import os.copy;
import os.isDir$;
import os.isFile$;
import os.makeDir;
import os.read;
import os.temp$;
import os.walk$;
import os.write$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.cli.graal.BytecodeProcessor;
import scala.cli.graal.ClassPathEntry;
import scala.cli.graal.JarCache;
import scala.cli.graal.PathingJar;
import scala.cli.graal.PathingJar$;
import scala.cli.graal.Processed;
import scala.cli.graal.Processed$;
import scala.cli.graal.TempCache$;
import scala.cli.graal.Unmodified$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import scala.util.Try$;

public final class BytecodeProcessor$
implements Serializable {
    public static final BytecodeProcessor$ MODULE$ = new BytecodeProcessor$();

    private BytecodeProcessor$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BytecodeProcessor$.class);
    }

    public Seq<Path> toClean(Seq<ClassPathEntry> classpath) {
        return (Seq)classpath.flatMap((Function1 & Serializable)x$1 -> {
            ClassPathEntry classPathEntry = x$1;
            if (classPathEntry instanceof Processed) {
                Processed processed = Processed$.MODULE$.unapply((Processed)classPathEntry);
                Path path = processed._1();
                Path path2 = processed._2();
                JarCache jarCache = processed._3();
                Path path3 = path;
                if (TempCache$.MODULE$.equals(jarCache)) {
                    return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{path3}));
                }
            }
            if (classPathEntry instanceof PathingJar) {
                PathingJar pathingJar = PathingJar$.MODULE$.unapply((PathingJar)classPathEntry);
                ClassPathEntry classPathEntry2 = pathingJar._1();
                Seq<ClassPathEntry> seq = pathingJar._2();
                ClassPathEntry path = classPathEntry2;
                Seq<ClassPathEntry> entries = seq;
                return this.toClean((Seq<ClassPathEntry>)((Seq)entries.$plus$colon((Object)path)));
            }
            return package$.MODULE$.Nil();
        });
    }

    public Seq<ClassPathEntry> processPathingJar(Path pathingJar, JarCache cache) {
        Seq seq;
        block7: {
            try (JarFile jarFile = new JarFile(pathingJar.toIO());){
                String cp = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                if (cp != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(cp))) {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])cp.split(" +"));
                    Seq entries = (Seq)ArrayOps$.MODULE$.toSeq$extension(object).map((Function1 & Serializable)rawEntry -> Path$.MODULE$.apply(rawEntry, os.package$.MODULE$.pwd(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$));
                    Seq<ClassPathEntry> processedCp = this.processClassPathEntries((Seq<Path>)entries, cache);
                    Path dest = temp$.MODULE$.apply(temp$.MODULE$.apply$default$1(), temp$.MODULE$.apply$default$2(), temp$.MODULE$.apply$default$3(), ".jar", temp$.MODULE$.apply$default$5(), temp$.MODULE$.apply$default$6());
                    try (OutputStream outStream = Files.newOutputStream(dest.toNIO(), StandardOpenOption.CREATE);){
                        String stringCp = ((IterableOnceOps)processedCp.map((Function1 & Serializable)_$1 -> _$1.path().toNIO())).mkString(" ");
                        Manifest manifest = new Manifest(jarFile.getManifest());
                        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, stringCp);
                        JarOutputStream outjar = new JarOutputStream(outStream, manifest);
                        outjar.close();
                        dest.toNIO().toString();
                        seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PathingJar[]{PathingJar$.MODULE$.apply(Processed$.MODULE$.apply(dest, pathingJar, TempCache$.MODULE$), processedCp)}));
                        break block7;
                    }
                }
                seq = this.processClassPathEntries((Seq<Path>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{pathingJar}))), cache);
            }
        }
        return seq;
    }

    public Seq<ClassPathEntry> processClassPath(String classPath, JarCache cache) {
        String string;
        String maybePathingJar;
        Object object;
        Object[] objectArray = classPath.split(File.pathSeparator);
        if (objectArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)objectArray), 1) == 0 && (maybePathingJar = (string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0))).endsWith(".jar")) {
            return this.processPathingJar(Path$.MODULE$.apply((Object)maybePathingJar, os.package$.MODULE$.pwd(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$), cache);
        }
        Object[] cp = objectArray;
        Object object2 = Predef$.MODULE$.refArrayOps(cp);
        Seq cp0 = (Seq)ArrayOps$.MODULE$.toSeq$extension(object2).map((Function1 & Serializable)_$2 -> Path$.MODULE$.apply(_$2, os.package$.MODULE$.pwd(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$));
        return this.processClassPathEntries((Seq<Path>)cp0, cache);
    }

    public JarCache processClassPath$default$2() {
        return TempCache$.MODULE$;
    }

    public Seq<ClassPathEntry> processClassPathEntries(Seq<Path> entries, JarCache cache) {
        Seq cp = (Seq)entries.map((Function1 & Serializable)path -> cache.cache((Path)path, (Function1<Path, ClassPathEntry>)(Function1 & Serializable)dest -> {
            String string = path.ext();
            String string2 = "jar";
            if (!(string != null ? !string.equals(string2) : string2 != null) && isFile$.MODULE$.apply(path)) {
                return this.processJar((Path)path, (Path)dest, cache);
            }
            if (isDir$.MODULE$.apply(path)) {
                return this.processDir((Path)path, (Path)dest, cache);
            }
            return Unmodified$.MODULE$.apply((Path)dest);
        }));
        if (cp.exists((Function1 & Serializable)_$3 -> _$3.modified())) {
            String jarName = "scala3RuntimeFixes.jar";
            InputStream runtimeJarIs = this.getClass().getClassLoader().getResourceAsStream(jarName);
            if (runtimeJarIs == null) {
                throw new NoSuchElementException("Unable to find scala3RuntimeFixes.jar on classpath, did you add scala3-graal jar on classpath?");
            }
            ClassPathEntry created = cache.put(RelPath$.MODULE$.apply((Object)jarName, (PathConvertible)PathConvertible.StringConvertible$.MODULE$), runtimeJarIs.readAllBytes());
            return (Seq)cp.$plus$colon((Object)created);
        }
        return cp;
    }

    public ClassPathEntry processDir(Path dir, Path dest, JarCache cache) {
        Product product;
        IndexedSeq paths = (IndexedSeq)walk$.MODULE$.apply(dir, walk$.MODULE$.apply$default$2(), walk$.MODULE$.apply$default$3(), walk$.MODULE$.apply$default$4(), walk$.MODULE$.apply$default$5(), walk$.MODULE$.apply$default$6()).filter((Function1)isFile$.MODULE$);
        Tuple2 tuple2 = paths.partitionMap((Function1 & Serializable)x$1 -> {
            Path path;
            Path p = path = x$1;
            String string = p.ext();
            String string2 = "class";
            if (string == null ? string2 != null : !string.equals(string2)) {
                return package$.MODULE$.Left().apply((Object)p);
            }
            Path clazzFile = path;
            byte[] original = read.bytes$.MODULE$.apply((ReadablePath)clazzFile);
            Option<byte[]> option = this.processClassFile(original);
            if (option instanceof Some) {
                byte[] content = (byte[])((Some)option).value();
                RelPath relPath = clazzFile.relativeTo(dir);
                Path destPath = dest.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(relPath));
                makeDir.all$.MODULE$.apply(destPath.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(os.package$.MODULE$.up())));
                if (content == original) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                write$.MODULE$.apply(destPath, (Source)Source$.MODULE$.WritableSource((Object)content, (Function1 & Serializable)a -> Writable$.MODULE$.ByteArrayWritable(a)), write$.MODULE$.apply$default$3(), write$.MODULE$.apply$default$4());
                return package$.MODULE$.Right().apply((Object)clazzFile);
            }
            return package$.MODULE$.Left().apply((Object)clazzFile);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        IndexedSeq skipped = (IndexedSeq)tuple2._1();
        IndexedSeq processed = (IndexedSeq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)skipped, (Object)processed);
        IndexedSeq skipped2 = (IndexedSeq)tuple22._1();
        IndexedSeq processed2 = (IndexedSeq)tuple22._2();
        if (processed2.nonEmpty()) {
            skipped2.foreach((Function1)(JProcedure1 & Serializable)file -> {
                Path path = dest.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(file.relativeTo(dir)));
                boolean bl = copy.over$.MODULE$.apply$default$3();
                boolean bl2 = copy.over$.MODULE$.apply$default$4();
                boolean bl3 = copy.over$.MODULE$.apply$default$5();
                copy.over$.MODULE$.apply(file, path, bl, bl2, bl3, true);
            });
            product = Processed$.MODULE$.apply(dest, dir, cache);
        } else {
            product = Unmodified$.MODULE$.apply(dir);
        }
        return product;
    }

    public ClassPathEntry processJar(Path path, Path dest, JarCache cache) {
        ClassPathEntry classPathEntry;
        try (JarFile jarFile = new JarFile(path.toIO());){
            Product product;
            ObjectRef processedBytecode = ObjectRef.create((Object)None$.MODULE$);
            String endMarker = "///";
            ObjectRef processed = ObjectRef.create((Object)endMarker);
            Iterator classFilesIterator = CollectionConverters$.MODULE$.IteratorHasAsScala(jarFile.entries().asIterator()).asScala().filter((Function1 & Serializable)_$5 -> _$5.getName().endsWith(".class"));
            Set cachedEntries = classFilesIterator.map((Function1 & Serializable)entry -> this.processEntry$1(jarFile, processedBytecode, endMarker, processed, (JarEntry)entry)).takeWhile((Function1 & Serializable)_$6 -> {
                String string = _$6;
                String string2 = endMarker;
                return string == null ? string2 != null : !string.equals(string2);
            }).toSet();
            if (((Option)processedBytecode.elem).isEmpty()) {
                product = Unmodified$.MODULE$.apply(path);
            } else {
                makeDir.all$.MODULE$.apply(dest.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(os.package$.MODULE$.up())));
                OutputStream outStream = Files.newOutputStream(dest.toNIO(), StandardOpenOption.CREATE);
                JarOutputStream outjar = new JarOutputStream(outStream);
                CollectionConverters$.MODULE$.IteratorHasAsScala(jarFile.entries().asIterator()).asScala().foreach((Function1)(JProcedure1 & Serializable)entry -> {
                    byte[] byArray;
                    byte[] content = jarFile.getInputStream((ZipEntry)entry).readAllBytes();
                    String name = entry.getName();
                    if (cachedEntries.contains((Object)name) || !name.endsWith(".class")) {
                        byArray = content;
                    } else {
                        String string = name;
                        String string2 = (String)processed$2.elem;
                        byArray = !(string != null ? !string.equals(string2) : string2 != null) ? (byte[])((Option)processedBytecode$2.elem).get() : (byte[])this.processClassFile(content).getOrElse(() -> this.$anonfun$10(content));
                    }
                    byte[] destBytes = byArray;
                    JarEntry newEntry = new JarEntry(entry.getName());
                    outjar.putNextEntry(newEntry);
                    outjar.write(destBytes);
                    outjar.closeEntry();
                });
                outjar.close();
                product = Processed$.MODULE$.apply(dest, path, cache);
            }
            classPathEntry = product;
        }
        return classPathEntry;
    }

    public Option<byte[]> processClassReader(ClassReader reader) {
        ClassWriter writer = new ClassWriter(reader, 3);
        BytecodeProcessor.LazyValVisitor visitor = new BytecodeProcessor.LazyValVisitor(writer);
        Try res = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$anonfun$11(reader, visitor);
            return BoxedUnit.UNIT;
        });
        if (visitor.changed() && res.isSuccess()) {
            return Some$.MODULE$.apply((Object)writer.toByteArray());
        }
        return None$.MODULE$;
    }

    public Option<byte[]> processClassFile(Function0<InputStream> content) {
        Option<byte[]> option;
        try (InputStream is = (InputStream)content.apply();){
            option = this.processClassReader(new ClassReader(is));
        }
        return option;
    }

    public Option<byte[]> processClassFile(byte[] content) {
        return this.processClassReader(new ClassReader(content));
    }

    private final InputStream $anonfun$6(JarFile jarFile$2, JarEntry entry$1) {
        return jarFile$2.getInputStream(entry$1);
    }

    private final String processEntry$1$$anonfun$1(JarEntry entry$2) {
        return entry$2.getName();
    }

    private final String processEntry$1(JarFile jarFile$1, ObjectRef processedBytecode$1, String endMarker$1, ObjectRef processed$1, JarEntry entry) {
        Option option;
        Option newBytecode = this.processClassFile((Function0<InputStream>)((Function0 & Serializable)() -> this.$anonfun$6(jarFile$1, entry)));
        String string = entry.getName();
        processed$1.elem = string;
        string = null;
        processedBytecode$1.elem = option = newBytecode;
        option = null;
        return (String)newBytecode.fold(() -> this.processEntry$1$$anonfun$1(entry), (Function1 & Serializable)_$4 -> endMarker$1);
    }

    private final byte[] $anonfun$10(byte[] content$1) {
        return content$1;
    }

    private final void $anonfun$11(ClassReader reader$1, BytecodeProcessor.LazyValVisitor visitor$1) {
        reader$1.accept((ClassVisitor)visitor$1, 0);
    }
}

