/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.semanticdb.scalac;

import java.net.URI;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.meta.internal.io.PathIO$;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;

public final class SemanticdbPaths$ {
    public static SemanticdbPaths$ MODULE$;
    private final RelativePath semanticdbPrefix;
    private final String semanticdbExtension;
    private final String scalaExtension;
    private final String scalaScriptExtension;

    static {
        new SemanticdbPaths$();
    }

    public RelativePath semanticdbPrefix() {
        return this.semanticdbPrefix;
    }

    public String semanticdbExtension() {
        return this.semanticdbExtension;
    }

    private String scalaExtension() {
        return this.scalaExtension;
    }

    private String scalaScriptExtension() {
        return this.scalaScriptExtension;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSemanticdb(RelativePath path) {
        if (!path.toNIO().startsWith(this.semanticdbPrefix().toNIO())) return false;
        String string = PathIO$.MODULE$.extension(path.toNIO());
        String string2 = this.semanticdbExtension();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public AbsolutePath toScala(AbsolutePath semanticdb, AbsolutePath sourceroot, AbsolutePath targetroot) {
        return sourceroot.resolve(this.toScala(semanticdb.toRelative(targetroot)));
    }

    public RelativePath toScala(RelativePath path) {
        Predef$.MODULE$.require(this.isSemanticdb(path));
        RelativePath scalaSibling = path.resolveSibling((Function1<String, String> & java.io.Serializable & Serializable)x$1 -> new StringOps(Predef$.MODULE$.augmentString((String)x$1)).stripSuffix(new StringBuilder(1).append(".").append(MODULE$.semanticdbExtension()).toString()));
        return this.semanticdbPrefix().relativize(scalaSibling);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isScala(RelativePath path) {
        String extension;
        String string = extension = PathIO$.MODULE$.extension(path.toNIO());
        String string2 = this.scalaExtension();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = extension;
        String string4 = this.scalaScriptExtension();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public RelativePath fromScala(RelativePath path) {
        Predef$.MODULE$.require(this.isScala(path));
        RelativePath semanticdbSibling = path.resolveSibling((Function1<String, String> & java.io.Serializable & Serializable)x$2 -> new StringBuilder(1).append((String)x$2).append(".").append(MODULE$.semanticdbExtension()).toString());
        return this.semanticdbPrefix().resolve(semanticdbSibling);
    }

    public AbsolutePath toSemanticdb(RelativePath path, AbsolutePath targetroot) {
        Predef$.MODULE$.require(this.isScala(path));
        RelativePath semanticdbPath = path.resolveSibling((Function1<String, String> & java.io.Serializable & Serializable)x$3 -> new StringBuilder(1).append((String)x$3).append(".").append(MODULE$.semanticdbExtension()).toString());
        return targetroot.resolve(this.semanticdbPrefix()).resolve(semanticdbPath);
    }

    public AbsolutePath toSemanticdb(TextDocument doc, AbsolutePath targetroot) {
        AbsolutePath targetrootWithSemanticdbPrefix = targetroot.resolve(this.semanticdbPrefix());
        URI uri = targetrootWithSemanticdbPrefix.toURI(true).resolve(new StringBuilder(1).append(doc.uri()).append(".").append(this.semanticdbExtension()).toString());
        return AbsolutePath$.MODULE$.fromAbsoluteUri(uri, AbsolutePath$.MODULE$.workingDirectory());
    }

    private SemanticdbPaths$() {
        MODULE$ = this;
        this.semanticdbPrefix = RelativePath$.MODULE$.apply("META-INF").resolve("semanticdb");
        this.semanticdbExtension = "semanticdb";
        this.scalaExtension = "scala";
        this.scalaScriptExtension = "sc";
    }
}

