/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jansi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fusesource.jansi.AnsiConsole;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.PosixPtyTerminal;
import org.jline.terminal.impl.PosixSysTerminal;
import org.jline.terminal.impl.jansi.JansiNativePty;
import org.jline.terminal.impl.jansi.freebsd.FreeBsdNativePty;
import org.jline.terminal.impl.jansi.linux.LinuxNativePty;
import org.jline.terminal.impl.jansi.osx.OsXNativePty;
import org.jline.terminal.impl.jansi.win.JansiWinSysTerminal;
import org.jline.terminal.spi.Pty;
import org.jline.terminal.spi.TerminalProvider;
import org.jline.utils.OSUtils;

public class JansiTerminalProvider
implements TerminalProvider {
    static final int JANSI_MAJOR_VERSION;
    static final int JANSI_MINOR_VERSION;

    public static int getJansiMajorVersion() {
        return JANSI_MAJOR_VERSION;
    }

    public static int getJansiMinorVersion() {
        return JANSI_MINOR_VERSION;
    }

    public static boolean isAtLeast(int major, int minor) {
        return JANSI_MAJOR_VERSION > major || JANSI_MAJOR_VERSION == major && JANSI_MINOR_VERSION >= minor;
    }

    @Override
    public String name() {
        return "jansi";
    }

    public Pty current(TerminalProvider.Stream consoleStream) throws IOException {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux")) {
            return LinuxNativePty.current(consoleStream);
        }
        if (osName.startsWith("Mac") || osName.startsWith("Darwin")) {
            return OsXNativePty.current(consoleStream);
        }
        if (!osName.startsWith("Solaris") && !osName.startsWith("SunOS") && osName.startsWith("FreeBSD") && JansiTerminalProvider.isAtLeast(1, 16)) {
            return FreeBsdNativePty.current(consoleStream);
        }
        throw new UnsupportedOperationException();
    }

    public Pty open(Attributes attributes, Size size) throws IOException {
        if (JansiTerminalProvider.isAtLeast(1, 16)) {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Linux")) {
                return LinuxNativePty.open(attributes, size);
            }
            if (osName.startsWith("Mac") || osName.startsWith("Darwin")) {
                return OsXNativePty.open(attributes, size);
            }
            if (!osName.startsWith("Solaris") && !osName.startsWith("SunOS") && osName.startsWith("FreeBSD")) {
                return FreeBsdNativePty.open(attributes, size);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Terminal sysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, TerminalProvider.Stream consoleStream) throws IOException {
        if (OSUtils.IS_WINDOWS) {
            return this.winSysTerminal(name, type, ansiPassThrough, encoding, nativeSignals, signalHandler, paused, consoleStream);
        }
        return this.posixSysTerminal(name, type, ansiPassThrough, encoding, nativeSignals, signalHandler, paused, consoleStream);
    }

    public Terminal winSysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, TerminalProvider.Stream consoleStream) throws IOException {
        if (JansiTerminalProvider.isAtLeast(1, 12)) {
            JansiWinSysTerminal terminal2 = JansiWinSysTerminal.createTerminal(name, type, ansiPassThrough, encoding, nativeSignals, signalHandler, paused, consoleStream);
            if (!JansiTerminalProvider.isAtLeast(1, 16)) {
                terminal2.disableScrolling();
            }
            return terminal2;
        }
        throw new UnsupportedOperationException();
    }

    public Terminal posixSysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, TerminalProvider.Stream consoleStream) throws IOException {
        Pty pty = this.current(consoleStream);
        return new PosixSysTerminal(name, type, pty, encoding, nativeSignals, signalHandler);
    }

    @Override
    public Terminal newTerminal(String name, String type, InputStream in, OutputStream out, Charset encoding, Terminal.SignalHandler signalHandler, boolean paused, Attributes attributes, Size size) throws IOException {
        Pty pty = this.open(attributes, size);
        return new PosixPtyTerminal(name, type, pty, in, out, encoding, signalHandler, paused);
    }

    @Override
    public boolean isSystemStream(TerminalProvider.Stream stream) {
        try {
            if (OSUtils.IS_WINDOWS) {
                return this.isWindowsSystemStream(stream);
            }
            return this.isPosixSystemStream(stream);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isWindowsSystemStream(TerminalProvider.Stream stream) {
        return JansiWinSysTerminal.isWindowsSystemStream(stream);
    }

    public boolean isPosixSystemStream(TerminalProvider.Stream stream) {
        return JansiNativePty.isPosixSystemStream(stream);
    }

    @Override
    public String systemStreamName(TerminalProvider.Stream stream) {
        return JansiNativePty.posixSystemStreamName(stream);
    }

    static {
        int major = 0;
        int minor = 0;
        try {
            Matcher m;
            String v = null;
            try (InputStream is2 = AnsiConsole.class.getResourceAsStream("jansi.properties");){
                if (is2 != null) {
                    Properties props = new Properties();
                    props.load(is2);
                    v = props.getProperty("version");
                }
            }
            catch (IOException is2) {
                // empty catch block
            }
            if (v == null) {
                v = AnsiConsole.class.getPackage().getImplementationVersion();
            }
            if (v != null && (m = Pattern.compile("([0-9]+)\\.([0-9]+)([\\.-]\\S+)?").matcher(v)).matches()) {
                major = Integer.parseInt(m.group(1));
                minor = Integer.parseInt(m.group(2));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JANSI_MAJOR_VERSION = major;
        JANSI_MINOR_VERSION = minor;
    }
}

