/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jansi;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fusesource.jansi.AnsiConsole;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.jansi.JansiNativePty;
import org.jline.terminal.impl.jansi.freebsd.FreeBsdNativePty;
import org.jline.terminal.impl.jansi.linux.LinuxNativePty;
import org.jline.terminal.impl.jansi.osx.OsXNativePty;
import org.jline.terminal.impl.jansi.win.JansiWinSysTerminal;
import org.jline.terminal.spi.JansiSupport;
import org.jline.terminal.spi.Pty;
import org.jline.utils.OSUtils;

public class JansiSupportImpl
implements JansiSupport {
    static final int JANSI_MAJOR_VERSION;
    static final int JANSI_MINOR_VERSION;

    public static int getJansiMajorVersion() {
        return JANSI_MAJOR_VERSION;
    }

    public static int getJansiMinorVersion() {
        return JANSI_MINOR_VERSION;
    }

    public static boolean isAtLeast(int major, int minor) {
        return JANSI_MAJOR_VERSION > major || JANSI_MAJOR_VERSION == major && JANSI_MINOR_VERSION >= minor;
    }

    @Override
    public Pty current() throws IOException {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux")) {
            return LinuxNativePty.current();
        }
        if (osName.startsWith("Mac") || osName.startsWith("Darwin")) {
            return OsXNativePty.current();
        }
        if (!osName.startsWith("Solaris") && !osName.startsWith("SunOS") && osName.startsWith("FreeBSD") && JansiSupportImpl.isAtLeast(1, 16)) {
            return FreeBsdNativePty.current();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Pty open(Attributes attributes, Size size) throws IOException {
        if (JansiSupportImpl.isAtLeast(1, 16)) {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Linux")) {
                return LinuxNativePty.open(attributes, size);
            }
            if (osName.startsWith("Mac") || osName.startsWith("Darwin")) {
                return OsXNativePty.open(attributes, size);
            }
            if (!osName.startsWith("Solaris") && !osName.startsWith("SunOS") && osName.startsWith("FreeBSD")) {
                return FreeBsdNativePty.open(attributes, size);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Terminal winSysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, int codepage, boolean nativeSignals, Terminal.SignalHandler signalHandler) throws IOException {
        return this.winSysTerminal(name, type, ansiPassThrough, encoding, codepage, nativeSignals, signalHandler, false);
    }

    @Override
    public Terminal winSysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, int codepage, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused) throws IOException {
        if (JansiSupportImpl.isAtLeast(1, 12)) {
            JansiWinSysTerminal terminal2 = JansiWinSysTerminal.createTerminal(name, type, ansiPassThrough, encoding, codepage, nativeSignals, signalHandler, paused);
            if (!JansiSupportImpl.isAtLeast(1, 16)) {
                terminal2.disableScrolling();
            }
            return terminal2;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWindowsConsole() {
        return JansiWinSysTerminal.isWindowsConsole();
    }

    @Override
    public boolean isConsoleOutput() {
        if (OSUtils.IS_CYGWIN || OSUtils.IS_MSYSTEM) {
            if (JansiSupportImpl.isAtLeast(2, 1)) {
                return JansiNativePty.isConsoleOutput();
            }
            throw new UnsupportedOperationException();
        }
        if (OSUtils.IS_WINDOWS) {
            return JansiWinSysTerminal.isConsoleOutput();
        }
        return JansiNativePty.isConsoleOutput();
    }

    @Override
    public boolean isConsoleInput() {
        if (OSUtils.IS_CYGWIN || OSUtils.IS_MSYSTEM) {
            if (JansiSupportImpl.isAtLeast(2, 1)) {
                return JansiNativePty.isConsoleInput();
            }
            throw new UnsupportedOperationException();
        }
        if (OSUtils.IS_WINDOWS) {
            return JansiWinSysTerminal.isConsoleInput();
        }
        return JansiNativePty.isConsoleInput();
    }

    static {
        int major = 0;
        int minor = 0;
        try {
            Matcher m;
            String v = null;
            try (InputStream is2 = AnsiConsole.class.getResourceAsStream("jansi.properties");){
                if (is2 != null) {
                    Properties props = new Properties();
                    props.load(is2);
                    v = props.getProperty("version");
                }
            }
            catch (IOException is2) {
                // empty catch block
            }
            if (v == null) {
                v = AnsiConsole.class.getPackage().getImplementationVersion();
            }
            if (v != null && (m = Pattern.compile("([0-9]+)\\.([0-9]+)([\\.-]\\S+)?").matcher(v)).matches()) {
                major = Integer.parseInt(m.group(1));
                minor = Integer.parseInt(m.group(2));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JANSI_MAJOR_VERSION = major;
        JANSI_MINOR_VERSION = minor;
    }
}

