/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.tokenizers;

import scala.Option;
import scala.Predef$;
import scala.meta.Dialect;
import scala.meta.inputs.Input;
import scala.meta.internal.tokenizers.CharArrayReaderData;
import scala.meta.internal.tokenizers.Chars$;
import scala.meta.internal.tokenizers.Reporter;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005-4Aa\u0006\r\u0001C!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011!1\u0004A!A!\u0002\u00139\u0004\"\u0002\u001e\u0001\t\u0003Y\u0004b\u0002!\u0001\u0005\u0004%\t!\u0011\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\"\t\u000f%\u0003\u0001\u0019!C\u0001\u0015\"9a\n\u0001a\u0001\n\u0003y\u0005BB+\u0001A\u0003&1\nC\u0003W\u0001\u0011\u0015q\u000bC\u0003Y\u0001\u0011\u0015q\u000bC\u0003Z\u0001\u0011\u0015q\u000bC\u0003[\u0001\u0011\u00051\fC\u0003]\u0001\u0011%q\u000bC\u0003^\u0001\u0011%q\u000bC\u0003_\u0001\u0011%q\u000bC\u0003`\u0001\u0011%\u0001\rC\u0003b\u0001\u0011\u0005!M\u0002\u0003f\u0001\u00011\u0007\"\u0002\u001e\u0014\t\u00039\u0007\"\u00025\u0014\t\u0003I\u0007\"\u00026\u0014\t\u0003I'aD\"iCJ\f%O]1z%\u0016\fG-\u001a:\u000b\u0005eQ\u0012A\u0003;pW\u0016t\u0017N_3sg*\u00111\u0004H\u0001\tS:$XM\u001d8bY*\u0011QDH\u0001\u0005[\u0016$\u0018MC\u0001 \u0003\u0015\u00198-\u00197b\u0007\u0001\u00192\u0001\u0001\u0012'!\t\u0019C%D\u0001\u001f\u0013\t)cD\u0001\u0004B]f\u0014VM\u001a\t\u0003O!j\u0011\u0001G\u0005\u0003Sa\u00111c\u00115be\u0006\u0013(/Y=SK\u0006$WM\u001d#bi\u0006\fQ!\u001b8qkR\u0004\"\u0001L\u0018\u000e\u00035R!A\f\u000f\u0002\r%t\u0007/\u001e;t\u0013\t\u0001TFA\u0003J]B,H/A\u0004eS\u0006dWm\u0019;\u0011\u0005M\"T\"\u0001\u000f\n\u0005Ub\"a\u0002#jC2,7\r^\u0001\te\u0016\u0004xN\u001d;feB\u0011q\u0005O\u0005\u0003sa\u0011\u0001BU3q_J$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\tqjdh\u0010\t\u0003O\u0001AQA\u000b\u0003A\u0002-BQ!\r\u0003A\u0002IBQA\u000e\u0003A\u0002]\n1AY;g+\u0005\u0011\u0005cA\u0012D\u000b&\u0011AI\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003G\u0019K!a\u0012\u0010\u0003\t\rC\u0017M]\u0001\u0005EV4\u0007%A\bjgVs\u0017nY8eK\u0016\u001b8-\u00199f+\u0005Y\u0005CA\u0012M\u0013\tieDA\u0004C_>dW-\u00198\u0002'%\u001cXK\\5d_\u0012,Wi]2ba\u0016|F%Z9\u0015\u0005A\u001b\u0006CA\u0012R\u0013\t\u0011fD\u0001\u0003V]&$\bb\u0002+\t\u0003\u0003\u0005\raS\u0001\u0004q\u0012\n\u0014\u0001E5t+:L7m\u001c3f\u000bN\u001c\u0017\r]3!\u0003!qW\r\u001f;DQ\u0006\u0014H#\u0001)\u0002\u001f9,\u0007\u0010^\"p[6,g\u000e^\"iCJ\f1B\\3yiJ\u000bwo\u00115be\u0006\tb.\u001a=u\u001d>tw\u000b[5uKN\u0004\u0018mY3\u0016\u0003\u0015\u000b\u0001\u0003]8uK:$\u0018.\u00197V]&\u001cw\u000eZ3\u0002\rM\\\u0017\u000e]\"S\u0003A\u0001x\u000e^3oi&\fG\u000eT5oK\u0016sG-\u0001\u0007dQ\u0016\u001c7\u000eT5oK\u0016sG\rF\u0001L\u0003=awn\\6bQ\u0016\fGMU3bI\u0016\u0014X#A2\u0011\u0005\u0011\u001cR\"\u0001\u0001\u00031\rC\u0017M]!se\u0006LHj\\8lC\",\u0017\r\u001a*fC\u0012,'o\u0005\u0002\u0014yQ\t1-\u0001\u0003hKR\u001cG#A#\u0002\t\u001d,G/\u001e")
public class CharArrayReader
implements CharArrayReaderData {
    public final Input scala$meta$internal$tokenizers$CharArrayReader$$input;
    public final Dialect scala$meta$internal$tokenizers$CharArrayReader$$dialect;
    public final Reporter scala$meta$internal$tokenizers$CharArrayReader$$reporter;
    private final char[] buf;
    private boolean isUnicodeEscape;
    private char ch;
    private int charOffset;
    private int lineStartOffset;
    private int lastLineStartOffset;
    private int lastUnicodeOffset;

    @Override
    public char ch() {
        return this.ch;
    }

    @Override
    public void ch_$eq(char x$1) {
        this.ch = x$1;
    }

    @Override
    public int charOffset() {
        return this.charOffset;
    }

    @Override
    public void charOffset_$eq(int x$1) {
        this.charOffset = x$1;
    }

    @Override
    public int lineStartOffset() {
        return this.lineStartOffset;
    }

    @Override
    public void lineStartOffset_$eq(int x$1) {
        this.lineStartOffset = x$1;
    }

    @Override
    public int lastLineStartOffset() {
        return this.lastLineStartOffset;
    }

    @Override
    public void lastLineStartOffset_$eq(int x$1) {
        this.lastLineStartOffset = x$1;
    }

    @Override
    public int lastUnicodeOffset() {
        return this.lastUnicodeOffset;
    }

    @Override
    public void lastUnicodeOffset_$eq(int x$1) {
        this.lastUnicodeOffset = x$1;
    }

    public char[] buf() {
        return this.buf;
    }

    public boolean isUnicodeEscape() {
        return this.isUnicodeEscape;
    }

    public void isUnicodeEscape_$eq(boolean x$1) {
        this.isUnicodeEscape = x$1;
    }

    public final void nextChar() {
        if (this.isUnicodeEscape()) {
            this.charOffset_$eq(this.lastUnicodeOffset());
        }
        this.isUnicodeEscape_$eq(false);
        if (this.charOffset() >= this.buf().length) {
            this.ch_$eq('\u001a');
            return;
        }
        char c = this.buf()[this.charOffset()];
        this.ch_$eq(c);
        this.charOffset_$eq(this.charOffset() + 1);
        if (c == '\\') {
            this.scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
        }
        if (this.ch() < ' ') {
            this.skipCR();
            this.potentialLineEnd();
        }
        if (this.ch() == '\"' && !this.scala$meta$internal$tokenizers$CharArrayReader$$dialect.allowMultilinePrograms()) {
            throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("double quotes are not allowed in single-line quasiquotes", this.charOffset() - 1);
        }
    }

    public final void nextCommentChar() {
        if (this.charOffset() >= this.buf().length) {
            this.ch_$eq('\u001a');
            return;
        }
        this.ch_$eq(this.buf()[this.charOffset()]);
        this.charOffset_$eq(this.charOffset() + 1);
        this.checkLineEnd();
    }

    public final void nextRawChar() {
        if (this.isUnicodeEscape()) {
            this.charOffset_$eq(this.lastUnicodeOffset());
        }
        this.isUnicodeEscape_$eq(false);
        if (this.charOffset() >= this.buf().length) {
            this.ch_$eq('\u001a');
            return;
        }
        char c = this.buf()[this.charOffset()];
        this.ch_$eq(c);
        this.charOffset_$eq(this.charOffset() + 1);
        if (c == '\\') {
            this.scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
            return;
        }
    }

    public char nextNonWhitespace() {
        while (this.ch() == ' ' || this.ch() == '\t') {
            this.nextRawChar();
        }
        return this.ch();
    }

    public void scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode() {
        int end = this.charOffset();
        if (this.charOffset() < this.buf().length && this.buf()[this.charOffset()] == 'u' && this.evenSlashPrefix$1()) {
            do {
                this.charOffset_$eq(this.charOffset() + 1);
            } while (this.charOffset() < this.buf().length && this.buf()[this.charOffset()] == 'u');
            try {
                int code = this.udigit$1() << 12 | this.udigit$1() << 8 | this.udigit$1() << 4 | this.udigit$1();
                this.lastUnicodeOffset_$eq(this.charOffset());
                this.isUnicodeEscape_$eq(true);
                this.ch_$eq((char)code);
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                }
                throw throwable;
            }
        }
        if (end < this.buf().length) {
            this.charOffset_$eq(end);
            return;
        }
    }

    private void skipCR() {
        if (this.ch() == '\r' && this.charOffset() < this.buf().length) {
            char c = this.buf()[this.charOffset()];
            switch (c) {
                case '\\': {
                    if (this.lookaheadReader().getu() == '\n') {
                        this.scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
                        return;
                    }
                    return;
                }
            }
            return;
        }
    }

    private void potentialLineEnd() {
        if (this.checkLineEnd() && !this.scala$meta$internal$tokenizers$CharArrayReader$$dialect.allowMultilinePrograms()) {
            throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("line breaks are not allowed in single-line quasiquotes", this.charOffset() - 1);
        }
    }

    private boolean checkLineEnd() {
        boolean ok;
        block0: {
            boolean bl = ok = this.ch() == '\n' || this.ch() == '\f';
            if (!ok) break block0;
            this.lastLineStartOffset_$eq(this.lineStartOffset());
            this.lineStartOffset_$eq(this.charOffset());
        }
        return ok;
    }

    public CharArrayLookaheadReader lookaheadReader() {
        return new CharArrayLookaheadReader();
    }

    private final boolean evenSlashPrefix$1() {
        int p;
        for (p = this.charOffset() - 2; p >= 0 && this.buf()[p] == '\\'; --p) {
        }
        return (this.charOffset() - p) % 2 == 0;
    }

    private final int udigit$1() {
        if (this.charOffset() >= this.buf().length) {
            throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("incomplete unicode escape", this.charOffset() - 1);
        }
        int d = Chars$.MODULE$.digit2int(this.buf()[this.charOffset()], 16);
        if (d < 0) {
            throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("error in unicode escape", this.charOffset());
        }
        this.charOffset_$eq(this.charOffset() + 1);
        return d;
    }

    public CharArrayReader(Input input, Dialect dialect, Reporter reporter) {
        this.scala$meta$internal$tokenizers$CharArrayReader$$input = input;
        this.scala$meta$internal$tokenizers$CharArrayReader$$dialect = dialect;
        this.scala$meta$internal$tokenizers$CharArrayReader$$reporter = reporter;
        CharArrayReaderData.$init$(this);
        this.buf = input.chars();
        this.isUnicodeEscape = false;
    }

    public class CharArrayLookaheadReader
    extends CharArrayReader {
        public char getc() {
            this.nextChar();
            return this.ch();
        }

        public char getu() {
            Predef$.MODULE$.require(this.buf()[this.charOffset()] == '\\');
            this.ch_$eq('\\');
            this.charOffset_$eq(this.charOffset() + 1);
            this.scala$meta$internal$tokenizers$CharArrayReader$CharArrayLookaheadReader$$$outer().scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
            return this.ch();
        }

        public /* synthetic */ CharArrayReader scala$meta$internal$tokenizers$CharArrayReader$CharArrayLookaheadReader$$$outer() {
            return CharArrayReader.this;
        }

        public CharArrayLookaheadReader() {
            if (CharArrayReader.this == null) {
                throw null;
            }
            super(CharArrayReader.this.scala$meta$internal$tokenizers$CharArrayReader$$input, CharArrayReader.this.scala$meta$internal$tokenizers$CharArrayReader$$dialect, CharArrayReader.this.scala$meta$internal$tokenizers$CharArrayReader$$reporter);
            this.charOffset_$eq(CharArrayReader.this.charOffset());
            this.ch_$eq(CharArrayReader.this.ch());
        }
    }
}

