/*
 * Decompiled with CFR 0.152.
 */
package com.virtuslab.semanticgraphs.scalac_plugin.graphgenerator.analyzerv2;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import com.virtuslab.semanticgraphs.proto.model.GraphNodeOuterClass;
import com.virtuslab.semanticgraphs.scalac_plugin.graphgenerator.analyzerv2.EdgeType$;
import com.virtuslab.semanticgraphs.scalac_plugin.graphgenerator.analyzerv2.GraphAccumulator;
import com.virtuslab.semanticgraphs.scalac_plugin.graphgenerator.analyzerv2.ProtoHelper$;
import com.virtuslab.semanticgraphs.scalac_plugin.graphgenerator.analyzerv2.SemanticdbHelper;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.meta.internal.semanticdb.AnnotatedType;
import scala.meta.internal.semanticdb.Annotation;
import scala.meta.internal.semanticdb.ClassSignature;
import scala.meta.internal.semanticdb.ConstantType;
import scala.meta.internal.semanticdb.ExistentialType;
import scala.meta.internal.semanticdb.MethodSignature;
import scala.meta.internal.semanticdb.Range;
import scala.meta.internal.semanticdb.RepeatedType;
import scala.meta.internal.semanticdb.Scope;
import scala.meta.internal.semanticdb.Signature;
import scala.meta.internal.semanticdb.SingleType;
import scala.meta.internal.semanticdb.StructuralType;
import scala.meta.internal.semanticdb.SuperType;
import scala.meta.internal.semanticdb.SymbolInformation;
import scala.meta.internal.semanticdb.SymbolOccurrence;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.internal.semanticdb.ThisType;
import scala.meta.internal.semanticdb.Type;
import scala.meta.internal.semanticdb.Type$Empty$;
import scala.meta.internal.semanticdb.TypeRef;
import scala.meta.internal.semanticdb.TypeSignature;
import scala.meta.internal.semanticdb.UnionType;
import scala.meta.internal.semanticdb.UniversalType;
import scala.meta.internal.semanticdb.ValueSignature;
import scala.meta.internal.semanticdb.WithType;
import scala.meta.internal.semanticdb.package$XtensionSemanticdbSymbolInformation$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001B\b\u0011\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tS\u0001\u0011\t\u0011)A\u0005U!)Q\u0006\u0001C\u0001]!9!\u0007\u0001b\u0001\n\u0003\u0019\u0004B\u0002\u001f\u0001A\u0003%A\u0007C\u0003>\u0001\u0011\u0005a\bC\u0003C\u0001\u0011\u00051\tC\u0003Q\u0001\u0011%\u0011\u000bC\u0004\u0002\u0006\u0001!I!a\u0002\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001b\u0012\u0001dU3nC:$\u0018n\u00193c\u000fJ\f\u0007\u000f[#yiJ\f7\r^8s\u0015\t\t\"#\u0001\u0006b]\u0006d\u0017P_3smJR!a\u0005\u000b\u0002\u001d\u001d\u0014\u0018\r\u001d5hK:,'/\u0019;pe*\u0011QCF\u0001\u000eg\u000e\fG.Y2`a2,x-\u001b8\u000b\u0005]A\u0012AD:f[\u0006tG/[2he\u0006\u0004\bn\u001d\u0006\u00033i\t\u0011B^5siV\u001cH.\u00192\u000b\u0003m\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g\u0003A9'/\u00199i\u0003\u000e\u001cW/\\;mCR|'\u000f\u0005\u0002'O5\t\u0001#\u0003\u0002)!\t\u0001rI]1qQ\u0006\u001b7-^7vY\u0006$xN]\u0001\u0011g\u0016l\u0017M\u001c;jG\u0012\u0014\u0007*\u001a7qKJ\u0004\"AJ\u0016\n\u00051\u0002\"\u0001E*f[\u0006tG/[2eE\"+G\u000e]3s\u0003\u0019a\u0014N\\5u}Q\u0019q\u0006M\u0019\u0011\u0005\u0019\u0002\u0001\"\u0002\u0013\u0004\u0001\u0004)\u0003\"B\u0015\u0004\u0001\u0004Q\u0013A\u00027pO\u001e,'/F\u00015!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002:5\u0005AA/\u001f9fg\u00064W-\u0003\u0002<m\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0012de\u0016\fG/Z%oSRL\u0017\r\\$sCBD')Y:fI>s7+Z7b]RL7\r\u0012\"\u0015\u0003}\u0002\"a\b!\n\u0005\u0005\u0003#\u0001B+oSR\fq!\u001a=ue\u0006\u001cG\u000f\u0006\u0002@\t\")Qi\u0002a\u0001\r\u0006\t2/_7c_2LeNZ8s[\u0006$\u0018n\u001c8\u0011\u0005\u001dsU\"\u0001%\u000b\u0005%S\u0015AC:f[\u0006tG/[2eE*\u00111\nT\u0001\tS:$XM\u001d8bY*\u0011Q\nI\u0001\u0005[\u0016$\u0018-\u0003\u0002P\u0011\n\t2+_7c_2LeNZ8s[\u0006$\u0018n\u001c8\u0002=\u0015DHO]1di\u0016#w-Z:Ge>l7\t\\1tgNKwM\\1ukJ,Gc\u0001*tqB\u00191k\u00170\u000f\u0005QKfBA+Y\u001b\u00051&BA,\u001d\u0003\u0019a$o\\8u}%\t\u0011%\u0003\u0002[A\u00059\u0001/Y2lC\u001e,\u0017B\u0001/^\u0005\r\u0019V-\u001d\u0006\u00035\u0002\u0002\"a\u00189\u000f\u0005\u0001lgBA1k\u001d\t\u0011\u0007N\u0004\u0002dO:\u0011AM\u001a\b\u0003+\u0016L\u0011aG\u0005\u00033iI!a\u0006\r\n\u0005%4\u0012!\u00029s_R|\u0017BA6m\u0003\u0015iw\u000eZ3m\u0015\tIg#\u0003\u0002o_\u0006\u0019rI]1qQ:{G-Z(vi\u0016\u00148\t\\1tg*\u00111\u000e\\\u0005\u0003cJ\u0014A!\u00123hK*\u0011an\u001c\u0005\u0006i\"\u0001\r!^\u0001\u000fG2\f7o]*jO:\fG/\u001e:f!\t9e/\u0003\u0002x\u0011\nq1\t\\1tgNKwM\\1ukJ,\u0007\"B=\t\u0001\u0004Q\u0018\u0001\u00039be\u0016tG/\u00133\u0011\u0005m|hB\u0001?~!\t)\u0006%\u0003\u0002\u007fA\u00051\u0001K]3eK\u001aLA!!\u0001\u0002\u0004\t11\u000b\u001e:j]\u001eT!A \u0011\u0002?\u0015DHO]1di\u0016#w-Z:Ge>lW*\u001a;i_\u0012\u001c\u0016n\u001a8biV\u0014X\rF\u0004S\u0003\u0013\tY!!\u0006\t\u000b\u0015K\u0001\u0019\u0001$\t\u000f\u00055\u0011\u00021\u0001\u0002\u0010\u0005yQ.\u001a;i_\u0012\u001c\u0016n\u001a8biV\u0014X\rE\u0002H\u0003#I1!a\u0005I\u0005=iU\r\u001e5pINKwM\\1ukJ,\u0007\"B=\n\u0001\u0004Q\u0018\u0001F3yiJ\f7\r^#eO\u0016\u001chI]8n)f\u0004X\rF\u0004S\u00037\t)#!\u000b\t\u000f\u0005u!\u00021\u0001\u0002 \u0005)q\f^=qKB\u0019q)!\t\n\u0007\u0005\r\u0002J\u0001\u0003UsB,\u0007BBA\u0014\u0015\u0001\u0007!0\u0001\u0003s_2,\u0007\"B=\u000b\u0001\u0004Q\u0018aC2sK\u0006$X-\u00123hKN$RAUA\u0018\u0003kAq!!\r\f\u0001\u0004\t\u0019$\u0001\u0005ts6d\u0017N\\6t!\r\u00196L\u001f\u0005\u0007\u0003;Y\u0001\u0019\u0001>\u0002\u0015\r\u0014X-\u0019;f\u000b\u0012<W\rF\u0003_\u0003w\ty\u0004\u0003\u0004\u0002>1\u0001\rA_\u0001\u0006G\"LG\u000e\u001a\u0005\u0007\u0003;a\u0001\u0019\u0001>\u0002/\r\u0014X-\u0019;f\u000b\u0012<WMR8s\t\u00164\u0017N\\5uS>tG#\u00020\u0002F\u0005%\u0003BBA$\u001b\u0001\u0007!0\u0001\u0004ts6\u0014w\u000e\u001c\u0005\u0007\u0003;i\u0001\u0019\u0001>\u0002\u001f\u0015DHO]1di2{7-\u0019;j_:$B!a\u0014\u0002\\A)q$!\u0015\u0002V%\u0019\u00111\u000b\u0011\u0003\r=\u0003H/[8o!\ry\u0016qK\u0005\u0004\u00033\u0012(\u0001\u0003'pG\u0006$\u0018n\u001c8\t\r\u0005\u001dc\u00021\u0001{\u0001")
public class SemanticdbGraphExtractor {
    private final GraphAccumulator graphAccumulator;
    private final SemanticdbHelper semanticdbHelper;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void createInitialGraphBasedOnSemanticDB() {
        TextDocument textDocument = this.semanticdbHelper.textDocument();
        textDocument.symbols().foreach((Function1<SymbolInformation, Object> & Serializable)symbolInformation -> {
            this.extract(symbolInformation);
            return BoxedUnit.UNIT;
        });
    }

    public void extract(SymbolInformation symbolInformation) {
        Seq seq;
        String parentId = symbolInformation.symbol();
        Signature signature = symbolInformation.signature();
        if (signature instanceof ClassSignature) {
            ClassSignature classSignature = (ClassSignature)signature;
            seq = this.extractEdgesFromClassSignature(classSignature, parentId);
        } else if (signature instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)signature;
            seq = this.extractEdgesFromMethodSignature(symbolInformation, methodSignature, parentId);
        } else if (signature instanceof ValueSignature) {
            ValueSignature valueSignature = (ValueSignature)signature;
            seq = this.extractEdgesFromType(valueSignature.tpe(), EdgeType$.MODULE$.TYPE(), parentId);
        } else if (signature instanceof TypeSignature) {
            TypeSignature typeSignature = (TypeSignature)signature;
            seq = (Seq)((IterableOps)this.extractEdgesFromType(typeSignature.upperBound(), EdgeType$.MODULE$.TYPE_PARAMETER(), parentId).$plus$plus(this.extractEdgesFromType(typeSignature.lowerBound(), EdgeType$.MODULE$.TYPE_PARAMETER(), parentId))).$plus$plus(this.createEdges((Seq)Option$.MODULE$.option2Iterable(typeSignature.typeParameters()).toSeq().flatMap((Function1<Scope, Seq> & Serializable)x$1 -> x$1.symlinks()), EdgeType$.MODULE$.TYPE_PARAMETER()));
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Not supported signature {}", (Object)signature);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        Seq edges = seq;
        Seq annotationsEdges = (Seq)symbolInformation.annotations().flatMap((Function1<Annotation, Seq> & Serializable)annotation -> this.extractEdgesFromType(annotation.tpe(), "ANNOTATED", parentId));
        Seq overrides = (Seq)symbolInformation.overriddenSymbols().map((Function1<String, GraphNodeOuterClass.Edge> & Serializable)overridenSymbol -> this.createEdge((String)overridenSymbol, EdgeType$.MODULE$.OVERRIDE()));
        this.graphAccumulator.createNode(symbolInformation, this.extractLocation(symbolInformation.symbol()), (Seq)((IterableOps)annotationsEdges.$plus$plus(edges)).$plus$plus(overrides), this.graphAccumulator.createNode$default$4());
    }

    private Seq<GraphNodeOuterClass.Edge> extractEdgesFromClassSignature(ClassSignature classSignature, String parentId) {
        Seq declarationsEdges = (Seq)classSignature.declarations().map((Function1<Scope, Seq> & Serializable)declaration -> this.createEdges(declaration.symlinks(), EdgeType$.MODULE$.DECLARATION())).getOrElse((Function0<Seq> & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
        Seq parametersEdges = (Seq)classSignature.typeParameters().map((Function1<Scope, Seq> & Serializable)typeParameters -> this.createEdges(typeParameters.symlinks(), EdgeType$.MODULE$.TYPE_PARAMETER())).getOrElse((Function0<Seq> & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
        Seq extendsEdges = (Seq)classSignature.parents().flatMap((Function1<Type, Seq> & Serializable)x$2 -> this.extractEdgesFromType((Type)x$2, EdgeType$.MODULE$.EXTEND(), parentId));
        return (Seq)((IterableOps)declarationsEdges.$plus$plus(parametersEdges)).$plus$plus(extendsEdges);
    }

    private Seq<GraphNodeOuterClass.Edge> extractEdgesFromMethodSignature(SymbolInformation symbolInformation, MethodSignature methodSignature, String parentId) {
        Seq parametersEdges = (Seq)methodSignature.parameterLists().flatMap((Function1<Scope, Seq> & Serializable)parameters -> this.createEdges(parameters.symlinks(), EdgeType$.MODULE$.PARAMETER()));
        Seq<GraphNodeOuterClass.Edge> returnTypeEdges = this.extractEdgesFromType(methodSignature.returnType(), package$XtensionSemanticdbSymbolInformation$.MODULE$.isVar$extension(scala.meta.internal.semanticdb.package$.MODULE$.XtensionSemanticdbSymbolInformation(symbolInformation)) || package$XtensionSemanticdbSymbolInformation$.MODULE$.isVal$extension(scala.meta.internal.semanticdb.package$.MODULE$.XtensionSemanticdbSymbolInformation(symbolInformation)) ? EdgeType$.MODULE$.TYPE() : EdgeType$.MODULE$.RETURN_TYPE(), parentId);
        return (Seq)parametersEdges.$plus$plus(returnTypeEdges);
    }

    private Seq<GraphNodeOuterClass.Edge> extractEdgesFromType(Type _type, String role, String parentId) {
        BoxedUnit boxedUnit;
        Type type;
        while (true) {
            Type tpe;
            if ((type = _type) instanceof SingleType) {
                SingleType singleType = (SingleType)type;
                String symbol = singleType.symbol();
                return new $colon$colon<Nothing$>((Nothing$)((Object)this.createEdge(symbol, role)), Nil$.MODULE$);
            }
            if (type instanceof TypeRef) {
                TypeRef typeRef = (TypeRef)type;
                String symbol = typeRef.symbol();
                Seq<Type> typeArguments = typeRef.typeArguments();
                GraphNodeOuterClass.Edge edge = this.createEdge(symbol, role);
                return (Seq)((SeqOps)typeArguments.flatMap((Function1<Type, Seq> & Serializable)x$3 -> this.extractEdgesFromType((Type)x$3, role, parentId))).$plus$colon(edge);
            }
            if (type instanceof ExistentialType) {
                ExistentialType existentialType = (ExistentialType)type;
                Type tpe2 = existentialType.tpe();
                Option<Scope> declarations = existentialType.declarations();
                return (Seq)this.extractEdgesFromType(tpe2, role, parentId).$plus$plus((IterableOnce)declarations.map((Function1<Scope, Seq> & Serializable)scope -> (Seq)scope.symlinks().map((Function1<String, GraphNodeOuterClass.Edge> & Serializable)link -> this.createEdge((String)link, role))).getOrElse((Function0<Seq> & Serializable)() -> (Seq)package$.MODULE$.Seq().empty()));
            }
            if (type instanceof AnnotatedType) {
                AnnotatedType annotatedType = (AnnotatedType)type;
                Seq<Annotation> annotations = annotatedType.annotations();
                Type tpe3 = annotatedType.tpe();
                return (Seq)((IterableOps)((IterableOps)annotations.map((Function1<Annotation, Type> & Serializable)x$4 -> x$4.tpe())).flatMap((Function1<Type, Seq> & Serializable)x$5 -> this.extractEdgesFromType((Type)x$5, role, parentId))).$plus$plus(this.extractEdgesFromType(tpe3, role, parentId));
            }
            if (Type$Empty$.MODULE$.equals(type)) {
                return (Seq)package$.MODULE$.Seq().empty();
            }
            if (type instanceof RepeatedType) {
                Type tpe4;
                RepeatedType repeatedType = (RepeatedType)type;
                _type = tpe4 = repeatedType.tpe();
                continue;
            }
            if (type instanceof StructuralType) {
                StructuralType structuralType = (StructuralType)type;
                Type tpe5 = structuralType.tpe();
                Option<Scope> declarations = structuralType.declarations();
                return (Seq)this.extractEdgesFromType(tpe5, role, parentId).$plus$plus((IterableOnce)declarations.map((Function1<Scope, Seq> & Serializable)scope -> (Seq)scope.symlinks().map((Function1<String, GraphNodeOuterClass.Edge> & Serializable)link -> this.createEdge((String)link, role))).getOrElse((Function0<Seq> & Serializable)() -> (Seq)package$.MODULE$.Seq().empty()));
            }
            if (type instanceof ConstantType) {
                return (Seq)package$.MODULE$.Seq().empty();
            }
            if (type instanceof ThisType) {
                ThisType thisType = (ThisType)type;
                String symbol = thisType.symbol();
                return new $colon$colon<Nothing$>((Nothing$)((Object)this.createEdge(symbol, role)), Nil$.MODULE$);
            }
            if (type instanceof SuperType) {
                SuperType superType = (SuperType)type;
                String symbol = superType.symbol();
                return new $colon$colon<Nothing$>((Nothing$)((Object)this.createEdge(symbol, role)), Nil$.MODULE$);
            }
            if (type instanceof WithType) {
                WithType withType = (WithType)type;
                Seq<Type> types = withType.types();
                return (Seq)types.flatMap((Function1<Type, Seq> & Serializable)x$6 -> this.extractEdgesFromType((Type)x$6, role, parentId));
            }
            if (type instanceof UnionType) {
                UnionType unionType = (UnionType)type;
                Seq<Type> types = unionType.types();
                return (Seq)types.flatMap((Function1<Type, Seq> & Serializable)x$7 -> this.extractEdgesFromType((Type)x$7, role, parentId));
            }
            if (!(type instanceof UniversalType)) break;
            UniversalType universalType = (UniversalType)type;
            _type = tpe = universalType.tpe();
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Not supported type in {} - {}", new Object[]{role, type});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Seq<GraphNodeOuterClass.Edge> createEdges(Seq<String> symlinks, String _type) {
        return (Seq)symlinks.map((Function1<String, GraphNodeOuterClass.Edge> & Serializable)x$8 -> this.createEdgeForDefinition((String)x$8, _type));
    }

    public GraphNodeOuterClass.Edge createEdge(String child, String _type) {
        String childId = this.graphAccumulator.createId(child);
        return ProtoHelper$.MODULE$.createEdge(childId, _type, None$.MODULE$);
    }

    public GraphNodeOuterClass.Edge createEdgeForDefinition(String symbol, String _type) {
        String childId = this.graphAccumulator.createId(symbol);
        return ProtoHelper$.MODULE$.createEdge(childId, _type, this.extractLocation(symbol));
    }

    private Option<GraphNodeOuterClass.Location> extractLocation(String symbol) {
        Option<SymbolOccurrence> occurrence = this.semanticdbHelper.findOccurence(symbol);
        return occurrence.flatMap((Function1<SymbolOccurrence, Option> & Serializable)x$9 -> x$9.range()).map((Function1<Range, GraphNodeOuterClass.Location> & Serializable)r -> ProtoHelper$.MODULE$.createLocation($this.graphAccumulator.uri(), r.startLine(), r.startCharacter(), r.endLine(), r.endCharacter()));
    }

    public SemanticdbGraphExtractor(GraphAccumulator graphAccumulator, SemanticdbHelper semanticdbHelper) {
        this.graphAccumulator = graphAccumulator;
        this.semanticdbHelper = semanticdbHelper;
        this.logger = Logger$.MODULE$.apply(SemanticdbGraphExtractor.class);
    }
}

