/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.common.rdf;

import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilderByVertexId;
import org.vertexium.Element;
import org.vertexium.Metadata;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.Visibility;
import org.vertexium.inmemory.InMemoryGraph;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.property.StreamingPropertyValue;
import org.visallo.common.rdf.RdfExportHelper;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.web.clientapi.model.VisibilityJson;

public class RdfExportHelperTest {
    private InMemoryGraph graph;
    private Authorizations authorizations;
    private RdfExportHelper rdfExportHelper;

    @Before
    public void before() {
        this.graph = InMemoryGraph.create();
        this.authorizations = this.graph.createAuthorizations(new String[]{"A", "B"});
        this.rdfExportHelper = new RdfExportHelper();
    }

    @Test
    public void testExportVertex() throws IOException {
        String warning = "\"Unhandled value type org.vertexium.inmemory.InMemoryStreamingPropertyValue to convert to RDF string\"";
        StreamingPropertyValue raw = new StreamingPropertyValue(IOUtils.toInputStream((String)"abc", (String)"UTF-8"), byte[].class);
        raw.searchIndex(false);
        VertexBuilder v1Builder = this.graph.prepareVertex("v1", new Visibility(""));
        VisalloProperties.VISIBILITY_JSON.setProperty((ElementMutation)v1Builder, (Object)new VisibilityJson(""), new Visibility(""));
        VisalloProperties.CONCEPT_TYPE.setProperty((ElementMutation)v1Builder, (Object)"http://visallo.org#person", new Visibility(""));
        Metadata metadata = new Metadata();
        metadata.add("meta1", (Object)"meta1Value", new Visibility(""));
        VisalloProperties.RAW.setProperty((ElementMutation)v1Builder, (Object)raw, metadata, new Visibility(""));
        v1Builder.addPropertyValue("k1", "http://visallo.org#firstName", (Object)"Joe", metadata, new Visibility(""));
        v1Builder.save(this.authorizations);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        String rdf = this.rdfExportHelper.exportElementToRdfTriple((Element)v1);
        String expected = "# Vertex: v1\n<v1> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://visallo.org#person>\n<v1> <http://visallo.org#conceptType> \"http://visallo.org#person\"\n<v1> <http://visallo.org#firstName:k1> \"Joe\"\n<v1> <http://visallo.org#firstName:k1@meta1> \"meta1Value\"\n# <v1> <http://visallo.org#raw> " + warning + "\n<v1> <http://visallo.org#visibilityJson> \"{\\\"source\\\":\\\"\\\"}\"\n";
        Assert.assertEquals((Object)expected, (Object)rdf);
    }

    @Test
    public void testExportEdge() {
        this.graph.addVertex("v1", new Visibility(""), this.authorizations);
        this.graph.addVertex("v2", new Visibility(""), this.authorizations);
        EdgeBuilderByVertexId e1Builder = this.graph.prepareEdge("e1", "v1", "v2", "http://visallo.org#knows", new Visibility(""));
        VisalloProperties.VISIBILITY_JSON.setProperty((ElementMutation)e1Builder, (Object)new VisibilityJson(""), new Visibility(""));
        VisalloProperties.CONCEPT_TYPE.setProperty((ElementMutation)e1Builder, (Object)"http://visallo.org#person", new Visibility(""));
        Metadata metadata = new Metadata();
        metadata.add("meta1", (Object)"meta1Value", new Visibility(""));
        e1Builder.addPropertyValue("k1", "http://visallo.org#firstName", (Object)"Joe", metadata, new Visibility(""));
        e1Builder.save(this.authorizations);
        this.graph.flush();
        Edge e1 = this.graph.getEdge("e1", this.authorizations);
        String rdf = this.rdfExportHelper.exportElementToRdfTriple((Element)e1);
        String expected = "# Edge: e1\n<v1> <http://visallo.org#knows:e1> <v2>\n<EDGE:e1> <http://visallo.org#conceptType> \"http://visallo.org#person\"\n<EDGE:e1> <http://visallo.org#firstName:k1> \"Joe\"\n<EDGE:e1> <http://visallo.org#firstName:k1@meta1> \"meta1Value\"\n<EDGE:e1> <http://visallo.org#visibilityJson> \"{\\\"source\\\":\\\"\\\"}\"\n";
        Assert.assertEquals((Object)expected, (Object)rdf);
    }
}

