/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.visallo.core.util.ShutdownListener;
import org.visallo.core.util.ShutdownService;

public class ShutdownServiceTest {
    private ShutdownService shutdownService;
    private List<Class> shutdownList;

    @Before
    public void before() {
        this.shutdownService = new ShutdownService();
        this.shutdownList = new ArrayList<Class>();
    }

    @Test
    public void testShutdown() {
        A a = new A();
        B b = new B(a);
        this.shutdownService.register((ShutdownListener)a);
        this.shutdownService.register((ShutdownListener)b);
        this.shutdownService.shutdown();
        Assert.assertEquals((long)2L, (long)this.shutdownList.size());
        Assert.assertEquals(B.class, (Object)this.shutdownList.get(0));
        Assert.assertEquals(A.class, (Object)this.shutdownList.get(1));
    }

    private class B
    implements ShutdownListener {
        private final A a;

        public B(A a) {
            this.a = a;
            ShutdownServiceTest.this.shutdownService.register((ShutdownListener)this);
        }

        public void shutdown() {
            Assert.assertFalse((String)"A should shutdown after B", (boolean)this.a.hasShutdown);
            ShutdownServiceTest.this.shutdownList.add(B.class);
        }
    }

    private class A
    implements ShutdownListener {
        public boolean hasShutdown = false;

        public A() {
            ShutdownServiceTest.this.shutdownService.register((ShutdownListener)this);
        }

        public void shutdown() {
            this.hasShutdown = true;
            ShutdownServiceTest.this.shutdownList.add(A.class);
        }
    }
}

