/*
 * Copyright 2017 Artur Jablonski
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *          http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.voeetech.asyncimapclient.client.builders;

import java.util.List;

/**
 * Created by apfel on 26.01.17.
 */
public class Validator {
    public static void rejectNull(Object obj) {
        if (obj == null)
            throw new IllegalArgumentException("illegal null value");
    }

    public static void rejectNullOrEmpty(String string) {
        rejectNull(string);
        if (string.isEmpty())
            throw new IllegalArgumentException("illegal empty string");
    }

    public static void rejectNullOrEmpty(List<?> list) {
        rejectNull(list);
        if (list.isEmpty())
            throw new IllegalArgumentException("illegal empty list");
    }
}
