/*
 * Decompiled with CFR 0.152.
 */
package io.netty_voltpatches;

import java.lang.reflect.Field;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.AbstractSet;
import java.util.Iterator;

public final class NinjaKeySet
extends AbstractSet<SelectionKey> {
    private SelectionKey[] keys = new SelectionKey[1024];
    private int numKeys;
    public static final boolean supported;

    @Override
    public boolean add(SelectionKey o) {
        if (o == null) {
            return false;
        }
        int size = this.numKeys;
        this.keys[size++] = o;
        this.numKeys = size;
        if (size == this.keys.length) {
            this.doubleCapacity();
        }
        return true;
    }

    public SelectionKey[] keys() {
        return this.keys;
    }

    private void doubleCapacity() {
        SelectionKey[] newKeys = new SelectionKey[this.keys.length << 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.numKeys);
        this.keys = newKeys;
    }

    @Override
    public void clear() {
        for (int ii = 0; ii < this.numKeys; ++ii) {
            this.keys[ii] = null;
        }
        this.numKeys = 0;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    @Override
    public Iterator<SelectionKey> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.numKeys;
    }

    public static NinjaKeySet instrumentSelector(Selector selector) {
        try {
            NinjaKeySet selectedKeySet = new NinjaKeySet();
            if (!supported) {
                return selectedKeySet;
            }
            Class<?> selectorImplClass = Class.forName("sun.nio.ch.SelectorImpl", false, ClassLoader.getSystemClassLoader());
            if (!selectorImplClass.isAssignableFrom(selector.getClass())) {
                return selectedKeySet;
            }
            Field selectedKeysField = selectorImplClass.getDeclaredField("selectedKeys");
            Field publicSelectedKeysField = selectorImplClass.getDeclaredField("publicSelectedKeys");
            selectedKeysField.setAccessible(true);
            publicSelectedKeysField.setAccessible(true);
            selectedKeysField.set(selector, selectedKeySet);
            publicSelectedKeysField.set(selector, selectedKeySet);
            return selectedKeySet;
        }
        catch (Throwable t) {
            return null;
        }
    }

    static {
        boolean supportedTemp = false;
        try (Selector s = Selector.open();){
            Class<?> selectorImplClass = Class.forName("sun.nio.ch.SelectorImpl", false, ClassLoader.getSystemClassLoader());
            if (selectorImplClass.isAssignableFrom(s.getClass())) {
                supportedTemp = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        supported = supportedTemp;
    }
}

