/*
 * Decompiled with CFR 0.152.
 */
package org.json_voltpatches;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.json_voltpatches.JSONArray;
import org.json_voltpatches.JSONException;
import org.json_voltpatches.JSONString;
import org.json_voltpatches.JSONTokener;

public class JSONObject {
    private final Map<String, Object> m_map = new TreeMap<String, Object>();
    public static final Object NULL = new Null();

    public JSONObject() {
    }

    public JSONObject(JSONObject jo, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            try {
                this.putOnce(names[i], jo.opt(names[i]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JSONObject(JSONTokener x) throws JSONException {
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.m_map.put(entry.getKey(), JSONObject.wrap(entry.getValue()));
        }
    }

    public JSONObject(Object bean) {
        this();
        this.populateMap(bean);
    }

    public JSONObject(Object object, String[] names) {
        this();
        Class<?> c = object.getClass();
        for (String name : names) {
            try {
                this.putOpt(name, c.getField(name).get(object));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JSONObject(String source) throws JSONException {
        this(new JSONTokener(source));
    }

    public JSONObject accumulate(String key, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, value instanceof JSONArray ? new JSONArray().put(value) : value);
        } else if (o instanceof JSONArray) {
            ((JSONArray)o).put(value);
        } else {
            this.put(key, new JSONArray().put(o).put(value));
        }
        return this;
    }

    public JSONObject append(String key, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, new JSONArray().put(value));
        } else if (o instanceof JSONArray) {
            this.put(key, ((JSONArray)o).put(value));
        } else {
            throw new JSONException("JSONObject[" + key + "] is not a JSONArray.");
        }
        return this;
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String s = Double.toString(d);
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object get(String key) throws JSONException {
        Object o = this.opt(key);
        if (o == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) throws JSONException {
        Object o = this.get(key);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) throws JSONException {
        Object o = this.get(key);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.valueOf((String)o).doubleValue();
        }
        catch (Exception e) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a number.");
        }
    }

    public int getInt(String key) throws JSONException {
        Object o = this.get(key);
        try {
            return o instanceof Number ? ((Number)o).intValue() : Integer.parseInt((String)o);
        }
        catch (Exception e) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not an int.");
        }
    }

    public JSONArray getJSONArray(String key) throws JSONException {
        Object o = this.get(key);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) throws JSONException {
        Object o = this.get(key);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONObject.");
    }

    public long getLong(String key) throws JSONException {
        Object o = this.get(key);
        try {
            return o instanceof Number ? ((Number)o).longValue() : Long.parseLong((String)o);
        }
        catch (Exception e) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a long.");
        }
    }

    public static String[] getNames(JSONObject jo) {
        int length = jo.length();
        if (length == 0) {
            return null;
        }
        String[] names = jo.m_map.keySet().toArray(new String[length]);
        return names;
    }

    public static String[] getNames(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> klass = object.getClass();
        Field[] fields = klass.getFields();
        int length = fields.length;
        if (length == 0) {
            return null;
        }
        String[] names = new String[length];
        for (int i = 0; i < length; ++i) {
            names[i] = fields[i].getName();
        }
        return names;
    }

    public String getString(String key) throws JSONException {
        return this.get(key).toString();
    }

    public boolean has(String key) {
        return this.m_map.containsKey(key);
    }

    public JSONObject increment(String key) throws JSONException {
        Object value = this.opt(key);
        if (value == null) {
            this.put(key, 1);
        } else if (value instanceof Integer) {
            this.put(key, (Integer)value + 1);
        } else if (value instanceof Long) {
            this.put(key, (Long)value + 1L);
        } else if (value instanceof Double) {
            this.put(key, (Double)value + 1.0);
        } else if (value instanceof Float) {
            this.put(key, ((Float)value).floatValue() + 1.0f);
        } else {
            throw new JSONException("Unable to increment [" + key + "].");
        }
        return this;
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Iterator<String> keys() {
        return this.m_map.keySet().iterator();
    }

    public int length() {
        return this.m_map.size();
    }

    public JSONArray names() {
        JSONArray ja = new JSONArray();
        for (String key : this.m_map.keySet()) {
            ja.put(key);
        }
        return ja.length() == 0 ? null : ja;
    }

    public static String numberToString(Number n) throws JSONException {
        if (n == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(n);
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object opt(String key) {
        return key == null ? null : this.m_map.get(key);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        try {
            Object o = this.opt(key);
            return o instanceof Number ? ((Number)o).doubleValue() : new Double((String)o).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(String key) {
        Object o = this.opt(key);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(String key) {
        Object o = this.opt(key);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        Object o = this.opt(key);
        return o != null ? o.toString() : defaultValue;
    }

    private void populateMap(Object bean) {
        Method[] methods;
        Class<?> klass = bean.getClass();
        boolean includeSuperClass = klass.getClassLoader() != null;
        for (Method method : methods = includeSuperClass ? klass.getMethods() : klass.getDeclaredMethods()) {
            try {
                if (!Modifier.isPublic(method.getModifiers())) continue;
                String name = method.getName();
                String key = "";
                if (name.startsWith("get")) {
                    if (!name.equals("getClass") && !name.equals("getDeclaringClass")) {
                        key = name.substring(3);
                    }
                } else if (name.startsWith("is")) {
                    key = name.substring(2);
                }
                if (key.length() <= 0 || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key.length() == 1) {
                    key = key.toLowerCase();
                } else if (!Character.isUpperCase(key.charAt(1))) {
                    key = key.substring(0, 1).toLowerCase() + key.substring(1);
                }
                Object result = method.invoke(bean, (Object[])null);
                this.m_map.put(key, JSONObject.wrap(result));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JSONObject put(String key, boolean value) throws JSONException {
        if (key == null) {
            throw new JSONException("Null key.");
        }
        this.m_map.put(key, value);
        return this;
    }

    public JSONObject put(String key, Collection<?> value) throws JSONException {
        this.put(key, new JSONArray(value));
        return this;
    }

    public JSONObject put(String key, double value) throws JSONException {
        this.put(key, new Double(value));
        return this;
    }

    public JSONObject put(String key, int value) throws JSONException {
        this.put(key, new Integer(value));
        return this;
    }

    public JSONObject put(String key, long value) throws JSONException {
        this.put(key, new Long(value));
        return this;
    }

    public JSONObject put(String key, Map<String, Object> value) throws JSONException {
        this.put(key, new JSONObject(value));
        return this;
    }

    public JSONObject put(String key, Object value) throws JSONException {
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null) {
            JSONObject.testValidity(value);
            this.m_map.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject putOnce(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            if (this.opt(key) != null) {
                throw new JSONException("Duplicate key \"" + key + "\"");
            }
            this.put(key, value);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    public static String quotable(String string) {
        int i;
        if (string == null) {
            return "";
        }
        char prior = '\u0000';
        char current = '\u0000';
        int len = string.length();
        block12: for (i = 0; i < len; ++i) {
            prior = current;
            current = string.charAt(i);
            if (current < ' ' || current >= '\u0080' && current < '\u00a0' || current >= '\u2000' && current < '\u2100') break;
            if (current == '/') {
                if (prior != '<') continue;
                break;
            }
            switch (current) {
                default: {
                    continue block12;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\"': 
                case '\\': {
                    break block12;
                }
            }
        }
        if (i == len) {
            return string;
        }
        StringBuilder sb = new StringBuilder(len + 2);
        if (i > 0) {
            sb.append(string.substring(0, i));
        }
        current = prior;
        while (i < len) {
            prior = current;
            current = string.charAt(i);
            switch (current) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(current);
                    break;
                }
                case '/': {
                    if (prior == '<') {
                        sb.append('\\');
                    }
                    sb.append(current);
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                default: {
                    if (current < ' ' || current >= '\u0080' && current < '\u00a0' || current >= '\u2000' && current < '\u2100') {
                        String t = "000" + Integer.toHexString(current);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        break;
                    }
                    sb.append(current);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String quote(String string) {
        return "\"" + JSONObject.quotable(string) + "\"";
    }

    public Object remove(String key) {
        return this.m_map.remove(key);
    }

    public Set<String> sortedKeySet() {
        return new TreeSet<String>(this.m_map.keySet());
    }

    public Iterator<String> sortedKeys() {
        return this.sortedKeySet().iterator();
    }

    public static Object stringToValue(String s) {
        if (s.equals("")) {
            return s;
        }
        if (s.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (s.equalsIgnoreCase("null")) {
            return NULL;
        }
        char b = s.charAt(0);
        if (b >= '0' && b <= '9' || b == '.' || b == '-' || b == '+') {
            if (b == '0' && s.length() > 2 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                try {
                    return new Integer(Integer.parseInt(s.substring(2), 16));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (s.indexOf(46) > -1 || s.indexOf(101) > -1 || s.indexOf(69) > -1) {
                    return Double.valueOf(s);
                }
                Long myLong = new Long(s);
                if (myLong == (long)myLong.intValue()) {
                    return new Integer(myLong.intValue());
                }
                return myLong;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    static void testValidity(Object o) throws JSONException {
        if (o != null && (o instanceof Double ? ((Double)o).isInfinite() || ((Double)o).isNaN() : o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    public JSONArray toJSONArray(JSONArray names) throws JSONException {
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        try {
            if (this.m_map.isEmpty()) {
                return "{}";
            }
            StringBuffer sb = new StringBuffer();
            String keyprefix = "{\"";
            for (Map.Entry<String, Object> entry : this.m_map.entrySet()) {
                sb.append(keyprefix);
                sb.append(JSONObject.quotable(entry.getKey()));
                sb.append("\":");
                sb.append(JSONObject.valueToString(entry.getValue()));
                keyprefix = ",\"";
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) throws JSONException {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) throws JSONException {
        int n = this.length();
        if (n == 0) {
            return "{}";
        }
        Set<Map.Entry<String, Object>> entries = this.m_map.entrySet();
        if (n == 1) {
            Map.Entry<String, Object> entry = entries.iterator().next();
            return "{\"" + entry.getKey() + "\": " + JSONObject.valueToString(entry.getValue(), indentFactor, indent) + "}";
        }
        StringBuffer sb = new StringBuffer();
        int newindent = indent + indentFactor;
        String keyprefix = "{\n";
        for (String key : this.sortedKeySet()) {
            sb.append(keyprefix);
            for (int j = 0; j < newindent; ++j) {
                sb.append(' ');
            }
            sb.append('\"');
            sb.append(JSONObject.quotable(key));
            sb.append("\": ");
            sb.append(JSONObject.valueToString(this.m_map.get(key), indentFactor, newindent));
            keyprefix = ",\n";
        }
        sb.append('\n');
        for (int j = 0; j < indent; ++j) {
            sb.append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    static String valueToString(Object value) throws JSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof JSONString) {
            try {
                String asString = ((JSONString)value).toJSONString();
                if (asString == null) {
                    throw new JSONException("Unexpected null from toJSONString");
                }
                return asString;
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value).toString();
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection)value).toString();
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString();
        }
        return JSONObject.quote(value.toString());
    }

    static String valueToString(Object value, int indentFactor, int indent) throws JSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        try {
            String o;
            if (value instanceof JSONString && (o = ((JSONString)value).toJSONString()) instanceof String) {
                return o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONObject) {
            return ((JSONObject)value).toString(indentFactor, indent);
        }
        if (value instanceof JSONArray) {
            return ((JSONArray)value).toString(indentFactor, indent);
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value).toString(indentFactor, indent);
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection)value).toString(indentFactor, indent);
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString(indentFactor, indent);
        }
        return JSONObject.quote(value.toString());
    }

    static Object wrap(Object object) {
        try {
            if (object == null) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof JSONString || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String) {
                return object;
            }
            if (object instanceof Collection) {
                return new JSONArray((Collection)object);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                return new JSONObject((Map)object);
            }
            String checkPrefix = object.getClass().getName();
            if (checkPrefix.lastIndexOf(46) == -1) {
                checkPrefix = "";
            }
            if (checkPrefix.startsWith("java.") || checkPrefix.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            return new JSONObject(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Writer write(Writer writer) throws JSONException {
        try {
            if (this.m_map.isEmpty()) {
                writer.write("{}");
                return writer;
            }
            String keyprefix = "{\"";
            for (Map.Entry<String, Object> entry : this.m_map.entrySet()) {
                writer.write(keyprefix);
                writer.write(JSONObject.quotable(entry.getKey()));
                writer.write("\":");
                Object v = entry.getValue();
                if (v instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(v));
                }
                keyprefix = ",\"";
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

