/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.logging;

import com.google_voltpatches.common.base.Throwables;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.voltcore.logging.Level;
import org.voltcore.logging.VoltNullLogger;
import org.voltcore.logging.VoltUtilLoggingLogger;
import org.voltcore.utils.EstTime;
import org.voltcore.utils.RateLimitedLogger;

public class VoltLogger {
    final CoreVoltLogger m_logger;
    private static final String ASYNCH_LOGGER_THREAD_NAME = "Async Logger";
    private static ExecutorService m_asynchLoggerPool;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized void shutdownAsynchronousLogging() {
        if (m_asynchLoggerPool != null) {
            try {
                m_asynchLoggerPool.submit(new Runnable(){

                    @Override
                    public void run() {
                    }
                }).get();
            }
            catch (Exception e) {
                Throwables.getRootCause(e).printStackTrace();
            }
            m_asynchLoggerPool.shutdown();
            try {
                m_asynchLoggerPool.awaitTermination(365L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unable to shutdown VoltLogger", e);
            }
            m_asynchLoggerPool = null;
        }
    }

    public static synchronized void startAsynchronousLogging() {
        if ("true".equals(System.getProperty("voltdb_no_logging"))) {
            return;
        }
        if (m_asynchLoggerPool == null && !Boolean.getBoolean("DISABLE_ASYNC_LOGGING")) {
            m_asynchLoggerPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new LoggerThreadFactory());
            try {
                m_asynchLoggerPool.submit(new Runnable(){

                    @Override
                    public void run() {
                    }
                }).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Unable to prime asynchronous logging", e);
            }
        }
    }

    private void submit(Level level, Object message, Throwable t) {
        if (!this.m_logger.isEnabledFor(level)) {
            return;
        }
        if (m_asynchLoggerPool == null) {
            this.m_logger.log(level, message, t);
            return;
        }
        Runnable runnableLoggingTask = this.createRunnableLoggingTask(level, message, t);
        try {
            m_asynchLoggerPool.submit(runnableLoggingTask).get();
        }
        catch (Exception e) {
            Throwables.propagate(e);
        }
    }

    private void execute(Level level, Object message, Throwable t) {
        if (!this.m_logger.isEnabledFor(level)) {
            return;
        }
        if (m_asynchLoggerPool == null) {
            this.m_logger.log(level, message, t);
            return;
        }
        Runnable runnableLoggingTask = this.createRunnableLoggingTask(level, message, t);
        try {
            m_asynchLoggerPool.execute(runnableLoggingTask);
        }
        catch (RejectedExecutionException e) {
            this.m_logger.log(Level.DEBUG, "Failed to execute logging task. Running in-line", e);
            runnableLoggingTask.run();
        }
    }

    private Runnable createRunnableLoggingTask(final Level level, final Object message, final Throwable t) {
        final String callerThreadName = Thread.currentThread().getName();
        Runnable runnableLoggingTask = new Runnable(){

            @Override
            public void run() {
                Thread loggerThread = Thread.currentThread();
                loggerThread.setName(callerThreadName);
                try {
                    VoltLogger.this.m_logger.log(level, message, t);
                }
                catch (Throwable t2) {
                    System.err.println("Exception thrown in logging thread for " + callerThreadName + ":" + t2);
                }
                finally {
                    loggerThread.setName(VoltLogger.ASYNCH_LOGGER_THREAD_NAME);
                }
            }
        };
        return runnableLoggingTask;
    }

    private void submitl7d(Level level, String key, Object[] params, Throwable t) {
        if (!this.m_logger.isEnabledFor(level)) {
            return;
        }
        if (m_asynchLoggerPool == null) {
            this.m_logger.l7dlog(level, key, params, t);
            return;
        }
        Runnable runnableLoggingTask = this.createRunnableL7dLoggingTask(level, key, params, t);
        switch (level) {
            case INFO: 
            case WARN: 
            case DEBUG: 
            case TRACE: {
                m_asynchLoggerPool.execute(runnableLoggingTask);
                break;
            }
            case FATAL: 
            case ERROR: {
                try {
                    m_asynchLoggerPool.submit(runnableLoggingTask).get();
                }
                catch (Exception e) {
                    Throwables.propagate(e);
                }
                break;
            }
            default: {
                throw new AssertionError((Object)("Unrecognized level " + (Object)((Object)level)));
            }
        }
    }

    private Runnable createRunnableL7dLoggingTask(final Level level, final String key, final Object[] params, final Throwable t) {
        final String callerThreadName = Thread.currentThread().getName();
        Runnable runnableLoggingTask = new Runnable(){

            @Override
            public void run() {
                Thread loggerThread = Thread.currentThread();
                loggerThread.setName(callerThreadName);
                try {
                    VoltLogger.this.m_logger.l7dlog(level, key, params, t);
                }
                catch (Throwable t2) {
                    System.err.println("Exception thrown in logging thread for " + callerThreadName + ":" + t2);
                }
                finally {
                    loggerThread.setName(VoltLogger.ASYNCH_LOGGER_THREAD_NAME);
                }
            }
        };
        return runnableLoggingTask;
    }

    public void debug(Object message) {
        this.execute(Level.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.execute(Level.DEBUG, message, t);
    }

    public boolean isDebugEnabled() {
        return this.m_logger.isEnabledFor(Level.DEBUG);
    }

    public void error(Object message) {
        this.submit(Level.ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.submit(Level.ERROR, message, t);
    }

    public void fatal(Object message) {
        this.submit(Level.FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.submit(Level.FATAL, message, t);
    }

    public void info(Object message) {
        this.execute(Level.INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.execute(Level.INFO, message, t);
    }

    public boolean isInfoEnabled() {
        return this.m_logger.isEnabledFor(Level.INFO);
    }

    public void trace(Object message) {
        this.execute(Level.TRACE, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.execute(Level.TRACE, message, t);
    }

    public boolean isTraceEnabled() {
        return this.m_logger.isEnabledFor(Level.TRACE);
    }

    public void warn(Object message) {
        this.execute(Level.WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.execute(Level.WARN, message, t);
    }

    public void l7dlog(Level level, String key, Throwable t) {
        this.submitl7d(level, key, null, t);
    }

    public void l7dlog(Level level, String key, Object[] params, Throwable t) {
        this.submitl7d(level, key, params, t);
    }

    public void log(Level level, Object message, Throwable t) {
        switch (level) {
            case INFO: 
            case WARN: 
            case DEBUG: 
            case TRACE: {
                this.execute(level, message, t);
                break;
            }
            case FATAL: 
            case ERROR: {
                this.submit(level, message, t);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unrecognized level " + (Object)((Object)level)));
            }
        }
    }

    public long getLogLevels(VoltLogger[] loggers) {
        return this.m_logger.getLogLevels(loggers);
    }

    public void setLevel(Level level) {
        this.m_logger.setLevel(level);
    }

    public static void configure(String xmlConfig, File voltroot) {
        try {
            Class<?> loggerClz = Class.forName("org.voltcore.logging.VoltLog4jLogger");
            if (!$assertionsDisabled && loggerClz == null) {
                throw new AssertionError();
            }
            Method configureMethod = loggerClz.getMethod("configure", String.class, File.class);
            configureMethod.invoke(null, xmlConfig, voltroot);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public VoltLogger(String classname) {
        if ("true".equals(System.getProperty("voltdb_no_logging"))) {
            this.m_logger = new VoltNullLogger.CoreNullLogger();
            return;
        }
        CoreVoltLogger tempLogger = null;
        try {
            Class<?> loggerClz = Class.forName("org.voltcore.logging.VoltLog4jLogger");
            if (!$assertionsDisabled && loggerClz == null) {
                throw new AssertionError();
            }
            Constructor<?> constructor = loggerClz.getConstructor(String.class);
            tempLogger = (CoreVoltLogger)constructor.newInstance(classname);
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        if (tempLogger == null) {
            tempLogger = new VoltUtilLoggingLogger(classname);
        }
        this.m_logger = tempLogger;
    }

    protected VoltLogger(CoreVoltLogger logger) {
        if (!$assertionsDisabled && logger == null) {
            throw new AssertionError();
        }
        this.m_logger = logger;
    }

    public void rateLimitedLog(long suppressInterval, Level level, Throwable cause, String format, Object ... args) {
        RateLimitedLogger.tryLogForMessage(EstTime.currentTimeMillis(), suppressInterval, TimeUnit.SECONDS, this, level, cause, format, args);
    }

    static {
        boolean bl = $assertionsDisabled = !VoltLogger.class.desiredAssertionStatus();
        m_asynchLoggerPool = Boolean.getBoolean("DISABLE_ASYNC_LOGGING") ? null : ("true".equals(System.getProperty("voltdb_no_logging")) ? null : new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new LoggerThreadFactory()));
    }

    static interface CoreVoltLogger {
        public boolean isEnabledFor(Level var1);

        public void log(Level var1, Object var2, Throwable var3);

        public void l7dlog(Level var1, String var2, Object[] var3, Throwable var4);

        public long getLogLevels(VoltLogger[] var1);

        public void setLevel(Level var1);
    }

    private static class LoggerThreadFactory
    implements ThreadFactory {
        private static final int SMALL_STACK_SIZE = 262144;

        private LoggerThreadFactory() {
        }

        @Override
        public synchronized Thread newThread(Runnable runnable) {
            Thread t = new Thread(null, runnable, VoltLogger.ASYNCH_LOGGER_THREAD_NAME, 262144L);
            t.setDaemon(true);
            return t;
        }
    }
}

