/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import org.voltcore.logging.Level;
import org.voltcore.logging.VoltLogger;
import org.voltcore.network.NetworkDBBPool;
import org.voltcore.utils.DBBPool;
import org.voltcore.utils.DeferredSerialization;
import org.voltcore.utils.RateLimitedLogger;

public abstract class NIOWriteStreamBase {
    protected static final VoltLogger networkLog = new VoltLogger("NETWORK");
    protected boolean m_isShutdown = false;
    protected DBBPool.BBContainer m_currentWriteBuffer = null;
    protected final ArrayDeque<DBBPool.BBContainer> m_queuedBuffers = new ArrayDeque();
    protected long m_bytesWritten = 0L;
    protected long m_messagesWritten = 0L;
    private long m_lastBytesWritten = 0L;
    private long m_lastMessagesWritten = 0L;
    private static final boolean ASSERT_ON;

    long[] getBytesAndMessagesWritten(boolean interval) {
        if (interval) {
            long bytesWrittenThisTime = this.m_bytesWritten - this.m_lastBytesWritten;
            this.m_lastBytesWritten = this.m_bytesWritten;
            long messagesWrittenThisTime = this.m_messagesWritten - this.m_lastMessagesWritten;
            this.m_lastMessagesWritten = this.m_messagesWritten;
            return new long[]{bytesWrittenThisTime, messagesWrittenThisTime};
        }
        return new long[]{this.m_bytesWritten, this.m_messagesWritten};
    }

    public int getOutstandingMessageCount() {
        return this.m_queuedBuffers.size();
    }

    public boolean isEmpty() {
        return this.m_queuedBuffers.isEmpty() && this.m_currentWriteBuffer == null;
    }

    abstract int drainTo(GatheringByteChannel var1) throws IOException;

    protected abstract Deque<DeferredSerialization> getQueuedWrites();

    int serializeQueuedWrites(NetworkDBBPool pool) throws IOException {
        int processedWrites = 0;
        Deque<DeferredSerialization> oldlist = this.getQueuedWrites();
        if (oldlist.isEmpty()) {
            return 0;
        }
        DeferredSerialization ds = null;
        int bytesQueued = 0;
        while ((ds = oldlist.poll()) != null) {
            ++processedWrites;
            int serializedSize = ds.getSerializedSize();
            if (serializedSize == -1) continue;
            DBBPool.BBContainer outCont = this.m_queuedBuffers.peekLast();
            ByteBuffer outbuf = null;
            if (outCont == null || !outCont.b().hasRemaining()) {
                outCont = pool.acquire();
                outCont.b().clear();
                this.m_queuedBuffers.offer(outCont);
            }
            if ((outbuf = outCont.b()).remaining() >= serializedSize) {
                int oldLimit = outbuf.limit();
                outbuf.limit(outbuf.position() + serializedSize);
                ByteBuffer slice = outbuf.slice();
                ds.serialize(slice);
                NIOWriteStreamBase.checkSloppySerialization(slice, ds);
                slice.position(0);
                bytesQueued += slice.remaining();
                outbuf.position(outbuf.limit());
                outbuf.limit(oldLimit);
                continue;
            }
            ByteBuffer buf = ByteBuffer.allocate(serializedSize);
            ds.serialize(buf);
            NIOWriteStreamBase.checkSloppySerialization(buf, ds);
            buf.position(0);
            bytesQueued += buf.remaining();
            while (buf.hasRemaining()) {
                if (!outbuf.hasRemaining()) {
                    outCont = pool.acquire();
                    outbuf = outCont.b();
                    outbuf.clear();
                    this.m_queuedBuffers.offer(outCont);
                }
                if (outbuf.remaining() >= buf.remaining()) {
                    outbuf.put(buf);
                    continue;
                }
                int oldLimit = buf.limit();
                buf.limit(buf.position() + outbuf.remaining());
                outbuf.put(buf);
                buf.limit(oldLimit);
            }
        }
        this.updateQueued(bytesQueued, true);
        return processedWrites;
    }

    protected static void checkSloppySerialization(ByteBuffer buf, DeferredSerialization ds) {
        if (buf.limit() != buf.capacity()) {
            if (ASSERT_ON) {
                networkLog.fatal("Sloppy serialization size for message class " + ds);
                System.exit(-1);
            }
            RateLimitedLogger.tryLogForMessage(System.currentTimeMillis(), 1L, TimeUnit.HOURS, networkLog, Level.WARN, "Sloppy serialization size for message class %s", ds);
        }
    }

    void shutdown() {
        int bytesReleased = 0;
        this.m_isShutdown = true;
        DBBPool.BBContainer c = null;
        if (this.m_currentWriteBuffer != null) {
            bytesReleased += this.m_currentWriteBuffer.b().remaining();
            this.m_currentWriteBuffer.discard();
        }
        while ((c = this.m_queuedBuffers.poll()) != null) {
            c.b().flip();
            bytesReleased += c.b().remaining();
            c.discard();
        }
        this.updateQueued(-bytesReleased, false);
    }

    protected abstract void updateQueued(int var1, boolean var2);

    static {
        boolean assertOn = false;
        if (!$assertionsDisabled) {
            assertOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERT_ON = assertOn;
    }
}

