/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.voltcore.utils.DBBPool;

public class NetworkDBBPool {
    private static final int LIMIT = Integer.getInteger("NETWORK_DBB_LIMIT", 512);
    private static final int SIZE = Integer.getInteger("NETWORK_DBB_SIZE", 32768);
    private final Queue<DBBPool.BBContainer> m_buffers;
    private final int m_allocationSize;

    public NetworkDBBPool(int numBuffers) {
        this(numBuffers, SIZE);
    }

    NetworkDBBPool(int numBuffers, int allocSize) {
        this.m_buffers = new ArrayBlockingQueue<DBBPool.BBContainer>(numBuffers);
        this.m_allocationSize = allocSize;
    }

    public NetworkDBBPool() {
        this(LIMIT, SIZE);
    }

    DBBPool.BBContainer acquire() {
        DBBPool.BBContainer cont = this.m_buffers.poll();
        if (cont == null) {
            cont = DBBPool.allocateDirect(this.m_allocationSize);
        }
        return new CachedContainer(cont);
    }

    void clear() {
        DBBPool.BBContainer cont = null;
        while ((cont = this.m_buffers.poll()) != null) {
            cont.discard();
        }
    }

    private final class CachedContainer
    extends DBBPool.BBContainer {
        private final DBBPool.BBContainer m_original;

        CachedContainer(DBBPool.BBContainer container) {
            super(container.b());
            this.m_original = container;
        }

        @Override
        public void discard() {
            this.checkDoubleFree();
            if (!NetworkDBBPool.this.m_buffers.offer(this.m_original)) {
                this.m_original.discard();
            }
        }
    }
}

