/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import com.google_voltpatches.common.base.Function;
import com.google_voltpatches.common.cache.Cache;
import com.google_voltpatches.common.cache.CacheBuilder;
import java.net.InetAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.voltcore.utils.CoreUtils;

public class ReverseDNSCache {
    private static volatile ThreadPoolExecutor m_es = new ThreadPoolExecutor(1, 16, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), CoreUtils.getThreadFactory("Reverse DNS lookups"));
    public static final long DEFAULT_MAX_SUCCESS = 10000L;
    public static final long DEFAULT_MAX_FAILURE = 10000L;
    public static final long DEFAULT_SUCCESS_TIMEOUT = 600L;
    public static final long DEFAULT_FAILURE_TIMEOUT = 3600L;
    public static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private static final Function<InetAddress, String> DNS_RESOLVER = new Function<InetAddress, String>(){

        @Override
        public String apply(InetAddress inetAddress) {
            return inetAddress.getHostName();
        }
    };
    private static final ReverseDNSCache m_instance = new ReverseDNSCache(10000L, 10000L, 600L, 3600L, DEFAULT_TIMEOUT_UNIT);
    private static final String DUMMY = "";
    private final Cache<InetAddress, String> m_successes;
    private final Cache<InetAddress, String> m_failures;

    public static synchronized void start() {
        if (m_es == null) {
            m_es = new ThreadPoolExecutor(1, 16, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), CoreUtils.getThreadFactory("Reverse DNS lookups"));
            try {
                m_es.submit(new Runnable(){

                    @Override
                    public void run() {
                    }
                }).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Unable to prime ReverseDNSCache", e);
            }
        }
    }

    public static synchronized void stop() throws InterruptedException {
        if (m_es != null) {
            m_es.shutdown();
            try {
                m_es.awaitTermination(365L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unable to shutdown ReverseDNSCache", e);
            }
            m_es = null;
        }
    }

    public static void submit(Runnable r) {
        ThreadPoolExecutor es = m_es;
        if (es == null || es.isShutdown()) {
            throw new IllegalStateException("ReverseDNSCache is closed");
        }
        es.submit(r);
    }

    public ReverseDNSCache(Long successEntries, Long failureEntries, Long successTimeout, Long failureTimeout, TimeUnit timeoutUnit) {
        this.m_successes = this.getCache(successEntries, successTimeout, timeoutUnit);
        this.m_failures = this.getCache(failureEntries, failureTimeout, timeoutUnit);
    }

    public Cache<InetAddress, String> getCache(Long entries, Long timeout, TimeUnit timeoutUnit) {
        CacheBuilder<Object, Object> b = CacheBuilder.newBuilder();
        if (entries != null) {
            b.maximumSize(entries);
        }
        if (timeout != null) {
            b.expireAfterWrite(timeout, timeoutUnit);
        }
        return b.build();
    }

    public String getHostnameOrAddress(InetAddress address) {
        String hostname = this.m_successes.getIfPresent(address);
        if (hostname == null) {
            hostname = this.m_failures.getIfPresent(address);
            if (hostname != null) {
                return address.getHostAddress();
            }
        } else {
            return hostname;
        }
        hostname = DNS_RESOLVER.apply(address);
        if (hostname.equals(address.getHostAddress())) {
            this.m_failures.put(address, DUMMY);
        } else {
            this.m_successes.put(address, hostname);
        }
        return hostname;
    }

    public static String hostnameOrAddress(InetAddress address) {
        return m_instance.getHostnameOrAddress(address);
    }
}

