/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import com.google_voltpatches.common.util.concurrent.ListenableFuture;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.IllegalReferenceCountException;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.voltcore.logging.VoltLogger;
import org.voltcore.network.CipherExecutor;
import org.voltcore.network.Connection;
import org.voltcore.network.InputHandler;
import org.voltcore.network.NIOReadStream;
import org.voltcore.network.NetworkDBBPool;
import org.voltcore.network.TLSException;
import org.voltcore.utils.CoreUtils;
import org.voltcore.utils.FlexibleSemaphore;
import org.voltcore.utils.Pair;
import org.voltcore.utils.ssl.SSLBufferDecrypter;

public class TLSDecryptionAdapter {
    public static final int TLS_HEADER_SIZE = 5;
    private static final int MAX_READ = 32768;
    private static final int NOT_AVAILABLE = -1;
    protected static final VoltLogger networkLog = new VoltLogger("NETWORK");
    private final SSLBufferDecrypter m_decrypter;
    private final ConcurrentLinkedDeque<ExecutionException> m_exceptions = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<ByteBuffer> m_decrypted = new ConcurrentLinkedDeque();
    private final FlexibleSemaphore m_inFlight = new FlexibleSemaphore(1);
    private final CipherExecutor m_ce;
    private final DecryptionGateway m_dcryptgw;
    private final Connection m_connection;
    private final InputHandler m_inputHandler;
    private volatile boolean m_isDead;
    private int m_needed = -1;

    public TLSDecryptionAdapter(Connection connection, InputHandler handler, SSLEngine sslEngine, CipherExecutor cipherExecutor) {
        this.m_connection = connection;
        this.m_inputHandler = handler;
        this.m_ce = cipherExecutor;
        this.m_decrypter = new SSLBufferDecrypter(sslEngine);
        this.m_dcryptgw = new DecryptionGateway();
    }

    void die() {
        this.m_isDead = true;
        this.m_dcryptgw.die();
        int waitFor = 1 - this.m_inFlight.availablePermits();
        for (int i = 0; i < waitFor; ++i) {
            try {
                if (!this.m_inFlight.tryAcquire(1L, TimeUnit.SECONDS)) continue;
                this.m_inFlight.release();
            }
            catch (InterruptedException e) {}
            break;
        }
        this.m_inFlight.drainPermits();
        this.m_inFlight.release();
    }

    private boolean isDead() {
        return this.m_isDead;
    }

    public Pair<Integer, Integer> handleInputStreamMessages(boolean doRead, NIOReadStream readStream, SocketChannel fromChannel, NetworkDBBPool toPool) throws IOException {
        int maxRead;
        this.checkForGatewayExceptions();
        int readBytes = 0;
        if (doRead && (maxRead = this.getMaxRead(readStream)) > 0) {
            readBytes = readStream.read(fromChannel, maxRead, toPool);
            if (readBytes == -1) {
                throw new EOFException();
            }
            if (readBytes > 0) {
                ByteBuf frameHeader = Unpooled.wrappedBuffer((byte[])new byte[5]);
                while (readStream.dataAvailable() >= 5) {
                    readStream.peekBytes(frameHeader.array());
                    this.m_needed = frameHeader.getShort(3) + 5;
                    if (readStream.dataAvailable() < this.m_needed) break;
                    this.m_dcryptgw.offer(readStream.getSlice(this.m_needed));
                    this.m_needed = -1;
                }
            }
        }
        int numMessages = 0;
        ByteBuffer message = null;
        while ((message = this.pollDecryptedQueue()) != null) {
            ++numMessages;
            this.m_inputHandler.handleMessage(message, this.m_connection);
        }
        return new Pair<Integer, Integer>(readBytes, numMessages);
    }

    private final int getMaxRead(NIOReadStream readStream) {
        return this.m_inputHandler.getMaxRead() == 0 ? 0 : (this.m_needed == -1 ? 32768 : (readStream.dataAvailable() > this.m_needed ? 0 : this.m_needed - readStream.dataAvailable()));
    }

    ByteBuffer pollDecryptedQueue() {
        return this.m_decrypted.poll();
    }

    void releaseDecryptedBuffer() {
        this.m_dcryptgw.releaseDecryptedBuffer();
    }

    void checkForGatewayExceptions() throws IOException {
        ExecutionException ee = this.m_exceptions.poll();
        if (ee != null) {
            IOException ioe = TLSException.ioCause(ee.getCause());
            if (ioe == null) {
                ioe = new IOException("decrypt task failed", ee.getCause());
            }
            throw ioe;
        }
    }

    void waitForPendingDecrypts() throws IOException {
        boolean acquired;
        do {
            int waitFor;
            acquired = (waitFor = 1 - this.m_inFlight.availablePermits()) == 0;
            for (int i = 0; i < waitFor && !acquired; ++i) {
                this.checkForGatewayExceptions();
                try {
                    acquired = this.m_inFlight.tryAcquire(1L, TimeUnit.SECONDS);
                    if (!acquired) continue;
                    this.m_inFlight.release();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new IOException("interrupted while waiting for pending decrypts", e);
                }
            }
        } while (!acquired);
    }

    String dumpState() {
        return new StringBuilder(256).append("TLSPortAdapter[").append("gateway=").append(this.m_dcryptgw.dumpState()).append(", decrypted.isEmpty()= ").append(this.m_decrypted.isEmpty()).append(", exceptions.isEmpty()= ").append(this.m_exceptions.isEmpty()).append(", inFlight=").append(this.m_inFlight.availablePermits()).append("]").toString();
    }

    static class BadMessageLength
    extends IOException {
        private static final long serialVersionUID = 8547352379044459911L;

        public BadMessageLength(String string) {
            super(string);
        }
    }

    class DecryptionGateway
    implements Runnable {
        private final byte[] m_overlap;
        private final ConcurrentLinkedDeque<NIOReadStream.Slice> m_q;
        private final CompositeByteBuf m_msgbb;

        DecryptionGateway() {
            this.m_overlap = new byte[TLSDecryptionAdapter.this.m_decrypter.getPacketBufferSize()];
            this.m_q = new ConcurrentLinkedDeque();
            this.m_msgbb = Unpooled.compositeBuffer();
        }

        synchronized void offer(NIOReadStream.Slice slice) {
            if (TLSDecryptionAdapter.this.isDead()) {
                slice.markConsumed().discard();
                return;
            }
            boolean wasEmpty = this.m_q.isEmpty();
            this.m_q.offer(slice);
            if (wasEmpty) {
                this.submitSelf();
            }
            TLSDecryptionAdapter.this.m_inFlight.reducePermits(1);
        }

        synchronized void die() {
            NIOReadStream.Slice slice = null;
            while ((slice = this.m_q.poll()) != null) {
                slice.markConsumed().discard();
            }
            this.releaseDecryptedBuffer();
        }

        synchronized boolean isEmpty() {
            return this.m_q.isEmpty();
        }

        String dumpState() {
            return new StringBuilder(256).append("DecryptionGateway[isEmpty()=").append(this.isEmpty()).append(", isDead()=").append(TLSDecryptionAdapter.this.isDead()).append(", msgbb=").append(this.m_msgbb).append("]").toString();
        }

        void releaseDecryptedBuffer() {
            if (this.m_msgbb.refCnt() > 0) {
                try {
                    this.m_msgbb.release();
                }
                catch (IllegalReferenceCountException illegalReferenceCountException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ByteBuf dest;
            NIOReadStream.Slice slice = this.m_q.peek();
            if (slice == null) {
                return;
            }
            ByteBuf src = slice.bb;
            if (TLSDecryptionAdapter.this.isDead()) {
                DecryptionGateway decryptionGateway = this;
                synchronized (decryptionGateway) {
                    slice.markConsumed().discard();
                    this.m_q.poll();
                    this.releaseDecryptedBuffer();
                    return;
                }
            }
            ByteBuffer[] slicebbarr = slice.bb.nioBuffers();
            if (slicebbarr.length > 1) {
                src = Unpooled.wrappedBuffer((byte[])this.m_overlap).clear();
                slice.bb.readBytes(src, slice.bb.readableBytes());
                slicebbarr[0] = src.nioBuffer();
            }
            int srcBBLength = slicebbarr[0].remaining();
            try {
                dest = TLSDecryptionAdapter.this.m_decrypter.tlsunwrap(slicebbarr[0], TLSDecryptionAdapter.this.m_ce.allocator());
            }
            catch (TLSException e) {
                TLSDecryptionAdapter.this.m_inFlight.release();
                TLSDecryptionAdapter.this.m_exceptions.offer(new ExecutionException("fragment decrypt task failed", e));
                networkLog.error("fragment decrypt task failed", e);
                networkLog.error("isDead()=" + TLSDecryptionAdapter.this.isDead() + ", Src buffer original length: " + srcBBLength + ", Length after decrypt operation: " + slicebbarr[0].remaining());
                TLSDecryptionAdapter.this.m_connection.enableWriteSelection();
                return;
            }
            assert (!slicebbarr[0].hasRemaining()) : "decrypter did not wholly consume the source buffer";
            if (!TLSDecryptionAdapter.this.isDead()) {
                if (dest.isReadable()) {
                    this.m_msgbb.addComponent(true, dest);
                } else {
                    dest.release();
                }
                int read = 0;
                while (this.m_msgbb.readableBytes() >= this.getNeededBytes()) {
                    ByteBuffer bb;
                    block22: {
                        bb = null;
                        try {
                            bb = TLSDecryptionAdapter.this.m_inputHandler.retrieveNextMessage(this.m_msgbb);
                            if (bb == null) {
                            }
                            break block22;
                        }
                        catch (IOException e) {
                            TLSDecryptionAdapter.this.m_inFlight.release();
                            this.m_msgbb.release();
                            TLSDecryptionAdapter.this.m_exceptions.offer(new ExecutionException("failed message length check", e));
                            networkLog.error("failed message length check", e);
                            TLSDecryptionAdapter.this.m_connection.enableWriteSelection();
                        }
                        continue;
                    }
                    TLSDecryptionAdapter.this.m_decrypted.offer((ByteBuffer)bb.flip());
                    ++read;
                }
                if (read > 0) {
                    this.m_msgbb.discardReadComponents();
                    TLSDecryptionAdapter.this.m_connection.enableWriteSelection();
                }
            } else {
                dest.release();
                this.releaseDecryptedBuffer();
            }
            DecryptionGateway decryptionGateway = this;
            synchronized (decryptionGateway) {
                this.m_q.poll();
                slice.markConsumed().discard();
                TLSDecryptionAdapter.this.m_inFlight.release();
                if (this.m_q.peek() != null) {
                    this.submitSelf();
                }
            }
        }

        void submitSelf() {
            ListenableFuture<?> fut = TLSDecryptionAdapter.this.m_ce.submit(this);
            fut.addListener(new ExceptionListener(fut), CoreUtils.LISTENINGSAMETHREADEXECUTOR);
        }

        private int getNeededBytes() {
            int nextLength = TLSDecryptionAdapter.this.m_inputHandler.getNextMessageLength();
            return nextLength == 0 ? 4 : nextLength;
        }
    }

    class ExceptionListener
    implements Runnable {
        private final ListenableFuture<?> m_fut;

        private ExceptionListener(ListenableFuture<?> fut) {
            this.m_fut = fut;
        }

        @Override
        public void run() {
            if (TLSDecryptionAdapter.this.isDead()) {
                return;
            }
            try {
                this.m_fut.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                TLSDecryptionAdapter.this.m_inFlight.release();
                networkLog.error("unexpect fault occurred in decrypt task", e.getCause());
                TLSDecryptionAdapter.this.m_exceptions.offer(e);
            }
        }
    }
}

