/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import com.google_voltpatches.common.util.concurrent.ListenableFuture;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.GatheringByteChannel;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.voltcore.logging.VoltLogger;
import org.voltcore.network.CipherExecutor;
import org.voltcore.network.Connection;
import org.voltcore.network.NIOWriteStreamBase;
import org.voltcore.network.TLSException;
import org.voltcore.utils.CoreUtils;
import org.voltcore.utils.DeferredSerialization;
import org.voltcore.utils.FlexibleSemaphore;
import org.voltcore.utils.Pair;
import org.voltcore.utils.ssl.SSLBufferEncrypter;

public class TLSEncryptionAdapter {
    private static final VoltLogger s_networkLog = new VoltLogger("NETWORK");
    private final ConcurrentLinkedDeque<ExecutionException> m_exceptions = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<EncryptedMessages> m_encryptedQueue = new ConcurrentLinkedDeque();
    private EncryptedMessages m_inflightMessages;
    private final FlexibleSemaphore m_inFlight = new FlexibleSemaphore(1);
    private final Connection m_connection;
    private final CipherExecutor m_ce;
    private final SSLEngine m_sslEngine;
    private final SSLBufferEncrypter m_encrypter;
    private final EncryptionGateway m_ecryptgw = new EncryptionGateway();
    private volatile boolean m_isShutdown;

    public TLSEncryptionAdapter(Connection connection, SSLEngine engine, CipherExecutor cipherExecutor) {
        this.m_connection = connection;
        this.m_sslEngine = engine;
        this.m_ce = cipherExecutor;
        this.m_encrypter = new SSLBufferEncrypter(engine);
    }

    public int applicationBufferSize() {
        return this.m_sslEngine.getSession().getApplicationBufferSize();
    }

    public int packetBufferSize() {
        return this.m_sslEngine.getSession().getPacketBufferSize();
    }

    public Pair<Integer, Integer> encryptBuffers(Deque<DeferredSerialization> buffersToEncrypt, int frameMax) throws IOException {
        ByteBuf accum = this.m_ce.allocator().buffer(frameMax).clear();
        int processedWrites = 0;
        DeferredSerialization ds = null;
        int bytesQueued = 0;
        int frameMsgs = 0;
        while ((ds = buffersToEncrypt.poll()) != null) {
            ByteBuffer jbb;
            ++processedWrites;
            int serializedSize = ds.getSerializedSize();
            if (serializedSize == -1) continue;
            if (serializedSize > frameMax) {
                if (accum.writerIndex() > 0) {
                    this.m_ecryptgw.offer(new SerializedMessages(accum, frameMsgs));
                    frameMsgs = 0;
                    bytesQueued += accum.writerIndex();
                    accum = this.m_ce.allocator().buffer(frameMax).clear();
                }
                ByteBuf big = this.m_ce.allocator().buffer(serializedSize).writerIndex(serializedSize);
                jbb = big.nioBuffer();
                ds.serialize(jbb);
                NIOWriteStreamBase.checkSloppySerialization(jbb, ds);
                bytesQueued += big.writerIndex();
                this.m_ecryptgw.offer(new SerializedMessages(big, 1));
                frameMsgs = 0;
                continue;
            }
            if (accum.writerIndex() + serializedSize > frameMax) {
                this.m_ecryptgw.offer(new SerializedMessages(accum, frameMsgs));
                frameMsgs = 0;
                bytesQueued += accum.writerIndex();
                accum = this.m_ce.allocator().buffer(frameMax).clear();
            }
            ByteBuf packet = accum.slice(accum.writerIndex(), serializedSize);
            jbb = packet.nioBuffer();
            ds.serialize(jbb);
            NIOWriteStreamBase.checkSloppySerialization(jbb, ds);
            accum.writerIndex(accum.writerIndex() + serializedSize);
            ++frameMsgs;
        }
        if (accum.writerIndex() > 0) {
            this.m_ecryptgw.offer(new SerializedMessages(accum, frameMsgs));
            bytesQueued += accum.writerIndex();
        } else {
            accum.release();
        }
        return new Pair<Integer, Integer>(processedWrites, bytesQueued);
    }

    void waitForPendingEncrypts() throws IOException {
        boolean acquired;
        do {
            int waitFor;
            acquired = (waitFor = 1 - this.m_inFlight.availablePermits()) == 0;
            for (int i = 0; i < waitFor && !acquired; ++i) {
                this.checkForGatewayExceptions();
                try {
                    acquired = this.m_inFlight.tryAcquire(1L, TimeUnit.SECONDS);
                    if (!acquired) continue;
                    this.m_inFlight.release();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new IOException("interrupted while waiting for pending encrypts", e);
                }
            }
        } while (!acquired);
    }

    boolean hasOutstandingData() {
        return this.m_inflightMessages != null || !this.m_encryptedQueue.isEmpty();
    }

    public EncryptLedger drainEncryptedMessages(GatheringByteChannel channel) throws IOException {
        this.checkForGatewayExceptions();
        int delta = 0;
        int bytesWritten = 0;
        int messagesWritten = 0;
        while (true) {
            if (this.m_inflightMessages == null) {
                this.m_inflightMessages = this.m_encryptedQueue.poll();
                if (this.m_inflightMessages == null) break;
                delta += this.m_inflightMessages.m_delta;
            }
            bytesWritten = (int)((long)bytesWritten + this.m_inflightMessages.write(channel));
            if (this.m_inflightMessages.m_messages.isReadable()) break;
            messagesWritten += this.m_inflightMessages.m_count;
            this.m_inflightMessages.m_messages.release();
            this.m_inflightMessages = null;
        }
        return new EncryptLedger(delta, bytesWritten, messagesWritten);
    }

    public boolean isEmpty() {
        return this.m_ecryptgw.isEmpty() && this.m_encryptedQueue.isEmpty() && this.m_inflightMessages == null;
    }

    public void checkForGatewayExceptions() throws IOException {
        ExecutionException ee = this.m_exceptions.poll();
        if (ee != null) {
            IOException ioe = TLSException.ioCause(ee.getCause());
            if (ioe == null) {
                ioe = new IOException("encrypt task failed", ee.getCause());
            }
            throw ioe;
        }
    }

    String dumpState() {
        return new StringBuilder(256).append("TLSEncryptionAdapter[").append("isEmpty()=").append(this.isEmpty()).append(", exceptions.isEmpty()=").append(this.m_exceptions.isEmpty()).append(", encryptedFrames.isEmpty()=").append(this.m_encryptedQueue.isEmpty()).append(", m_inflightMessages.readableBytes()=").append(this.m_inflightMessages == null ? 0 : this.m_inflightMessages.m_messages.readableBytes()).append(", gateway=").append(this.m_ecryptgw.dumpState()).append(", inFlight=").append(this.m_inFlight.availablePermits()).append("]").toString();
    }

    public int getOutstandingMessageCount() {
        return this.m_encryptedQueue.size() + (this.m_inflightMessages == null ? 0 : this.m_inflightMessages.m_count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        if (this.m_isShutdown) {
            return;
        }
        this.m_isShutdown = true;
        try {
            int waitFor = 1 - Math.min(this.m_inFlight.availablePermits(), -4);
            for (int i = 0; i < waitFor; ++i) {
                try {
                    if (!this.m_inFlight.tryAcquire(1L, TimeUnit.SECONDS)) continue;
                    this.m_inFlight.release();
                }
                catch (InterruptedException e) {}
                break;
            }
            this.m_ecryptgw.die();
            EncryptedMessages messages = null;
            while ((messages = this.m_encryptedQueue.poll()) != null) {
                messages.m_messages.release();
            }
            if (this.m_inflightMessages != null) {
                assert (this.m_inflightMessages.m_messages != null && this.m_inflightMessages.m_messages.refCnt() > 0);
                this.m_inflightMessages.m_messages.release();
            }
        }
        finally {
            this.m_inFlight.drainPermits();
            this.m_inFlight.release();
        }
    }

    private static final class EncryptedMessages
    extends SerializedMessages {
        final int m_delta;

        EncryptedMessages(ByteBuf messages, int count, int clearTextSize) {
            super(messages, count);
            this.m_delta = this.m_messages.readableBytes() - clearTextSize;
        }

        long write(GatheringByteChannel channel) throws IOException {
            return this.m_messages.readBytes(channel, this.m_messages.readableBytes());
        }
    }

    private static class SerializedMessages {
        final ByteBuf m_messages;
        final int m_count;

        SerializedMessages(ByteBuf messages, int count) {
            this.m_messages = messages;
            this.m_count = count;
        }
    }

    class ExceptionListener
    implements Runnable {
        private final ListenableFuture<?> m_fut;

        private ExceptionListener(ListenableFuture<?> fut) {
            this.m_fut = fut;
        }

        @Override
        public void run() {
            if (!TLSEncryptionAdapter.this.m_isShutdown) {
                return;
            }
            try {
                this.m_fut.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                s_networkLog.error("unexpect fault occurred in encrypt task", e.getCause());
                TLSEncryptionAdapter.this.m_exceptions.offer(e);
            }
        }
    }

    class EncryptionGateway
    implements Runnable {
        private final ConcurrentLinkedDeque<SerializedMessages> m_q = new ConcurrentLinkedDeque();

        EncryptionGateway() {
        }

        synchronized void offer(SerializedMessages frame) {
            boolean wasEmpty = this.m_q.isEmpty();
            this.m_q.add(frame);
            TLSEncryptionAdapter.this.m_inFlight.reducePermits(1);
            if (wasEmpty) {
                this.submitSelf();
            }
        }

        synchronized int die() {
            int toUnqueue = 0;
            SerializedMessages ef = null;
            while ((ef = this.m_q.poll()) != null) {
                toUnqueue += ef.m_messages.readableBytes();
            }
            return toUnqueue;
        }

        String dumpState() {
            return new StringBuilder(256).append("EncryptionGateway[").append("q.isEmpty()=").append(this.m_q.isEmpty()).append("]").toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SerializedMessages messages = this.m_q.peek();
            if (messages == null) {
                return;
            }
            try {
                ByteBuf encr;
                int clearTextSize = messages.m_messages.readableBytes();
                try {
                    encr = TLSEncryptionAdapter.this.m_encrypter.tlswrap(messages.m_messages, (ByteBufAllocator)TLSEncryptionAdapter.this.m_ce.allocator());
                }
                catch (TLSException e) {
                    TLSEncryptionAdapter.this.m_exceptions.offer(new ExecutionException("failed to encrypt frame", e));
                    TLSEncryptionAdapter.this.m_connection.enableWriteSelection();
                    messages.m_messages.release();
                    TLSEncryptionAdapter.this.m_inFlight.release();
                    return;
                }
                if (TLSEncryptionAdapter.this.m_isShutdown) {
                    encr.release();
                    return;
                }
                TLSEncryptionAdapter.this.m_encryptedQueue.offer(new EncryptedMessages(encr, messages.m_count, clearTextSize));
                try {
                    TLSEncryptionAdapter.this.m_connection.enableWriteSelection();
                }
                catch (CancelledKeyException e) {
                    s_networkLog.debug("CancelledKeyException while trying to enable write", e);
                    messages.m_messages.release();
                    TLSEncryptionAdapter.this.m_inFlight.release();
                    return;
                }
            }
            finally {
                messages.m_messages.release();
                TLSEncryptionAdapter.this.m_inFlight.release();
            }
            EncryptionGateway encryptionGateway = this;
            synchronized (encryptionGateway) {
                this.m_q.poll();
                if (this.m_q.peek() != null && !TLSEncryptionAdapter.this.m_isShutdown) {
                    this.submitSelf();
                }
            }
        }

        boolean isEmpty() {
            return this.m_q.isEmpty();
        }

        void submitSelf() {
            ListenableFuture<?> fut = TLSEncryptionAdapter.this.m_ce.submit(this);
            fut.addListener(new ExceptionListener(fut), CoreUtils.LISTENINGSAMETHREADEXECUTOR);
        }
    }

    static final class EncryptLedger {
        final int encryptedBytesDelta;
        final long bytesWritten;
        final int messagesWritten;

        public EncryptLedger(int delta, long bytesWritten, int messagesWritten) {
            this.encryptedBytesDelta = delta;
            this.bytesWritten = bytesWritten;
            this.messagesWritten = messagesWritten;
        }
    }
}

