/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import java.io.IOException;
import java.nio.channels.GatheringByteChannel;
import java.util.Deque;
import javax.net.ssl.SSLEngine;
import org.voltcore.network.CipherExecutor;
import org.voltcore.network.Connection;
import org.voltcore.network.NetworkDBBPool;
import org.voltcore.network.PicoNIOWriteStream;
import org.voltcore.network.TLSEncryptionAdapter;
import org.voltcore.utils.Pair;

public class TLSPicoNIOWriteStream
extends PicoNIOWriteStream {
    private final TLSEncryptionAdapter m_tlsEncryptionAdapter;

    public TLSPicoNIOWriteStream(Connection connection, SSLEngine engine, CipherExecutor cipherExecutor) {
        this.m_tlsEncryptionAdapter = new TLSEncryptionAdapter(connection, engine, cipherExecutor);
    }

    @Override
    int serializeQueuedWrites(NetworkDBBPool pool) throws IOException {
        this.m_tlsEncryptionAdapter.checkForGatewayExceptions();
        int frameMax = Math.min(16384, this.m_tlsEncryptionAdapter.applicationBufferSize());
        Deque oldlist = this.getQueuedWrites();
        if (oldlist.isEmpty()) {
            return 0;
        }
        Pair<Integer, Integer> processedWrites = this.m_tlsEncryptionAdapter.encryptBuffers(oldlist, frameMax);
        this.updateQueued(processedWrites.getSecond(), true);
        return processedWrites.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int drainTo(GatheringByteChannel channel) throws IOException {
        int totalWritten = 0;
        try {
            TLSEncryptionAdapter.EncryptLedger ledger = null;
            do {
                ledger = this.m_tlsEncryptionAdapter.drainEncryptedMessages(channel);
                totalWritten = (int)((long)totalWritten + ledger.bytesWritten);
                this.m_messagesWritten += (long)ledger.messagesWritten;
            } while (ledger.bytesWritten > 0L);
        }
        finally {
            if (totalWritten > 0) {
                this.m_bytesWritten += (long)totalWritten;
            }
        }
        return totalWritten;
    }

    @Override
    synchronized void shutdown() {
        super.shutdown();
        this.m_tlsEncryptionAdapter.shutdown();
    }
}

