/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import org.voltcore.network.CipherExecutor;
import org.voltcore.network.PicoNetwork;
import org.voltcore.network.TLSDecryptionAdapter;
import org.voltcore.network.TLSPicoNIOWriteStream;
import org.voltcore.utils.Pair;

public class TLSPicoNetwork
extends PicoNetwork {
    private TLSDecryptionAdapter m_tlsDecryptAdapter;
    private final SSLEngine m_sslEngine;
    private final CipherExecutor m_cipherExecutor;

    public TLSPicoNetwork(SocketChannel sc, SSLEngine sslEngine, CipherExecutor cipherExecutor) {
        super(sc);
        this.m_sslEngine = sslEngine;
        this.m_cipherExecutor = cipherExecutor;
    }

    @Override
    protected void startSetup() {
        this.m_tlsDecryptAdapter = new TLSDecryptionAdapter(this, this.m_ih, this.m_sslEngine, this.m_cipherExecutor);
        this.m_writeStream = new TLSPicoNIOWriteStream(this, this.m_sslEngine, this.m_cipherExecutor);
    }

    @Override
    protected void dispatchReadStream() throws IOException {
        try {
            Pair<Integer, Integer> readInfo = this.m_tlsDecryptAdapter.handleInputStreamMessages(this.readyForRead(), this.readStream(), this.m_sc, this.m_pool);
            if (readInfo.getFirst() > 0) {
                this.m_hadWork = true;
            }
            this.m_messagesRead += (long)readInfo.getSecond().intValue();
        }
        catch (EOFException eof) {
            this.m_interestOps &= 0xFFFFFFFE;
            this.m_key.interestOps(this.m_interestOps);
            if (this.m_sc.socket().isConnected()) {
                try {
                    this.m_sc.socket().shutdownInput();
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
            this.m_shouldStop = true;
            this.safeStopping();
            this.enableWriteSelection();
        }
    }

    @Override
    protected void safeStopping() {
        this.m_tlsDecryptAdapter.die();
        super.safeStopping();
    }
}

