/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import com.google_voltpatches.common.util.concurrent.SettableFuture;
import io.netty_voltpatches.NinjaKeySet;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import jsr166y.ThreadLocalRandom;
import org.voltcore.logging.VoltLogger;
import org.voltcore.network.CipherExecutor;
import org.voltcore.network.Connection;
import org.voltcore.network.InputHandler;
import org.voltcore.network.NetworkDBBPool;
import org.voltcore.network.ReverseDNSPolicy;
import org.voltcore.network.VoltNetworkPool;
import org.voltcore.network.VoltPort;
import org.voltcore.network.VoltPortFactory;
import org.voltcore.utils.LatencyWatchdog;
import org.voltcore.utils.Pair;

class VoltNetwork
implements Runnable,
VoltNetworkPool.IOStatsIntf {
    private final Selector m_selector;
    private static final VoltLogger m_logger = new VoltLogger(VoltNetwork.class.getName());
    private static final VoltLogger networkLog = new VoltLogger("NETWORK");
    private final ConcurrentLinkedQueue<Runnable> m_tasks = new ConcurrentLinkedQueue();
    private volatile boolean m_shouldStop = false;
    private final Thread m_thread;
    private final HashSet<VoltPort> m_ports = new HashSet();
    private final AtomicInteger m_numPorts = new AtomicInteger();
    final NetworkDBBPool m_pool = new NetworkDBBPool();
    private final String m_coreBindId;
    final String networkThreadName;
    private final NinjaKeySet m_ninjaSelectedKeys;

    void start() {
        this.m_thread.start();
    }

    VoltNetwork(int networkId, String coreBindId, String networkName) {
        this.m_thread = new Thread((Runnable)this, "Volt " + networkName + " Network - " + networkId);
        this.networkThreadName = new String("Volt " + networkName + " Network - " + networkId);
        this.m_thread.setDaemon(true);
        this.m_coreBindId = coreBindId;
        try {
            this.m_selector = Selector.open();
        }
        catch (IOException ex) {
            m_logger.fatal(null, ex);
            throw new RuntimeException(ex);
        }
        this.m_ninjaSelectedKeys = NinjaKeySet.instrumentSelector(this.m_selector);
    }

    VoltNetwork(Selector s) {
        this.m_thread = null;
        this.m_selector = s;
        this.m_coreBindId = null;
        this.networkThreadName = new String("Test Selector Thread");
        this.m_ninjaSelectedKeys = NinjaKeySet.instrumentSelector(this.m_selector);
    }

    void shutdown() throws InterruptedException {
        this.m_shouldStop = true;
        if (this.m_thread != null) {
            this.m_selector.wakeup();
            this.m_thread.join();
        }
    }

    boolean isStopping() {
        return this.m_shouldStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection registerChannel(final SocketChannel channel, final InputHandler handler, final int interestOps, final ReverseDNSPolicy dns, final CipherExecutor cipherService, final SSLEngine sslEngine) throws IOException {
        Object object = channel.blockingLock();
        synchronized (object) {
            channel.configureBlocking(false);
            channel.socket().setKeepAlive(true);
        }
        Callable<Connection> registerTask = new Callable<Connection>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Connection call() throws Exception {
                VoltPort port = VoltPortFactory.createVoltPort(channel, VoltNetwork.this, handler, (InetSocketAddress)channel.socket().getRemoteSocketAddress(), VoltNetwork.this.m_pool, cipherService, sslEngine);
                port.registering();
                if (dns != ReverseDNSPolicy.NONE) {
                    port.resolveHostname(dns == ReverseDNSPolicy.SYNCHRONOUS);
                }
                try {
                    SelectionKey key = channel.register(VoltNetwork.this.m_selector, interestOps, null);
                    port.setKey(key);
                    port.registered();
                    key.attach(port);
                    VoltPort voltPort = port;
                    return voltPort;
                }
                finally {
                    VoltNetwork.this.m_ports.add(port);
                    VoltNetwork.this.m_numPorts.incrementAndGet();
                }
            }
        };
        FutureTask<Connection> ft = new FutureTask<Connection>(registerTask);
        this.m_tasks.offer(ft);
        this.m_selector.wakeup();
        try {
            return ft.get();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private Runnable getUnregisterRunnable(final Connection c) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                VoltPort port = (VoltPort)c;
                assert (c != null);
                SelectionKey selectionKey = port.getKey();
                try {
                    if (!VoltNetwork.this.m_ports.contains(port)) {
                        return;
                    }
                    try {
                        port.unregistering();
                    }
                    finally {
                        try {
                            selectionKey.attach(null);
                            selectionKey.cancel();
                        }
                        finally {
                            VoltNetwork.this.m_ports.remove(port);
                            VoltNetwork.this.m_numPorts.decrementAndGet();
                        }
                    }
                }
                finally {
                    port.unregistered();
                }
            }
        };
    }

    Future<?> unregisterChannel(Connection c) {
        FutureTask<Object> ft = new FutureTask<Object>(this.getUnregisterRunnable(c), null);
        this.m_tasks.offer(ft);
        this.m_selector.wakeup();
        return ft;
    }

    void addToChangeList(VoltPort port) {
        this.addToChangeList(port, false);
    }

    void addToChangeList(final VoltPort port, boolean runFirst) {
        if (runFirst) {
            this.m_tasks.offer(new Runnable(){

                @Override
                public void run() {
                    VoltNetwork.this.callPort(port);
                }
            });
        } else {
            this.m_tasks.offer(new Runnable(){

                @Override
                public void run() {
                    VoltNetwork.this.installInterests(port);
                }
            });
        }
        this.m_selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        if (this.m_coreBindId != null) {
            // empty if block
        }
        try {
            while (!this.m_shouldStop) {
                try {
                    while (!this.m_shouldStop) {
                        LatencyWatchdog.pet();
                        int readyKeys = this.m_selector.select();
                        Runnable task = null;
                        while ((task = this.m_tasks.poll()) != null) {
                            task.run();
                        }
                        if (readyKeys > 0) {
                            if (NinjaKeySet.supported) {
                                this.optimizedInvokeCallbacks(r);
                            } else {
                                this.invokeCallbacks(r);
                            }
                        }
                        task = null;
                        while ((task = this.m_tasks.poll()) != null) {
                            task.run();
                        }
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    m_logger.error(null, ex);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                this.p_shutdown();
            }
            catch (Throwable t) {
                m_logger.error("Error shutting down Volt Network", t);
                t.printStackTrace();
            }
        }
    }

    private void p_shutdown() {
        Set<SelectionKey> keys = this.m_selector.keys();
        for (SelectionKey key : keys) {
            VoltPort port = (VoltPort)key.attachment();
            if (port == null) continue;
            try {
                this.getUnregisterRunnable(port).run();
            }
            catch (Throwable e) {
                networkLog.error("Exception unregistering port " + port, e);
            }
        }
        this.m_pool.clear();
        try {
            this.m_selector.close();
        }
        catch (IOException e) {
            m_logger.error(null, e);
        }
    }

    void installInterests(VoltPort port) {
        try {
            if (port.isRunning()) {
                assert (false) : "Shouldn't be running since it is all single threaded now?";
                return;
            }
            if (port.isDead()) {
                this.getUnregisterRunnable(port).run();
                try {
                    port.m_selectionKey.channel().close();
                }
                catch (IOException iOException) {}
            } else {
                this.resumeSelection(port);
            }
        }
        catch (CancelledKeyException e) {
            networkLog.warn("Had a cancelled key exception while processing queued runnables for port " + port, e);
        }
    }

    private void resumeSelection(VoltPort port) {
        SelectionKey key = port.getKey();
        if (key.isValid()) {
            key.interestOps(port.interestOps());
        } else {
            this.m_ports.remove(port);
            this.m_numPorts.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callPort(VoltPort port) {
        try {
            port.lockForHandlingWork();
            port.getKey().interestOps(0);
            port.run();
        }
        catch (CancelledKeyException e) {
            port.m_running = false;
        }
        catch (Exception e) {
            String trimmed;
            port.die();
            String string = trimmed = e.getMessage() == null ? "" : e.getMessage().trim();
            if (e instanceof IOException && (trimmed.equalsIgnoreCase("Connection reset by peer") || trimmed.equalsIgnoreCase("broken pipe")) || e instanceof AsynchronousCloseException || e instanceof ClosedChannelException || e instanceof ClosedByInterruptException) {
                m_logger.debug("VoltPort died, probably of natural causes", e);
            } else {
                e.printStackTrace();
                networkLog.error("VoltPort died due to an unexpected exception", e);
            }
        }
        finally {
            this.installInterests(port);
        }
    }

    protected void invokeCallbacks(ThreadLocalRandom r) {
        VoltPort port;
        Object obj;
        int itInx;
        Set<SelectionKey> selectedKeys = this.m_selector.selectedKeys();
        int keyCount = selectedKeys.size();
        int startInx = r.nextInt(keyCount);
        Iterator<SelectionKey> it = selectedKeys.iterator();
        for (itInx = 0; itInx < startInx; ++itInx) {
            it.next();
        }
        while (itInx < keyCount) {
            obj = it.next().attachment();
            if (obj == null) continue;
            port = (VoltPort)obj;
            this.callPort(port);
            ++itInx;
        }
        itInx = 0;
        it = selectedKeys.iterator();
        while (itInx < startInx) {
            obj = it.next().attachment();
            if (obj == null) continue;
            port = (VoltPort)obj;
            this.callPort(port);
            ++itInx;
        }
        selectedKeys.clear();
    }

    protected void optimizedInvokeCallbacks(ThreadLocalRandom r) {
        VoltPort port;
        Object obj;
        int ii;
        int numKeys = this.m_ninjaSelectedKeys.size();
        int startIndex = r.nextInt(numKeys);
        SelectionKey[] keys = this.m_ninjaSelectedKeys.keys();
        for (ii = startIndex; ii < numKeys; ++ii) {
            obj = keys[ii].attachment();
            if (obj == null) continue;
            port = (VoltPort)obj;
            this.callPort(port);
        }
        for (ii = 0; ii < startIndex; ++ii) {
            obj = keys[ii].attachment();
            if (obj == null) continue;
            port = (VoltPort)obj;
            this.callPort(port);
        }
        this.m_ninjaSelectedKeys.clear();
    }

    private Map<Long, Pair<String, long[]>> getIOStatsImpl(boolean interval) {
        HashMap<Long, Pair<String, long[]>> retval = new HashMap<Long, Pair<String, long[]>>();
        long totalRead = 0L;
        long totalMessagesRead = 0L;
        long totalWritten = 0L;
        long totalMessagesWritten = 0L;
        for (VoltPort p : this.m_ports) {
            long read = p.readStream().getBytesRead(interval);
            long[] writeInfo = p.writeStream().getBytesAndMessagesWritten(interval);
            long messagesRead = p.getMessagesRead(interval);
            totalRead += read;
            totalMessagesRead += messagesRead;
            totalWritten += writeInfo[0];
            totalMessagesWritten += writeInfo[1];
            retval.put(p.connectionId(), Pair.of(p.getHostnameOrIP(), new long[]{read, messagesRead, writeInfo[0], writeInfo[1]}));
        }
        retval.put(-1L, Pair.of("GLOBAL", new long[]{totalRead, totalMessagesRead, totalWritten, totalMessagesWritten}));
        return retval;
    }

    @Override
    public Future<Map<Long, Pair<String, long[]>>> getIOStats(final boolean interval) {
        Callable<Map<Long, Pair<String, long[]>>> task = new Callable<Map<Long, Pair<String, long[]>>>(){

            @Override
            public Map<Long, Pair<String, long[]>> call() throws Exception {
                return VoltNetwork.this.getIOStatsImpl(interval);
            }
        };
        FutureTask<Map<Long, Pair<String, long[]>>> ft = new FutureTask<Map<Long, Pair<String, long[]>>>(task);
        this.m_tasks.offer(ft);
        this.m_selector.wakeup();
        return ft;
    }

    Long getThreadId() {
        return this.m_thread.getId();
    }

    void queueTask(Runnable r) {
        this.m_tasks.offer(r);
        this.m_selector.wakeup();
    }

    int numPorts() {
        return this.m_numPorts.get();
    }

    public Future<Set<Connection>> getConnections() {
        final SettableFuture<Set<Connection>> connectionsFuture = SettableFuture.create();
        this.queueTask(new Runnable(){

            @Override
            public void run() {
                connectionsFuture.set(new HashSet(VoltNetwork.this.m_ports));
            }
        });
        return connectionsFuture;
    }
}

