/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import org.voltcore.logging.VoltLogger;
import org.voltcore.network.CipherExecutor;
import org.voltcore.network.Connection;
import org.voltcore.network.InputHandler;
import org.voltcore.network.ReverseDNSPolicy;
import org.voltcore.network.VoltNetwork;
import org.voltcore.utils.Pair;

public class VoltNetworkPool {
    private static final VoltLogger m_logger = new VoltLogger(VoltNetworkPool.class.getName());
    private final VoltNetwork[] m_networks;
    private final AtomicLong m_nextNetwork = new AtomicLong();
    public final String m_poolName;

    public VoltNetworkPool() {
        this(1, 1, null, "");
    }

    public VoltNetworkPool(int numThreads, int startThreadId, Queue<String> coreBindIds, String poolName) {
        this.m_poolName = poolName;
        if (numThreads < 1) {
            throw new IllegalArgumentException("Must specify a positive number of threads");
        }
        if (coreBindIds == null || coreBindIds.isEmpty()) {
            this.m_networks = new VoltNetwork[numThreads];
            for (int ii = 0; ii < numThreads; ++ii) {
                this.m_networks[ii] = new VoltNetwork(ii + startThreadId, null, poolName);
            }
        } else {
            int coreBindIdsSize = coreBindIds.size();
            this.m_networks = new VoltNetwork[coreBindIdsSize];
            for (int ii = 0; ii < coreBindIdsSize; ++ii) {
                this.m_networks[ii] = new VoltNetwork(ii + startThreadId, coreBindIds.poll(), poolName);
            }
        }
    }

    public void start() {
        for (VoltNetwork vn : this.m_networks) {
            vn.start();
        }
    }

    public void shutdown() throws InterruptedException {
        for (VoltNetwork vn : this.m_networks) {
            vn.shutdown();
        }
    }

    public Connection registerChannel(SocketChannel channel, InputHandler handler, CipherExecutor cipherService, SSLEngine sslEngine) throws IOException {
        return this.registerChannel(channel, handler, 1, ReverseDNSPolicy.ASYNCHRONOUS, cipherService, sslEngine);
    }

    public Connection registerChannel(SocketChannel channel, InputHandler handler, int interestOps, ReverseDNSPolicy dns, CipherExecutor cipherService, SSLEngine sslEngine) throws IOException {
        VoltNetwork vn = this.m_networks[(int)(this.m_nextNetwork.getAndIncrement() % (long)this.m_networks.length)];
        for (int ii = 0; ii < this.m_networks.length; ++ii) {
            if (this.m_networks[ii] == vn || vn.numPorts() <= this.m_networks[ii].numPorts()) continue;
            vn = this.m_networks[ii];
        }
        return vn.registerChannel(channel, handler, interestOps, dns, cipherService, sslEngine);
    }

    public List<Long> getThreadIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (VoltNetwork vn : this.m_networks) {
            ids.add(vn.getThreadId());
        }
        return ids;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Long, Pair<String, long[]>> getIOStats(boolean interval, List<IOStatsIntf> picoNetworks) throws ExecutionException, InterruptedException {
        void var7_10;
        HashMap<Long, Pair<String, long[]>> retval = new HashMap<Long, Pair<String, long[]>>();
        LinkedList<Future<Map<Long, Pair<String, long[]>>>> statTasks = new LinkedList<Future<Map<Long, Pair<String, long[]>>>>();
        VoltNetwork[] voltNetworkArray = this.m_networks;
        int n = voltNetworkArray.length;
        boolean bl = false;
        while (var7_10 < n) {
            VoltNetwork vn = voltNetworkArray[var7_10];
            statTasks.add(vn.getIOStats(interval));
            ++var7_10;
        }
        for (IOStatsIntf pn : picoNetworks) {
            statTasks.add(pn.getIOStats(interval));
        }
        long[] globalStats = null;
        for (Future future : statTasks) {
            try {
                Map stats = (Map)future.get(500L, TimeUnit.MILLISECONDS);
                if (globalStats == null) {
                    globalStats = (long[])((Pair)stats.get(-1L)).getSecond();
                } else {
                    long[] localStats = (long[])((Pair)stats.get(-1L)).getSecond();
                    for (int ii = 0; ii < localStats.length; ++ii) {
                        int n2 = ii;
                        globalStats[n2] = globalStats[n2] + localStats[ii];
                    }
                }
                retval.putAll(stats);
            }
            catch (TimeoutException e) {
                m_logger.warn("Timed out retrieving stats from network thread, probably harmless", e);
            }
        }
        retval.put(-1L, Pair.of("GLOBAL", globalStats));
        return retval;
    }

    /*
     * WARNING - void declaration
     */
    public Set<Connection> getConnections() {
        void var4_6;
        ArrayList<Future<Set<Connection>>> futures = new ArrayList<Future<Set<Connection>>>(this.m_networks.length);
        VoltNetwork[] voltNetworkArray = this.m_networks;
        int n = voltNetworkArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            VoltNetwork vn = voltNetworkArray[var4_6];
            futures.add(vn.getConnections());
            ++var4_6;
        }
        HashSet<Connection> conns = new HashSet<Connection>();
        for (Future future : futures) {
            HashSet connsForNetwork;
            try {
                connsForNetwork = (HashSet)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                connsForNetwork = new HashSet();
            }
            conns.addAll(connsForNetwork);
        }
        return conns;
    }

    public static interface IOStatsIntf {
        public Future<Map<Long, Pair<String, long[]>>> getIOStats(boolean var1);
    }
}

