/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.voltcore.logging.VoltLogger;
import org.voltcore.network.Connection;
import org.voltcore.network.InputHandler;
import org.voltcore.network.NIOReadStream;
import org.voltcore.network.NetworkDBBPool;
import org.voltcore.network.ReverseDNSCache;
import org.voltcore.network.VoltNIOWriteStream;
import org.voltcore.network.VoltNetwork;
import org.voltcore.network.VoltProtocolHandler;

public class VoltPort
implements Connection {
    protected final VoltNetwork m_network;
    protected static final VoltLogger networkLog = new VoltLogger("NETWORK");
    public static final int MAX_MESSAGE_LENGTH = 0x3200000;
    protected final NetworkDBBPool m_pool;
    private int m_readyOps = 0;
    protected volatile int m_interestOps = 0;
    volatile boolean m_running = false;
    protected volatile boolean m_isDead = false;
    protected volatile boolean m_isShuttingDown = false;
    protected final Object m_lock = new Object();
    protected SelectionKey m_selectionKey;
    protected SocketChannel m_channel;
    protected final InputHandler m_handler;
    protected NIOReadStream m_readStream;
    protected VoltNIOWriteStream m_writeStream;
    protected long m_messagesRead = 0L;
    private long m_lastMessagesRead = 0L;
    volatile String m_remoteHostname = null;
    final InetSocketAddress m_remoteSocketAddress;
    final String m_remoteSocketAddressString;
    private volatile String m_remoteHostAndAddressAndPort;
    private String m_toString = null;
    private boolean m_alreadyStopped = false;

    public VoltPort(VoltNetwork network, InputHandler handler, InetSocketAddress remoteAddress, NetworkDBBPool pool) {
        this.m_network = network;
        this.m_handler = handler;
        this.m_remoteSocketAddress = remoteAddress;
        this.m_remoteSocketAddressString = remoteAddress.getAddress().getHostAddress();
        this.m_pool = pool;
        this.m_remoteHostAndAddressAndPort = "/" + this.m_remoteSocketAddressString + ":" + this.m_remoteSocketAddress.getPort();
        this.m_toString = super.toString() + ":" + this.m_remoteHostAndAddressAndPort;
    }

    void resolveHostname(boolean synchronous) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                String remoteHost = ReverseDNSCache.hostnameOrAddress(VoltPort.this.m_remoteSocketAddress.getAddress());
                if (!remoteHost.equals(VoltPort.this.m_remoteSocketAddress.getAddress().getHostAddress())) {
                    VoltPort.this.m_remoteHostname = remoteHost;
                    VoltPort.this.m_remoteHostAndAddressAndPort = remoteHost + VoltPort.this.m_remoteHostAndAddressAndPort;
                    VoltPort.this.m_toString = VoltPort.this.toString() + ":" + VoltPort.this.m_remoteHostAndAddressAndPort;
                }
            }
        };
        if (synchronous) {
            r.run();
        } else {
            try {
                ReverseDNSCache.submit(r);
            }
            catch (RejectedExecutionException e) {
                networkLog.debug("Reverse DNS lookup for " + this.m_remoteSocketAddress + " rejected because the queue was full");
            }
        }
    }

    protected void setKey(SelectionKey key) {
        this.m_selectionKey = key;
        this.m_channel = (SocketChannel)key.channel();
        this.m_readStream = new NIOReadStream();
        this.m_writeStream = new VoltNIOWriteStream(this, this.m_handler.offBackPressure(), this.m_handler.onBackPressure(), this.m_handler.writestreamMonitor());
        this.m_interestOps = key.interestOps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockForHandlingWork() {
        Object object = this.m_lock;
        synchronized (object) {
            assert (!this.m_running);
            this.m_running = true;
            this.m_readyOps = 0;
            this.m_readyOps = this.m_selectionKey.readyOps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        try {
            int read;
            int maxRead;
            if (this.readyForRead() && (maxRead = this.m_handler.getMaxRead()) > 0 && (read = this.fillReadStream(maxRead)) > 0) {
                try {
                    ByteBuffer message;
                    while ((message = this.m_handler.retrieveNextMessage(this.readStream())) != null) {
                        this.m_handler.handleMessage(message, this);
                        ++this.m_messagesRead;
                    }
                }
                catch (VoltProtocolHandler.BadMessageLength e) {
                    networkLog.error("Bad message length exception", e);
                    throw e;
                }
            }
            this.drainWriteStream();
        }
        finally {
            Object object = this.m_lock;
            synchronized (object) {
                assert (this.m_running);
                this.m_running = false;
            }
        }
    }

    protected int fillReadStream(int maxBytes) throws IOException {
        if (maxBytes == 0 || this.m_isShuttingDown) {
            return 0;
        }
        int read = this.m_readStream.read(this.m_channel, maxBytes, this.m_pool);
        if (read == -1) {
            this.handleReadStreamEOF();
        }
        return read;
    }

    protected void handleReadStreamEOF() throws IOException {
        this.disableReadSelection();
        if (this.m_channel.socket().isConnected()) {
            try {
                this.m_channel.socket().shutdownInput();
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        this.m_isShuttingDown = true;
        this.m_handler.stopping(this);
        this.enableWriteSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void drainWriteStream() throws IOException {
        this.m_writeStream.serializeQueuedWrites(this.m_pool);
        VoltNIOWriteStream voltNIOWriteStream = this.m_writeStream;
        synchronized (voltNIOWriteStream) {
            if (!this.m_writeStream.isEmpty()) {
                this.m_writeStream.drainTo(this.m_channel);
            }
            if (this.m_writeStream.isEmpty()) {
                this.disableWriteSelection();
                if (this.m_isShuttingDown) {
                    this.m_channel.close();
                    this.unregistered();
                }
            }
        }
    }

    @Override
    public void enableWriteSelection() {
        this.setInterests(4, 0);
    }

    @Override
    public void disableWriteSelection() {
        this.setInterests(0, 4);
    }

    @Override
    public void disableReadSelection() {
        this.setInterests(0, 1);
    }

    @Override
    public void enableReadSelection() {
        this.setInterests(1, 0);
    }

    int interestOps() {
        return this.m_interestOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterests(int opsToAdd, int opsToRemove) {
        Object object = this.m_lock;
        synchronized (object) {
            int oldInterestOps = this.m_interestOps;
            this.m_interestOps = (this.m_interestOps | opsToAdd) & ~opsToRemove;
            if (oldInterestOps != this.m_interestOps && !this.m_running) {
                this.m_network.addToChangeList(this, (opsToAdd & 4) != 0);
            }
        }
    }

    public SelectionKey getKey() {
        return this.m_selectionKey;
    }

    int readyOps() {
        return this.m_readyOps;
    }

    boolean readyForRead() {
        return (this.readyOps() & 1) != 0 && (this.m_interestOps & 1) != 0;
    }

    boolean isRunning() {
        return this.m_running;
    }

    void die() {
        this.m_isDead = true;
    }

    boolean isDead() {
        return this.m_isDead;
    }

    @Override
    public NIOReadStream readStream() {
        assert (this.m_readStream != null);
        return this.m_readStream;
    }

    @Override
    public VoltNIOWriteStream writeStream() {
        assert (this.m_writeStream != null);
        return this.m_writeStream;
    }

    void registering() {
        this.m_handler.starting(this);
    }

    void registered() {
        this.m_handler.started(this);
    }

    void unregistering() {
        this.m_handler.stopping(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregistered() {
        block16: {
            try {
                if (this.m_alreadyStopped) break block16;
                this.m_alreadyStopped = true;
                try {
                    this.m_handler.stopped(this);
                }
                finally {
                    try {
                        this.m_writeStream.shutdown();
                    }
                    finally {
                        if (this.m_readStream != null) {
                            this.m_readStream.shutdown();
                        }
                    }
                }
            }
            finally {
                networkLog.debug("Closing channel " + this.m_toString);
                try {
                    this.m_channel.close();
                }
                catch (IOException e) {
                    networkLog.warn(e);
                }
            }
        }
    }

    public String toString() {
        if (this.m_toString == null) {
            return super.toString();
        }
        return this.m_toString;
    }

    long getMessagesRead(boolean interval) {
        if (interval) {
            long messagesRead = this.m_messagesRead;
            long messagesReadThisTime = messagesRead - this.m_lastMessagesRead;
            this.m_lastMessagesRead = messagesRead;
            return messagesReadThisTime;
        }
        return this.m_messagesRead;
    }

    @Override
    public String getHostnameOrIP() {
        if (this.m_remoteHostname != null) {
            return this.m_remoteHostname;
        }
        return this.m_remoteSocketAddressString;
    }

    @Override
    public String getHostnameOrIP(long clientHandle) {
        return this.getHostnameOrIP();
    }

    @Override
    public String getHostnameAndIPAndPort() {
        return this.m_remoteHostAndAddressAndPort;
    }

    @Override
    public int getRemotePort() {
        return this.m_remoteSocketAddress.getPort();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return this.m_remoteSocketAddress;
    }

    @Override
    public long connectionId() {
        return this.m_handler.connectionId();
    }

    @Override
    public long connectionId(long clientHandle) {
        return this.connectionId();
    }

    @Override
    public Future<?> unregister() {
        return this.m_network.unregisterChannel(this);
    }

    @Override
    public void queueTask(Runnable r) {
        this.m_network.queueTask(r);
    }
}

