/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.network;

import java.io.IOException;
import java.nio.channels.GatheringByteChannel;
import java.util.Deque;
import javax.net.ssl.SSLEngine;
import org.voltcore.network.CipherExecutor;
import org.voltcore.network.Connection;
import org.voltcore.network.NetworkDBBPool;
import org.voltcore.network.QueueMonitor;
import org.voltcore.network.TLSEncryptionAdapter;
import org.voltcore.network.VoltNIOWriteStream;
import org.voltcore.utils.DeferredSerialization;
import org.voltcore.utils.EstTime;
import org.voltcore.utils.Pair;

public class VoltTLSNIOWriteStream
extends VoltNIOWriteStream {
    private int m_queuedBytes = 0;
    private final TLSEncryptionAdapter m_tlsEncryptAdapter;

    public VoltTLSNIOWriteStream(Connection connection, Runnable offBackPressureCallback, Runnable onBackPressureCallback, QueueMonitor monitor, SSLEngine engine, CipherExecutor cipherExecutor) {
        super(connection, offBackPressureCallback, onBackPressureCallback, monitor);
        this.m_tlsEncryptAdapter = new TLSEncryptionAdapter(connection, engine, cipherExecutor);
    }

    @Override
    int serializeQueuedWrites(NetworkDBBPool pool) throws IOException {
        this.m_tlsEncryptAdapter.checkForGatewayExceptions();
        int frameMax = Math.min(16384, this.m_tlsEncryptAdapter.applicationBufferSize());
        Deque oldlist = this.getQueuedWrites();
        if (oldlist.isEmpty()) {
            return 0;
        }
        Pair<Integer, Integer> processedWrites = this.m_tlsEncryptAdapter.encryptBuffers(oldlist, frameMax);
        this.updateQueued(processedWrites.getSecond(), true);
        return processedWrites.getFirst();
    }

    public void waitForPendingEncrypts() throws IOException {
        this.m_tlsEncryptAdapter.waitForPendingEncrypts();
    }

    @Override
    public void updateQueued(int queued, boolean noBackpressureSignal) {
        super.updateQueued(queued, noBackpressureSignal);
        this.m_queuedBytes += queued;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.m_queuedWrites.isEmpty() && this.m_tlsEncryptAdapter.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int drainTo(GatheringByteChannel channel) throws IOException {
        int totalWritten = 0;
        int delta = 0;
        try {
            TLSEncryptionAdapter.EncryptLedger ledger = null;
            do {
                ledger = this.m_tlsEncryptAdapter.drainEncryptedMessages(channel);
                delta += ledger.encryptedBytesDelta;
                totalWritten = (int)((long)totalWritten + ledger.bytesWritten);
                this.m_messagesWritten += (long)ledger.messagesWritten;
                if (!this.m_tlsEncryptAdapter.hasOutstandingData() || this.m_hadBackPressure) continue;
                this.backpressureStarted();
            } while (ledger.bytesWritten > 0L);
        }
        finally {
            if (!this.m_tlsEncryptAdapter.hasOutstandingData() && this.m_hadBackPressure && this.m_queuedWrites.size() <= 100) {
                this.backpressureEnded();
            }
            this.m_lastPendingWriteTime = totalWritten > 0 && !this.isEmpty() ? EstTime.currentTimeMillis() : -1L;
            if (totalWritten > 0) {
                this.updateQueued(delta - totalWritten, false);
                this.m_bytesWritten += (long)totalWritten;
            } else if (delta > 0) {
                this.updateQueued(delta, false);
            }
        }
        return totalWritten;
    }

    String dumpState() {
        return new StringBuilder(256).append("TLSNIOWriteStream[").append("isEmpty()=").append(this.isEmpty()).append(", encryptionAdapter=").append(this.m_tlsEncryptAdapter.dumpState()).append("]").toString();
    }

    @Override
    public synchronized int getOutstandingMessageCount() {
        return this.m_tlsEncryptAdapter.getOutstandingMessageCount() + this.m_queuedWrites.size();
    }

    @Override
    synchronized void shutdown() {
        this.m_isShutdown = true;
        DeferredSerialization ds = null;
        while ((ds = (DeferredSerialization)this.m_queuedWrites.poll()) != null) {
            ds.cancel();
        }
        this.m_tlsEncryptAdapter.shutdown();
        int unqueue = -this.m_queuedBytes;
        this.updateQueued(unqueue, false);
    }
}

