/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.voltcore.utils.DirectBufferCleaner;
import org.voltcore.utils.VoltUnsafe;
import sun.misc.Unsafe;

public class UnsafeDirectBufferCleaner
implements DirectBufferCleaner {
    private final Method invokeCleanerMtd;

    public UnsafeDirectBufferCleaner() {
        try {
            this.invokeCleanerMtd = Unsafe.class.getMethod("invokeCleaner", ByteBuffer.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Reflection failure: no sun.misc.Unsafe.invokeCleaner() method found", e);
        }
    }

    @Override
    public void clean(ByteBuffer buf) {
        VoltUnsafe.invoke(this.invokeCleanerMtd, buf);
    }
}

