/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.voltcore.utils.DirectBufferCleaner;
import org.voltcore.utils.ReflectiveDirectBufferCleaner;
import org.voltcore.utils.UnsafeDirectBufferCleaner;
import sun.misc.Unsafe;

public abstract class VoltUnsafe {
    public static final boolean IS_JAVA8 = System.getProperty("java.version").startsWith("1.8");
    private static final Unsafe UNSAFE = VoltUnsafe.unsafe();
    public static final DirectBufferCleaner DIRECT_BYTE_BUFFER_CLEANER = IS_JAVA8 ? new ReflectiveDirectBufferCleaner() : new UnsafeDirectBufferCleaner();

    public static Object invoke(Method mtd, Object ... args) {
        try {
            return mtd.invoke((Object)UNSAFE, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Unsafe invocation failed [cls=" + UNSAFE.getClass() + ", mtd=" + mtd + ']', e);
        }
    }

    public static void cleanDirectBuffer(ByteBuffer buf) {
        assert (buf.isDirect());
        DIRECT_BYTE_BUFFER_CLEANER.clean(buf);
    }

    private static Unsafe unsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException ignored) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return (Unsafe)f.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics.", e.getCause());
            }
        }
    }
}

