/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.voltcore.network.TLSException;

public class SSLBufferEncrypter {
    private final SSLEngine m_sslEngine;

    public SSLBufferEncrypter(SSLEngine sslEngine) {
        this.m_sslEngine = sslEngine;
    }

    public ByteBuf tlswrap(ByteBuffer src, ByteBufAllocator allocator) {
        ByteBuf encrypted = this.tlswrap(Unpooled.wrappedBuffer((ByteBuffer)src), allocator);
        src.position(src.limit());
        return encrypted;
    }

    public ByteBuf tlswrap(ByteBuf src, ByteBufAllocator allocator) {
        SSLSession session = this.m_sslEngine.getSession();
        int packetBufferSize = session.getPacketBufferSize();
        CompositeByteBuf fullyEncrypted = null;
        ByteBuf piece = null;
        try {
            do {
                piece = allocator.buffer(packetBufferSize);
                assert (piece.nioBufferCount() == 1) : "Should only have one buffer: " + piece.nioBufferCount();
                ByteBuffer destNioBuf = piece.nioBuffer(0, piece.writableBytes());
                ByteBuffer[] srcNioBuffers = src.nioBuffers();
                SSLEngineResult result = null;
                try {
                    result = this.m_sslEngine.wrap(srcNioBuffers, destNioBuf);
                }
                catch (IllegalArgumentException | IllegalStateException | ReadOnlyBufferException | SSLException e) {
                    throw new TLSException("ssl engine wrap fault", e);
                }
                switch (result.getStatus()) {
                    case OK: {
                        src.readerIndex(src.readerIndex() + result.bytesConsumed());
                        break;
                    }
                    case BUFFER_OVERFLOW: {
                        throw new TLSException("SSL engine unexpectedly overflowed when encrypting");
                    }
                    case BUFFER_UNDERFLOW: {
                        throw new TLSException("SSL engine unexpectedly underflowed when encrypting");
                    }
                    case CLOSED: {
                        throw new TLSException("SSL engine is closed on ssl wrap of buffer.");
                    }
                }
                piece.writerIndex(destNioBuf.position());
                if (fullyEncrypted == null) {
                    if (!src.isReadable()) {
                        return piece;
                    }
                    fullyEncrypted = allocator.compositeBuffer(1024);
                }
                fullyEncrypted.addComponent(true, piece);
                piece = null;
            } while (src.isReadable());
            return fullyEncrypted;
        }
        catch (Throwable t) {
            if (piece != null) {
                piece.release();
            }
            fullyEncrypted.release();
            throw t;
        }
    }
}

