/*
 * Decompiled with CFR 0.152.
 */
package org.voltcore.utils.ssl;

import com.google_voltpatches.common.collect.ImmutableSet;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class SSLConfiguration {
    public static final String KEYSTORE_CONFIG_PROP = "keyStore";
    public static final String KEYSTORE_PASSWORD_CONFIG_PROP = "keyStorePassword";
    public static final String TRUSTSTORE_CONFIG_PROP = "trustStore";
    public static final String TRUSTSTORE_PASSWORD_CONFIG_PROP = "trustStorePassword";
    public static Set<String> PREFERRED_CIPHERS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256")).add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384")).add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384")).add("TLS_RSA_WITH_AES_256_GCM_SHA384")).add("TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384")).add("TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384")).add("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384")).add("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384")).add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256")).add("TLS_RSA_WITH_AES_128_GCM_SHA256")).add("TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256")).add("TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256")).add("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256")).add("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256")).add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA")).add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA")).add("TLS_RSA_WITH_AES_256_CBC_SHA")).add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA")).add("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA")).add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA")).add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA")).add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA")).add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA")).add("TLS_RSA_WITH_AES_128_CBC_SHA")).add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA")).add("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA")).add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA")).add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA")).build();
    public static Set<String> GCM_CIPHERS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256")).add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384")).add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384")).add("TLS_RSA_WITH_AES_256_GCM_SHA384")).add("TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384")).add("TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384")).add("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384")).add("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384")).add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256")).add("TLS_RSA_WITH_AES_128_GCM_SHA256")).add("TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256")).add("TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256")).add("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256")).add("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256")).build();

    public static SslContext createClientSslContext(SslConfig sslConfig) {
        if (sslConfig == null) {
            throw new IllegalArgumentException("sslConfig is null");
        }
        try {
            SslContextBuilder builder = SslContextBuilder.forClient();
            if (sslConfig.keyStorePath != null && sslConfig.keyStorePassword != null) {
                builder.keyManager(SSLConfiguration.createKeyManagers(sslConfig.keyStorePath, sslConfig.keyStorePassword, sslConfig.keyStorePassword));
            }
            if (sslConfig.trustStorePath != null && sslConfig.trustStorePassword != null) {
                builder.trustManager(SSLConfiguration.createTrustManagers(sslConfig.trustStorePath, sslConfig.trustStorePassword));
            }
            return builder.build();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            throw new IllegalArgumentException("Failed to initialize SSL using " + sslConfig, ex);
        }
    }

    private static KeyManagerFactory createKeyManagers(String filepath, String keystorePassword, String keyPassword) throws FileNotFoundException, KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        try (FileInputStream keyStoreIS = new FileInputStream(filepath);){
            keyStore.load(keyStoreIS, keystorePassword.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, keyPassword.toCharArray());
        return kmf;
    }

    private static TrustManagerFactory createTrustManagers(String filepath, String keystorePassword) throws KeyStoreException, FileNotFoundException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        try (FileInputStream trustStoreIS = new FileInputStream(filepath);){
            trustStore.load(trustStoreIS, keystorePassword.toCharArray());
        }
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustFactory.init(trustStore);
        return trustFactory;
    }

    public static class SslConfig {
        public final String keyStorePath;
        public final String keyStorePassword;
        public final String trustStorePath;
        public final String trustStorePassword;

        public SslConfig() {
            this(null, null, null, null);
        }

        public SslConfig(String keyStorePath, String keyStorePassword, String trustStorePath, String trustStorePassword) {
            String pval = System.getProperty("javax.net.ssl.keyStore");
            if (pval != null) {
                keyStorePath = pval;
            }
            if ((pval = System.getProperty("javax.net.ssl.keyStorePassword")) != null) {
                keyStorePassword = pval;
            }
            if ((pval = System.getProperty("javax.net.ssl.trustStore")) != null) {
                trustStorePath = pval;
            }
            if ((pval = System.getProperty("javax.net.ssl.trustStorePassword")) != null) {
                trustStorePassword = pval;
            }
            this.keyStorePath = keyStorePath;
            this.keyStorePassword = keyStorePassword;
            this.trustStorePath = trustStorePath;
            this.trustStorePassword = trustStorePassword;
        }

        public String toString() {
            return "SslConfig [keyStorePath=" + this.keyStorePath + ", trustStorePath=" + this.trustStorePath + "]";
        }
    }
}

