/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb;

import java.io.Console;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import org.apache.commons_voltpatches.cli.CommandLine;
import org.apache.commons_voltpatches.cli.HelpFormatter;
import org.apache.commons_voltpatches.cli.Options;
import org.apache.commons_voltpatches.cli.PosixParser;

public abstract class CLIConfig {
    protected final Options options = new Options();
    protected Options helpmsgs = new Options();
    protected String cmdName = "command";
    protected String configDump;
    protected String usage;
    protected SSLContext m_sslContext;

    public void setSSLContext(SSLContext sslContext) {
        this.m_sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.m_sslContext;
    }

    public void exitWithMessageAndUsage(String msg) {
        System.err.println(msg);
        this.printUsage();
        System.exit(-1);
    }

    public void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.cmdName, this.helpmsgs, false);
    }

    private void assignValueToField(Field field, String value) throws Exception {
        if (value == null || value.length() == 0) {
            return;
        }
        field.setAccessible(true);
        Class<?> cls = field.getType();
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            field.set(this, Boolean.parseBoolean(value));
        } else if (cls == Byte.TYPE || cls == Byte.class) {
            field.set(this, Byte.parseByte(value));
        } else if (cls == Short.TYPE || cls == Short.class) {
            field.set(this, Short.parseShort(value));
        } else if (cls == Integer.TYPE || cls == Integer.class) {
            field.set(this, Integer.parseInt(value));
        } else if (cls == Long.TYPE || cls == Long.class) {
            field.set(this, Long.parseLong(value));
        } else if (cls == Float.TYPE || cls == Float.class) {
            field.set(this, Float.valueOf(Float.parseFloat(value)));
        } else if (cls == Double.TYPE || cls == Double.class) {
            field.set(this, Double.parseDouble(value));
        } else if (cls == String.class) {
            field.set(this, value);
        } else if (value.length() == 1 && (cls == Character.TYPE || cls == Character.class)) {
            field.set(this, Character.valueOf(value.charAt(0)));
        } else {
            System.err.println("Parsing failed. Reason: can not assign " + value + " to " + cls.toString() + " class");
            this.printUsage();
            System.exit(-1);
        }
    }

    private void addOptionFromField(Field field) {
        if (field.isAnnotationPresent(Option.class)) {
            String shortopt;
            Option option = field.getAnnotation(Option.class);
            String opt = option.opt();
            if (opt == null || opt.trim().length() == 0) {
                opt = field.getName();
            }
            if ((shortopt = option.shortOpt()) == null || shortopt.trim().length() == 0) {
                this.options.addOption(null, opt, option.hasArg(), option.desc());
                this.helpmsgs.addOption(null, opt, option.hasArg(), option.desc());
            } else {
                this.options.addOption(shortopt, opt, option.hasArg(), option.desc());
                this.helpmsgs.addOption(shortopt, opt, option.hasArg(), option.desc());
            }
        } else if (field.isAnnotationPresent(AdditionalArgs.class)) {
            AdditionalArgs params = field.getAnnotation(AdditionalArgs.class);
            String opt = params.opt();
            if (opt == null || opt.trim().length() == 0) {
                opt = field.getName();
            }
            this.options.addOption(opt, params.hasArg(), params.desc());
        }
    }

    public void parse(String cmdName, String[] args) {
        this.cmdName = cmdName;
        try {
            this.options.addOption("help", "h", false, "Print this message");
            List<Field> allFields = CLIConfig.getFields(this.getClass());
            for (Field field : allFields) {
                this.addOptionFromField(field);
            }
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.options, args);
            if (cmd.hasOption("help")) {
                this.printUsage();
                System.exit(0);
            }
            String[] leftargs = cmd.getArgs();
            int leftover = 0;
            TreeMap<String, String> kvMap = new TreeMap<String, String>();
            Field[] fields = new Field[allFields.size()];
            int n = 0;
            for (Field field : allFields) {
                fields[n++] = field;
                if (field.isAnnotationPresent(AdditionalArgs.class)) {
                    ++leftover;
                    continue;
                }
                if (!field.isAnnotationPresent(Option.class)) continue;
                Option option = field.getAnnotation(Option.class);
                String opt = option.opt();
                if (opt == null || opt.trim().length() == 0) {
                    opt = field.getName();
                }
                if (cmd.hasOption(opt)) {
                    if (option.hasArg()) {
                        this.assignValueToField(field, cmd.getOptionValue(opt));
                    } else if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                        field.setAccessible(true);
                        try {
                            field.set(this, true);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(e);
                        }
                    } else {
                        this.printUsage();
                    }
                } else if (option.required()) {
                    this.printUsage();
                }
                field.setAccessible(true);
                kvMap.put(opt, field.get(this).toString());
            }
            if (leftargs != null) {
                if (leftargs.length <= leftover) {
                    int j = 0;
                    for (int i = 0; i < leftargs.length; ++i) {
                        while (j < fields.length && !fields[j].isAnnotationPresent(AdditionalArgs.class)) {
                            ++j;
                        }
                        fields[j].setAccessible(true);
                        fields[j].set(this, leftargs[i]);
                    }
                } else {
                    System.err.println("Expected " + leftover + " args, but receive " + leftargs.length + " args");
                    this.printUsage();
                    System.exit(-1);
                }
            }
            this.validate();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry e : kvMap.entrySet()) {
                sb.append((String)e.getKey()).append(" = ").append((String)e.getValue()).append("\n");
            }
            this.configDump = sb.toString();
        }
        catch (Exception e) {
            System.err.println("Parsing failed. Reason: " + e.getMessage());
            this.printUsage();
            System.exit(-1);
        }
    }

    public static List<Field> getFields(Class<?> startClass) {
        ArrayList<Field> currentClassFields = new ArrayList<Field>();
        currentClassFields.addAll(Arrays.asList(startClass.getDeclaredFields()));
        Class<?> parentClass = startClass.getSuperclass();
        if (parentClass != null) {
            List<Field> parentClassFields = CLIConfig.getFields(parentClass);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }

    public static String readPasswordIfNeeded(String user, String pwd, String prompt) throws IOException {
        if (null != user && user.trim().length() > 0 && (pwd == null || pwd.trim().length() == 0)) {
            Console console = System.console();
            if (console == null) {
                throw new IOException("Unable to read password from console.");
            }
            char[] val = console.readPassword("%s", prompt);
            if (val != null) {
                return new String(val);
            }
            return "";
        }
        return pwd;
    }

    public void validate() {
    }

    public String getConfigDumpString() {
        return this.configDump;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface AdditionalArgs {
        public String opt() default "";

        public boolean hasArg() default false;

        public boolean required() default false;

        public String desc() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Option {
        public String opt() default "";

        public String shortOpt() default "";

        public boolean hasArg() default true;

        public boolean required() default false;

        public String desc() default "";
    }
}

