/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import org.json_voltpatches.JSONArray;
import org.json_voltpatches.JSONException;
import org.json_voltpatches.JSONObject;
import org.json_voltpatches.JSONString;
import org.json_voltpatches.JSONStringer;
import org.voltcore.utils.DBBPool;
import org.voltdb.PrivateVoltTableFactory;
import org.voltdb.VoltTable;
import org.voltdb.VoltType;
import org.voltdb.VoltTypeException;
import org.voltdb.common.Constants;
import org.voltdb.types.GeographyPointValue;
import org.voltdb.types.GeographyValue;
import org.voltdb.types.TimestampType;
import org.voltdb.types.VoltDecimalHelper;
import org.voltdb.utils.SerializationHelper;

public class ParameterSet
implements JSONString {
    private static final ParameterSet EMPTY = ParameterSet.fromArray(new Object[0]);
    static final byte ARRAY = -99;
    private final Object[] m_params;
    private final byte[][] m_encodedStrings;
    private final byte[][][] m_encodedStringArrays;
    private final int m_serializedSize;

    public static ParameterSet emptyParameterSet() {
        return EMPTY;
    }

    public static ParameterSet fromArrayWithCopy(Object ... params) {
        if (params.length == 0) {
            return EMPTY;
        }
        return ParameterSet.fromArray((Object[])params.clone());
    }

    public static ParameterSet fromArrayNoCopy(Object ... params) {
        if (params.length == 0) {
            return EMPTY;
        }
        return ParameterSet.fromArray(params);
    }

    private static ParameterSet fromArray(Object[] params) {
        byte[][][] encodedStringArrays = new byte[params.length][][];
        byte[][] encodedStrings = new byte[params.length][];
        int size = 2;
        block28: for (int ii = 0; ii < params.length; ++ii) {
            VoltType type;
            Object obj = params[ii];
            if (obj == null || obj == JSONObject.NULL) {
                ++size;
                continue;
            }
            ++size;
            Class<?> cls = obj.getClass();
            if (ByteBuffer.class.isAssignableFrom(cls)) {
                ByteBuffer bb = (ByteBuffer)obj;
                size += 4 + bb.capacity();
                continue;
            }
            if (cls.isArray()) {
                Object[] b;
                if (obj instanceof byte[]) {
                    b = (byte[])obj;
                    size += 4 + b.length;
                    continue;
                }
                if (obj instanceof Byte[]) {
                    b = (Byte[])obj;
                    size += 4 + b.length;
                    continue;
                }
                try {
                    type = VoltType.typeFromClass(cls.getComponentType());
                }
                catch (VoltTypeException e) {
                    obj = ParameterSet.getAKosherArray((Object[])obj);
                    cls = obj.getClass();
                    type = VoltType.typeFromClass(cls.getComponentType());
                }
                size += 3;
                switch (type) {
                    case SMALLINT: {
                        if (obj instanceof Short[]) {
                            size += 2 * ((Short[])obj).length;
                            continue block28;
                        }
                        size += 2 * ((short[])obj).length;
                        continue block28;
                    }
                    case INTEGER: {
                        if (obj instanceof Integer[]) {
                            size += 4 * ((Integer[])obj).length;
                            continue block28;
                        }
                        size += 4 * ((int[])obj).length;
                        continue block28;
                    }
                    case BIGINT: {
                        if (obj instanceof Long[]) {
                            size += 8 * ((Long[])obj).length;
                            continue block28;
                        }
                        size += 8 * ((long[])obj).length;
                        continue block28;
                    }
                    case FLOAT: {
                        if (obj instanceof Double[]) {
                            size += 8 * ((Double[])obj).length;
                            continue block28;
                        }
                        size += 8 * ((double[])obj).length;
                        continue block28;
                    }
                    case STRING: {
                        String[] strings = (String[])obj;
                        byte[][] arrayEncodedStrings = new byte[strings.length][];
                        for (int zz = 0; zz < strings.length; ++zz) {
                            if (strings[zz] == null) {
                                size += 4;
                                continue;
                            }
                            arrayEncodedStrings[zz] = strings[zz].getBytes(Constants.UTF8ENCODING);
                            size += 4 + arrayEncodedStrings[zz].length;
                        }
                        encodedStringArrays[ii] = arrayEncodedStrings;
                        continue block28;
                    }
                    case TIMESTAMP: {
                        size += 8 * ((TimestampType[])obj).length;
                        continue block28;
                    }
                    case DECIMAL: {
                        size += 16 * ((BigDecimal[])obj).length;
                        continue block28;
                    }
                    case VOLTTABLE: {
                        for (VoltTable vt : (VoltTable[])obj) {
                            size += vt.getSerializedSize();
                        }
                        continue block28;
                    }
                    case VARBINARY: {
                        if (obj instanceof Byte[][]) {
                            for (Object[] buf : (Byte[][])obj) {
                                size += 4;
                                if (buf == null) continue;
                                size += buf.length;
                            }
                            continue block28;
                        }
                        byte[][] byArray = (byte[][])obj;
                        int n = byArray.length;
                        for (int i = 0; i < n; ++i) {
                            Object[] buf;
                            buf = byArray[i];
                            size += 4;
                            if (buf == null) continue;
                            size += buf.length;
                        }
                        continue block28;
                    }
                    case GEOGRAPHY_POINT: {
                        size += VoltType.GEOGRAPHY_POINT.getLengthInBytesForFixedTypesWithoutCheck() * ((GeographyPointValue[])obj).length;
                        continue block28;
                    }
                    case GEOGRAPHY: {
                        for (GeographyValue gv : (GeographyValue[])obj) {
                            size += 4;
                            if (gv == null) continue;
                            size += gv.getLengthInBytes();
                        }
                        continue block28;
                    }
                    default: {
                        throw new RuntimeException("FIXME: Unsupported type " + (Object)((Object)type));
                    }
                }
            }
            if (obj == VoltType.NULL_TIMESTAMP) {
                size += 8;
                continue;
            }
            if (obj == VoltType.NULL_STRING_OR_VARBINARY) {
                size += 4;
                continue;
            }
            if (obj == VoltType.NULL_DECIMAL) {
                size += 16;
                continue;
            }
            if (obj == VoltType.NULL_POINT) {
                size += VoltType.GEOGRAPHY_POINT.getLengthInBytesForFixedTypesWithoutCheck();
                continue;
            }
            if (obj == VoltType.NULL_GEOGRAPHY) {
                size += 4;
                continue;
            }
            if (obj instanceof DBBPool.BBContainer) {
                size += 4 + ((DBBPool.BBContainer)obj).b().remaining();
                continue;
            }
            type = VoltType.typeFromClass(cls);
            switch (type) {
                case TINYINT: {
                    ++size;
                    continue block28;
                }
                case SMALLINT: {
                    size += 2;
                    continue block28;
                }
                case INTEGER: {
                    size += 4;
                    continue block28;
                }
                case BIGINT: {
                    size += 8;
                    continue block28;
                }
                case FLOAT: {
                    size += 8;
                    continue block28;
                }
                case STRING: {
                    byte[] encodedString = ((String)obj).getBytes(Constants.UTF8ENCODING);
                    size += 4 + encodedString.length;
                    encodedStrings[ii] = encodedString;
                    continue block28;
                }
                case TIMESTAMP: {
                    size += 8;
                    continue block28;
                }
                case DECIMAL: {
                    size += 16;
                    continue block28;
                }
                case GEOGRAPHY_POINT: {
                    size += VoltType.GEOGRAPHY_POINT.getLengthInBytesForFixedTypesWithoutCheck();
                    continue block28;
                }
                case GEOGRAPHY: {
                    size += 4 + ((GeographyValue)obj).getLengthInBytes();
                    continue block28;
                }
                case VOLTTABLE: {
                    size += ((VoltTable)obj).getSerializedSize();
                    continue block28;
                }
                default: {
                    throw new RuntimeException("FIXME: Unsupported type " + (Object)((Object)type));
                }
            }
        }
        return new ParameterSet(params, size, encodedStrings, encodedStringArrays);
    }

    public static ParameterSet fromJSONString(String json) throws JSONException, IOException {
        JSONArray jArray = new JSONArray(json);
        return ParameterSet.fromJSONArray(jArray);
    }

    public static ParameterSet fromJSONArray(JSONArray paramArray) throws JSONException, IOException {
        Object[] params = new Object[paramArray.length()];
        for (int i = 0; i < paramArray.length(); ++i) {
            params[i] = ParameterSet.paramFromPossibleJSON(paramArray.get(i));
        }
        return ParameterSet.fromArrayNoCopy(params);
    }

    public static ParameterSet fromByteBuffer(ByteBuffer buffer) throws IOException {
        int startPos = buffer.position();
        int count = buffer.getShort();
        if (count < 0) {
            throw new IllegalArgumentException("Invalid parameter length " + count + " for ParameterSet.");
        }
        Object[] params = new Object[count];
        Object encodedStrings = null;
        Object encodedStringArrays = null;
        for (int i = 0; i < count; ++i) {
            OneParamInfo opi = ParameterSet.readOneParameter(buffer);
            params[i] = opi.value;
            if (opi.encodedString != null) {
                if (encodedStrings == null) {
                    encodedStrings = new byte[count][];
                }
                encodedStrings[i] = opi.encodedString;
            }
            if (opi.encodedStringArray == null) continue;
            if (encodedStringArrays == null) {
                encodedStringArrays = new byte[count][][];
            }
            encodedStringArrays[i] = opi.encodedStringArray;
        }
        int size = buffer.position() - startPos;
        return new ParameterSet(params, size, (byte[][])encodedStrings, (byte[][][])encodedStringArrays);
    }

    private ParameterSet(Object[] params, int serializedSize, byte[][] encodedStrings, byte[][][] encodedStringArrays) {
        this.m_params = params;
        this.m_serializedSize = serializedSize;
        this.m_encodedStrings = encodedStrings;
        this.m_encodedStringArrays = encodedStringArrays;
    }

    static Object limitType(Object o) {
        Class<?> ctype = o.getClass();
        if (ctype == Integer.class) {
            return ((Integer)o).longValue();
        }
        return o;
    }

    public Object getParam(int index) {
        return this.m_params[index];
    }

    public boolean hasParam(int index) {
        return this.m_params.length > index;
    }

    public Object[] toArray() {
        return (Object[])this.m_params.clone();
    }

    public int size() {
        return this.m_params.length;
    }

    public int getSerializedSize() {
        assert (this.m_serializedSize >= 2);
        return this.m_serializedSize;
    }

    public ByteBuffer serialize() {
        return null;
    }

    static Object getParameterAtIndex(int partitionIndex, ByteBuffer unserializedParams) throws IOException {
        short paramLen = unserializedParams.getShort();
        if (partitionIndex >= paramLen) {
            throw new RuntimeException("Invalid partition parameter requested.");
        }
        for (int i = 0; i < partitionIndex; ++i) {
            ParameterSet.readOneParameter(unserializedParams);
        }
        OneParamInfo opi = ParameterSet.readOneParameter(unserializedParams);
        unserializedParams.rewind();
        return opi.value;
    }

    static Object getAKosherArray(Object[] array) {
        int i;
        Object[] retval;
        String msg;
        int tables = 0;
        int integers = 0;
        int strings = 0;
        int doubles = 0;
        int nulls = 0;
        if (array.length == 0) {
            return new int[0];
        }
        for (Object element : array) {
            if (element instanceof VoltTable) {
                ++tables;
                continue;
            }
            if (element instanceof Double) {
                ++doubles;
                continue;
            }
            if (element instanceof Float) {
                ++doubles;
                continue;
            }
            if (element instanceof Byte) {
                ++integers;
                continue;
            }
            if (element instanceof Short) {
                ++integers;
                continue;
            }
            if (element instanceof Integer) {
                ++integers;
                continue;
            }
            if (element instanceof Long) {
                ++integers;
                continue;
            }
            if (element instanceof String) {
                ++strings;
                continue;
            }
            if (element == VoltType.NULL_STRING_OR_VARBINARY) {
                ++nulls;
                continue;
            }
            if (null == element) {
                ++nulls;
                continue;
            }
            if (element instanceof GeographyPointValue || element instanceof GeographyValue || element == VoltType.NULL_POINT || element == VoltType.NULL_GEOGRAPHY) {
                throw new RuntimeException("GeographyPointValue or GeographyValue instances are not yet supported in Object arrays passed as parameters.  Try passing GeographyPointValue[] or GeographyValue[] instead.");
            }
            String msg2 = String.format("Type %s not supported in parameter set arrays.", element.getClass().toString());
            throw new RuntimeException(msg2);
        }
        if (tables > 0) {
            if (integers + strings + doubles > 0) {
                msg = "Cannot mix tables and other types in parameter set arrays.";
                throw new RuntimeException(msg);
            }
            assert (tables == array.length);
            retval = new VoltTable[tables];
            for (i = 0; i < array.length; ++i) {
                retval[i] = (VoltTable)array[i];
            }
            return retval;
        }
        if (nulls == array.length) {
            throw new RuntimeException("Unable to determine type. Parameter set array contains all NULL values.");
        }
        if (strings > 0) {
            if (integers + doubles > 0) {
                msg = "Cannot mix strings and numbers in parameter set arrays.";
                throw new RuntimeException(msg);
            }
            assert (strings + nulls == array.length);
            retval = new String[array.length];
            for (i = 0; i < array.length; ++i) {
                if (array[i] == VoltType.NULL_STRING_OR_VARBINARY) {
                    array[i] = null;
                }
                retval[i] = (String)array[i];
            }
            return retval;
        }
        if (nulls > 0) {
            msg = "Cannot mix numerics and nulls in parameter set arrays.";
            throw new RuntimeException(msg);
        }
        if (doubles > 0) {
            assert (doubles + integers == array.length);
            retval = new double[array.length];
            for (i = 0; i < array.length; ++i) {
                Number numberval = (Number)array[i];
                retval[i] = numberval.doubleValue();
            }
            return retval;
        }
        assert (integers == array.length);
        retval = new long[array.length];
        for (i = 0; i < array.length; ++i) {
            Number numberval = (Number)array[i];
            retval[i] = numberval.longValue();
        }
        return retval;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ParameterSet:");
        for (int i = 0; i < this.m_params.length; ++i) {
            b.append(",param[" + i + "]=" + (this.m_params[i] == null ? "NULL" : this.m_params[i].toString() + "(" + this.m_params[i].getClass().getName() + ")"));
        }
        return new String(b);
    }

    @Override
    public String toJSONString() {
        JSONStringer js = new JSONStringer();
        try {
            js.array();
            for (Object o : this.m_params) {
                if (o instanceof Double) {
                    Double dval = (Double)o;
                    if (dval.isNaN()) {
                        js.value(dval.toString());
                        continue;
                    }
                    if (dval.isInfinite()) {
                        js.value(dval.toString());
                        continue;
                    }
                    js.value(o);
                    continue;
                }
                js.value(o);
            }
            js.endArray();
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to serialize a parameter set to JSON.", e);
        }
        return js.toString();
    }

    static Object paramFromPossibleJSON(Object value) throws JSONException, IOException {
        if (value instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)value;
            return VoltTable.fromJSONObject(jsonObj);
        }
        if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            Object[] retval = new Object[array.length()];
            for (int i = 0; i < array.length(); ++i) {
                Object valueAtIndex = array.get(i);
                retval[i] = ParameterSet.paramFromPossibleJSON(valueAtIndex);
            }
            return retval;
        }
        return value;
    }

    private static OneParamInfo readOneParameter(ByteBuffer in) throws IOException {
        String[] value;
        VoltType nextType;
        byte[] encodedString = null;
        byte[][] encodedStringArray = null;
        byte nextTypeByte = in.get();
        if (nextTypeByte == -99) {
            nextType = null;
            byte etype = in.get();
            try {
                nextType = VoltType.get(etype);
            }
            catch (AssertionError ae) {
                throw new RuntimeException("ParameterSet doesn't support type " + etype);
            }
            if (nextType == null) {
                value = null;
            } else if (nextType == VoltType.STRING) {
                encodedStringArray = (byte[][])SerializationHelper.readArray(byte[].class, in);
                String[] sval = new String[encodedStringArray.length];
                for (int i = 0; i < encodedStringArray.length; ++i) {
                    sval[i] = encodedStringArray[i] == null ? null : new String(encodedStringArray[i], Constants.UTF8ENCODING);
                }
                value = sval;
            } else {
                value = SerializationHelper.readArray(nextType.classFromType(), in);
            }
        } else {
            try {
                nextType = VoltType.get(nextTypeByte);
            }
            catch (AssertionError ae) {
                throw new RuntimeException("ParameterSet doesn't support type " + nextTypeByte);
            }
            switch (nextType) {
                case NULL: {
                    value = null;
                    break;
                }
                case TINYINT: {
                    value = in.get();
                    break;
                }
                case SMALLINT: {
                    value = in.getShort();
                    break;
                }
                case INTEGER: {
                    value = in.getInt();
                    break;
                }
                case BIGINT: {
                    value = in.getLong();
                    break;
                }
                case FLOAT: {
                    value = in.getDouble();
                    break;
                }
                case STRING: {
                    int len = in.getInt();
                    if (len == -1) {
                        value = VoltType.NULL_STRING_OR_VARBINARY;
                        break;
                    }
                    encodedString = new byte[len];
                    in.get(encodedString);
                    value = new String(encodedString, Constants.UTF8ENCODING);
                    break;
                }
                case VARBINARY: {
                    int len = in.getInt();
                    if (len == -1) {
                        value = VoltType.NULL_STRING_OR_VARBINARY;
                        break;
                    }
                    encodedString = new byte[len];
                    in.get(encodedString);
                    value = (String[])encodedString;
                    break;
                }
                case TIMESTAMP: {
                    long micros = in.getLong();
                    value = new TimestampType(micros);
                    break;
                }
                case VOLTTABLE: {
                    int tableSize = in.getInt();
                    byte[] tableBytes = new byte[tableSize];
                    in.get(tableBytes);
                    value = PrivateVoltTableFactory.createVoltTableFromBuffer(ByteBuffer.wrap(tableBytes), false);
                    break;
                }
                case DECIMAL: {
                    BigDecimal decimal_val = SerializationHelper.getBigDecimal(in);
                    if (decimal_val == null) {
                        value = VoltType.NULL_DECIMAL;
                        break;
                    }
                    value = decimal_val;
                    break;
                }
                case GEOGRAPHY_POINT: {
                    value = GeographyPointValue.unflattenFromBuffer(in);
                    if (value != null) break;
                    value = VoltType.NULL_POINT;
                    break;
                }
                case GEOGRAPHY: {
                    int len = in.getInt();
                    if (len == -1) {
                        value = VoltType.NULL_GEOGRAPHY;
                        break;
                    }
                    value = GeographyValue.unflattenFromBuffer(in);
                    break;
                }
                case BOOLEAN: {
                    value = in.get();
                    break;
                }
                default: {
                    throw new RuntimeException("ParameterSet doesn't support type " + (Object)((Object)nextType));
                }
            }
        }
        OneParamInfo retval = new OneParamInfo();
        retval.value = value;
        retval.encodedString = encodedString;
        retval.encodedStringArray = encodedStringArray;
        return retval;
    }

    public void flattenToBuffer(ByteBuffer buf) throws IOException {
        buf.putShort((short)this.m_params.length);
        block28: for (int i = 0; i < this.m_params.length; ++i) {
            VoltType type;
            DBBPool.BBContainer cont;
            Object obj = this.m_params[i];
            if (obj == null || obj == JSONObject.NULL) {
                VoltType type2 = VoltType.NULL;
                buf.put(type2.getValue());
                continue;
            }
            Class<?> cls = obj.getClass();
            if (ByteBuffer.class.isAssignableFrom(cls)) {
                ByteBuffer bb = (ByteBuffer)obj;
                buf.put(VoltType.VARBINARY.getValue());
                buf.putInt(bb.capacity());
                byte[] b = bb.array();
                buf.put(b);
                continue;
            }
            if (cls.isArray()) {
                if (obj instanceof byte[] || obj instanceof Byte[]) {
                    byte[] b = obj instanceof Byte[] ? ArrayUtils.toPrimitive((Byte[])((Byte[])obj)) : (byte[])obj;
                    buf.put(VoltType.VARBINARY.getValue());
                    buf.putInt(b.length);
                    buf.put(b);
                    continue;
                }
                if (obj instanceof DBBPool.BBContainer) {
                    cont = (DBBPool.BBContainer)obj;
                    ByteBuffer paramBuf = cont.b();
                    buf.put(VoltType.VARBINARY.getValue());
                    buf.putInt(paramBuf.remaining());
                    buf.put(paramBuf);
                    continue;
                }
                buf.put((byte)-99);
                try {
                    type = VoltType.typeFromClass(cls.getComponentType());
                }
                catch (VoltTypeException e) {
                    obj = ParameterSet.getAKosherArray((Object[])obj);
                    cls = obj.getClass();
                    type = VoltType.typeFromClass(cls.getComponentType());
                }
                buf.put(type.getValue());
                switch (type) {
                    case SMALLINT: {
                        if (obj instanceof Short[]) {
                            SerializationHelper.writeArray(ArrayUtils.toPrimitive((Short[])((Short[])obj)), buf);
                            continue block28;
                        }
                        SerializationHelper.writeArray((short[])obj, buf);
                        continue block28;
                    }
                    case INTEGER: {
                        if (obj instanceof Integer[]) {
                            SerializationHelper.writeArray(ArrayUtils.toPrimitive((Integer[])((Integer[])obj)), buf);
                            continue block28;
                        }
                        SerializationHelper.writeArray((int[])obj, buf);
                        continue block28;
                    }
                    case BIGINT: {
                        if (obj instanceof Long[]) {
                            SerializationHelper.writeArray(ArrayUtils.toPrimitive((Long[])((Long[])obj)), buf);
                            continue block28;
                        }
                        SerializationHelper.writeArray((long[])obj, buf);
                        continue block28;
                    }
                    case FLOAT: {
                        if (obj instanceof Double[]) {
                            SerializationHelper.writeArray(ArrayUtils.toPrimitive((Double[])((Double[])obj)), buf);
                            continue block28;
                        }
                        SerializationHelper.writeArray((double[])obj, buf);
                        continue block28;
                    }
                    case STRING: {
                        if (this.m_encodedStringArrays[i] == null) {
                            throw new IOException("String array not encoded");
                        }
                        if (this.m_encodedStringArrays[i].length > Short.MAX_VALUE) {
                            throw new IOException("Array exceeds maximum length of 32767 bytes");
                        }
                        buf.putShort((short)this.m_encodedStringArrays[i].length);
                        for (int zz = 0; zz < this.m_encodedStringArrays[i].length; ++zz) {
                            SerializationHelper.writeVarbinary(this.m_encodedStringArrays[i][zz], buf);
                        }
                        continue block28;
                    }
                    case TIMESTAMP: {
                        SerializationHelper.writeArray((TimestampType[])obj, buf);
                        continue block28;
                    }
                    case DECIMAL: {
                        SerializationHelper.writeArray((BigDecimal[])obj, buf);
                        continue block28;
                    }
                    case VOLTTABLE: {
                        SerializationHelper.writeArray((VoltTable[])obj, buf);
                        continue block28;
                    }
                    case VARBINARY: {
                        if (obj instanceof Byte[][]) {
                            Byte[][] boxByteBuf = (Byte[][])obj;
                            int byteLen = boxByteBuf.length;
                            byte[][] byteBuf = new byte[byteLen][];
                            for (int ii = 0; ii < byteLen; ++ii) {
                                byteBuf[ii] = ArrayUtils.toPrimitive((Byte[])boxByteBuf[ii]);
                            }
                            SerializationHelper.writeArray(byteBuf, buf);
                            continue block28;
                        }
                        SerializationHelper.writeArray((byte[][])obj, buf);
                        continue block28;
                    }
                    case GEOGRAPHY_POINT: {
                        SerializationHelper.writeArray((GeographyPointValue[])obj, buf);
                        continue block28;
                    }
                    case GEOGRAPHY: {
                        SerializationHelper.writeArray((GeographyValue[])obj, buf);
                        continue block28;
                    }
                    default: {
                        throw new RuntimeException("FIXME: Unsupported type " + (Object)((Object)type));
                    }
                }
            }
            if (obj == VoltType.NULL_TIMESTAMP) {
                buf.put(VoltType.TIMESTAMP.getValue());
                buf.putLong(Long.MIN_VALUE);
                continue;
            }
            if (obj == VoltType.NULL_STRING_OR_VARBINARY) {
                buf.put(VoltType.STRING.getValue());
                buf.putInt(-1);
                continue;
            }
            if (obj == VoltType.NULL_DECIMAL) {
                buf.put(VoltType.DECIMAL.getValue());
                VoltDecimalHelper.serializeNull(buf);
                continue;
            }
            if (obj == VoltType.NULL_POINT) {
                buf.put(VoltType.GEOGRAPHY_POINT.getValue());
                GeographyPointValue.serializeNull(buf);
                continue;
            }
            if (obj == VoltType.NULL_GEOGRAPHY) {
                buf.put(VoltType.GEOGRAPHY.getValue());
                buf.putInt(-1);
                continue;
            }
            if (obj instanceof DBBPool.BBContainer) {
                cont = (DBBPool.BBContainer)obj;
                ByteBuffer paramBuf = cont.b();
                buf.put(VoltType.VARBINARY.getValue());
                buf.putInt(paramBuf.remaining());
                buf.put(paramBuf);
                continue;
            }
            type = VoltType.typeFromClass(cls);
            buf.put(type.getValue());
            switch (type) {
                case TINYINT: {
                    buf.put((Byte)obj);
                    continue block28;
                }
                case SMALLINT: {
                    buf.putShort((Short)obj);
                    continue block28;
                }
                case INTEGER: {
                    buf.putInt((Integer)obj);
                    continue block28;
                }
                case BIGINT: {
                    buf.putLong((Long)obj);
                    continue block28;
                }
                case FLOAT: {
                    if (cls == Float.class) {
                        buf.putDouble(((Float)obj).doubleValue());
                        continue block28;
                    }
                    if (cls == Double.class) {
                        buf.putDouble((Double)obj);
                        continue block28;
                    }
                    throw new RuntimeException("Can't cast parameter type to Double");
                }
                case STRING: {
                    if (this.m_encodedStrings[i] == null) {
                        throw new IOException("String not encoded: " + (String)obj);
                    }
                    SerializationHelper.writeVarbinary(this.m_encodedStrings[i], buf);
                    continue block28;
                }
                case TIMESTAMP: {
                    long micros = ParameterSet.timestampToMicroseconds(obj);
                    buf.putLong(micros);
                    continue block28;
                }
                case DECIMAL: {
                    VoltDecimalHelper.serializeBigDecimal((BigDecimal)obj, buf);
                    continue block28;
                }
                case VOLTTABLE: {
                    ((VoltTable)obj).flattenToBuffer(buf);
                    continue block28;
                }
                case GEOGRAPHY_POINT: {
                    ((GeographyPointValue)obj).flattenToBuffer(buf);
                    continue block28;
                }
                case GEOGRAPHY: {
                    GeographyValue gv = (GeographyValue)obj;
                    buf.putInt(gv.getLengthInBytes());
                    gv.flattenToBuffer(buf);
                    continue block28;
                }
                default: {
                    throw new RuntimeException("FIXME: Unsupported type " + (Object)((Object)type));
                }
            }
        }
    }

    static long timestampToMicroseconds(Object obj) {
        long micros = 0L;
        if (obj instanceof Date) {
            micros = ((Date)obj).getTime() * 1000L;
            if (obj instanceof Timestamp) {
                long nanos = ((Timestamp)obj).getNanos();
                if (nanos % 1000L != 0L) {
                    throw new RuntimeException("Can't serialize TIMESTAMP value with fractional microseconds");
                }
                micros += nanos % 1000000L / 1000L;
            }
        } else if (obj instanceof TimestampType) {
            micros = ((TimestampType)obj).getTime();
        }
        return micros;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParameterSet)) {
            return false;
        }
        return Arrays.deepEquals(this.m_params, ((ParameterSet)obj).m_params);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    static class OneParamInfo {
        Object value;
        byte[] encodedString;
        byte[][] encodedStringArray;

        OneParamInfo() {
        }
    }
}

