/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.zip.CRC32;
import org.apache.hadoop_voltpatches.util.PureJavaCrc32;
import org.json_voltpatches.JSONArray;
import org.json_voltpatches.JSONException;
import org.json_voltpatches.JSONObject;
import org.json_voltpatches.JSONString;
import org.json_voltpatches.JSONStringer;
import org.voltdb.ParameterSet;
import org.voltdb.VoltOverflowException;
import org.voltdb.VoltTableRow;
import org.voltdb.VoltType;
import org.voltdb.VoltTypeException;
import org.voltdb.common.Constants;
import org.voltdb.types.GeographyPointValue;
import org.voltdb.types.GeographyValue;
import org.voltdb.types.TimestampType;
import org.voltdb.types.VoltDecimalHelper;
import org.voltdb.utils.Encoder;

public final class VoltTable
extends VoltTableRow
implements JSONString {
    public static final int MAX_SERIALIZED_TABLE_LENGTH = 0xA00000;
    public static final String MAX_SERIALIZED_TABLE_LENGTH_STR = String.valueOf(10240) + "k";
    static final int NULL_STRING_INDICATOR = -1;
    static final Charset METADATA_ENCODING = Constants.US_ASCII_ENCODING;
    static final Charset ROWDATA_ENCODING = Constants.UTF8ENCODING;
    boolean m_readOnly = false;
    int m_rowStart = -1;
    int m_rowCount = -1;
    int m_colCount = -1;
    private static final int NO_MEMOIZED_ROW_OFFSET = Integer.MIN_VALUE;
    private int m_memoizedRowOffset = Integer.MIN_VALUE;
    private int m_memoizedBufferOffset;
    private HashMap<String, Integer> m_columnNameIndexMap;
    static final String JSON_NAME_KEY = "name";
    static final String JSON_TYPE_KEY = "type";
    static final String JSON_SCHEMA_KEY = "schema";
    static final String JSON_DATA_KEY = "data";
    static final String JSON_STATUS_KEY = "status";
    private static final int POS_COL_COUNT = 5;
    private static final int POS_COL_TYPES = 7;
    final ExtraMetadata m_extraMetadata;
    byte[] m_schemaString = null;

    VoltTable() {
        this((ExtraMetadata)null);
    }

    VoltTable(ExtraMetadata extraMetadata) {
        this.m_extraMetadata = extraMetadata;
    }

    VoltTable(ByteBuffer backing, boolean readOnly) {
        this.m_extraMetadata = null;
        this.m_buffer = backing;
        this.m_rowStart = this.m_buffer.getInt(0) + 4;
        this.m_colCount = this.m_buffer.getShort(5);
        this.m_rowCount = this.m_buffer.getInt(this.m_rowStart);
        this.m_buffer.position(this.m_buffer.limit());
        this.m_readOnly = readOnly;
        assert (this.verifyTableInvariants());
    }

    public VoltTable(ColumnInfo[] columns, int columnCount) {
        this(null, columns, columnCount);
    }

    public VoltTable(ColumnInfo[] columns) {
        this(null, columns, columns.length);
    }

    private static ColumnInfo[] prependColumn(ColumnInfo firstColumn, ColumnInfo[] columns) {
        int allLen = 1 + columns.length;
        ColumnInfo[] allColumns = new ColumnInfo[allLen];
        allColumns[0] = firstColumn;
        for (int i = 0; i < columns.length; ++i) {
            allColumns[i + 1] = columns[i];
        }
        return allColumns;
    }

    public VoltTable(ColumnInfo firstColumn, ColumnInfo ... columns) {
        this(VoltTable.prependColumn(firstColumn, columns));
    }

    VoltTable(ExtraMetadata extraMetadata, ColumnInfo[] columns, int columnCount) {
        this.m_extraMetadata = extraMetadata;
        int allocationSize = 1024;
        this.m_buffer = ByteBuffer.allocate(allocationSize);
        boolean success = false;
        while (!success) {
            try {
                int i;
                this.m_colCount = columnCount;
                this.m_rowCount = 0;
                if (columns == null) {
                    throw new RuntimeException("VoltTable(..) constructor passed null schema.");
                }
                if (columnCount <= 0) {
                    throw new RuntimeException("VoltTable(..) constructor requires at least one column.");
                }
                if (columns.length < columnCount) {
                    throw new RuntimeException("VoltTable(..) constructor passed truncated column schema array.");
                }
                this.m_buffer.putInt(0);
                this.m_buffer.put((byte)-128);
                this.m_buffer.putShort((short)columnCount);
                for (i = 0; i < columnCount; ++i) {
                    this.m_buffer.put(columns[i].type.getValue());
                }
                for (i = 0; i < columnCount; ++i) {
                    if (columns[i].name == null) {
                        this.m_buffer.position(0);
                        throw new IllegalArgumentException("VoltTable column names can not be null.");
                    }
                    this.writeStringToBuffer(columns[i].name, METADATA_ENCODING, this.m_buffer);
                }
                this.m_rowStart = this.m_buffer.position();
                this.m_buffer.putInt(0, this.m_rowStart - 4);
                this.m_buffer.putInt(0);
                this.m_buffer.limit(this.m_buffer.position());
                success = true;
            }
            catch (BufferOverflowException e) {
                this.m_buffer = ByteBuffer.allocate(allocationSize *= 4);
            }
        }
        assert (this.verifyTableInvariants());
    }

    public final void clearRowData() {
        assert (this.verifyTableInvariants());
        this.m_buffer.position(this.m_rowStart);
        this.m_buffer.putInt(0);
        this.m_rowCount = 0;
        this.m_activeRowIndex = -1;
        assert (this.verifyTableInvariants());
    }

    @Override
    public VoltTableRow cloneRow() {
        Row retval = new Row(this.m_position);
        retval.m_hasCalculatedOffsets = this.m_hasCalculatedOffsets;
        retval.m_wasNull = this.m_wasNull;
        if (this.m_offsets != null) {
            for (int i = 0; i < this.m_colCount; ++i) {
                retval.m_offsets[i] = this.m_offsets[i];
            }
        }
        retval.m_activeRowIndex = this.m_activeRowIndex;
        return retval;
    }

    @Override
    byte[] getSchemaString() {
        if (this.m_schemaString != null) {
            return this.m_schemaString;
        }
        this.m_schemaString = new byte[this.m_colCount];
        int pos = this.m_buffer.position();
        this.m_buffer.position(7);
        this.m_buffer.get(this.m_schemaString);
        this.m_buffer.position(pos);
        return this.m_schemaString;
    }

    public final String getColumnName(int index) {
        assert (this.verifyTableInvariants());
        if (index < 0 || index >= this.m_colCount) {
            throw new IllegalArgumentException("Not a valid column index.");
        }
        int pos = 7 + this.m_colCount;
        String name = null;
        for (int i = 0; i < index; ++i) {
            pos += this.m_buffer.getInt(pos) + 4;
        }
        name = this.readString(pos, METADATA_ENCODING);
        assert (name != null);
        assert (this.verifyTableInvariants());
        return name;
    }

    @Override
    public final VoltType getColumnType(int index) {
        assert (this.verifyTableInvariants());
        assert (index < this.m_colCount);
        VoltType retval = VoltType.get(this.m_buffer.get(7 + index));
        assert (this.verifyTableInvariants());
        return retval;
    }

    final boolean getColumnNullable(int index) {
        if (this.m_extraMetadata != null) {
            return this.m_extraMetadata.originalColumnInfos[index].nullable;
        }
        return true;
    }

    final int getColumnMaxSize(int index) {
        if (this.m_extraMetadata != null) {
            return this.m_extraMetadata.originalColumnInfos[index].size;
        }
        return 0x100000;
    }

    final int getColumnPkeyIndex(int index) {
        if (this.m_extraMetadata != null) {
            for (int i = 0; i < this.m_extraMetadata.pkeyIndexes.length; ++i) {
                if (this.m_extraMetadata.pkeyIndexes[i] != index) continue;
                return i;
            }
        }
        return -1;
    }

    final int[] getPkeyColumnIndexes() {
        if (this.m_extraMetadata != null && this.m_extraMetadata.pkeyIndexes != null) {
            return this.m_extraMetadata.pkeyIndexes;
        }
        return new int[0];
    }

    final boolean getColumnUniqueness(int index) {
        if (this.m_extraMetadata != null) {
            return this.m_extraMetadata.originalColumnInfos[index].unique;
        }
        return false;
    }

    final String getColumnDefaultValue(int index) {
        if (this.m_extraMetadata != null) {
            return this.m_extraMetadata.originalColumnInfos[index].defaultValue;
        }
        return null;
    }

    @Override
    public final int getColumnIndex(String name) {
        Integer cachedIndex;
        if (this.m_columnNameIndexMap == null) {
            this.m_columnNameIndexMap = new HashMap(this.m_colCount);
            for (int i = 0; i < this.m_colCount; ++i) {
                this.m_columnNameIndexMap.put(this.getColumnName(i).toUpperCase(), i);
            }
        }
        if ((cachedIndex = this.m_columnNameIndexMap.get(name.toUpperCase())) == null) {
            String msg = "No Column named '" + name + "'. Existing columns are:";
            for (int i = 0; i < this.m_colCount; ++i) {
                msg = msg + "[" + i + "]" + this.getColumnName(i) + ",";
            }
            throw new IllegalArgumentException(msg);
        }
        return cachedIndex;
    }

    public final VoltTableRow fetchRow(int index) {
        assert (this.verifyTableInvariants());
        if (index < 0 || index >= this.m_rowCount) {
            throw new IndexOutOfBoundsException("index = " + index + "; rows = " + this.m_rowCount);
        }
        if (this.m_memoizedRowOffset == Integer.MIN_VALUE || index < this.m_memoizedRowOffset) {
            this.m_memoizedRowOffset = 0;
            this.m_memoizedBufferOffset = this.m_rowStart + 4;
        }
        while (this.m_memoizedRowOffset < index) {
            this.m_memoizedBufferOffset += this.m_buffer.getInt(this.m_memoizedBufferOffset) + 4;
            ++this.m_memoizedRowOffset;
        }
        Row retval = new Row(this.m_memoizedBufferOffset + 4);
        retval.m_activeRowIndex = index;
        return retval;
    }

    private void addColumnValue(Object value, VoltType columnType, int col) {
        block47: {
            int maxColSize;
            block46: {
                boolean allowNulls = true;
                maxColSize = 0x100000;
                if (this.m_extraMetadata != null) {
                    allowNulls = this.m_extraMetadata.originalColumnInfos[col].nullable;
                    maxColSize = this.m_extraMetadata.originalColumnInfos[col].size;
                }
                if (!VoltType.isVoltNullValue(value)) break block46;
                if (!allowNulls) {
                    throw new IllegalArgumentException(String.format("Column %s at index %d doesn't allow NULL values.", this.getColumnName(col), col));
                }
                switch (columnType) {
                    case TINYINT: {
                        this.m_buffer.put((byte)-128);
                        break block47;
                    }
                    case SMALLINT: {
                        this.m_buffer.putShort((short)Short.MIN_VALUE);
                        break block47;
                    }
                    case INTEGER: {
                        this.m_buffer.putInt(Integer.MIN_VALUE);
                        break block47;
                    }
                    case TIMESTAMP: {
                        this.m_buffer.putLong(Long.MIN_VALUE);
                        break block47;
                    }
                    case BIGINT: {
                        this.m_buffer.putLong(Long.MIN_VALUE);
                        break block47;
                    }
                    case FLOAT: {
                        this.m_buffer.putDouble(-1.7E308);
                        break block47;
                    }
                    case STRING: 
                    case GEOGRAPHY: 
                    case VARBINARY: {
                        this.m_buffer.putInt(-1);
                        break block47;
                    }
                    case GEOGRAPHY_POINT: {
                        GeographyPointValue.serializeNull(this.m_buffer);
                        break block47;
                    }
                    case DECIMAL: {
                        VoltDecimalHelper.serializeNull(this.m_buffer);
                        break block47;
                    }
                    default: {
                        throw new VoltTypeException("Unsupported type: " + (Object)((Object)columnType));
                    }
                }
            }
            try {
                switch (columnType) {
                    case TINYINT: {
                        if (value instanceof BigDecimal) {
                            throw new ClassCastException();
                        }
                        Number n1 = (Number)value;
                        if (columnType.wouldCastOverflow(n1)) {
                            throw new VoltTypeException("Cast of " + n1.doubleValue() + " to " + columnType.toString() + " would overflow");
                        }
                        this.m_buffer.put(n1.byteValue());
                        break;
                    }
                    case SMALLINT: {
                        if (value instanceof BigDecimal) {
                            throw new ClassCastException();
                        }
                        Number n2 = (Number)value;
                        if (columnType.wouldCastOverflow(n2)) {
                            throw new VoltTypeException("Cast to " + columnType.toString() + " would overflow");
                        }
                        this.m_buffer.putShort(n2.shortValue());
                        break;
                    }
                    case INTEGER: {
                        if (value instanceof BigDecimal) {
                            throw new ClassCastException();
                        }
                        Number n3 = (Number)value;
                        if (columnType.wouldCastOverflow(n3)) {
                            throw new VoltTypeException("Cast to " + columnType.toString() + " would overflow");
                        }
                        this.m_buffer.putInt(n3.intValue());
                        break;
                    }
                    case BIGINT: {
                        if (value instanceof BigDecimal) {
                            throw new ClassCastException();
                        }
                        Number n4 = (Number)value;
                        if (columnType.wouldCastOverflow(n4)) {
                            throw new VoltTypeException("Cast to " + columnType.toString() + " would overflow");
                        }
                        this.m_buffer.putLong(n4.longValue());
                        break;
                    }
                    case FLOAT: {
                        if (value instanceof BigDecimal) {
                            throw new ClassCastException();
                        }
                        Number n5 = (Number)value;
                        if (columnType.wouldCastOverflow(n5)) {
                            throw new VoltTypeException("Cast to " + columnType.toString() + " would overflow");
                        }
                        this.m_buffer.putDouble(n5.doubleValue());
                        break;
                    }
                    case STRING: {
                        if (value instanceof byte[]) {
                            if (((byte[])value).length > maxColSize) {
                                throw new VoltOverflowException("Value in VoltTable.addRow(...) larger than allowed max " + VoltType.humanReadableSize(maxColSize));
                            }
                            assert (this.testForUTF8Encoding((byte[])value));
                            this.writeStringOrVarbinaryToBuffer((byte[])value, this.m_buffer);
                            break;
                        }
                        if (((String)value).length() > maxColSize) {
                            throw new VoltOverflowException("Value in VoltTable.addRow(...) larger than allowed max " + VoltType.humanReadableSize(maxColSize));
                        }
                        this.writeStringToBuffer((String)value, ROWDATA_ENCODING, this.m_buffer);
                        break;
                    }
                    case VARBINARY: {
                        if (value instanceof String) {
                            value = Encoder.hexDecode((String)value);
                        }
                        if (value instanceof byte[]) {
                            if (((byte[])value).length > maxColSize) {
                                throw new VoltOverflowException("Value in VoltTable.addRow(...) larger than allowed max " + VoltType.humanReadableSize(maxColSize));
                            }
                            this.writeStringOrVarbinaryToBuffer((byte[])value, this.m_buffer);
                            break;
                        }
                        throw new ClassCastException();
                    }
                    case GEOGRAPHY: {
                        GeographyValue gv = (GeographyValue)value;
                        this.m_buffer.putInt(gv.getLengthInBytes());
                        gv.flattenToBuffer(this.m_buffer);
                        break;
                    }
                    case GEOGRAPHY_POINT: {
                        GeographyPointValue pt = (GeographyPointValue)value;
                        pt.flattenToBuffer(this.m_buffer);
                        break;
                    }
                    case TIMESTAMP: {
                        if (value instanceof BigDecimal) {
                            throw new ClassCastException();
                        }
                        long micros = value instanceof Date || value instanceof TimestampType ? ParameterSet.timestampToMicroseconds(value) : ((Number)value).longValue();
                        this.m_buffer.putLong(micros);
                        break;
                    }
                    case DECIMAL: {
                        VoltDecimalHelper.serializeBigDecimal((BigDecimal)value, this.m_buffer);
                        break;
                    }
                    default: {
                        throw new VoltTypeException("Unsupported type: " + (Object)((Object)columnType));
                    }
                }
            }
            catch (ClassCastException cce) {
                throw new VoltTypeException("Value for column " + col + " (" + this.getColumnName(col) + ") is type " + value.getClass().getSimpleName() + " when type " + (Object)((Object)columnType) + " was expected.");
            }
        }
    }

    public final void add(VoltTableRow row) {
        assert (this.verifyTableInvariants());
        if (this.m_readOnly) {
            throw new IllegalStateException("Table is read-only. Make a copy before changing.");
        }
        if (this.m_colCount == 0) {
            throw new IllegalStateException("Table has no columns defined");
        }
        if (row.getColumnCount() != this.m_colCount) {
            throw new IllegalArgumentException(row.getColumnCount() + " arguments but table has " + this.m_colCount + " columns");
        }
        int pos = this.m_buffer.position();
        try {
            boolean canDoRawCopy;
            this.m_buffer.limit(this.m_buffer.capacity());
            byte[] inboundSchemaString = row.getSchemaString();
            byte[] mySchemaString = this.getSchemaString();
            boolean bl = canDoRawCopy = inboundSchemaString == mySchemaString || Arrays.equals(inboundSchemaString, mySchemaString);
            if (canDoRawCopy) {
                this.m_schemaString = inboundSchemaString;
                ByteBuffer rawRow = row.getRawRow();
                this.m_buffer.put(rawRow);
            } else {
                this.m_buffer.position(pos + 4);
                for (int i = 0; i < this.m_colCount; ++i) {
                    VoltType outboundType;
                    VoltType inboundType = row.getColumnType(i);
                    if (inboundType == (outboundType = this.getColumnType(i))) {
                        byte[] raw = row.getRaw(i);
                        this.m_buffer.put(raw);
                        continue;
                    }
                    Object inboundValue = row.get(i, inboundType);
                    this.addColumnValue(inboundValue, outboundType, i);
                }
                int rowsize = this.m_buffer.position() - pos - 4;
                assert (rowsize >= 0);
                if (rowsize > 0x200000) {
                    throw new VoltOverflowException("Table row total length larger than allowed max " + VoltTableRow.MAX_TUPLE_LENGTH_STR);
                }
                this.m_buffer.putInt(pos, rowsize);
            }
            this.m_buffer.limit(this.m_buffer.position());
            ++this.m_rowCount;
            this.m_buffer.putInt(this.m_rowStart, this.m_rowCount);
        }
        catch (VoltTypeException vte) {
            this.m_buffer.position(pos);
            throw vte;
        }
        catch (BufferOverflowException e) {
            this.m_buffer.position(pos);
            this.expandBuffer();
            this.add(row);
        }
        catch (VoltOverflowException e) {
            this.m_buffer.position(pos);
            throw e;
        }
        catch (IllegalArgumentException e) {
            if (this.m_buffer.limit() - this.m_buffer.position() < 32) {
                this.m_buffer.position(pos);
                this.expandBuffer();
                this.add(row);
            }
            throw e;
        }
        assert (this.verifyTableInvariants());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRow(Object ... values) {
        block18: {
            assert (this.verifyTableInvariants());
            if (this.m_readOnly) {
                throw new IllegalStateException("Table is read-only. Make a copy before changing.");
            }
            if (this.m_colCount == 0) {
                throw new IllegalStateException("Table has no columns defined");
            }
            if (values.length != this.m_colCount) {
                throw new IllegalArgumentException(values.length + " arguments but table has " + this.m_colCount + " columns");
            }
            int pos = this.m_buffer.position();
            try {
                this.m_buffer.limit(this.m_buffer.capacity());
                this.m_buffer.position(pos + 4);
                int typePos = 7;
                for (int col = 0; col < this.m_colCount; ++col) {
                    Object value = values[col];
                    VoltType columnType = VoltType.get(this.m_buffer.get(typePos + col));
                    this.addColumnValue(value, columnType, col);
                }
                int rowsize = this.m_buffer.position() - pos - 4;
                assert (rowsize >= 0);
                if (rowsize > 0x200000) {
                    throw new VoltOverflowException("Table row total length larger than allowed max " + VoltTableRow.MAX_TUPLE_LENGTH_STR);
                }
                this.m_buffer.putInt(pos, rowsize);
                ++this.m_rowCount;
                this.m_buffer.putInt(this.m_rowStart, this.m_rowCount);
            }
            catch (VoltTypeException vte) {
                this.m_buffer.position(pos);
                throw vte;
            }
            catch (BufferOverflowException e) {
                this.m_buffer.position(pos);
                this.expandBuffer();
                this.addRow(values);
            }
            catch (VoltOverflowException e) {
                this.m_buffer.position(pos);
                throw e;
            }
            catch (IllegalArgumentException e) {
                this.m_buffer.position(pos);
                if (this.m_buffer.limit() - this.m_buffer.position() < 32) {
                    this.expandBuffer();
                    this.addRow(values);
                    break block18;
                }
                throw e;
            }
            finally {
                this.m_buffer.limit(this.m_buffer.position());
            }
        }
        assert (this.verifyTableInvariants());
    }

    private final void expandBuffer() {
        this.expandBuffer(0);
    }

    private final void expandBuffer(int minSize) {
        int newSize = this.m_buffer.capacity();
        while ((newSize <<= 1) < minSize) {
        }
        this.expandBufferTo(newSize);
    }

    private void expandBufferTo(int newSize) {
        int end = this.m_buffer.position();
        assert (end > this.m_rowStart);
        ByteBuffer buf2 = ByteBuffer.allocate(newSize);
        this.m_buffer.limit(end);
        this.m_buffer.position(0);
        buf2.put(this.m_buffer);
        this.m_buffer = buf2;
    }

    public final long asScalarLong() {
        this.verifyTableInvariants();
        if (this.m_rowCount != 1) {
            throw new IllegalStateException("table must contain exactly 1 tuple; tuples = " + this.m_rowCount);
        }
        if (this.m_colCount != 1) {
            throw new IllegalStateException("table must contain exactly 1 column; columns = " + this.m_colCount);
        }
        VoltType colType = this.getColumnType(0);
        switch (colType) {
            case TINYINT: {
                byte tinyInt = this.m_buffer.get(this.m_rowStart + 8);
                this.m_wasNull = tinyInt == -128;
                return tinyInt;
            }
            case SMALLINT: {
                short smallInt = this.m_buffer.getShort(this.m_rowStart + 8);
                this.m_wasNull = smallInt == Short.MIN_VALUE;
                return smallInt;
            }
            case INTEGER: {
                int integer = this.m_buffer.getInt(this.m_rowStart + 8);
                this.m_wasNull = integer == Integer.MIN_VALUE;
                return integer;
            }
            case BIGINT: {
                long bigInt = this.m_buffer.getLong(this.m_rowStart + 8);
                this.m_wasNull = bigInt == Long.MIN_VALUE;
                return bigInt;
            }
        }
        throw new IllegalStateException("table must contain exactly 1 integral value; column 1 is type = " + colType.name());
    }

    public void addTable(VoltTable other) {
        if (this.m_readOnly) {
            throw new IllegalStateException("Table is read-only. Make a copy before changing.");
        }
        this.checkHasExactSchema(other);
        this.m_buffer.limit(this.m_buffer.capacity());
        ByteBuffer rawRows = other.getAllRowsRaw();
        if (this.m_buffer.remaining() < rawRows.remaining()) {
            this.expandBuffer(this.m_buffer.capacity() - this.m_buffer.remaining() + rawRows.remaining());
        }
        this.m_buffer.put(rawRows);
        this.m_buffer.limit(this.m_buffer.position());
        this.m_rowCount += other.getRowCount();
        this.m_buffer.putInt(this.m_rowStart, this.m_rowCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTables(Collection<VoltTable> tables) {
        if (this.m_readOnly) {
            throw new IllegalStateException("Table is read-only. Make a copy before changing.");
        }
        try {
            this.m_buffer.limit(this.m_buffer.capacity());
            ArrayList<ByteBuffer> rawTables = new ArrayList<ByteBuffer>(tables.size());
            int totalRawSize = 0;
            int newRowCounts = 0;
            for (VoltTable table : tables) {
                if (table == null) continue;
                this.checkHasExactSchema(table);
                ByteBuffer rawTable = table.getAllRowsRaw();
                rawTables.add(rawTable);
                totalRawSize += rawTable.remaining();
                newRowCounts += table.getRowCount();
            }
            if (this.m_buffer.remaining() < totalRawSize) {
                this.expandBufferTo(this.m_buffer.position() + totalRawSize);
            }
            for (ByteBuffer rawTable : rawTables) {
                this.m_buffer.put(rawTable);
            }
            this.m_rowCount += newRowCounts;
            this.m_buffer.putInt(this.m_rowStart, this.m_rowCount);
        }
        finally {
            this.m_buffer.limit(this.m_buffer.position());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer getAllRowsRaw() {
        int origPosition = this.m_buffer.position();
        int start = this.m_rowStart + 4;
        try {
            this.m_buffer.position(start);
            ByteBuffer byteBuffer = this.m_buffer.slice();
            return byteBuffer;
        }
        finally {
            this.m_buffer.position(origPosition);
        }
    }

    private void checkHasExactSchema(VoltTable other) {
        if (!this.hasExactSchema(other)) {
            StringBuilder sb = new StringBuilder("Could not merge table with schema ");
            other.getColumnString(sb).append(" into ");
            throw new IllegalArgumentException(this.getColumnString(sb).toString());
        }
    }

    private boolean hasExactSchema(VoltTable other) {
        if (this.getColumnCount() != other.getColumnCount() || this.m_rowStart != other.m_rowStart) {
            return false;
        }
        ByteBuffer myDup = this.m_buffer.duplicate();
        myDup.position(7).limit(this.m_rowStart);
        ByteBuffer otherDup = other.m_buffer.duplicate();
        otherDup.position(7).limit(this.m_rowStart);
        return myDup.equals(otherDup);
    }

    private StringBuilder getColumnString(StringBuilder buffer) {
        short colCount = this.m_buffer.getShort(5);
        buffer.append(" column count: ").append(colCount).append('\n');
        assert (colCount == this.m_colCount);
        for (int i = 0; i < this.m_colCount; ++i) {
            buffer.append('(').append(this.getColumnName(i)).append(':').append(this.getColumnType(i).name()).append("), ");
        }
        return buffer;
    }

    public String toString() {
        assert (this.verifyTableInvariants());
        StringBuilder buffer = new StringBuilder();
        buffer.append(" header size: ").append(this.m_buffer.getInt(0)).append("\n");
        byte statusCode = this.m_buffer.get(4);
        buffer.append(" status code: ").append(statusCode);
        this.getColumnString(buffer);
        buffer.append(" rows -\n");
        VoltTableRow r = this.cloneRow();
        r.resetRowPosition();
        while (r.advanceRow()) {
            buffer.append("  ");
            for (int i = 0; i < this.m_colCount; ++i) {
                switch (this.getColumnType(i)) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: {
                        long lval = r.getLong(i);
                        if (r.wasNull()) {
                            buffer.append("NULL");
                            break;
                        }
                        buffer.append(lval);
                        break;
                    }
                    case FLOAT: {
                        double dval = r.getDouble(i);
                        if (r.wasNull()) {
                            buffer.append("NULL");
                            break;
                        }
                        buffer.append(dval);
                        break;
                    }
                    case TIMESTAMP: {
                        TimestampType tstamp = r.getTimestampAsTimestamp(i);
                        if (r.wasNull()) {
                            buffer.append("NULL");
                            assert (tstamp == null);
                            break;
                        }
                        buffer.append(tstamp);
                        break;
                    }
                    case STRING: {
                        String string = r.getString(i);
                        if (r.wasNull()) {
                            buffer.append("NULL");
                            assert (string == null);
                            break;
                        }
                        buffer.append(string);
                        break;
                    }
                    case VARBINARY: {
                        byte[] bin = r.getVarbinary(i);
                        if (r.wasNull()) {
                            buffer.append("NULL");
                            assert (bin == null);
                            break;
                        }
                        buffer.append(VoltTable.varbinaryToPrintableString(bin));
                        break;
                    }
                    case DECIMAL: {
                        BigDecimal bd = r.getDecimalAsBigDecimal(i);
                        if (r.wasNull()) {
                            buffer.append("NULL");
                            assert (bd == null);
                            break;
                        }
                        buffer.append(bd.toString());
                        break;
                    }
                    case GEOGRAPHY_POINT: {
                        GeographyPointValue pt = r.getGeographyPointValue(i);
                        if (r.wasNull()) {
                            buffer.append("NULL");
                            break;
                        }
                        buffer.append(pt.toString());
                        break;
                    }
                    case GEOGRAPHY: {
                        GeographyValue gv = r.getGeographyValue(i);
                        if (r.wasNull()) {
                            buffer.append("NULL");
                            break;
                        }
                        buffer.append(gv.toString());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Table column had unexpected type.");
                    }
                }
                if (i >= this.m_colCount - 1) continue;
                buffer.append(",");
            }
            buffer.append("\n");
        }
        assert (this.verifyTableInvariants());
        return buffer.toString();
    }

    public static String varbinaryToPrintableString(byte[] bin) {
        PureJavaCrc32 crc = new PureJavaCrc32();
        StringBuilder sb = new StringBuilder();
        sb.append("bin[crc:");
        crc.update(bin);
        sb.append(crc.getValue());
        sb.append(",value:0x");
        String hex = Encoder.hexEncode(bin);
        if (hex.length() > 13) {
            sb.append(hex.substring(0, 10));
            sb.append("...");
        } else {
            sb.append(hex);
        }
        sb.append("]");
        return sb.toString();
    }

    public String toFormattedString() {
        return this.toFormattedString(true);
    }

    public String toFormattedString(boolean includeColumnNames) {
        VoltType colType;
        int i;
        int i2;
        int MAX_PRINTABLE_CHARS = 90;
        int MAX_PRINTABLE_CHARS_GEOGRAPHY = 74;
        String ELLIPSIS = "...";
        String DECIMAL_FORMAT = "%01.12f";
        StringBuffer sb = new StringBuffer();
        int columnCount = this.getColumnCount();
        int[] padding = new int[columnCount];
        String[] fmt = new String[columnCount];
        for (i2 = 0; i2 < columnCount; ++i2) {
            padding[i2] = this.getColumnName(i2).length();
        }
        this.resetRowPosition();
        while (this.advanceRow()) {
            for (i2 = 0; i2 < columnCount; ++i2) {
                int width;
                VoltType colType2 = this.getColumnType(i2);
                Object value = this.get(i2, colType2);
                if (this.wasNull()) {
                    width = 4;
                } else if (colType2 == VoltType.DECIMAL) {
                    BigDecimal bd = (BigDecimal)value;
                    String valueStr = String.format("%01.12f", bd.doubleValue());
                    width = valueStr.length();
                } else {
                    width = colType2 == VoltType.VARBINARY ? ((byte[])value).length * 2 : value.toString().length();
                    if (colType2 == VoltType.GEOGRAPHY && width > 74 || colType2 != VoltType.GEOGRAPHY && width > 90) {
                        int n = width = colType2 == VoltType.GEOGRAPHY ? 74 : 90;
                    }
                }
                if (width <= padding[i2]) continue;
                padding[i2] = width;
            }
        }
        String pad = "";
        for (i = 0; i < columnCount; ++i) {
            int n = i;
            padding[n] = padding[n] + 1;
            colType = this.getColumnType(i);
            String justification = colType.isVariableLength() || colType == VoltType.TIMESTAMP || colType == VoltType.GEOGRAPHY_POINT ? "-" : "";
            fmt[i] = "%1$" + justification + padding[i] + "s";
            if (!includeColumnNames) continue;
            sb.append(pad).append(String.format("%1$-" + padding[i] + "s", this.getColumnName(i)));
            pad = " ";
        }
        if (includeColumnNames) {
            sb.append("\n");
            pad = "";
            for (i = 0; i < columnCount; ++i) {
                char[] underline_array = new char[padding[i]];
                Arrays.fill(underline_array, '-');
                sb.append(pad).append(new String(underline_array));
                pad = " ";
            }
            sb.append("\n");
        }
        this.resetRowPosition();
        while (this.advanceRow()) {
            pad = "";
            for (i = 0; i < columnCount; ++i) {
                String valueStr;
                colType = this.getColumnType(i);
                Object value = this.get(i, colType);
                if (this.wasNull()) {
                    valueStr = "NULL";
                } else if (colType == VoltType.DECIMAL) {
                    BigDecimal bd = (BigDecimal)value;
                    valueStr = String.format("%01.12f", bd.doubleValue());
                } else if (colType == VoltType.VARBINARY) {
                    valueStr = Encoder.hexEncode((byte[])value);
                    if (valueStr.length() > 90) {
                        valueStr = valueStr.substring(0, 90 - "...".length()) + "...";
                    }
                } else {
                    valueStr = value.toString();
                }
                sb.append(pad).append(String.format(fmt[i], valueStr));
                pad = " ";
            }
            sb.append("\n");
        }
        this.resetRowPosition();
        return sb.toString();
    }

    @Override
    public String toJSONString() {
        JSONStringer js = new JSONStringer();
        try {
            js.object();
            js.keySymbolValuePair(JSON_STATUS_KEY, this.getStatusCode());
            js.key(JSON_SCHEMA_KEY).array();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                js.object();
                js.keySymbolValuePair(JSON_NAME_KEY, this.getColumnName(i));
                js.keySymbolValuePair(JSON_TYPE_KEY, this.getColumnType(i).getValue());
                js.endObject();
            }
            js.endArray();
            js.key(JSON_DATA_KEY).array();
            VoltTableRow row = this.cloneRow();
            row.resetRowPosition();
            while (row.advanceRow()) {
                js.array();
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    row.putJSONRep(i, js);
                }
                js.endArray();
            }
            js.endArray();
            js.endObject();
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to serialized a table to JSON.", e);
        }
        return js.toString();
    }

    public JSONStringer toJSONStringerV2(JSONStringer js) throws JSONException {
        VoltTableRow row = this.cloneRow();
        row.resetRowPosition();
        js.array();
        while (row.advanceRow()) {
            js.object();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                js.key(this.getColumnName(i));
                row.putJSONRep(i, js);
            }
            js.endObject();
        }
        js.endArray();
        return js;
    }

    public static VoltTable fromJSONString(String json) throws JSONException, IOException {
        JSONObject jsonObj = new JSONObject(json);
        return VoltTable.fromJSONObject(jsonObj);
    }

    public static VoltTable fromJSONObject(JSONObject json) throws JSONException, IOException {
        JSONArray jsonCols = json.getJSONArray(JSON_SCHEMA_KEY);
        ColumnInfo[] columns = new ColumnInfo[jsonCols.length()];
        for (int i = 0; i < jsonCols.length(); ++i) {
            JSONObject jsonCol = jsonCols.getJSONObject(i);
            String name = jsonCol.getString(JSON_NAME_KEY);
            VoltType type = VoltType.get((byte)jsonCol.getInt(JSON_TYPE_KEY));
            columns[i] = new ColumnInfo(name, type);
        }
        VoltTable t = new VoltTable(columns);
        byte status = (byte)json.getInt(JSON_STATUS_KEY);
        t.setStatusCode(status);
        JSONArray data = json.getJSONArray(JSON_DATA_KEY);
        for (int i = 0; i < data.length(); ++i) {
            JSONArray jsonRow = data.getJSONArray(i);
            assert (jsonRow.length() == jsonCols.length());
            Object[] row = new Object[jsonRow.length()];
            block7: for (int j = 0; j < jsonRow.length(); ++j) {
                row[j] = jsonRow.get(j);
                if (row[j] == JSONObject.NULL) {
                    row[j] = null;
                }
                VoltType type = columns[j].type;
                if (row[j] == null) continue;
                switch (type) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case TIMESTAMP: 
                    case BIGINT: {
                        if (row[j] instanceof String) {
                            row[j] = Long.parseLong((String)row[j]);
                        }
                        assert (row[j] instanceof Number);
                        continue block7;
                    }
                    case DECIMAL: {
                        String decVal = row[j] instanceof String ? (String)row[j] : row[j].toString();
                        if (decVal.compareToIgnoreCase("NULL") == 0) {
                            row[j] = null;
                            continue block7;
                        }
                        row[j] = VoltDecimalHelper.deserializeBigDecimalFromString(decVal);
                        continue block7;
                    }
                    case FLOAT: {
                        if (row[j] instanceof String) {
                            row[j] = Double.parseDouble((String)row[j]);
                        }
                        assert (row[j] instanceof Number);
                        continue block7;
                    }
                }
            }
            t.addRow(row);
        }
        return t;
    }

    public boolean hasSameContents(VoltTable other) {
        return this.hasSameContents(other, true);
    }

    public boolean hasSameContents(VoltTable other, boolean ignoreOrder) {
        assert (this.verifyTableInvariants());
        if (this == other) {
            return true;
        }
        if (this.m_buffer.position() != other.m_buffer.position()) {
            return false;
        }
        if (ignoreOrder) {
            return this.getTableCheckSum(true) == other.getTableCheckSum(true);
        }
        ByteBuffer thisBuffer = this.m_buffer.duplicate();
        thisBuffer.limit(thisBuffer.position()).rewind();
        ByteBuffer otherBuffer = other.m_buffer.duplicate();
        otherBuffer.limit(otherBuffer.position()).rewind();
        return thisBuffer.equals(otherBuffer);
    }

    public long getTableCheckSum(boolean includeHeader) {
        ByteBuffer buffer = this.m_buffer.asReadOnlyBuffer();
        int limit = buffer.position();
        long hash = 0L;
        CRC32 crc = new CRC32();
        if (includeHeader) {
            buffer.rewind().limit(this.m_rowStart + 4);
            crc.update(buffer);
            hash = crc.getValue();
        } else {
            buffer.position(this.m_rowStart + 4);
        }
        int position = buffer.position();
        for (int i = 0; i < this.m_rowCount; ++i) {
            buffer.limit(limit);
            int length = buffer.getInt(position) + 4;
            buffer.limit(position + length);
            crc.reset();
            crc.update(buffer);
            hash += crc.getValue();
            assert ((position += length) == buffer.position());
        }
        assert (limit == position && buffer.limit() == limit);
        return hash;
    }

    @Deprecated
    public boolean equals(Object o) {
        if (!(o instanceof VoltTable)) {
            return false;
        }
        return this.hasSameContents((VoltTable)o);
    }

    @Deprecated
    public int hashCode() {
        throw new UnsupportedOperationException("unimplemented");
    }

    VoltTable semiDeepCopy() {
        assert (this.verifyTableInvariants());
        VoltTable cloned = new VoltTable(this.m_extraMetadata);
        cloned.m_colCount = this.m_colCount;
        cloned.m_rowCount = this.m_rowCount;
        cloned.m_rowStart = this.m_rowStart;
        cloned.m_buffer = this.m_buffer.duplicate();
        cloned.m_activeRowIndex = this.m_activeRowIndex;
        cloned.m_hasCalculatedOffsets = this.m_hasCalculatedOffsets;
        cloned.m_memoizedBufferOffset = this.m_memoizedBufferOffset;
        cloned.m_memoizedRowOffset = this.m_memoizedRowOffset;
        cloned.m_offsets = this.m_offsets == null ? null : (int[])this.m_offsets.clone();
        cloned.m_position = this.m_position;
        cloned.m_schemaString = this.m_schemaString == null ? null : (byte[])this.m_schemaString.clone();
        cloned.m_wasNull = this.m_wasNull;
        cloned.m_readOnly = true;
        assert (this.verifyTableInvariants());
        assert (cloned.verifyTableInvariants());
        return cloned;
    }

    public final VoltTable clone(int extraBytes) {
        assert (this.verifyTableInvariants());
        VoltTable cloned = new VoltTable(this.m_extraMetadata);
        cloned.m_colCount = this.m_colCount;
        cloned.m_rowCount = 0;
        cloned.m_rowStart = this.m_rowStart;
        int pos = this.m_buffer.position();
        this.m_buffer.position(0);
        this.m_buffer.limit(this.m_rowStart);
        cloned.m_buffer = ByteBuffer.allocate(this.m_rowStart + extraBytes + 100);
        cloned.m_buffer.put(this.m_buffer);
        this.m_buffer.limit(this.m_buffer.capacity());
        this.m_buffer.position(pos);
        cloned.m_buffer.putInt(0);
        assert (this.verifyTableInvariants());
        assert (cloned.verifyTableInvariants());
        return cloned;
    }

    boolean testForUTF8Encoding(byte[] strbytes) {
        try {
            new String(strbytes, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    private final void writeStringToBuffer(String s, Charset encoding, ByteBuffer b) {
        if (s == null) {
            b.putInt(-1);
            return;
        }
        int len = 0;
        byte[] strbytes = s.getBytes(encoding);
        assert (strbytes != null);
        len = strbytes.length;
        b.putInt(len);
        b.put(strbytes);
    }

    private final void writeStringOrVarbinaryToBuffer(byte[] s, ByteBuffer b) {
        if (s == null) {
            b.putInt(-1);
            return;
        }
        int len = s.length;
        b.putInt(len);
        b.put(s);
    }

    @Override
    public final int getRowCount() {
        return this.m_rowCount;
    }

    @Override
    protected final int getRowStart() {
        return this.m_rowStart;
    }

    @Override
    public final int getColumnCount() {
        return this.m_colCount;
    }

    private final boolean verifyTableInvariants() {
        assert (this.m_buffer != null);
        assert (this.m_rowCount >= 0);
        assert (this.m_colCount > 0);
        assert (this.m_rowStart > 0);
        int minsize = 16;
        assert (this.m_buffer.capacity() >= 16);
        assert (this.m_buffer.limit() >= 16);
        if (this.m_buffer.position() < 16) {
            System.err.printf("Buffer position %d is smaller than it should be.\n", this.m_buffer.position());
            return false;
        }
        int rowStart = this.m_buffer.getInt(0) + 4;
        if (rowStart < 12) {
            System.err.printf("rowStart with value %d is smaller than it should be.\n", rowStart);
            return false;
        }
        assert (this.m_buffer.position() > this.m_rowStart);
        short colCount = this.m_buffer.getShort(5);
        assert (colCount > 0);
        return true;
    }

    public byte getStatusCode() {
        return this.m_buffer.get(4);
    }

    public void setStatusCode(byte code) {
        this.m_buffer.put(4, code);
    }

    public int getSerializedSize() {
        return this.m_buffer.limit() + 4;
    }

    public void flattenToBuffer(ByteBuffer buf) {
        ByteBuffer dup = this.m_buffer.duplicate();
        buf.putInt(dup.limit());
        dup.position(0);
        buf.put(dup);
    }

    public byte[] buildReusableDependenyResult() {
        ByteBuffer dup = this.m_buffer.duplicate();
        ByteBuffer responseBuf = ByteBuffer.allocate(dup.limit());
        dup.position(0);
        responseBuf.put(dup);
        return responseBuf.array();
    }

    private void initFromRawBuffer() {
        this.m_buffer.position(this.m_buffer.limit());
        this.m_rowStart = this.m_buffer.getInt(0) + 4;
        this.m_colCount = this.m_buffer.getShort(5);
        this.m_rowCount = this.m_buffer.getInt(this.m_rowStart);
        assert (this.verifyTableInvariants());
    }

    void initFromByteArray(byte[] byteArray, int position, int len) {
        this.m_buffer = ByteBuffer.wrap(byteArray, position, len).asReadOnlyBuffer();
        this.initFromRawBuffer();
    }

    public final void convertToHeapBuffer() {
        if (this.m_buffer.isDirect()) {
            ByteBuffer heapBuffer = ByteBuffer.allocate(this.m_buffer.limit());
            this.m_buffer.position(0);
            heapBuffer.put(this.m_buffer);
            this.m_buffer = heapBuffer;
        }
    }

    void initFromBuffer(ByteBuffer buf) {
        int len = buf.getInt();
        assert (len >= 4);
        int startLimit = buf.limit();
        buf.limit(buf.position() + len);
        this.m_buffer = buf.slice().asReadOnlyBuffer();
        buf.limit(startLimit);
        buf.position(buf.position() + len);
        this.initFromRawBuffer();
    }

    public ByteBuffer getBuffer() {
        ByteBuffer buf = this.m_buffer.asReadOnlyBuffer();
        buf.position(0);
        return buf;
    }

    public ColumnInfo[] getTableSchema() {
        ColumnInfo[] schema = new ColumnInfo[this.m_colCount];
        for (int i = 0; i < this.m_colCount; ++i) {
            ColumnInfo col;
            schema[i] = col = new ColumnInfo(this.getColumnName(i), this.getColumnType(i));
        }
        return schema;
    }

    final class Row
    extends VoltTableRow {
        Row(int position) {
            this.m_buffer = VoltTable.this.m_buffer;
            assert (position < this.m_buffer.limit());
            this.m_position = position;
            this.m_offsets = new int[VoltTable.this.m_colCount];
            this.m_activeRowIndex = -1;
        }

        @Override
        public int getColumnCount() {
            return VoltTable.this.getColumnCount();
        }

        @Override
        public int getColumnIndex(String columnName) {
            return VoltTable.this.getColumnIndex(columnName);
        }

        @Override
        public VoltType getColumnType(int columnIndex) {
            return VoltTable.this.getColumnType(columnIndex);
        }

        @Override
        protected int getRowCount() {
            return VoltTable.this.getRowCount();
        }

        @Override
        protected int getRowStart() {
            return VoltTable.this.getRowStart();
        }

        @Override
        public VoltTableRow cloneRow() {
            Row retval = new Row(this.m_position);
            retval.m_hasCalculatedOffsets = this.m_hasCalculatedOffsets;
            retval.m_wasNull = this.m_wasNull;
            for (int i = 0; i < VoltTable.this.m_colCount; ++i) {
                retval.m_offsets[i] = this.m_offsets[i];
            }
            retval.m_activeRowIndex = this.m_activeRowIndex;
            return retval;
        }

        @Override
        byte[] getSchemaString() {
            return VoltTable.this.getSchemaString();
        }
    }

    static class ExtraMetadata {
        final ColumnInfo[] originalColumnInfos;
        final String name;
        int partitionColIndex;
        int[] pkeyIndexes;

        ExtraMetadata(String name, int partitionColIndex, int[] pkeyIndexes, ColumnInfo ... originalColumnInfos) {
            this.name = name;
            this.partitionColIndex = partitionColIndex;
            this.pkeyIndexes = (int[])pkeyIndexes.clone();
            this.originalColumnInfos = (ColumnInfo[])originalColumnInfos.clone();
        }

        protected Object clone() {
            try {
                ExtraMetadata cloned = (ExtraMetadata)super.clone();
                for (int i = 0; i < this.originalColumnInfos.length; ++i) {
                    cloned.originalColumnInfos[i] = this.originalColumnInfos[i].clone();
                }
                return cloned;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public static class ColumnInfo
    implements Cloneable {
        final String name;
        final VoltType type;
        final int size;
        final boolean nullable;
        final boolean unique;
        final String defaultValue;
        static final String NO_DEFAULT_VALUE = "!@#$%^&*(!@#$%^&*(";

        public ColumnInfo(String name, VoltType type) {
            this.name = name;
            this.type = type;
            this.size = 0x100000;
            this.nullable = true;
            this.unique = false;
            this.defaultValue = NO_DEFAULT_VALUE;
        }

        ColumnInfo(String name, VoltType type, int size, boolean nullable, boolean unique, String defaultValue) {
            this.name = name;
            this.type = type;
            this.size = size;
            this.nullable = nullable;
            this.unique = unique;
            this.defaultValue = defaultValue;
        }

        ColumnInfo(JSONObject jsonCol) throws JSONException {
            this.name = jsonCol.getString(VoltTable.JSON_NAME_KEY);
            this.type = VoltType.get((byte)jsonCol.getInt(VoltTable.JSON_TYPE_KEY));
            this.size = 0x100000;
            this.nullable = true;
            this.unique = false;
            this.defaultValue = NO_DEFAULT_VALUE;
        }

        public ColumnInfo clone() {
            try {
                return (ColumnInfo)super.clone();
            }
            catch (CloneNotSupportedException e) {
                assert (false);
                throw new RuntimeException(e);
            }
        }

        public int hashCode() {
            throw new RuntimeException("Didn't expect you to hash this.");
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ColumnInfo)) {
                return false;
            }
            ColumnInfo other = (ColumnInfo)obj;
            if (this.nullable != other.nullable) {
                return false;
            }
            if (this.unique != other.unique) {
                return false;
            }
            if (this.defaultValue != other.defaultValue) {
                return false;
            }
            if (this.size != other.size) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            return this.name.equals(other.name);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{ name=" + this.name + ", type=" + (Object)((Object)this.type) + " }";
        }
    }
}

