/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb;

import com.google_voltpatches.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.voltdb.VoltTable;
import org.voltdb.VoltTypeException;
import org.voltdb.common.Constants;
import org.voltdb.types.GeographyPointValue;
import org.voltdb.types.GeographyValue;
import org.voltdb.types.TimestampType;

public class VoltType
extends Enum<VoltType> {
    public static final /* enum */ VoltType INVALID = new VoltType(0, new Class[0], null);
    public static final /* enum */ VoltType NULL = new VoltType(1, new Class[0], null);
    public static final /* enum */ VoltType NUMERIC = new VoltType(2, new Class[0], null);
    public static final /* enum */ VoltType TINYINT = new VoltType(3, "tinyint", 1, new Class[]{Byte.TYPE, Byte.class}, byte[].class, 't', -6, 2, "java.lang.Byte");
    public static final /* enum */ VoltType SMALLINT = new VoltType(4, "smallint", 2, new Class[]{Short.TYPE, Short.class}, short[].class, 's', 5, 2, "java.lang.Short");
    public static final /* enum */ VoltType INTEGER = new VoltType(5, "integer", 4, new Class[]{Integer.TYPE, Integer.class, AtomicInteger.class}, int[].class, 'i', 4, 2, "java.lang.Integer");
    public static final /* enum */ VoltType BIGINT = new VoltType(6, "bigint", 8, new Class[]{Long.TYPE, Long.class, AtomicLong.class}, long[].class, 'b', -5, 2, "java.lang.Long");
    public static final /* enum */ VoltType INLIST_OF_BIGINT = new VoltType(7, "INLIST OF BIGINT", -1, new Class[]{long[].class}, (Class)long[][].class, 'B', 1111, 0, "org.voltdb.types.Long[]"){
        private final Class<?>[] COMPATIBLE_ARRAYS = new Class[]{long[].class, Long[].class, int[].class, Integer[].class, short[].class, Short[].class, byte[].class, Byte[].class};

        @Override
        public boolean acceptsArray(Class<?> arrayArgClass) {
            for (Class<?> allowedArray : this.COMPATIBLE_ARRAYS) {
                if (allowedArray != arrayArgClass) continue;
                return true;
            }
            return false;
        }
    };
    public static final /* enum */ VoltType FLOAT = new VoltType(8, "float", 8, new Class[]{Double.TYPE, Double.class, Float.TYPE, Float.class}, double[].class, 'f', 6, 2, "java.lang.Double");
    public static final /* enum */ VoltType STRING = new VoltType(9, "varchar", new LengthRange("max_length"), new Class[]{String.class}, (Class)String[].class, 'v', 12, 3, "java.lang.String"){

        @Override
        public boolean acceptsArray(Class<?> arrayArgClass) {
            return byte[].class == arrayArgClass;
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }

        @Override
        public String getLiteralPrefix() {
            return "'";
        }

        @Override
        public String getLiteralSuffix() {
            return "'";
        }

        @Override
        public boolean isIndexable() {
            return true;
        }

        @Override
        public boolean isUniqueIndexable() {
            return true;
        }
    };
    public static final /* enum */ VoltType INLIST_OF_STRING = new VoltType(10, "INLIST OF STRING", -1, new Class[]{String[].class}, (Class)String[][].class, 'V', 1111, 0, "org.voltdb.types.String[]"){

        @Override
        public boolean acceptsArray(Class<?> arrayArgClass) {
            return String[].class == arrayArgClass;
        }
    };
    public static final /* enum */ VoltType TIMESTAMP = new VoltType(11, "timestamp", 8, new Class[]{TimestampType.class, java.util.Date.class, Date.class, Timestamp.class}, (Class)TimestampType[].class, 'p', 93, 2, "java.sql.Timestamp"){

        @Override
        public String getLiteralPrefix() {
            return "'";
        }

        @Override
        public String getLiteralSuffix() {
            return "'";
        }

        @Override
        public boolean isIndexable() {
            return true;
        }

        @Override
        public boolean isUniqueIndexable() {
            return true;
        }
    };
    public static final /* enum */ VoltType VOLTTABLE = new VoltType(21, new Class[]{VoltTable.class}, VoltTable[].class);
    public static final /* enum */ VoltType DECIMAL = new VoltType(22, "decimal", 16, new Class[]{BigDecimal.class}, (Class)BigDecimal[].class, 'd', 3, 2, "java.math.BigDecimal"){

        @Override
        public Integer getMinimumScale() {
            return 12;
        }

        @Override
        public Integer getMaximumScale() {
            return 12;
        }
    };
    public static final /* enum */ VoltType BOOLEAN = new VoltType(23, "boolean", 1, new Class[]{Boolean.TYPE, Boolean.class}, (Class)boolean[].class, 'o', 16, 2, "java.lang.Boolean"){

        @Override
        public Integer getMinimumScale() {
            return 0;
        }

        @Override
        public Integer getMaximumScale() {
            return 0;
        }
    };
    public static final /* enum */ VoltType VARBINARY = new VoltType(25, "varbinary", new LengthRange("max_length"), new Class[]{byte[].class, Byte[].class, ByteBuffer.class}, (Class)byte[][].class, 'l', -3, 2, "java.lang.Byte[]"){

        @Override
        public Object bytesToValue(byte[] value) {
            assert (value != null);
            return value;
        }

        @Override
        public boolean acceptsArray(Class<?> arrayArgClass) {
            return byte[].class == arrayArgClass || Byte[].class == arrayArgClass;
        }

        @Override
        public String getLiteralPrefix() {
            return "'";
        }

        @Override
        public String getLiteralSuffix() {
            return "'";
        }

        @Override
        public boolean isIndexable() {
            return true;
        }

        @Override
        public boolean isUniqueIndexable() {
            return true;
        }
    };
    public static final /* enum */ VoltType GEOGRAPHY_POINT = new VoltType(26, "GEOGRAPHY_POINT", GeographyPointValue.getLengthInBytes(), new Class[]{GeographyPointValue.class}, GeographyPointValue[].class, 'P', 1111, 2, "org.voltdb.types.GeographyPointValue");
    public static final /* enum */ VoltType GEOGRAPHY = new VoltType(27, "GEOGRAPHY", new LengthRange(155, 0x100000, 32768, "max_length"), new Class[]{GeographyValue.class}, (Class)GeographyValue[].class, 'g', 1111, 2, "org.voltdb.types.GeographyValue"){

        @Override
        public boolean isIndexable() {
            return true;
        }

        @Override
        public boolean isUniqueIndexable() {
            return false;
        }
    };
    public static final int MAX_VALUE_LENGTH = 0x100000;
    public static final int MAX_VALUE_LENGTH_IN_CHARACTERS = 262144;
    private final byte m_value;
    private final int m_lengthInBytes;
    private LengthRange m_lengthAsBytesRange;
    private final String m_sqlString;
    private final Class<?>[] m_classes;
    private final Class<?> m_vectorClass;
    private final char m_signatureChar;
    private final boolean m_jdbcVisible;
    private final int m_jdbcSqlDataType;
    private final int m_jdbcSearchable;
    private final String m_jdbcClass;
    private static final ImmutableMap<Class<?>, VoltType> s_classes;
    private static final byte VOLT_TYPE_MAX_ENUM = 30;
    private static final VoltType[] s_types;
    public static final int NULL_STRING_LENGTH = -1;
    public static final byte NULL_TINYINT = -128;
    public static final short NULL_SMALLINT = Short.MIN_VALUE;
    public static final int NULL_INTEGER = Integer.MIN_VALUE;
    public static final long NULL_BIGINT = Long.MIN_VALUE;
    public static final double NULL_FLOAT = -1.7E308;
    private static final Byte MAX_TINYINT;
    private static final Short MAX_SMALLINT;
    private static final Integer MAX_INTEGER;
    private static final Long MAX_BIGINT;
    private static final Long MAX_TIMESTAMP;
    private static final Float MAX_FLOAT;
    public static final NullTimestampSigil NULL_TIMESTAMP;
    public static final NullStringOrVarbinarySigil NULL_STRING_OR_VARBINARY;
    public static final NullDecimalSigil NULL_DECIMAL;
    public static final NullPointSigil NULL_POINT;
    public static final NullGeographySigil NULL_GEOGRAPHY;
    private static final /* synthetic */ VoltType[] $VALUES;

    public static VoltType[] values() {
        return (VoltType[])$VALUES.clone();
    }

    public static VoltType valueOf(String name) {
        return Enum.valueOf(VoltType.class, name);
    }

    public static String humanReadableSize(int size) {
        if (size > 9999) {
            return String.valueOf(size / 1024) + "K";
        }
        return String.valueOf(size) + "B";
    }

    private VoltType(byte value, Class<?>[] classes, Class<?> vectorClass) {
        this(value, -1, null, null, classes, vectorClass, '0', false, 1111, Integer.MIN_VALUE, null);
    }

    private VoltType(byte value, String sqlString, int lengthInBytes, Class<?>[] classes, Class<?> vectorClass, char signatureChar, int jdbcSqlDataType, int jdbcSearchable, String jdbcClass) {
        this(value, lengthInBytes, null, sqlString, classes, vectorClass, signatureChar, true, jdbcSqlDataType, jdbcSearchable, jdbcClass);
    }

    private VoltType(byte value, String sqlString, LengthRange lengthAsBytesRange, Class<?>[] classes, Class<?> vectorClass, char signatureChar, int jdbcSqlDataType, int jdbcSearchable, String jdbcClass) {
        this(value, -1, lengthAsBytesRange, sqlString, classes, vectorClass, signatureChar, true, jdbcSqlDataType, jdbcSearchable, jdbcClass);
    }

    private VoltType(byte value, int lengthInBytes, LengthRange lengthAsBytesRange, String sqlString, Class<?>[] classes, Class<?> vectorClass, char signatureChar, boolean jdbcVisible, int jdbcSqlDataType, int jdbcSearchable, String jdbcClass) {
        if (value > 30) {
            throw new RuntimeException("The VoltType enum byte value " + value + "falls outside the expected range. Consider reassigning the value to fill a gap within the existing range OR extending the range from its current value of VOLT_TYPE_MAX_ENUM = " + 30);
        }
        this.m_value = value;
        this.m_lengthInBytes = lengthInBytes;
        this.m_lengthAsBytesRange = lengthAsBytesRange;
        this.m_sqlString = sqlString;
        this.m_classes = classes;
        this.m_vectorClass = vectorClass;
        this.m_signatureChar = signatureChar;
        this.m_jdbcVisible = jdbcVisible;
        this.m_jdbcSqlDataType = jdbcSqlDataType;
        this.m_jdbcSearchable = jdbcSearchable;
        this.m_jdbcClass = jdbcClass;
    }

    public byte getValue() {
        return this.m_value;
    }

    public Class<?> classFromType() {
        if (this.m_classes.length == 0) {
            throw new RuntimeException("Unsupported type " + (Object)((Object)this));
        }
        return this.m_classes[0];
    }

    public static Class<?> classFromByteValue(byte value) {
        VoltType returnVT = VoltType.get(value);
        return returnVT.classFromType();
    }

    public Class<?> vectorClassFromType() {
        if (this.m_vectorClass == null) {
            throw new RuntimeException("Unsupported type " + (Object)((Object)this));
        }
        return this.m_vectorClass;
    }

    public static VoltType get(byte val) {
        VoltType type;
        VoltType voltType = type = val < s_types.length ? s_types[val] : null;
        if (type == null) {
            throw new AssertionError((Object)("Unknown type: " + String.valueOf(val)));
        }
        return type;
    }

    private boolean matchesString(String str) {
        return str.toUpperCase().endsWith(this.name());
    }

    public static VoltType typeFromString(String str) {
        if (str == null) {
            return NULL;
        }
        if (str.startsWith("VoltType.")) {
            str = str.substring("VoltType.".length());
        }
        if (str.compareToIgnoreCase("null") == 0) {
            return NULL;
        }
        for (VoltType type : VoltType.values()) {
            if (!type.matchesString(str)) continue;
            return type;
        }
        if (str.equalsIgnoreCase("DOUBLE")) {
            return FLOAT;
        }
        if (str.equalsIgnoreCase("CHARACTER") || str.equalsIgnoreCase("CHAR") || str.equalsIgnoreCase("VARCHAR")) {
            return STRING;
        }
        if (str.equalsIgnoreCase("BINARY")) {
            return VARBINARY;
        }
        throw new RuntimeException("Can't find type: " + str);
    }

    public static VoltType typeFromObject(Object obj) {
        assert (obj != null);
        Class<?> cls = obj.getClass();
        return VoltType.typeFromClass(cls);
    }

    public static VoltType typeFromClass(Class<?> cls) {
        VoltType type = s_classes.get(cls);
        if (type == null) {
            if (cls != null && ByteBuffer.class.isAssignableFrom(cls)) {
                type = VARBINARY;
            } else {
                throw new VoltTypeException("Unimplemented Object Type: " + cls);
            }
        }
        return type;
    }

    public String toString() {
        return "VoltType." + this.name();
    }

    public String getName() {
        return this.name();
    }

    public boolean isVariableLength() {
        return this.m_lengthAsBytesRange != null;
    }

    public int getLengthInBytesForFixedTypes() {
        if (this.m_lengthAsBytesRange != null) {
            throw new RuntimeException("Asking for fixed size for non-fixed or unknown type:" + this.m_sqlString);
        }
        return this.m_lengthInBytes;
    }

    public int getLengthInBytesForFixedTypesWithoutCheck() {
        return this.m_lengthInBytes;
    }

    public int getMinLengthInBytes() {
        return this.m_lengthAsBytesRange == null ? this.m_lengthInBytes : this.m_lengthAsBytesRange.getMinLengthInBytes();
    }

    public int getMaxLengthInBytes() {
        return this.m_lengthAsBytesRange == null ? this.m_lengthInBytes : this.m_lengthAsBytesRange.getMaxLengthInBytes();
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getCreateParams() {
        return this.m_lengthAsBytesRange == null ? null : this.m_lengthAsBytesRange.getLengthParamName();
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Integer getMinimumScale() {
        return this.isAnyIntegerType() ? Integer.valueOf(0) : null;
    }

    public Integer getMaximumScale() {
        return this.isAnyIntegerType() ? Integer.valueOf(0) : null;
    }

    public boolean isIndexable() {
        return this.isNumber();
    }

    public boolean isUniqueIndexable() {
        return this.isNumber();
    }

    public boolean acceptsArray(Class<?> arrayArgClass) {
        return false;
    }

    public String toSQLString() {
        return this.m_sqlString;
    }

    public boolean isJdbcVisible() {
        return this.m_jdbcVisible;
    }

    public int getJdbcSqlType() {
        return this.m_jdbcSqlDataType;
    }

    public int getNullable() {
        return 1;
    }

    public int getSearchable() {
        return this.m_jdbcSearchable;
    }

    public Boolean isUnsigned() {
        return this.isNumber() ? Boolean.valueOf(false) : null;
    }

    public String getJdbcClass() {
        return this.m_jdbcClass;
    }

    public boolean isExactNumeric() {
        return this.isAnyIntegerType() || this == DECIMAL;
    }

    public boolean isBackendIntegerType() {
        return this.isAnyIntegerType() || this == TIMESTAMP;
    }

    public boolean isAnyIntegerType() {
        switch (this) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumber() {
        switch (this) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    public boolean canExactlyRepresentAnyValueOf(VoltType otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType.isBackendIntegerType()) {
            if (this.isBackendIntegerType()) {
                return this.getMaxLengthInBytes() >= otherType.getMaxLengthInBytes();
            }
            if (this == FLOAT && otherType != BIGINT) {
                return true;
            }
        }
        return false;
    }

    public char getSignatureChar() {
        assert (this.m_signatureChar != '0');
        return this.m_signatureChar;
    }

    public Integer[] getTypePrecisionAndRadix() {
        Integer[] col_size_radix = new Integer[]{null, null};
        switch (this) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case TIMESTAMP: {
                col_size_radix[0] = this.getLengthInBytesForFixedTypes() * 8 - 1;
                col_size_radix[1] = 2;
                break;
            }
            case FLOAT: {
                col_size_radix[0] = 53;
                col_size_radix[1] = 2;
                break;
            }
            case DECIMAL: {
                col_size_radix[0] = 38;
                col_size_radix[1] = 10;
                break;
            }
            case STRING: 
            case VARBINARY: 
            case GEOGRAPHY: {
                col_size_radix[0] = 0x100000;
                break;
            }
        }
        return col_size_radix;
    }

    public int defaultLengthForVariableLengthType() {
        assert (this.m_lengthAsBytesRange != null);
        return this.m_lengthAsBytesRange.getDefaultLengthInBytes();
    }

    public String getMostCompatibleJavaTypeName() {
        if (this.m_classes.length > 0) {
            Class<?> javaClass = this.m_classes[0];
            return javaClass.getSimpleName();
        }
        return "(unknown?)";
    }

    public String getMaxValueForKeyPadding() {
        switch (this) {
            case TINYINT: {
                return MAX_TINYINT.toString();
            }
            case SMALLINT: {
                return MAX_SMALLINT.toString();
            }
            case INTEGER: {
                return MAX_INTEGER.toString();
            }
            case BIGINT: {
                return MAX_BIGINT.toString();
            }
            case TIMESTAMP: {
                return MAX_TIMESTAMP.toString();
            }
            case FLOAT: {
                return MAX_FLOAT.toString();
            }
        }
        return null;
    }

    boolean wouldCastOverflow(Number value) {
        switch (this) {
            case TINYINT: {
                return value.longValue() <= -128L || value.longValue() > 127L;
            }
            case SMALLINT: {
                return value.longValue() <= -32768L || value.longValue() > 32767L;
            }
            case INTEGER: {
                return value.longValue() <= Integer.MIN_VALUE || value.longValue() > Integer.MAX_VALUE;
            }
            case BIGINT: {
                return value.longValue() == Long.MIN_VALUE;
            }
            case FLOAT: {
                return value.doubleValue() == -1.7E308;
            }
        }
        throw new VoltTypeException("Unhandled cast overflow case, casting to: " + this.toString());
    }

    public Object getNullValue() {
        switch (this) {
            case TINYINT: {
                return (byte)-128;
            }
            case SMALLINT: {
                return (short)Short.MIN_VALUE;
            }
            case INTEGER: {
                return Integer.MIN_VALUE;
            }
            case BIGINT: {
                return Long.MIN_VALUE;
            }
            case FLOAT: {
                return -1.7E308;
            }
            case STRING: {
                return NULL_STRING_OR_VARBINARY;
            }
            case TIMESTAMP: {
                return NULL_TIMESTAMP;
            }
            case DECIMAL: {
                return NULL_DECIMAL;
            }
            case VARBINARY: {
                return NULL_STRING_OR_VARBINARY;
            }
            case GEOGRAPHY_POINT: {
                return NULL_POINT;
            }
            case GEOGRAPHY: {
                return NULL_GEOGRAPHY;
            }
        }
        throw new VoltTypeException("No NULL value for " + this.toString());
    }

    public static boolean isVoltNullValue(Object obj) {
        if (obj == null || obj == NULL_TIMESTAMP || obj == NULL_STRING_OR_VARBINARY || obj == NULL_DECIMAL || obj == NULL_POINT || obj == NULL_GEOGRAPHY) {
            return true;
        }
        switch (VoltType.typeFromObject(obj)) {
            case TINYINT: {
                return ((Number)obj).byteValue() == -128;
            }
            case SMALLINT: {
                return ((Number)obj).shortValue() == Short.MIN_VALUE;
            }
            case INTEGER: {
                return ((Number)obj).intValue() == Integer.MIN_VALUE;
            }
            case BIGINT: {
                return ((Number)obj).longValue() == Long.MIN_VALUE;
            }
            case FLOAT: {
                return ((Number)obj).doubleValue() == -1.7E308;
            }
            case DECIMAL: 
            case TIMESTAMP: 
            case STRING: 
            case VARBINARY: 
            case GEOGRAPHY: 
            case GEOGRAPHY_POINT: {
                return false;
            }
        }
        throw new VoltTypeException("Unsupported type: " + (Object)((Object)VoltType.typeFromObject(obj)));
    }

    public static byte[] valueToBytes(Object obj) {
        if (VoltType.isVoltNullValue(obj)) {
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof String) {
            return ((String)obj).getBytes(Constants.UTF8ENCODING);
        }
        long value = 0L;
        if (obj instanceof Long) {
            value = (Long)obj;
        } else if (obj instanceof Integer) {
            value = ((Integer)obj).intValue();
        } else if (obj instanceof Short) {
            value = ((Short)obj).shortValue();
        } else if (obj instanceof Byte) {
            value = ((Byte)obj).byteValue();
        }
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(value);
        return buf.array();
    }

    public Object bytesToValue(byte[] value) {
        assert (value != null);
        if (this == NULL) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.wrap(value);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        switch (this) {
            case BIGINT: {
                return buf.getLong();
            }
            case STRING: {
                return new String(value, Constants.UTF8ENCODING);
            }
            case INTEGER: {
                return buf.getInt();
            }
            case SMALLINT: {
                return buf.getShort();
            }
            case TINYINT: {
                return buf.get();
            }
        }
        throw new RuntimeException("bytesToValue failed to convert a non-partitionable type.");
    }

    static {
        $VALUES = new VoltType[]{INVALID, NULL, NUMERIC, TINYINT, SMALLINT, INTEGER, BIGINT, INLIST_OF_BIGINT, FLOAT, STRING, INLIST_OF_STRING, TIMESTAMP, VOLTTABLE, DECIMAL, BOOLEAN, VARBINARY, GEOGRAPHY_POINT, GEOGRAPHY};
        s_types = new VoltType[31];
        ImmutableMap.Builder<Class<?>, VoltType> b = ImmutableMap.builder();
        HashMap validation = new HashMap();
        VoltType[] voltTypeArray = VoltType.values();
        int n = voltTypeArray.length;
        for (int i = 0; i < n; ++i) {
            VoltType type;
            VoltType.s_types[type.m_value] = type = voltTypeArray[i];
            for (Class<?> cls : type.m_classes) {
                if (validation.get(cls) != null) {
                    throw new RuntimeException("Associate each java class like " + cls.getSimpleName() + " with at most one VoltType.");
                }
                validation.put(cls, type);
                b.put(cls, type);
            }
        }
        s_classes = b.build();
        MAX_TINYINT = new Byte(127);
        MAX_SMALLINT = new Short((short)Short.MAX_VALUE);
        MAX_INTEGER = new Integer(Integer.MAX_VALUE);
        MAX_BIGINT = new Long(Long.MAX_VALUE);
        MAX_TIMESTAMP = new Long(Long.MAX_VALUE);
        MAX_FLOAT = new Float(Float.MAX_VALUE);
        NULL_TIMESTAMP = new NullTimestampSigil();
        NULL_STRING_OR_VARBINARY = new NullStringOrVarbinarySigil();
        NULL_DECIMAL = new NullDecimalSigil();
        NULL_POINT = new NullPointSigil();
        NULL_GEOGRAPHY = new NullGeographySigil();
    }

    private static final class NullGeographySigil {
        private NullGeographySigil() {
        }
    }

    private static final class NullPointSigil {
        private NullPointSigil() {
        }
    }

    private static final class NullDecimalSigil {
        private NullDecimalSigil() {
        }
    }

    private static final class NullStringOrVarbinarySigil {
        private NullStringOrVarbinarySigil() {
        }
    }

    private static final class NullTimestampSigil {
        private NullTimestampSigil() {
        }
    }

    public static final class LengthRange {
        private final int m_min;
        private final int m_max;
        private final int m_default;
        private final String m_name;
        private static final int MAX_COLUMNS = 1024;
        private static final int MAX_ROW_SIZE = 0x200000;
        public static final int DEFAULT_COLUMN_SIZE = 2048;

        LengthRange(String maxLengthParamName) {
            this(1, 0x100000, 2048, maxLengthParamName);
        }

        LengthRange(int minBytes, int maxBytes, int defaultLength, String maxLengthParamName) {
            this.m_min = minBytes;
            this.m_max = maxBytes;
            this.m_default = defaultLength;
            this.m_name = maxLengthParamName;
        }

        int getMaxLengthInBytes() {
            return this.m_max;
        }

        int getMinLengthInBytes() {
            return this.m_min;
        }

        int getDefaultLengthInBytes() {
            return this.m_default;
        }

        String getLengthParamName() {
            return this.m_name;
        }
    }
}

