/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.util.EnumSet;

public enum ClientAuthScheme {
    HASH_SHA1,
    HASH_SHA256,
    SPNEGO;

    private static final EnumSet<ClientAuthScheme> hashedOnes;
    private static final ClientAuthScheme[] theList;

    public int getValue() {
        return this.ordinal();
    }

    public boolean isHashed() {
        return hashedOnes.contains((Object)this);
    }

    public static final ClientAuthScheme get(int i) {
        if (i < 0 || i >= theList.length) {
            throw new IllegalArgumentException("Invalid Hash Scheme");
        }
        return theList[i];
    }

    public static final ClientAuthScheme getByUnencodedLength(int i) {
        switch (i) {
            case 20: {
                return HASH_SHA1;
            }
            case 32: {
                return HASH_SHA256;
            }
            case 0: {
                return SPNEGO;
            }
        }
        throw new IllegalArgumentException("Invalid Hash Scheme for given length: " + i);
    }

    public static final int getDigestLength(ClientAuthScheme scheme) {
        switch (scheme) {
            case HASH_SHA1: {
                return 20;
            }
            case HASH_SHA256: {
                return 32;
            }
            case SPNEGO: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid Hash Scheme for Authentication.");
    }

    public static final int getHexencodedDigestLength(ClientAuthScheme scheme) {
        switch (scheme) {
            case HASH_SHA1: {
                return 40;
            }
            case HASH_SHA256: {
                return 64;
            }
            case SPNEGO: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid Hash Scheme for Authentication.");
    }

    public static final String getDigestScheme(ClientAuthScheme scheme) {
        switch (scheme) {
            case HASH_SHA1: {
                return "SHA-1";
            }
            case HASH_SHA256: {
                return "SHA-256";
            }
            case SPNEGO: {
                return "NONE";
            }
        }
        throw new IllegalArgumentException("Invalid Hash Digest Scheme for Authentication.");
    }

    static {
        hashedOnes = EnumSet.of(HASH_SHA1, HASH_SHA256);
        theList = ClientAuthScheme.values();
    }
}

