/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.RoundingMode;
import java.security.Principal;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.voltcore.utils.ssl.SSLConfiguration;
import org.voltdb.client.ClientAuthScheme;
import org.voltdb.client.ClientStatusListener;
import org.voltdb.client.ClientStatusListenerExt;
import org.voltdb.client.ClientStatusListenerWrapper;
import org.voltdb.client.DelegatePrincipal;
import org.voltdb.common.Constants;
import org.voltdb.types.VoltDecimalHelper;

public class ClientConfig {
    private static final String DEFAULT_SSL_PROPS_FILE = "ssl-config";
    static final long DEFAULT_PROCEDURE_TIMOUT_NANOS = TimeUnit.MINUTES.toNanos(2L);
    static final long DEFAULT_CONNECTION_TIMOUT_MS = 120000L;
    static final long DEFAULT_INITIAL_CONNECTION_RETRY_INTERVAL_MS = 1000L;
    static final long DEFAULT_MAX_CONNECTION_RETRY_INTERVAL_MS = 8000L;
    final ClientAuthScheme m_hashScheme;
    final String m_username;
    final String m_password;
    final boolean m_cleartext;
    final ClientStatusListenerExt m_listener;
    boolean m_heavyweight = false;
    int m_maxOutstandingTxns = 3000;
    int m_maxTransactionsPerSecond = Integer.MAX_VALUE;
    boolean m_autoTune = false;
    int m_autoTuneTargetInternalLatency = 5;
    long m_procedureCallTimeoutNanos = DEFAULT_PROCEDURE_TIMOUT_NANOS;
    long m_connectionResponseTimeoutMS = 120000L;
    boolean m_useClientAffinity = true;
    Subject m_subject = null;
    boolean m_reconnectOnConnectionLoss;
    long m_initialConnectionRetryIntervalMS = 1000L;
    long m_maxConnectionRetryIntervalMS = 8000L;
    boolean m_sendReadsToReplicasBytDefaultIfCAEnabled = false;
    SSLConfiguration.SslConfig m_sslConfig;
    boolean m_topologyChangeAware = false;
    boolean m_enableSSL = false;
    String m_sslPropsFile = null;
    public static final boolean ENABLE_SSL_FOR_TEST = Boolean.valueOf(System.getenv("ENABLE_SSL") == null ? Boolean.toString(Boolean.getBoolean("ENABLE_SSL")) : System.getenv("ENABLE_SSL"));

    static final String getUserNameFromSubject(Subject subject) {
        if (subject == null || subject.getPrincipals() == null || subject.getPrincipals().isEmpty()) {
            throw new IllegalArgumentException("Subject is null or does not contain principals");
        }
        Iterator<Principal> piter = subject.getPrincipals().iterator();
        Principal principal = piter.next();
        String username = principal.getName();
        while (piter.hasNext()) {
            principal = piter.next();
            if (!(principal instanceof DelegatePrincipal)) continue;
            username = principal.getName();
            break;
        }
        return username;
    }

    public ClientConfig() {
        this("", "", true, null, ClientAuthScheme.HASH_SHA256);
    }

    public ClientConfig(String username, String password) {
        this(username, password, true, null, ClientAuthScheme.HASH_SHA256);
    }

    @Deprecated
    public ClientConfig(String username, String password, ClientStatusListener listener, ClientAuthScheme scheme) {
        this(username, password, true, new ClientStatusListenerWrapper(listener), scheme);
    }

    public ClientConfig(String username, String password, ClientStatusListenerExt listener) {
        this(username, password, true, listener, ClientAuthScheme.HASH_SHA256);
    }

    public ClientConfig(String username, String password, ClientStatusListenerExt listener, ClientAuthScheme scheme) {
        this(username, password, true, listener, scheme);
    }

    public ClientConfig(String username, String password, boolean cleartext, ClientStatusListenerExt listener) {
        this(username, password, cleartext, listener, ClientAuthScheme.HASH_SHA256);
    }

    public ClientConfig(Subject subject, ClientStatusListenerExt listener) {
        this(ClientConfig.getUserNameFromSubject(subject), "", true, listener, ClientAuthScheme.HASH_SHA256);
        this.m_subject = subject;
    }

    public ClientConfig(String username, String password, boolean cleartext, ClientStatusListenerExt listener, ClientAuthScheme scheme) {
        if (ENABLE_SSL_FOR_TEST) {
            try (InputStream is = ClientConfig.class.getResourceAsStream(DEFAULT_SSL_PROPS_FILE);){
                Properties sslProperties = new Properties();
                sslProperties.load(is);
                String trustStorePath = sslProperties.getProperty("trustStore");
                String trustStorePassword = sslProperties.getProperty("trustStorePassword");
                this.setTrustStore(trustStorePath, trustStorePassword);
                this.enableSSL();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to access SSL configuration.", e);
            }
        }
        this.m_username = username == null ? "" : username;
        this.m_password = password == null ? "" : password;
        this.m_listener = listener;
        this.m_cleartext = cleartext;
        this.m_hashScheme = scheme;
    }

    public void setProcedureCallTimeout(long ms) {
        assert (ms >= 0L);
        if (ms < 0L) {
            ms = 0L;
        }
        if (ms == 0L) {
            ms = Long.MAX_VALUE;
        }
        this.m_procedureCallTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(ms);
    }

    public void setConnectionResponseTimeout(long ms) {
        assert (ms >= 0L);
        if (ms < 0L) {
            ms = 0L;
        }
        if (ms == 0L) {
            ms = Long.MAX_VALUE;
        }
        this.m_connectionResponseTimeoutMS = ms;
    }

    @Deprecated
    public void setMaxArenaSizes(int[] maxArenaSizes) {
    }

    public void setHeavyweight(boolean heavyweight) {
        this.m_heavyweight = heavyweight;
    }

    @Deprecated
    public void setExpectedOutgoingMessageSize(int size) {
    }

    public void setMaxOutstandingTxns(int maxOutstanding) {
        if (maxOutstanding < 1) {
            throw new IllegalArgumentException("Max outstanding must be greater than 0, " + maxOutstanding + " was specified");
        }
        this.m_maxOutstandingTxns = maxOutstanding;
    }

    public void setMaxTransactionsPerSecond(int maxTxnsPerSecond) {
        if (maxTxnsPerSecond < 1) {
            throw new IllegalArgumentException("Max TPS must be greater than 0, " + maxTxnsPerSecond + " was specified");
        }
        this.m_maxTransactionsPerSecond = maxTxnsPerSecond;
    }

    public void enableAutoTune() {
        this.m_autoTune = true;
    }

    public void setClientAffinity(boolean on) {
        this.m_useClientAffinity = on;
    }

    public void setTopologyChangeAware(boolean enabled) {
        this.m_topologyChangeAware = enabled;
    }

    public void setSendReadsToReplicasByDefault(boolean on) {
        this.m_sendReadsToReplicasBytDefaultIfCAEnabled = on;
    }

    public void setReconnectOnConnectionLoss(boolean on) {
        this.m_reconnectOnConnectionLoss = on;
    }

    public void setInitialConnectionRetryInterval(long ms) {
        this.m_initialConnectionRetryIntervalMS = ms;
    }

    public void setMaxConnectionRetryInterval(long ms) {
        this.m_maxConnectionRetryIntervalMS = ms;
    }

    public void setAutoTuneTargetInternalLatency(int targetLatency) {
        if (targetLatency < 1) {
            throw new IllegalArgumentException("Max auto tune latency must be greater than 0, " + targetLatency + " was specified");
        }
        this.m_autoTuneTargetInternalLatency = targetLatency;
    }

    public void enableKerberosAuthentication(Subject subject) {
        this.m_subject = subject;
    }

    public void enableKerberosAuthentication(String loginContextEntryKey) {
        try {
            LoginContext lc = new LoginContext(loginContextEntryKey);
            lc.login();
            this.m_subject = lc.getSubject();
        }
        catch (SecurityException | LoginException ex) {
            throw new IllegalArgumentException("Cannot determine client consumer's credentials", ex);
        }
    }

    public static void setRoundingConfig(boolean isEnabled, RoundingMode mode) {
        VoltDecimalHelper.setRoundingConfig(isEnabled, mode);
    }

    public void setTrustStore(String pathToTrustStore, String trustStorePassword) {
        File tsFD = new File(pathToTrustStore != null && !pathToTrustStore.trim().isEmpty() ? pathToTrustStore : "");
        if (!(tsFD.exists() && tsFD.isFile() && tsFD.canRead())) {
            throw new IllegalArgumentException("Trust store " + pathToTrustStore + " is not a read accessible file");
        }
        this.m_sslConfig = new SSLConfiguration.SslConfig(null, null, pathToTrustStore, trustStorePassword);
    }

    public void setTrustStoreConfigFromPropertyFile(String propFN) {
        File propFD = new File(propFN != null && !propFN.trim().isEmpty() ? propFN : "");
        if (!(propFD.exists() && propFD.isFile() && propFD.canRead())) {
            throw new IllegalArgumentException("Properties file " + propFN + " is not a read accessible file");
        }
        Properties props = new Properties();
        try (FileReader fr = new FileReader(propFD);){
            props.load(fr);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read properties file " + propFN, e);
        }
        String trustStore = props.getProperty("trustStore");
        String trustStorePassword = props.getProperty("trustStorePassword");
        this.m_sslConfig = new SSLConfiguration.SslConfig(null, null, trustStore, trustStorePassword);
    }

    public void enableSSL() {
        this.m_enableSSL = true;
        if (this.m_sslConfig == null) {
            this.m_sslConfig = new SSLConfiguration.SslConfig();
        }
    }

    public void setTrustStoreConfigFromDefault() {
        String trustStore = Constants.DEFAULT_TRUSTSTORE_RESOURCE;
        String trustStorePassword = "changeit";
        this.m_sslConfig = new SSLConfiguration.SslConfig(null, null, trustStore, trustStorePassword);
    }
}

