/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import org.voltcore.logging.VoltLogger;
import org.voltcore.network.ReverseDNSCache;
import org.voltcore.utils.EstTimeUpdater;
import org.voltdb.client.Client;
import org.voltdb.client.ClientConfig;
import org.voltdb.client.ClientImpl;

public abstract class ClientFactory {
    static int m_activeClientCount = 0;
    static boolean m_preserveResources = false;

    public static Client createClient() {
        return ClientFactory.createClient(new ClientConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Client createClient(ClientConfig config) {
        ClientImpl client = null;
        Class<ClientFactory> clazz = ClientFactory.class;
        synchronized (ClientFactory.class) {
            if (!m_preserveResources && ++m_activeClientCount == 1) {
                VoltLogger.startAsynchronousLogging();
                EstTimeUpdater.start();
                ReverseDNSCache.start();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            client = new ClientImpl(config);
            return client;
        }
    }

    public static synchronized void decreaseClientNum() throws InterruptedException {
        if (!m_preserveResources && m_activeClientCount <= 1) {
            m_activeClientCount = 0;
            VoltLogger.shutdownAsynchronousLogging();
            EstTimeUpdater.stop();
            ReverseDNSCache.stop();
        } else {
            --m_activeClientCount;
        }
    }

    public static synchronized void increaseClientCountToOne() {
        m_preserveResources = true;
        VoltLogger.startAsynchronousLogging();
        EstTimeUpdater.start();
        ReverseDNSCache.start();
        m_activeClientCount = 1;
    }
}

