/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import com.google_voltpatches.common.base.Charsets;
import com.google_voltpatches.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram_voltpatches.Histogram;

public class ClientStats {
    String m_procName;
    long m_startTS;
    long m_endTS;
    long m_connectionId;
    String m_hostname;
    int m_port;
    long m_invocationsCompleted;
    long m_invocationAborts;
    long m_invocationErrors;
    long m_invocationTimeouts;
    long m_roundTripTimeNanos;
    long m_clusterRoundTripTime;
    public static final int ONE_MS_BUCKET_COUNT = 50;
    public static final int TEN_MS_BUCKET_COUNT = 20;
    public static final int HUNDRED_MS_BUCKET_COUNT = 10;
    Histogram m_latencyHistogram;
    long m_bytesSent;
    long m_bytesReceived;
    private static final long LOWEST_TRACKABLE = 50L;
    private static final long HIGHEST_TRACKABLE = 10000000L;
    private static final int SIGNIFICANT_VALUE_DIGITS = 2;

    public static Histogram constructHistogram() {
        return new Histogram(50L, 10000000L, 2);
    }

    ClientStats() {
        this.m_procName = "";
        this.m_connectionId = -1L;
        this.m_hostname = "";
        this.m_port = -1;
        this.m_startTS = Long.MAX_VALUE;
        this.m_endTS = Long.MIN_VALUE;
        this.m_invocationErrors = 0L;
        this.m_invocationAborts = 0L;
        this.m_invocationsCompleted = 0L;
        this.m_clusterRoundTripTime = 0L;
        this.m_roundTripTimeNanos = 0L;
        this.m_bytesReceived = 0L;
        this.m_bytesSent = 0L;
        this.m_latencyHistogram = ClientStats.constructHistogram();
    }

    ClientStats(ClientStats other) {
        this.m_procName = other.m_procName;
        this.m_connectionId = other.m_connectionId;
        this.m_hostname = other.m_hostname;
        this.m_port = other.m_port;
        this.m_startTS = other.m_startTS;
        this.m_endTS = other.m_endTS;
        this.m_invocationsCompleted = other.m_invocationsCompleted;
        this.m_invocationAborts = other.m_invocationAborts;
        this.m_invocationErrors = other.m_invocationErrors;
        this.m_invocationTimeouts = other.m_invocationTimeouts;
        this.m_roundTripTimeNanos = other.m_roundTripTimeNanos;
        this.m_clusterRoundTripTime = other.m_clusterRoundTripTime;
        this.m_latencyHistogram = other.m_latencyHistogram.copy();
        this.m_latencyHistogram.reestablishTotalCount();
        this.m_bytesSent = other.m_bytesSent;
        this.m_bytesReceived = other.m_bytesReceived;
    }

    static ClientStats diff(ClientStats newer, ClientStats older) {
        if (newer.m_procName != older.m_procName || newer.m_connectionId != older.m_connectionId) {
            throw new IllegalArgumentException("Can't diff these ClientStats instances.");
        }
        ClientStats retval = new ClientStats();
        retval.m_procName = older.m_procName;
        retval.m_connectionId = older.m_connectionId;
        retval.m_hostname = older.m_hostname;
        retval.m_port = older.m_port;
        retval.m_startTS = older.m_startTS;
        retval.m_endTS = newer.m_endTS;
        retval.m_invocationsCompleted = newer.m_invocationsCompleted - older.m_invocationsCompleted;
        retval.m_invocationAborts = newer.m_invocationAborts - older.m_invocationAborts;
        retval.m_invocationErrors = newer.m_invocationErrors - older.m_invocationErrors;
        retval.m_invocationTimeouts = newer.m_invocationTimeouts - older.m_invocationTimeouts;
        retval.m_roundTripTimeNanos = newer.m_roundTripTimeNanos - older.m_roundTripTimeNanos;
        retval.m_clusterRoundTripTime = newer.m_clusterRoundTripTime - older.m_clusterRoundTripTime;
        retval.m_latencyHistogram = Histogram.diff(newer.m_latencyHistogram, older.m_latencyHistogram);
        retval.m_bytesSent = newer.m_bytesSent - older.m_bytesSent;
        retval.m_bytesReceived = newer.m_bytesReceived - older.m_bytesReceived;
        return retval;
    }

    static ClientStats merge(Iterable<ClientStats> statsIterable) {
        return ClientStats.merge(statsIterable.iterator());
    }

    static ClientStats merge(Iterator<ClientStats> statsIter) {
        if (!statsIter.hasNext()) {
            return new ClientStats();
        }
        ClientStats seed = statsIter.next();
        assert (seed != null);
        seed = (ClientStats)seed.clone();
        while (statsIter.hasNext()) {
            seed.add(statsIter.next());
        }
        return seed;
    }

    void add(ClientStats other) {
        if (!this.m_procName.equals(other.m_procName)) {
            this.m_procName = "";
        }
        if (this.m_connectionId != other.m_connectionId) {
            this.m_connectionId = -1L;
        }
        if (!this.m_hostname.equals(other.m_hostname)) {
            this.m_hostname = "";
        }
        if (this.m_port != other.m_port) {
            this.m_port = -1;
        }
        this.m_startTS = Math.min(other.m_startTS, this.m_startTS);
        this.m_endTS = Math.max(other.m_endTS, this.m_endTS);
        this.m_invocationsCompleted += other.m_invocationsCompleted;
        this.m_invocationAborts += other.m_invocationAborts;
        this.m_invocationErrors += other.m_invocationErrors;
        this.m_invocationTimeouts += other.m_invocationTimeouts;
        this.m_roundTripTimeNanos += other.m_roundTripTimeNanos;
        this.m_clusterRoundTripTime += other.m_clusterRoundTripTime;
        this.m_latencyHistogram.add(other.m_latencyHistogram);
        this.m_latencyHistogram.reestablishTotalCount();
        this.m_bytesSent += other.m_bytesSent;
        this.m_bytesReceived += other.m_bytesReceived;
    }

    void update(long roundTripTimeNanos, int clusterRoundTripTime, boolean abort, boolean error, boolean timeout) {
        ++this.m_invocationsCompleted;
        if (abort) {
            ++this.m_invocationAborts;
        }
        if (error) {
            ++this.m_invocationErrors;
        }
        if (timeout) {
            ++this.m_invocationTimeouts;
        }
        this.m_roundTripTimeNanos += roundTripTimeNanos;
        this.m_clusterRoundTripTime += (long)clusterRoundTripTime;
        long roundTripMicros = Math.max(50L, TimeUnit.NANOSECONDS.toMicros(roundTripTimeNanos));
        if (roundTripMicros > 10000000L) {
            this.m_latencyHistogram.recordValue(roundTripMicros % 10000000L);
            int count = (int)(roundTripMicros / 10000000L);
            for (int ii = 0; ii < count; ++ii) {
                this.m_latencyHistogram.recordValue(10000000L);
            }
        } else {
            this.m_latencyHistogram.recordValue(roundTripMicros);
        }
    }

    public String getProcedureName() {
        return this.m_procName;
    }

    public long getStartTimestamp() {
        return this.m_startTS;
    }

    public long getEndTimestamp() {
        return this.m_endTS;
    }

    public long getDuration() {
        assert (this.m_endTS != Long.MIN_VALUE);
        return this.m_endTS - this.m_startTS;
    }

    public long getConnectionId() {
        return this.m_connectionId;
    }

    public String getHostname() {
        return this.m_hostname;
    }

    public int getPort() {
        return this.m_port;
    }

    public long getInvocationsCompleted() {
        return this.m_invocationsCompleted;
    }

    public long getInvocationAborts() {
        return this.m_invocationAborts;
    }

    public long getInvocationErrors() {
        return this.m_invocationErrors;
    }

    public long getInvocationTimeouts() {
        return this.m_invocationTimeouts;
    }

    public double getAverageLatency() {
        if (this.m_invocationsCompleted == 0L) {
            return 0.0;
        }
        return (double)this.m_roundTripTimeNanos / (double)this.m_invocationsCompleted / 1000000.0;
    }

    public double getAverageInternalLatency() {
        if (this.m_invocationsCompleted == 0L) {
            return 0.0;
        }
        return (double)this.m_clusterRoundTripTime / (double)this.m_invocationsCompleted;
    }

    public long[] getLatencyBucketsBy1ms() {
        long[] buckets = new long[50];
        for (int ii = 0; ii < 50; ++ii) {
            buckets[ii] = this.m_latencyHistogram.getCountBetweenValues((long)ii * 1000L, (long)(ii + 1) * 1000L);
        }
        return buckets;
    }

    public long[] getLatencyBucketsBy10ms() {
        long[] buckets = new long[20];
        for (int ii = 0; ii < 20; ++ii) {
            buckets[ii] = this.m_latencyHistogram.getCountBetweenValues((long)ii * 10000L, (long)(ii + 1) * 10000L);
        }
        return buckets;
    }

    public long[] getLatencyBucketsBy100ms() {
        long[] buckets = new long[10];
        for (int ii = 0; ii < 10; ++ii) {
            buckets[ii] = this.m_latencyHistogram.getCountBetweenValues((long)ii * 100000L, (long)(ii + 1) * 100000L);
        }
        return buckets;
    }

    public long getBytesWritten() {
        return this.m_bytesSent;
    }

    public long getBytesRead() {
        return this.m_bytesReceived;
    }

    public int kPercentileLatency(double percentile) {
        if (this.m_latencyHistogram.getTotalCount() == 0L) {
            return 0;
        }
        percentile = Math.max(0.0, percentile);
        return (int)((double)Math.round(this.m_latencyHistogram.getValueAtPercentile(percentile * 100.0)) / 1000.0);
    }

    public double kPercentileLatencyAsDouble(double percentile) {
        if (this.m_latencyHistogram.getTotalCount() == 0L) {
            return 0.0;
        }
        percentile = Math.max(0.0, percentile);
        return (double)this.m_latencyHistogram.getValueAtPercentile(percentile * 100.0) / 1000.0;
    }

    public String latencyHistoReport() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream pw = null;
        try {
            pw = new PrintStream((OutputStream)baos, false, Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            Throwables.propagate(e);
        }
        this.m_latencyHistogram.outputPercentileDistributionVolt(pw, 1, 1000.0);
        return new String(baos.toByteArray(), Charsets.UTF_8);
    }

    public long getTxnThroughput() {
        assert (this.m_startTS != Long.MAX_VALUE);
        assert (this.m_endTS != Long.MIN_VALUE);
        if (this.m_invocationsCompleted == 0L) {
            return 0L;
        }
        if (this.m_endTS < this.m_startTS) {
            this.m_endTS = this.m_startTS + 1L;
        }
        long durationMs = this.m_endTS - this.m_startTS;
        return (long)((double)this.m_invocationsCompleted / ((double)durationMs / 1000.0));
    }

    public long getIOWriteThroughput() {
        assert (this.m_startTS != Long.MAX_VALUE);
        assert (this.m_endTS != Long.MIN_VALUE);
        if (this.m_bytesSent == 0L) {
            return 0L;
        }
        if (this.m_endTS < this.m_startTS) {
            this.m_endTS = this.m_startTS + 1L;
        }
        long durationMs = this.m_endTS - this.m_startTS;
        return (long)((double)this.m_bytesSent / ((double)durationMs / 1000.0));
    }

    public long getIOReadThroughput() {
        assert (this.m_startTS != Long.MAX_VALUE);
        assert (this.m_endTS != Long.MIN_VALUE);
        if (this.m_bytesReceived == 0L) {
            return 0L;
        }
        if (this.m_endTS < this.m_startTS) {
            this.m_endTS = this.m_startTS + 1L;
        }
        long durationMs = this.m_endTS - this.m_startTS;
        return (long)((double)this.m_bytesReceived / ((double)durationMs / 1000.0));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Start %s - End %s - Procedure: %s - ConnectionId: %d {\n", new Date(this.m_startTS).toString(), new Date(this.m_endTS).toString(), this.m_procName, this.m_connectionId));
        sb.append(String.format("    hostname: %s:%d\n", this.m_hostname, this.m_port));
        sb.append(String.format("    invocations completed/aborted/errors/timeouts: %d/%d/%d/%d\n", this.m_invocationsCompleted, this.m_invocationAborts, this.m_invocationErrors, this.m_invocationTimeouts));
        if (this.m_invocationsCompleted > 0L) {
            sb.append(String.format("    avg latency client/internal: %.2f/%d\n", (double)this.m_roundTripTimeNanos / (double)this.m_invocationsCompleted / 1000000.0, this.m_clusterRoundTripTime / this.m_invocationsCompleted));
            sb.append(this.latencyHistoReport()).append("\n");
        }
        return sb.toString();
    }

    protected Object clone() {
        return new ClientStats(this);
    }
}

