/*
 * Decompiled with CFR 0.152.
 */
package org.voltdb.client;

import com.google_voltpatches.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.security.Principal;
import org.voltdb.common.Constants;

public final class DelegatePrincipal
implements Principal {
    public static final int MAX_DELEGATE_NAME_SIZE = 4096;
    private final String m_name;
    private final int m_id;

    public DelegatePrincipal(String name, int id) {
        Preconditions.checkArgument(name != null && !name.trim().isEmpty() && name.length() < 4096, "passed name is null, blank, empty, or too large");
        this.m_name = name;
        this.m_id = id;
    }

    public DelegatePrincipal(ByteBuffer bb) {
        Preconditions.checkArgument(Preconditions.checkNotNull(bb, "passed byte buffer is null").remaining() >= 8, "unexpected byte buffer size");
        this.m_id = bb.getInt();
        int size = bb.getInt();
        Preconditions.checkArgument(size >= 0 && size <= 4096, "delegate name size %s is negative or too large", size);
        if (bb.hasArray()) {
            this.m_name = new String(bb.array(), bb.arrayOffset() + bb.position(), size, Constants.UTF8ENCODING);
            bb.position(bb.position() + size);
        } else {
            byte[] namebuff = new byte[size];
            bb.get(namebuff);
            this.m_name = new String(namebuff, Constants.UTF8ENCODING);
        }
    }

    public DelegatePrincipal(byte[] payload) {
        this(ByteBuffer.wrap(Preconditions.checkNotNull(payload, "passed payload is null")));
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public int getId() {
        return this.m_id;
    }

    public int wrappedSize() {
        return 8 + this.m_name.getBytes(Constants.UTF8ENCODING).length;
    }

    public void wrap(ByteBuffer bb) {
        byte[] bytes = this.m_name.getBytes(Constants.UTF8ENCODING);
        bb.putInt(this.m_id);
        bb.putInt(bytes.length);
        bb.put(bytes);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_id;
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DelegatePrincipal other = (DelegatePrincipal)obj;
        if (this.m_id != other.m_id) {
            return false;
        }
        return !(this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name));
    }

    @Override
    public String toString() {
        return "DelegatePrincipal [m_name=" + this.m_name + ", m_id=" + this.m_id + "]";
    }
}

